/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.features.create.ext.CreateEndpointFigureFeature;
import org.fusesource.ide.camel.editor.provider.ext.ICustomPaletteEntry;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.catalog.Dependency;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.wizards.NewTransformationWizard;

public class DataTransformationPaletteEntry
implements ICustomPaletteEntry {
    private static final String PROTOCOL = "dozer";

    public ICreateFeature newCreateFeature(IFeatureProvider fp) {
        return new DataMapperEndpointFigureFeature(fp, "Data Transformation", "Creates a Data Transformation endpoint...");
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public boolean providesProtocol(String protocol) {
        return PROTOCOL.equalsIgnoreCase(protocol);
    }

    public List<Dependency> getRequiredDependencies() {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        Dependency dep = new Dependency();
        dep.setGroupId("org.apache.camel");
        dep.setArtifactId("camel-dozer");
        dep.setVersion(Activator.getDefault().getCamelVersion());
        deps.add(dep);
        return deps;
    }

    class DataMapperEndpointFigureFeature
    extends CreateEndpointFigureFeature {
        public DataMapperEndpointFigureFeature(IFeatureProvider fp, String name, String description) {
            super(fp, name, description, null, DataTransformationPaletteEntry.this.getRequiredDependencies());
        }

        public Object[] create(ICreateContext context) {
            RouteSupport selectedRoute = Activator.getDiagramEditor().getSelectedRoute();
            AbstractNode node = this.createNode();
            if (node == null) {
                return new Object[0];
            }
            if (selectedRoute != null) {
                selectedRoute.addChild(node);
            } else {
                Activator.getLogger().warning("Warning! Could not find currently selectedNode, so can't associate this node with the route!: " + node);
            }
            PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, node);
            this.getFeatureProvider().link(pe, (Object)node);
            this.getFeatureProvider().getDirectEditingInfo().setActive(true);
            return new Object[]{node};
        }

        protected AbstractNode createNode() {
            WizardDialog dialog;
            int status;
            NewTransformationWizard wizard = new NewTransformationWizard();
            wizard.setNeedsProgressMonitor(true);
            IEditorInput element = Activator.getDiagramEditor().getEditorInput();
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                IFile res = input.getFile();
                wizard.setSelectedProject(res.getProject());
                IPath respath = JavaUtil.getJavaPathForResource((IResource)res);
                String path = respath.makeRelative().toString();
                wizard.setCamelFilePath(path);
                wizard.setSaveCamelConfig(false);
            }
            if ((status = (dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard)).open()) != 0) {
                return null;
            }
            return wizard.getRouteEndpoint();
        }
    }
}

