/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.ModelViewer;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformationTypePage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.WizardControlDecorationUpdater;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.WizardValidationMessageProvider;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;
import org.jboss.tools.fuse.transformation.editor.wizards.NewTransformationWizard;
import org.jboss.tools.fuse.transformation.model.ModelBuilder;

public class JavaPage
extends XformWizardPage
implements TransformationTypePage {
    private Composite _page;
    private boolean isSource = true;
    private Text _javaClassText;
    private ModelBuilder _builder;
    private org.jboss.tools.fuse.transformation.model.Model _javaModel = null;
    private ModelViewer _modelViewer;
    private Binding _binding;

    public JavaPage(String pageName, Model model, boolean isSource) {
        super(pageName, model);
        this.setTitle("Java Page");
        this.setImageDescriptor(Activator.imageDescriptor("transform.png"));
        this.isSource = isSource;
        this.observablesManager.addObservablesFromContext(this.context, true, true);
        this._builder = new ModelBuilder();
    }

    @Override
    public void createControl(final Composite parent) {
        if (this.isSource) {
            this.setTitle("Source Type (Java)");
            this.setDescription("Specify details for the source Java class for this transformation.");
        } else {
            this.setTitle("Target Type (Java)");
            this.setDescription("Specify details for the target Java class for this transformation.");
        }
        this.observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                JavaPage.this.createPage(parent);
            }
        });
        WizardPageSupport wps = WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.context);
        wps.setValidationMessageProvider((IValidationMessageProvider)new WizardValidationMessageProvider());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void createPage(Composite parent) {
        this._page = new Composite(parent, 0);
        this.setControl((Control)this._page);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.horizontalSpacing = 10;
        this._page.setLayout((Layout)layout);
        Label label = this.isSourcePage() ? this.createLabel(this._page, "Source Class:", "The source Java class for the transformation.") : this.createLabel(this._page, "Target Class:", "The target Java class for the transformation.");
        this._javaClassText = new Text(this._page, 2056);
        this._javaClassText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._javaClassText.setToolTipText(label.getToolTipText());
        Button javaClassBrowseButton = new Button(this._page, 0);
        javaClassBrowseButton.setLayoutData((Object)new GridData());
        javaClassBrowseButton.setText("...");
        javaClassBrowseButton.setToolTipText("Browse to specify the selected class.");
        javaClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    final IType selected = JavaPage.this.selectType(JavaPage.this._page.getShell(), "java.lang.Object", null);
                    if (selected != null) {
                        JavaPage.this._javaClassText.setText(selected.getFullyQualifiedName());
                        if (JavaPage.this.isSourcePage()) {
                            JavaPage.this.model.setSourceType(ModelType.CLASS);
                            JavaPage.this.model.setSourceFilePath(selected.getFullyQualifiedName());
                        } else {
                            JavaPage.this.model.setTargetType(ModelType.CLASS);
                            JavaPage.this.model.setTargetFilePath(selected.getFullyQualifiedName());
                        }
                        UIJob uiJob = new UIJob("open error"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                NewTransformationWizard wizard = (NewTransformationWizard)JavaPage.this.getWizard();
                                try {
                                    Class<?> tempClass = wizard.getLoader().loadClass(selected.getFullyQualifiedName());
                                    JavaPage.this._javaModel = ModelBuilder.fromJavaClass(tempClass);
                                    JavaPage.this._modelViewer.setModel(JavaPage.this._javaModel);
                                }
                                catch (ClassNotFoundException e) {
                                    e.printStackTrace();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        uiJob.setSystem(true);
                        uiJob.schedule();
                        JavaPage.this._javaClassText.notifyListeners(24, new Event());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Group group = new Group(this._page, 16);
        group.setText("Class Structure Preview");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 3, 3));
        this._modelViewer = new ModelViewer(null, (Composite)group, this._javaModel, null);
        this._modelViewer.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this._modelViewer.layout();
        this.bindControls();
        this.validatePage();
    }

    private void bindControls() {
        ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe((Widget)this._javaClassText);
        IObservableValue modelValue = null;
        modelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceFilePath").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetFilePath").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String path;
                String string = path = value == null ? null : value.toString().trim();
                if (path == null || path.isEmpty()) {
                    return ValidationStatus.error((String)"A source file path must be supplied for the transformation.");
                }
                NewTransformationWizard wizard = (NewTransformationWizard)JavaPage.this.getWizard();
                try {
                    Class<?> tempClass = wizard.getLoader().loadClass(path);
                    if (tempClass == null) {
                        return ValidationStatus.error((String)"Unable to find a source file with the supplied path");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return ValidationStatus.error((String)"Unable to find a source file with the supplied path");
                }
                return ValidationStatus.ok();
            }
        });
        this._binding = this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding, (int)this.decoratorPosition, (Composite)this._javaClassText.getParent(), (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        this.listenForValidationChanges();
    }

    @Override
    public boolean isSourcePage() {
        return this.isSource;
    }

    @Override
    public boolean isTargetPage() {
        return !this.isSource;
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            IJavaProject javaProject;
            IType superType;
            if (project == null) {
                project = this.model.getProject();
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle("Select Class");
        dialog.setMessage("Matching items");
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    @Override
    public void notifyListeners() {
        if (this._javaClassText != null && !this._javaClassText.isDisposed()) {
            this._javaClassText.notifyListeners(24, null);
        }
    }

    @Override
    public void pingBinding() {
        if (this._binding != null) {
            this._binding.validateTargetToModel();
        }
    }

    @Override
    public void clearControls() {
        if (this._javaClassText != null && !this._javaClassText.isDisposed()) {
            this._javaModel = new org.jboss.tools.fuse.transformation.model.Model("", "");
            this._modelViewer.setModel(this._javaModel);
            this._javaClassText.setText("");
        }
        this.notifyListeners();
    }

    static /* synthetic */ ModelBuilder access$3(JavaPage javaPage) {
        return javaPage._builder;
    }
}

