/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.net.URI;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.wsdl.PortType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.WSDLPortTypeSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IInterfaceComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.util.OpenFileUtil;
import org.switchyard.tools.ui.wizards.NewWSDLFileWizard;

public class WSDLURISelectionComposite
extends AbstractSwitchyardComposite
implements IInterfaceComposite {
    private Composite _panel;
    private Text _mWSDLInterfaceURIText;
    private String _sWSDLURI = null;
    private WSDLPortType _interface = null;
    private Button _browseBtnWorkspace;
    private Button _browseBtnFile;
    private Hyperlink _newWSDLLink;

    public WSDLURISelectionComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, style);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        this._panel.setLayout((Layout)gl);
        if (this.getRootGridData() != null) {
            this._panel.setLayoutData((Object)this.getRootGridData());
        }
        this._newWSDLLink = this.getToolkit().createHyperlink(this._panel, Messages.link_wsdlUri, 0);
        this._newWSDLLink.setEnabled(this.canEdit());
        this._newWSDLLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String oldResult = WSDLURISelectionComposite.this._mWSDLInterfaceURIText.getText().trim();
                if (oldResult.indexOf(35) > -1) {
                    oldResult = oldResult.substring(0, oldResult.indexOf(35));
                }
                IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
                IPath wsdlPath = modelFile.getParent().getParent().getProjectRelativePath();
                wsdlPath = wsdlPath.append(oldResult);
                IProject project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
                if (project.exists(wsdlPath)) {
                    IResource wsdlFile = project.findMember(wsdlPath);
                    OpenFileUtil.openFile(wsdlFile);
                } else {
                    String result = WSDLURISelectionComposite.getPathToNewWSDL(WSDLURISelectionComposite.this._panel.getShell(), wsdlPath, WSDLURISelectionComposite.this.openOnCreate());
                    if (result != null) {
                        WSDLURISelectionComposite.this._mWSDLInterfaceURIText.setText(result);
                        WSDLURISelectionComposite.this.setHasChanged(true);
                        WSDLURISelectionComposite.this.handleModify((Control)WSDLURISelectionComposite.this._newWSDLLink);
                        WSDLURISelectionComposite.this.fireChangedEvent(WSDLURISelectionComposite.this._newWSDLLink);
                    }
                }
            }
        });
        this._mWSDLInterfaceURIText = this.getToolkit().createText(this._panel, null, 2048);
        if (this._interface != null && this._interface instanceof WSDLPortType) {
            this._mWSDLInterfaceURIText.setText(this._interface.getInterface());
        }
        this._mWSDLInterfaceURIText.setEnabled(this.canEdit());
        this._mWSDLInterfaceURIText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!WSDLURISelectionComposite.this.inUpdate()) {
                    WSDLURISelectionComposite.this.setHasChanged(true);
                    WSDLURISelectionComposite.this.handleModify((Control)WSDLURISelectionComposite.this._mWSDLInterfaceURIText);
                    WSDLURISelectionComposite.this.fireChangedEvent(WSDLURISelectionComposite.this._mWSDLInterfaceURIText);
                }
            }
        });
        GridData uriGD = new GridData(768);
        this._mWSDLInterfaceURIText.setLayoutData((Object)uriGD);
        this._browseBtnWorkspace = this.getToolkit().createButton(this._panel, Messages.button_workspace, 8);
        this._browseBtnWorkspace.setEnabled(this.canEdit());
        GridData btnGD = new GridData();
        this._browseBtnWorkspace.setLayoutData((Object)btnGD);
        this._browseBtnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortType result;
                IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
                IJavaProject javaProject = null;
                if (modelFile != null && modelFile.getProject() != null) {
                    javaProject = JavaCore.create((IProject)modelFile.getProject());
                }
                if ((result = WSDLURISelectionComposite.this.browse(WSDLURISelectionComposite.this._panel.getShell(), javaProject)) != null) {
                    WSDLURISelectionComposite.this.setHasChanged(true);
                    WSDLURISelectionComposite.this.handleModify((Control)WSDLURISelectionComposite.this._browseBtnWorkspace);
                    WSDLURISelectionComposite.this.fireChangedEvent(WSDLURISelectionComposite.this._browseBtnWorkspace);
                }
            }
        });
    }

    @Override
    protected void handleModify(Control control) {
        this._sWSDLURI = this._mWSDLInterfaceURIText.getText().trim();
        if (this._interface != null && this._interface instanceof WSDLPortType) {
            if (this._interface.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        WSDLURISelectionComposite.this._interface.setInterface(WSDLURISelectionComposite.this._sWSDLURI);
                    }
                });
            } else {
                this._interface.setInterface(this._sWSDLURI);
            }
        }
        this.validate();
        this.setHasChanged(false);
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        String uriString = this._mWSDLInterfaceURIText.getText();
        if (uriString == null || uriString.trim().length() == 0) {
            this.setErrorMessage(Messages.error_noUri);
        } else if (uriString.trim().length() < uriString.length()) {
            this.setErrorMessage(Messages.error_spacesInUri);
        } else {
            try {
                URI.create(uriString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setErrorMessage(Messages.error_invalidUri);
            }
        }
        return this.getErrorMessage() == null;
    }

    public String getWSDLURI() {
        return this._sWSDLURI;
    }

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setInterface(Interface cInterface) {
        if (cInterface instanceof WSDLPortType && this._mWSDLInterfaceURIText != null && !this._mWSDLInterfaceURIText.isDisposed()) {
            this._interface = (WSDLPortType)cInterface;
            this.setInUpdate(true);
            if (this._interface.getInterface() != null) {
                this._mWSDLInterfaceURIText.setText(this._interface.getInterface());
            } else {
                this._mWSDLInterfaceURIText.setText("MyService.wsdl#wsdl.porttype(MyPortType)");
            }
            this.setInUpdate(false);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    public PortType browse(Shell shell, IJavaProject project) {
        PortType result;
        WSDLPortTypeSelectionDialog dialog = new WSDLPortTypeSelectionDialog(shell, (IContainer)(project == null ? ResourcesPlugin.getWorkspace().getRoot() : project.getProject()));
        dialog.setInitialPattern("*.wsdl");
        if (dialog.open() == 0 && (result = dialog.getSelectedPortType()) != null) {
            this._sWSDLURI = this.getInterfaceURL(project, result);
            this._mWSDLInterfaceURIText.setText(this._sWSDLURI);
            return result;
        }
        return null;
    }

    private static String getPathToNewWSDL(Shell shell, IPath path, boolean _openWhenFinish) {
        NewWSDLFileWizard newWizard = new NewWSDLFileWizard();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        if (modelFile != null && modelFile.getProject() != null) {
            IJavaProject javaProject = JavaCore.create((IProject)modelFile.getProject());
            IPackageFragmentRoot folder = javaProject.getPackageFragmentRoot((IResource)modelFile);
            selectionToPass = new StructuredSelection((Object)folder);
        }
        if (path != null) {
            newWizard.setStartingFileName(path.lastSegment());
        }
        newWizard.setOpenOnFinish(_openWhenFinish);
        newWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selectionToPass);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)newWizard);
        if (dialog.open() == 0) {
            return newWizard.getCreatedFilePath();
        }
        return null;
    }

    @Override
    public void setCanEdit(boolean canEdit) {
        super.setCanEdit(canEdit);
        if (this._mWSDLInterfaceURIText != null && !this._mWSDLInterfaceURIText.isDisposed()) {
            this._mWSDLInterfaceURIText.setEnabled(this.canEdit());
        }
        if (this._newWSDLLink != null && !this._newWSDLLink.isDisposed()) {
            this._newWSDLLink.setEnabled(this.canEdit());
        }
        if (this._browseBtnFile != null && !this._browseBtnFile.isDisposed()) {
            this._browseBtnFile.setEnabled(this.canEdit());
        }
        if (this._browseBtnWorkspace != null && !this._browseBtnWorkspace.isDisposed()) {
            this._browseBtnWorkspace.setEnabled(this.canEdit());
        }
    }

    private String getInterfaceURL(IJavaProject project, PortType portType) {
        Path filePath = new Path(portType.eResource().getURI().toPlatformString(true));
        IFile resource = project.getProject().getWorkspace().getRoot().getFile((IPath)filePath);
        filePath = JavaUtil.getJavaPathForResource((IResource)resource);
        return String.valueOf(filePath.toString()) + "#wsdl.porttype(" + portType.getQName().getLocalPart() + ")";
    }
}

