/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.TabFolderLayout;

public class BindingPropertyComposite
implements IBindingComposite,
ChangeListener {
    private Binding _binding;
    private EObject _targetObject;
    private Composite _panel;
    private List<IBindingComposite> _composites;
    private ListenerList _listeners = new ListenerList();

    public BindingPropertyComposite(List<IBindingComposite> composites) {
        this._composites = composites;
    }

    @Override
    public Binding getBinding() {
        return this._binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this._binding = binding;
        for (IBindingComposite composite : this._composites) {
            composite.setBinding(binding);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this._panel.setLayout((Layout)gl);
        TabFolder tabFolder = new TabFolder(this._panel, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout(tabFolder));
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        for (IBindingComposite composite : this._composites) {
            TabItem tab = new TabItem(tabFolder, 0);
            tab.setText(composite.getTitle());
            tab.setToolTipText(composite.getDescription());
            composite.createContents((Composite)tabFolder, 0, context);
            tab.setControl((Control)composite.getPanel());
            composite.addChangeListener(this);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setErrorMessage(String msg) {
    }

    @Override
    public String getErrorMessage() {
        for (IBindingComposite composite : this._composites) {
            String errorMessage = composite.getErrorMessage();
            if (errorMessage == null || errorMessage.length() <= 0) continue;
            return errorMessage;
        }
        return null;
    }

    @Override
    public void setTargetObject(EObject target) {
        this._targetObject = target;
        for (IBindingComposite composite : this._composites) {
            composite.setTargetObject(target);
        }
    }

    @Override
    public EObject getTargetObject() {
        return this._targetObject;
    }

    @Override
    public void setOpenOnCreate(boolean flag) {
    }

    @Override
    public boolean openOnCreate() {
        return false;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this._listeners.add((Object)listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this._listeners.remove((Object)listener);
    }

    @Override
    public void setDidSomething(boolean flag) {
    }

    @Override
    public boolean getDidSomething() {
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object[] objectArray = this._listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ChangeListener)listener).stateChanged(event);
            }
            catch (Exception e) {
                Activator.logError(e);
            }
            ++n2;
        }
    }

    @Override
    public String getTitle() {
        return this._composites.get(0).getTitle();
    }

    @Override
    public String getDescription() {
        return this._composites.get(0).getDescription();
    }

    @Override
    public void dispose() {
        for (IBindingComposite composite : this._composites) {
            composite.dispose();
        }
    }
}

