/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.rss;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.rss.CamelRSSBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.rss.RssFactory;
import org.switchyard.tools.models.switchyard1_0.camel.rss.RssPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.CompoundValidator;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.databinding.URLValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class CamelRSSConsumerComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelRSSBindingType _binding = null;
    private Text _nameText;
    private Text _feedURIText;
    private Text _lastUpdateText;
    private Text _delayText;
    private Button _filterCheckbox;
    private Button _splitEntriesCheckbox;
    private WritableValue _bindingValue;
    private Button _sortEntriesCheckbox;

    CamelRSSConsumerComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return "RSS Binding";
    }

    @Override
    public String getDescription() {
        return "RSS Binding";
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelRSSBindingType) {
            this._binding = (CamelRSSBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (this._binding.getConsume() == null) {
                TransactionalEditingDomain domain = this.getDomain((EObject)this._binding);
                if (domain != null) {
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            CamelRSSConsumerComposite.this._binding.setConsume(RssFactory.eINSTANCE.createRSSScheduledPollConsumerType());
                        }
                    });
                } else {
                    this._binding.setConsume(RssFactory.eINSTANCE.createRSSScheduledPollConsumerType());
                }
            }
            this._filterCheckbox.setEnabled(this._splitEntriesCheckbox.getSelection());
            this._lastUpdateText.setEnabled(this._splitEntriesCheckbox.getSelection());
            this._sortEntriesCheckbox.setEnabled(this._splitEntriesCheckbox.getSelection());
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getConsumerTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getConsumerTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._feedURIText = this.createLabelAndText(composite, "Feed URI*");
        this.getToolkit().createLabel(composite, "");
        this.getToolkit().createLabel(composite, "");
        Group splitEntryOptionsGroup = new Group(composite, 0);
        splitEntryOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        splitEntryOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        splitEntryOptionsGroup.setText("Split Entry Options");
        this._splitEntriesCheckbox = this.createCheckbox((Composite)splitEntryOptionsGroup, "Split Entries", 2);
        this._filterCheckbox = this.createCheckbox((Composite)splitEntryOptionsGroup, "Filter", 2);
        this._lastUpdateText = this.createLabelAndText((Composite)splitEntryOptionsGroup, "Last Update (Starting Timestamp)");
        this._sortEntriesCheckbox = this.createCheckbox((Composite)splitEntryOptionsGroup, "Sort Entries (by Date)", 2);
        Group pollOptionsGroup = new Group(composite, 0);
        pollOptionsGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        pollOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        pollOptionsGroup.setText("Poll Options");
        this._delayText = this.createLabelAndText((Composite)pollOptionsGroup, "Delay Between Polls (MS) (Default 500)");
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelRSSBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("RSS binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("RSS binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        CompoundValidator uriValidator = new CompoundValidator(new StringEmptyValidator("Feed URI may not be empty."), new URLValidator("Potential problem with Feed URI"));
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._feedURIText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__FEED_URI), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(uriValidator), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ISWTObservableValue splitEntriesCheckboxValue = SWTObservables.observeSelection((Control)this._splitEntriesCheckbox);
        final IObservableValue filterValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__FILTER);
        final IObservableValue lastUpdateValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__LAST_UPDATE);
        final IObservableValue sortEntriesValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__SORT_ENTRIES);
        binding = context.bindValue((IObservableValue)splitEntriesCheckboxValue, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__SPLIT_ENTRIES), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._splitEntriesCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CamelRSSConsumerComposite.this._filterCheckbox.setEnabled(CamelRSSConsumerComposite.this._splitEntriesCheckbox.getSelection());
                CamelRSSConsumerComposite.this._lastUpdateText.setEnabled(CamelRSSConsumerComposite.this._splitEntriesCheckbox.getSelection());
                CamelRSSConsumerComposite.this._sortEntriesCheckbox.setEnabled(CamelRSSConsumerComposite.this._splitEntriesCheckbox.getSelection());
                if (!CamelRSSConsumerComposite.this._splitEntriesCheckbox.getSelection()) {
                    filterValue.setValue((Object)Boolean.TRUE);
                    lastUpdateValue.setValue(null);
                    sortEntriesValue.setValue((Object)Boolean.FALSE);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._filterCheckbox), filterValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ISWTObservableValue delayed1 = this.createDelayedObservableText(this._lastUpdateText);
        binding = context.bindValue((IObservableValue)delayed1, lastUpdateValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("Last Update must match the format yyyy-MM-ddTHH:mm:ss", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._sortEntriesCheckbox), sortEntriesValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{RssPackage.Literals.CAMEL_RSS_BINDING_TYPE__CONSUME, RssPackage.Literals.RSS_SCHEDULED_POLL_CONSUMER_TYPE__DELAY});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._delayText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

