/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.mqtt;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.mqtt.CamelMqttBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.mqtt.MqttPackage;
import org.switchyard.tools.models.switchyard1_0.camel.mqtt.QualityOfServiceType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.CompoundValidator;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyBooleanValidator;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.databinding.URLValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class CamelMQTTProducerComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelMqttBindingType _binding = null;
    private Text _nameText;
    private Text _hostURIText;
    private Text _publishTopicNameText;
    private Combo _byDefaultRetainCombo;
    private WritableValue _bindingValue;
    private Text _connectAttemptsMaxText;
    private Text _reconnectAttemptsMaxText;
    private ComboViewer _qosCombo;

    CamelMQTTProducerComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return "MQTT Binding";
    }

    @Override
    public String getDescription() {
        return "MQTT Binding";
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelMqttBindingType) {
            this._binding = (CamelMqttBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getProducerTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getProducerTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._hostURIText = this.createLabelAndText(composite, "Host URI (Default: tcp://127.0.0.1:1883)");
        this._publishTopicNameText = this.createLabelAndText(composite, "Publish Topic Name");
        this._connectAttemptsMaxText = this.createLabelAndText(composite, "Connect Attempts Max");
        this._reconnectAttemptsMaxText = this.createLabelAndText(composite, "Reconnect Attempts Max");
        this.getToolkit().createLabel(composite, "Quality of Service", 0);
        this._qosCombo = new ComboViewer(composite);
        this._qosCombo.getControl().setLayoutData((Object)new GridData(4, 0, true, false));
        this._qosCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._qosCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        QualityOfServiceType[] qosTypes = new QualityOfServiceType[]{QualityOfServiceType.AT_MOST_ONCE, QualityOfServiceType.AT_LEAST_ONCE, QualityOfServiceType.EXACTLY_ONCE};
        this._qosCombo.setInput((Object)qosTypes);
        this.getToolkit().adapt(this._qosCombo.getControl(), true, true);
        this.getToolkit().createLabel(composite, "Retain By Default");
        this._byDefaultRetainCombo = new Combo(composite, 2052);
        this.getToolkit().adapt((Composite)this._byDefaultRetainCombo);
        this._byDefaultRetainCombo.add("true");
        this._byDefaultRetainCombo.add("false");
        this._byDefaultRetainCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelMqttBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("MQTT binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        CompoundValidator uriValidator = new CompoundValidator(new URLValidator("Potential problem with Host URI"));
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._hostURIText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__HOST), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(uriValidator), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._publishTopicNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__PUBLISH_TOPIC_NAME), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._connectAttemptsMaxText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__CONNECT_ATTEMPTS_MAX), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Connect Attempts Max must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._reconnectAttemptsMaxText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__RECONNECT_ATTEMPTS_MAX), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Reconnect Attempts Max must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._qosCombo), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__QUALITY_OF_SERVICE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._byDefaultRetainCombo), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)MqttPackage.Literals.CAMEL_MQTT_BINDING_TYPE__BY_DEFAULT_RETAIN), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyBooleanValidator("Retain By Default must be a valid boolean value (true or false) or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

