/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.IValidateConfiguration;
import org.switchyard.tools.ui.debug.ServiceHandlerBreakpoint;
import org.switchyard.tools.ui.debug.ValidateConfigurationBuilder;

public class ValidateHandlerBreakpoint
extends ServiceHandlerBreakpoint {
    private static final String MARKER_ID = "org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker";
    private static final String TYPE = "org.switchyard.handlers.ValidateHandler";
    private static final String EXCHANGE_VARIABLE = "exchange";
    private IValidateConfiguration _validateConfiguration;

    public ValidateHandlerBreakpoint() {
        super(TYPE, EXCHANGE_VARIABLE);
    }

    public ValidateHandlerBreakpoint(IResource resource, IInteractionConfiguration configuration, IValidateConfiguration validateConfiguration, boolean register) throws CoreException {
        super(resource, configuration, register, TYPE, EXCHANGE_VARIABLE, MARKER_ID);
        this._validateConfiguration = validateConfiguration;
    }

    public IValidateConfiguration getValidateConfiguration() {
        if (this._validateConfiguration == null) {
            try {
                this._validateConfiguration = ValidateConfigurationBuilder.create().updateFrom(this.getMarker().getAttributes()).build();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this._validateConfiguration;
    }

    public void setValidateConfiguration(IValidateConfiguration configuration) throws CoreException {
        if (configuration.equals(this._validateConfiguration)) {
            return;
        }
        Map attributes = this.getMarker().getAttributes();
        attributes.putAll(configuration.toAttributesMap());
        this.setAttributes(attributes);
        this._validateConfiguration = configuration;
        if (this.getDelegates().size() > 0) {
            this.configurationUpdated();
        }
    }

    @Override
    protected String createMessageCondition() {
        return this.createCondition(super.createMessageCondition());
    }

    @Override
    protected String createFaultCondition() {
        return this.createCondition(super.createFaultCondition());
    }

    private String createCondition(String baseCondition) {
        String validateCondition = this.createValidateCondition();
        if (baseCondition == null) {
            return validateCondition;
        }
        if (validateCondition == null) {
            return baseCondition;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(baseCondition);
        buffer.append("\n        && ");
        buffer.append(validateCondition);
        buffer.append(')');
        return buffer.toString();
    }

    private String createValidateCondition() {
        Set<String> types = this.getValidateConfiguration().getValidateTypes();
        if (types == null || types.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append("get(").append(EXCHANGE_VARIABLE).append(") != null && ");
        buffer.append("java.util.Arrays.asList(");
        Iterator<String> typeIter = types.iterator();
        while (typeIter.hasNext()) {
            String type = typeIter.next();
            buffer.append('\"').append(type).append('\"');
            if (!typeIter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(").contains(").append(EXCHANGE_VARIABLE).append(".getContext().getProperty(\"org.switchyard.contentType\").getValue().toString())");
        buffer.append(')');
        return buffer.toString();
    }
}

