/* Generated By:JJTree: Do not edit this line. JoinPredicate.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.designer.query.sql.lang.IJoinPredicate;
import org.teiid.designer.query.sql.lang.IJoinType.Types;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory.ASTNodes;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.GroupSymbol;

/**
 *
 */
public class JoinPredicate extends FromClause
    implements IJoinPredicate<FromClause, LanguageVisitor>{

    private FromClause leftClause;

    private FromClause rightClause;

    private JoinType joinType;

    private List<Criteria> joinCriteria;

    /**
     * @param p
     * @param id
     */
    public JoinPredicate(TeiidParser p, int id) {
        super(p, id);
        joinType = p.createASTNode(ASTNodes.JOIN_TYPE);
        joinType.setKind(Types.JOIN_INNER);
    }

    /**
     * Set left clause 
     * @param predicate Left clause to set
     */
    @Override
    public void setLeftClause(FromClause predicate) {
        this.leftClause = predicate;
    }
    
    /**
     * Get left clause
     * @return Left clause
     */
    @Override
    public FromClause getLeftClause() {
        return this.leftClause;
    }
    
    /**
     * Set right clause 
     * @param predicate Right clause to set
     */
    @Override
    public void setRightClause(FromClause predicate) {
        this.rightClause = predicate;
    }
    
    /**
     * Get right clause
     * @return Right clause
     */
    @Override
    public FromClause getRightClause() {
        return this.rightClause;
    }
    
    /**
     * Set join type for this predicate
     * @param type Type of join
     */
    public void setJoinType(JoinType type) { 
        this.joinType = type;
    }
    
    /**
     * Get join type for this predicate
     * @return Type of join
     */
    public JoinType getJoinType() {
        return this.joinType;
    }               
    
    /**
     * Set join criteria for this predicate
     * @param criteria List of {@link Criteria} set on this predicate
     */
    public void setJoinCriteria(List<Criteria> criteria) {
        List<Criteria> newCriteria = new ArrayList<Criteria>();
        for (Criteria criterium : criteria) {
            newCriteria.addAll(Criteria.separateCriteriaByAnd(criterium));
        }

        this.joinCriteria = newCriteria;
    }
    
    /**
     * Get join criteria for this predicate
     * @return List of {@link Criteria} 
     */
    public List getJoinCriteria() {
        return this.joinCriteria;
    }

    @Override
    public void collectGroups(Collection<GroupSymbol> groups) {
        if(this.leftClause != null) { 
            this.leftClause.collectGroups(groups);
        } 
        if(this.rightClause != null) {
            this.rightClause.collectGroups(groups);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + ((this.joinCriteria == null) ? 0 : this.joinCriteria.hashCode());
        result = prime * result + ((this.joinType == null) ? 0 : this.joinType.hashCode());
        result = prime * result + ((this.leftClause == null) ? 0 : this.leftClause.hashCode());
        result = prime * result + ((this.rightClause == null) ? 0 : this.rightClause.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (getClass() != obj.getClass()) return false;
        JoinPredicate other = (JoinPredicate)obj;
        if (this.joinCriteria == null) {
            if (other.joinCriteria != null) return false;
        } else if (!this.joinCriteria.equals(other.joinCriteria)) return false;
        if (this.joinType == null) {
            if (other.joinType != null) return false;
        } else if (!this.joinType.equals(other.joinType)) return false;
        if (this.leftClause == null) {
            if (other.leftClause != null) return false;
        } else if (!this.leftClause.equals(other.leftClause)) return false;
        if (this.rightClause == null) {
            if (other.rightClause != null) return false;
        } else if (!this.rightClause.equals(other.rightClause)) return false;
        return true;
    }

    /** Accept the visitor. **/
    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public JoinPredicate clone() {
        JoinPredicate clone = new JoinPredicate(this.parser, this.id);

        if(getLeftClause() != null)
            clone.setLeftClause(getLeftClause().clone());
        if(getRightClause() != null)
            clone.setRightClause(getRightClause().clone());
        if(getJoinType() != null)
            clone.setJoinType(getJoinType().clone());
        if(getJoinCriteria() != null)
            clone.setJoinCriteria(cloneList(getJoinCriteria()));
        clone.setOptional(isOptional());
        clone.setMakeInd(isMakeInd());
        clone.setNoUnnest(isNoUnnest());
        clone.setMakeDep(isMakeDep());
        clone.setMakeNotDep(isMakeNotDep());
        clone.setPreserve(isPreserve());

        return clone;
    }

}
/* JavaCC - OriginalChecksum=997199fc490b061080c014d8a592db24 (do not edit this line) */
