/* Generated By:JJTree&JavaCC: Do not edit this line. Teiid7Parser.java */
package org.teiid.query.parser.v7;
import org.teiid.query.sql.lang.*;


import java.math.BigInteger;
import java.util.*;
import java.util.regex.Matcher;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.query.sql.lang.IMatchCriteria.MatchMode;
import org.teiid.designer.query.sql.lang.IJoinType;
import org.teiid.runtime.client.Messages;
import org.teiid.language.SortSpecification.NullOrdering;
import org.teiid.metadata.Column;
import org.teiid.metadata.BaseColumn.NullType;
import org.teiid.metadata.Table;
import org.teiid.query.parser.AbstractTeiidParser;
import org.teiid.query.parser.ParsedDataType;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidNodeFactory.ASTNodes;
import org.teiid.query.sql.lang.*;
import org.teiid.query.sql.lang.CriteriaOperator.Operator;
import org.teiid.query.sql.lang.SubqueryCompareCriteria.PredicateQuantifier;
import org.teiid.query.sql.proc.*;
import org.teiid.query.sql.symbol.*;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.StringUtil;

/** 
 * <p>The SQLParser is a JavaCC-generated parser that reads a SQL string and produces a 
 * Query object.  The SQLParser.java file is generated by JavaCC from the SQLParser.jj
 * file.  <B>WARNING:</B> DO NOT MODIFY the SQLParser.java file as it will be 
 * regenerated from the .jj file and your changes will be lost!</p>
 */
@SuppressWarnings({"nls", "unused", "javadoc"})
public class Teiid7Parser extends AbstractTeiidParser/*@bgen(jjtree)*/implements Teiid7ParserTreeConstants, Teiid7ParserConstants {/*@bgen(jjtree)*/
  protected JJTTeiid7ParserState jjtree = new JJTTeiid7ParserState();
    private String getComment(Token t) {
        Token optToken = t.specialToken;
        if (optToken == null) {
            return ""; //$NON-NLS-1$
        }

        //handle nested comments
        String image = optToken.image;
        while (optToken.specialToken != null) {
            optToken = optToken.specialToken;
            image = optToken.image + image;
        }

        String hint = image.substring(2, image.length() - 2);
        if (hint.startsWith("+")) { //$NON-NLS-1$
            hint = hint.substring(1);
        }

        return hint;
    }

    private boolean isNonStrictHint(Token t) {
        String[] parts = getComment(t).split("\u005c\u005cs"); //$NON-NLS-1$
        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(Limit.NON_STRICT)) {
                return true;
            }
        }
        return false;
    }

    private SourceHint getSourceHint(Token t) {
        String comment = getComment(t);
        Matcher matcher = SOURCE_HINT.matcher(comment);
        if (!matcher.find()) {
            return null;
        }
        SourceHint sourceHint = new SourceHint();
        String generalHint = matcher.group(1);
        if (generalHint != null) {
            sourceHint.setGeneralHint(normalizeStringLiteral(generalHint));
        }
        int end = matcher.end();
        matcher = SOURCE_HINT_ARG.matcher(comment);
        while (matcher.find(end)) {
            end = matcher.end();
            sourceHint.setSourceHint(matcher.group(1), normalizeStringLiteral(matcher.group(2)), false);
        }
        return sourceHint;
    }

    private SubqueryHint getSubqueryHint(Token t) {
        SubqueryHint hint = new SubqueryHint();
        String[] parts = getComment(t).split("\u005c\u005cs"); //$NON-NLS-1$
        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(SubqueryHint.MJ)) {
                hint.setMergeJoin(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.NOUNNEST)) {
                hint.setNoUnnest(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.DJ)) {
                hint.setDepJoin();
            }
        }
        return hint;
    }

    private void setFromClauseOptions(Token groupID, FromClause fromClause){
        String[] parts = getComment(groupID).split("\u005c\u005cs"); //$NON-NLS-1$

        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(Option.OPTIONAL)) {
                fromClause.setOptional(true);
            } else if (parts[i].equalsIgnoreCase(Option.MAKEDEP)) {
                fromClause.setMakeDep(true);
            } else if (parts[i].equalsIgnoreCase(Option.MAKENOTDEP)) {
                fromClause.setMakeNotDep(true);
            } else if (parts[i].equalsIgnoreCase(FromClause.MAKEIND)) {
                fromClause.setMakeInd(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.NOUNNEST)) {
                fromClause.setNoUnnest(true);
            }
        }
    }

    /**
     * Generate an expression name based on the function type and previous names.
     * @param info Parse info, including counts for each function type
     * @param functionType Null for expression, the function name for aggregates
     * @return New unique function name
     */
    private String generateFunctionName(ParseInfo info, String functionType) {
        if (functionType == null) {
            functionType = "expr"; //$NON-NLS-1$
        } else {
            functionType = functionType.toLowerCase();
        }
        if (info.nameCounts == null) {
            info.nameCounts = new HashMap<String, Integer>();
        }
        Integer num = info.nameCounts.get(functionType);
        if (num == null) {
            num = 0;
        }
        info.nameCounts.put(functionType, num + 1);
        return functionType + (num == 0 ? "" : ""+num); //$NON-NLS-1$   //$NON-NLS-2$  
    }

    @Override
    public ITeiidServerVersion getVersion() {
        if (version == null)
            version = new TeiidServerVersion("7.7.x");

        return version;
    }

//----------------------------------------------------
//----------------------------------------------------
  final public String stringVal() throws ParseException {
        Token t = null;
    t = jj_consume_token(STRINGVAL);
                {if (true) return normalizeStringLiteral(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public String id() throws ParseException {
        Token t = null;
    t = jj_consume_token(ID);
                {if (true) return normalizeId(t.image);}
    throw new Error("Missing return statement in function");
  }

/** 
 * Parse any of several command types - this is the main parser entry point. 
 * @param info instructions to parse the command
 * @return Parsed command
 * @throws ParseException if parsing failed
 */
  final public Command command(ParseInfo info) throws ParseException {
        Command command = null;
    if (jj_2_1(2)) {
      command = createUpdateProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      case LBRACE:
        command = callableStatement(info);
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

  final public Command designerCommand(ParseInfo info) throws ParseException {
        Command command = null;
    if (jj_2_2(2)) {
      command = updateProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

  final public Command updateProcedure(ParseInfo info) throws ParseException {
        Command command = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CREATE:
      command = createUpdateProcedure(info);
      break;
    case FOR:
      command = forEachRowTriggerAction(info);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

  final public Command createTrigger(ParseInfo info) throws ParseException {
        String target = null;
        TriggerAction triggerAction = null;
        Token event = null;
    jj_consume_token(CREATE);
    jj_consume_token(TRIGGER);
    jj_consume_token(ON);
    target = id();
    nonReserved("INSTEAD");
    jj_consume_token(OF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      event = jj_consume_token(INSERT);
      break;
    case UPDATE:
      event = jj_consume_token(UPDATE);
      break;
    case DELETE:
      event = jj_consume_token(DELETE);
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    triggerAction = forEachRowTriggerAction(info);
                AlterTrigger trigger = alterTrigger();
        trigger.setTarget(groupSymbol(target));
        trigger.setDefinition(triggerAction);
        trigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
        trigger.setCreate(true);
        {if (true) return trigger;}
    throw new Error("Missing return statement in function");
  }

  final public Command alter(ParseInfo info) throws ParseException {
        String target = null;
        QueryCommand command = null;
        Statement stmt = null;
        TriggerAction triggerAction = null;
        Token comment = null;
        Token event = null;
        String enabled = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      nonReserved("VIEW");
      target = id();
      jj_consume_token(AS);
                                                          comment = getToken(1).specialToken;
      command = queryExpression(info);
                    /*
             * if (comment != null) {
             *     command.setCacheHint(getQueryCacheOption(comment.image));
             * }
             */
                    AlterView view = alterView();
            view.setTarget(groupSymbol(target));
            view.setDefinition(command);
            {if (true) return view;}
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      target = id();
      jj_consume_token(AS);
                                                    comment = getToken(1).specialToken;
      stmt = statement(info);
                        CreateUpdateProcedureCommand cup = createASTNode(ASTNodes.CREATE_UPDATE_PROCEDURE_COMMAND);
            cup.setBlock(asBlock(stmt));
                        cup.setUpdateProcedure(false);
                        /*
             * if (comment != null) {
             *     cup.setCacheHint(getQueryCacheOption(comment.image));
             * }
             */
                        AlterProcedure procedure = alterProcedure();
            procedure.setTarget(groupSymbol(target));
            procedure.setDefinition(cup);
            {if (true) return procedure;}
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      jj_consume_token(ON);
      target = id();
      nonReserved("INSTEAD");
      jj_consume_token(OF);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        event = jj_consume_token(INSERT);
        break;
      case UPDATE:
        event = jj_consume_token(UPDATE);
        break;
      case DELETE:
        event = jj_consume_token(DELETE);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        triggerAction = forEachRowTriggerAction(info);
        break;
      case ID:
        enabled = nonReserved("ENABLED","DISABLED");
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    AlterTrigger trigger = alterTrigger();
            trigger.setTarget(groupSymbol(target));
            trigger.setDefinition(triggerAction);
            trigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
            if (enabled != null) {
                trigger.setEnabled(enabled.equalsIgnoreCase("ENABLED"));
            }
            {if (true) return trigger;}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TriggerAction forEachRowTriggerAction(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TriggerAction */
        TriggerAction jjtn000 = (TriggerAction)TeiidNodeFactory.jjtCreate(this, JJTTRIGGERACTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Block b = block();
        b.setAtomic(true);
        Statement stmt = null;
    try {
      jj_consume_token(FOR);
      jj_consume_token(EACH);
      jj_consume_token(ROW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEGIN:
        jj_consume_token(BEGIN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ATOMIC:
          jj_consume_token(ATOMIC);
          break;
        default:
          jj_la1[9] = jj_gen;
          ;
        }
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ALTER:
          case BEGIN:
          case BREAK:
          case CALL:
          case CONTINUE:
          case CREATE:
          case DECLARE:
          case DELETE:
          case DROP:
          case ERROR:
          case EXEC:
          case EXECUTE:
          case IF:
          case INSERT:
          case LEAVE:
          case LOOP:
          case SELECT:
          case TABLE:
          case UPDATE:
          case WITH:
          case WHILE:
          case ID:
          case LPAREN:
            ;
            break;
          default:
            jj_la1[10] = jj_gen;
            break label_1;
          }
          stmt = statement(info);
            b.addStatement(stmt);
        }
        jj_consume_token(END);
        break;
      case ALTER:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case LOOP:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case WHILE:
      case ID:
      case LPAREN:
        stmt = statement(info);
       b = asBlock(stmt);
       b.setAtomic(true);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setBlock(b);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public Command userCommand(ParseInfo info) throws ParseException {
        Command command = null;
        SourceHint sourceHint = null;
     int index = 1;
     Token t = null;
     do
       t = getToken(index++);
     while (t != null && t.kind == LPAREN);
     t = getToken(index);
     if (t != null)
      sourceHint = getSourceHint(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case WITH:
    case LPAREN:
      command = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      command = storedProcedure(info, newStoredProcedure());
      break;
    case INSERT:
      command = insert(info);
      break;
    case UPDATE:
      command = update(info);
      break;
    case DELETE:
      command = delete(info);
      break;
    case DROP:
      command = dropTable(info);
      break;
    default:
      jj_la1[12] = jj_gen;
      if (jj_2_3(2)) {
        command = createTempTable(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
          command = alter(info);
          break;
        case CREATE:
          command = createTrigger(info);
          break;
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
            if (sourceHint != null) {
//	        if (command instanceof SetQuery) {
//	        	((SetQuery)command).getProjectedQuery().setSourceHint(sourceHint);
//	        } else {
                        command.setSourceHint(sourceHint);
//	    	}
            }
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/** 
 * Parse drop table command. 
 * @param info instructions to parse the command
 * @return Parsed command
 * @throws ParseException if parsing failed
 */
  final public Command dropTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Drop */
        Drop jjtn000 = (Drop)TeiidNodeFactory.jjtCreate(this, JJTDROP);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String table = null;
    try {
      jj_consume_token(DROP);
      jj_consume_token(TABLE);
      table = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setTable(groupSymbol(table));
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/** 
 * Parse create temp table command. 
 * @param info instructions to parse the command
 * @return Parsed command
 * @throws ParseException if parsing failed
 */
  final public Command createTempTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Create */
    Create jjtn000 = (Create)TeiidNodeFactory.jjtCreate(this, JJTCREATE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String table = null;
    String pkId = null;
    Column col = null;
    try {
      jj_consume_token(CREATE);
      jj_consume_token(LOCAL);
      jj_consume_token(TEMPORARY);
      jj_consume_token(TABLE);
      table = id();
      jj_consume_token(LPAREN);
        jjtn000.setTable(groupSymbol(table));
      col = tableElement(info);
      jjtn000.getColumns().add(col);
      label_2:
      while (true) {
        if (jj_2_4(2)) {
          ;
        } else {
          break label_2;
        }
        jj_consume_token(COMMA);
        col = tableElement(info);
        jjtn000.getColumns().add(col);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(PRIMARY);
        nonReserved("KEY");
        jj_consume_token(LPAREN);
        pkId = id();
        jjtn000.getPrimaryKey().add(elementSymbol(validateName(pkId, true)));
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[14] = jj_gen;
            break label_3;
          }
          jj_consume_token(COMMA);
          pkId = id();
         jjtn000.getPrimaryKey().add(elementSymbol(validateName(pkId, true)));
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Column tableElement(ParseInfo info) throws ParseException {
    String element = null;
    String type = null;
    boolean autoIncrement = false;
    boolean notNull = false;
    element = id();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      type = dataTypeString();
      break;
    case ID:
      nonReserved("SERIAL");
        type = "INTEGER";
        autoIncrement = true;
        notNull = true;
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                     notNull = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
        try {
          Column c = new Column(getVersion());
          c.setName(validateName(element, true));
          c.setRuntimeType(type);
          c.setAutoIncremented(autoIncrement);
          c.setNullType(notNull?NullType.No_Nulls:NullType.Nullable);
          {if (true) return c;}
        } catch (Exception ex) {
          {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse error statement
 * @throws ParseException if parsing failed
 */
  final public RaiseErrorStatement errorStatement(ParseInfo info) throws ParseException {
    Expression errMsg = null;
    jj_consume_token(ERROR);
    errMsg = expression(info);
        RaiseErrorStatement errStmt = raiseErrorStatement(errMsg);
        {if (true) return errStmt;}
    throw new Error("Missing return statement in function");
  }

  final public RaiseErrorStatement raiseErrorStatement(Expression expression) throws ParseException {
 /*@bgen(jjtree) RaiseErrorStatement */
  RaiseErrorStatement jjtn000 = (RaiseErrorStatement)TeiidNodeFactory.jjtCreate(this, JJTRAISEERRORSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.setExpression(expression);
      {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse statement
 * @throws ParseException if parsing failed
 */
  final public Statement statement(ParseInfo info) throws ParseException {
    Statement statement;
    String label = null;
    if (jj_2_5(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        label = id();
        jj_consume_token(COLON);
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOOP:
        statement = loopStatement(info);
        break;
      case WHILE:
        statement = whileStatement(info);
        break;
      case BEGIN:
        statement = compoundStatement(info);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                ((Labeled) statement).setLabel(label);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case ID:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          statement = ifStatement(info);
          break;
        case ALTER:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case LEAVE:
        case SELECT:
        case TABLE:
        case UPDATE:
        case WITH:
        case ID:
        case LPAREN:
          statement = delimitedStatement(info);
          break;
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  final public Statement delimitedStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    if (jj_2_6(3)) {
      stmt = assignStatement(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case ID:
      case LPAREN:
        stmt = sqlStatement(info);
        break;
      case ERROR:
        stmt = errorStatement(info);
        break;
      case DECLARE:
        stmt = declareStatement(info);
        break;
      case BREAK:
      case CONTINUE:
      case LEAVE:
        stmt = branchingStatement(info);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
             {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public Block compoundStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    Block block = block();
    Boolean atomic = null;
    jj_consume_token(BEGIN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATOMIC:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                     atomic = Boolean.FALSE;
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      jj_consume_token(ATOMIC);
                                                         if (atomic == null) {atomic = Boolean.TRUE;}
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case LOOP:
      case SELECT:
      case TABLE:
      case UPDATE:
      case WITH:
      case WHILE:
      case ID:
      case LPAREN:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_4;
      }
      stmt = statement(info);
            block.addStatement(stmt);
    }
    jj_consume_token(END);
        if (atomic != null) {
                block.setAtomic(atomic);
        }
        {if (true) return block;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse break statement 
 * @throws ParseException if parsing failed
 */
  final public BranchingStatement branchingStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) BranchingStatement */
    BranchingStatement jjtn000 = (BranchingStatement)TeiidNodeFactory.jjtCreate(this, JJTBRANCHINGSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token mode = null;
    String label = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BREAK:
      case CONTINUE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BREAK:
          mode = jj_consume_token(BREAK);
          break;
        case CONTINUE:
          mode = jj_consume_token(CONTINUE);
          break;
        default:
          jj_la1[26] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          label = id();
          break;
        default:
          jj_la1[27] = jj_gen;
          ;
        }
        break;
      case LEAVE:
        mode = jj_consume_token(LEAVE);
        label = id();
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setMode(BranchingStatement.BranchingMode.valueOf(mode.image.toUpperCase()));
            jjtn000.setLabel(label);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse while statement 
 * @throws ParseException if parsing failed
 */
  final public WhileStatement whileStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) WhileStatement */
    WhileStatement jjtn000 = (WhileStatement)TeiidNodeFactory.jjtCreate(this, JJTWHILESTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Criteria criteria = null;
    Statement stmt = null;
    try {
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      criteria = criteria(info);
      jj_consume_token(RPAREN);
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCondition(criteria);
        jjtn000.setBlock(asBlock(stmt));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse loop statement 
 * @throws ParseException if parsing failed
 */
  final public LoopStatement loopStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) LoopStatement */
    LoopStatement jjtn000 = (LoopStatement)TeiidNodeFactory.jjtCreate(this, JJTLOOPSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String cursor = null;
    QueryCommand query = null;
    Statement stmt = null;
    try {
      jj_consume_token(LOOP);
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
      query = queryExpression(info);
      jj_consume_token(RPAREN);
      jj_consume_token(AS);
      cursor = id();
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setBlock(asBlock(stmt));
        jjtn000.setCommand(query);
        jjtn000.setCursorName(cursor);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse if statement 
 * @throws ParseException if parsing failed
 */
  final public IfStatement ifStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) IfStatement */
    IfStatement jjtn000 = (IfStatement)TeiidNodeFactory.jjtCreate(this, JJTIFSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Criteria criteria = null;
    Statement ifStatement = null;
    Statement elseStatement = null;
    try {
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      criteria = criteria(info);
      jj_consume_token(RPAREN);
      ifStatement = statement(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseStatement = statement(info);
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCondition(criteria);
        jjtn000.setIfBlock(asBlock(ifStatement));
        jjtn000.setElseBlock(asBlock(elseStatement));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse criteria selector
 * @throws ParseException if parsing failed
 */
  final public CriteriaSelector criteriaSelector() throws ParseException {
 /*@bgen(jjtree) CriteriaSelector */
    CriteriaSelector jjtn000 = (CriteriaSelector)TeiidNodeFactory.jjtCreate(this, JJTCRITERIASELECTOR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String element = null;
    List elements = new ArrayList(2);
    Token operator = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
      case IN:
      case IS:
      case LIKE:
      case EQ:
      case NE:
      case NE2:
      case LT:
      case LE:
      case GT:
      case GE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          operator = jj_consume_token(EQ);
          break;
        case NE:
          operator = jj_consume_token(NE);
          break;
        case NE2:
          operator = jj_consume_token(NE2);
          break;
        case LE:
          operator = jj_consume_token(LE);
          break;
        case GE:
          operator = jj_consume_token(GE);
          break;
        case LT:
          operator = jj_consume_token(LT);
          break;
        case GT:
          operator = jj_consume_token(GT);
          break;
        case IN:
          operator = jj_consume_token(IN);
          break;
        case LIKE:
          operator = jj_consume_token(LIKE);
          break;
        case IS:
          operator = jj_consume_token(IS);
          jj_consume_token(NULL);
          break;
        case BETWEEN:
          operator = jj_consume_token(BETWEEN);
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
       jjtn000.setSelectorType(Operator.getOperator(getVersion(), operator.image));
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      jj_consume_token(CRITERIA);
      if (jj_2_7(4)) {
        jj_consume_token(ON);
        jj_consume_token(LPAREN);
        element = id();
       elements.add(elementSymbol(element));
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[32] = jj_gen;
            break label_5;
          }
          jj_consume_token(COMMA);
          element = id();
                elements.add(elementSymbol(element));
        }
        jj_consume_token(RPAREN);
       jjtn000.setElements(elements);
      } else {
        ;
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse has criteria
 * @throws ParseException
 */
  final public HasCriteria hasCriteria() throws ParseException {
 /*@bgen(jjtree) HasCriteria */
    HasCriteria jjtn000 = (HasCriteria)TeiidNodeFactory.jjtCreate(this, JJTHASCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);CriteriaSelector critSelector = null;
    try {
      jj_consume_token(HAS);
      critSelector = criteriaSelector();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setSelector(critSelector);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse declare statement
 * @throws ParseException if parsing failed
 */
  final public DeclareStatement declareStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DeclareStatement */
    DeclareStatement jjtn000 = (DeclareStatement)TeiidNodeFactory.jjtCreate(this, JJTDECLARESTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String var = null;
    Constant type = null;
    ElementSymbol variableID = null;
    LanguageObject value = null;
    try {
      jj_consume_token(DECLARE);
      type = dataType();
      var = id();
        variableID = elementSymbol(var);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case EQ:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          nonReserved(":=");
          break;
        case EQ:
          jj_consume_token(EQ);
          break;
        default:
          jj_la1[33] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        value = assignStatementOperand(info);
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setVariable(variableID);
        jjtn000.setVariableType((String) type.getValue());
        if (value instanceof Expression) {
            jjtn000.setExpression((Expression)value);
        }
        else if (value instanceof QueryCommand) {
            jjtn000.setExpression(scalarSubquery((QueryCommand)value));
        }
        else {
            jjtn000.setCommand((Command)value);
        }

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse assignment statement
 * @throws ParseException if parsing failed
 */
  final public AssignmentStatement assignStatement(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    String var = null;
    ElementSymbol elementID = null;
    var = id();
        elementID = elementSymbol(var);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      nonReserved(":=");
      break;
    case EQ:
      jj_consume_token(EQ);
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    value = assignStatementOperand(info);
        {if (true) return assignmentStatement(elementID, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse operand of assignment statement, which can be nested
 * arbitrarily deeply in parentheses.
 * @throws ParseException if parsing failed
 */
  final public LanguageObject assignStatementOperand(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    if (jj_2_8(2147483647)) {
      value = insert(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        //deprecated
              value = update(info);
        break;
      case DELETE:
        //deprecated
              value = delete(info);
        break;
      default:
        jj_la1[36] = jj_gen;
        if (jj_2_9(2147483647)) {
          value = expression(info);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SELECT:
          case TABLE:
          case WITH:
          case LPAREN:
            value = queryExpression(info);
            break;
          default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse sql statement 
 * @throws ParseException if parsing failed
 */
  final public CommandStatement sqlStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CommandStatement */
    CommandStatement jjtn000 = (CommandStatement)TeiidNodeFactory.jjtCreate(this, JJTCOMMANDSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Command cmd = null;
    String var = null;
    ElementSymbol elementID = null;
    StoredProcedure storedProcedure = null;
    try {
      if (jj_2_10(2)) {
        cmd = userCommand(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXEC:
        case EXECUTE:
          cmd = dynamicCommand(info);
          break;
        case ID:
          var = id();
        storedProcedure = newStoredProcedure();
        elementID = elementSymbol(var);
        SPParameter parameter = new SPParameter(this, 1, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
        parameter.setExpression(elementID);
            storedProcedure.setParameter(parameter);
            storedProcedure.setCalledWithReturn(true);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
            nonReserved(":=");
            break;
          case EQ:
            jj_consume_token(EQ);
            break;
          default:
            jj_la1[38] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          cmd = storedProcedure(info, storedProcedure);
          break;
        default:
          jj_la1[39] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCommand(cmd);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public TranslateCriteria translateCriteria(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TranslateCriteria */
    TranslateCriteria jjtn000 = (TranslateCriteria)TeiidNodeFactory.jjtCreate(this, JJTTRANSLATECRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String element = null;
    Expression value = null;
    ElementSymbol leftSymbol = null;

    CriteriaSelector critSelector = null;

    CompareCriteria compCrit = null;

    List critList = null;
    try {
      jj_consume_token(TRANSLATE);
      critSelector = criteriaSelector();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
            critList = new ArrayList(2);
        jj_consume_token(LPAREN);
        element = id();
        jj_consume_token(EQ);
        value = expression(info);
            compCrit = createASTNode(ASTNodes.COMPARE_CRITERIA);
            leftSymbol = elementSymbol(element);
            compCrit.setLeftExpression(leftSymbol);
            compCrit.setRightExpression(value);
            compCrit.setOperator(Operator.EQ);
            critList.add(compCrit);
            compCrit = null;
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[40] = jj_gen;
            break label_6;
          }
          jj_consume_token(COMMA);
          element = id();
          jj_consume_token(EQ);
          value = expression(info);
            compCrit = createASTNode(ASTNodes.COMPARE_CRITERIA);
            leftSymbol = elementSymbol(element);
            compCrit.setLeftExpression(leftSymbol);
            compCrit.setRightExpression(value);
            compCrit.setOperator(Operator.EQ);
            critList.add(compCrit);
            compCrit = null;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setSelector(critSelector);

        if ( critList != null) {
            jjtn000.setTranslations(critList);
        }

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse create update procedure command
 * @throws ParseException if parsing failed
 */
  final public CreateUpdateProcedureCommand createUpdateProcedure(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CreateUpdateProcedureCommand */
    CreateUpdateProcedureCommand jjtn000 = (CreateUpdateProcedureCommand)TeiidNodeFactory.jjtCreate(this, JJTCREATEUPDATEPROCEDURECOMMAND);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Statement stmt = null;
    try {
      jj_consume_token(CREATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
                         jjtn000.setUpdateProcedure(false);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        jj_consume_token(UPDATE);
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
      jj_consume_token(PROCEDURE);
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setBlock(asBlock(stmt));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse error statement
 * @throws ParseException if parsing failed
 */
  final public DynamicCommand dynamicCommand(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DynamicCommand */
    DynamicCommand jjtn000 = (DynamicCommand)TeiidNodeFactory.jjtCreate(this, JJTDYNAMICCOMMAND);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression sql = null;
    String groupID = null;
        GroupSymbol group = null;
        int updateCount = 0;
        Token updateToken = null;
        List<ProjectedColumn> elements = null;
        SetClauseList using = null;
        SetClauseList setClauseList = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXECUTE:
        jj_consume_token(EXECUTE);
        break;
      case EXEC:
        jj_consume_token(EXEC);
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case IMMEDIATE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING:
          jj_consume_token(STRING);
          break;
        case IMMEDIATE:
          jj_consume_token(IMMEDIATE);
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      sql = expression(info);
        jjtn000.setSql(sql);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        elements = createElementsWithTypes(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTO:
          jj_consume_token(INTO);
          groupID = id();
         group = groupSymbol(groupID);
          break;
        default:
          jj_la1[47] = jj_gen;
          ;
        }
         jjtn000.setIntoGroup(group);
         List<ElementSymbol> symbols = new ArrayList(elements.size());
         for (ProjectedColumn col : elements) {
                symbols.add(col.getSymbol());
         }
         jjtn000.setAsColumns(symbols);
         jjtn000.setAsClauseSet(true);
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        using = setClauseList(true, info);
             jjtn000.setUsing(using);
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        jj_consume_token(UPDATE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGERVAL:
          updateToken = jj_consume_token(INTEGERVAL);
        updateCount = Integer.parseInt(updateToken.image);
          break;
        case STAR:
          jj_consume_token(STAR);
        updateCount = 2;
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setUpdatingModelCount(updateCount);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SetClauseList setClauseList(boolean shortName, ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SetClauseList */
        SetClauseList jjtn000 = (SetClauseList)TeiidNodeFactory.jjtCreate(this, JJTSETCLAUSELIST);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String element = null;
        String symbolName = null;
        ElementSymbol symbol = null;
        Expression value = null;
    try {
      element = id();
      jj_consume_token(EQ);
        try {
           symbolName = shortName?validateName(element, true):element;
           symbol = elementSymbol(symbolName);
           value = expression(info);
           jjtn000.addClause(setClause(symbol, value));
        } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        element = id();
        jj_consume_token(EQ);
        try {
               symbolName = shortName?validateName(element, true):element;
           symbol = elementSymbol(symbolName);
           value = expression(info);
           jjtn000.addClause(setClause(symbol, value));
        } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SetClause setClause(ElementSymbol symbol, Expression value) throws ParseException {
 /*@bgen(jjtree) SetClause */
  SetClause jjtn000 = (SetClause)TeiidNodeFactory.jjtCreate(this, JJTSETCLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setSymbol(symbol);
        jjtn000.setValue(value);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Create elements with datatypes
 * @throws ParseException if parsing failed
 */
  final public List<ProjectedColumn> createElementsWithTypes(ParseInfo info) throws ParseException {
        String element = null;
        String type = null;
        ProjectedColumn symbol = null;
        List<ProjectedColumn> elements = new ArrayList<ProjectedColumn>();
    element = id();
    type = dataTypeString();
            try {
               symbol = projectedColumn(validateName(element, true), type);
               elements.add(symbol);
            } catch (Exception ex) {
               {if (true) throw new ParseException(ex.getLocalizedMessage());}
            }
    label_8:
    while (true) {
      if (jj_2_11(2)) {
        ;
      } else {
        break label_8;
      }
      jj_consume_token(COMMA);
      element = id();
      type = dataTypeString();
                  try {
                  symbol = projectedColumn(validateName(element, true), type);
                      elements.add(symbol);
                  } catch (Exception ex) {
              {if (true) throw new ParseException(ex.getLocalizedMessage());}
          }
    }
                {if (true) return elements;}
    throw new Error("Missing return statement in function");
  }

  final public ProjectedColumn projectedColumn(String name, String type) throws ParseException {
 /*@bgen(jjtree) ProjectedColumn */
  ProjectedColumn jjtn000 = (ProjectedColumn)TeiidNodeFactory.jjtCreate(this, JJTPROJECTEDCOLUMN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        jjtn000.setType(type);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public StoredProcedure callableStatement(ParseInfo info) throws ParseException {
        StoredProcedure storedProcedure = newStoredProcedure();
        storedProcedure.setCallableStatement(true);
        Token call = null;
        String procName = null;
        Option option = null;
        SPParameter parameter = null;
        int parameterIndex = 1;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
      jj_consume_token(EQ);
           parameter = new SPParameter(this, parameterIndex++, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
           storedProcedure.setParameter(parameter);
           storedProcedure.setCalledWithReturn(true);
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    jj_consume_token(CALL);
    procName = id();
                storedProcedure.setProcedureName(procName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      storedProcedure = executeUnnamedParams(info, storedProcedure, parameterIndex);
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/**
 * * Parse stored query command
 * @throws ParseException if parsing failed
 */
  final public StoredProcedure storedProcedure(ParseInfo info, StoredProcedure storedProcedure) throws ParseException {
        String procName = null;
        Option option = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXEC:
      jj_consume_token(EXEC);
      break;
    case EXECUTE:
      jj_consume_token(EXECUTE);
      break;
    case CALL:
      jj_consume_token(CALL);
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    procName = id();
                        storedProcedure.setProcedureName(procName);
    jj_consume_token(LPAREN);
    if (jj_2_12(2147483647)) {
      storedProcedure = executeNamedParams(info, storedProcedure);
    } else {
      storedProcedure = executeUnnamedParams(info, storedProcedure, storedProcedure.getParameterCount() + 1);
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

  final public StoredProcedure newStoredProcedure() throws ParseException {
 /*@bgen(jjtree) StoredProcedure */
  StoredProcedure jjtn000 = (StoredProcedure)TeiidNodeFactory.jjtCreate(this, JJTSTOREDPROCEDURE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an exec statement with unnamed parameters</p>
 * @throws ParseException if parsing failed
 */
  final public StoredProcedure executeUnnamedParams(ParseInfo info, StoredProcedure storedProcedure, int parameterIndex) throws ParseException {
        SPParameter parameter = null;
    Expression value = null;
    if (jj_2_13(1)) {
      value = expression(info);
                                parameter = new SPParameter(this, parameterIndex++, value);
                                parameter.setParameterType(SPParameter.IN);
                                storedProcedure.setParameter(parameter);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        value = expression(info);
                                        parameter = new SPParameter(this, parameterIndex++, value);
                                        parameter.setParameterType(SPParameter.IN);
                                        storedProcedure.setParameter(parameter);
      }
    } else {
      ;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an exec statement with named parameters</p>
 * @throws ParseException if parsing failed
 */
  final public StoredProcedure executeNamedParams(ParseInfo info, StoredProcedure storedProcedure) throws ParseException {
        String name = null;
    Expression value = null;
        SPParameter parameter = null;
        int parameterIndex = 1;
                storedProcedure.setDisplayNamedParameters(true);
    name = id();
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GT:
      jj_consume_token(GT);
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    value = expression(info);
                        parameter = new SPParameter(this, parameterIndex++, value);
                        parameter.setName(name);
                        parameter.setParameterType(SPParameter.IN);
                        storedProcedure.setParameter(parameter);
                        parameter = null;
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      name = id();
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        jj_consume_token(GT);
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      value = expression(info);
                                parameter = new SPParameter(this, parameterIndex++, value);
                                parameter.setName(name);
                                parameter.setParameterType(SPParameter.IN);
                                storedProcedure.setParameter(parameter);
                                parameter = null;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse an INSERT command
 * @return Parsed insert statement
 * @throws ParseException if parsing failed
 */
  final public Insert insert(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Insert */
        Insert jjtn000 = (Insert)TeiidNodeFactory.jjtCreate(this, JJTINSERT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String group = null;
        List values = null;
        List<ElementSymbol> columns = null;
        Option option = null;
        QueryCommand query = null;
    try {
      jj_consume_token(INSERT);
      jj_consume_token(INTO);
      group = id();
      if (jj_2_14(2147483647)) {
        columns = columnList(false);
          jjtn000.setVariables(columns);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VALUES:
        jj_consume_token(VALUES);
        jj_consume_token(LPAREN);
        values = expressionList(info);
        jj_consume_token(RPAREN);
                    // Store each row of values
                    jjtn000.setValues(values);
        break;
      case SELECT:
      case TABLE:
      case WITH:
      case LPAREN:
        query = queryExpression(info);
                    jjtn000.setQueryExpression(query);
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
            jjtn000.setOption(option);
        break;
      default:
        jj_la1[63] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Store group
                jjtn000.setGroup(groupSymbol(group) );

                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public List<ElementSymbol> columnList(boolean validate) throws ParseException {
        String element = null;
        List<ElementSymbol> symbols = new LinkedList<ElementSymbol>();
    jj_consume_token(LPAREN);
    element = id();
                if (validate) {
                    try {
                            element = validateName(element, true);
                        } catch (Exception ex) {
                {if (true) throw new ParseException(ex.getLocalizedMessage());}
            }
                }
                symbols.add(elementSymbol(element));
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      element = id();
                        if (validate) {
                            try {
                                    element = validateName(element, true);
                                } catch (Exception ex) {
                    {if (true) throw new ParseException(ex.getLocalizedMessage());}
                }
                        }
                        symbols.add(elementSymbol(element));
    }
    jj_consume_token(RPAREN);
                {if (true) return symbols;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse row values - this is a comma separated list of values.
 * @return List of values, never null
 * @throws ParseException if parsing failed
 */
  final public ArrayList<Expression> expressionList(ParseInfo info) throws ParseException {
        ArrayList<Expression> rowVals = new ArrayList<Expression>(4);
        Expression value = null;
    value = expression(info);
        rowVals.add(value);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[65] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      value = expression(info);
            rowVals.add(value);
    }
                {if (true) return rowVals;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse an UPDATE command
 * @return Parsed update statement
 * @throws ParseException if parsing failed
 */
  final public Update update(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Update */
        Update jjtn000 = (Update)TeiidNodeFactory.jjtCreate(this, JJTUPDATE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String group = null;
        SetClauseList setClauseList = null;
        Criteria criteria = null;
        Option option = null;
    try {
      jj_consume_token(UPDATE);
      group = id();
      jj_consume_token(SET);
      setClauseList = setClauseList(false, info);
                jjtn000.setChangeList(setClauseList);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        criteria = where(info);
        break;
      default:
        jj_la1[66] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
           jjtn000.setOption(option);
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Store group
                jjtn000.setGroup(groupSymbol( group) );

                // Store optional criteria
                if(criteria != null) {
                        jjtn000.setCriteria(criteria);
                }

                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a DELETE command
 * @return Parsed delete statement
 * @throws ParseException if parsing failed
 */
  final public Delete delete(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Delete */
        Delete jjtn000 = (Delete)TeiidNodeFactory.jjtCreate(this, JJTDELETE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String group = null;
        Criteria criteria = null;
        Option option = null;
    try {
      jj_consume_token(DELETE);
      jj_consume_token(FROM);
      group = id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        criteria = where(info);
        break;
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
           jjtn000.setOption(option);
        break;
      default:
        jj_la1[69] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setGroup(groupSymbol(group));
                jjtn000.setCriteria(criteria);

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryCommand queryExpression(ParseInfo info) throws ParseException {
    QueryCommand queryCommand = null;
        List<WithQueryCommand> withList = null;
        WithQueryCommand withQueryCommand = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      withQueryCommand = withListElement(info);
            withList = new LinkedList<WithQueryCommand>();
            withList.add(withQueryCommand);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[70] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        withQueryCommand = withListElement(info);
            withList.add(withQueryCommand);
      }
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    queryCommand = queryExpressionBody(info);
                queryCommand.setWith(withList);
                {if (true) return queryCommand;}
    throw new Error("Missing return statement in function");
  }

  final public WithQueryCommand withListElement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) WithQueryCommand */
   WithQueryCommand jjtn000 = (WithQueryCommand)TeiidNodeFactory.jjtCreate(this, JJTWITHQUERYCOMMAND);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);String name = null;
   List<ElementSymbol> columns = null;
   QueryCommand queryExpression = null;
    try {
      name = id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        columns = columnList(true);
        break;
      default:
        jj_la1[72] = jj_gen;
        ;
      }
      jj_consume_token(AS);
      jj_consume_token(LPAREN);
      queryExpression = queryExpression(info);
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            try {
               jjtn000.setGroupSymbol(groupSymbol(validateName(name, false)));
            } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
        jjtn000.setColumns(columns);
        jjtn000.setQueryExpression(queryExpression);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryCommand queryExpressionBody(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    Option option = null;
        OrderBy orderby = null;
        Limit limit = null;
        SetQuery.Operation type;
    query = queryTerm(info);
    label_14:
    while (true) {
      if (jj_2_15(1)) {
        ;
      } else {
        break label_14;
      }
      if (jj_2_16(2147483647) && (getToken(2).kind != JOIN)) {
        jj_consume_token(UNION);
                                                                              type = SetQuery.Operation.UNION;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCEPT:
          jj_consume_token(EXCEPT);
                                                                                                                              type = SetQuery.Operation.EXCEPT;
          break;
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      rightQuery = queryTerm(info);
                    query = setQuery(type, all, query, rightQuery);
                all = false;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby = orderby(info);
                               query.setOrderBy( orderby );
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      limit = limit(info);
                             query.setLimit( limit );
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    if (jj_2_17(2147483647)) {
      option = option(info);
                                                 query.setOption(option);
    } else {
      ;
    }
                {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public QueryCommand queryTerm(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    query = queryPrimary(info);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERSECT:
        ;
        break;
      default:
        jj_la1[78] = jj_gen;
        break label_15;
      }
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[80] = jj_gen;
        ;
      }
      rightQuery = queryPrimary(info);
                    query = setQuery(SetQuery.Operation.INTERSECT, all, query, rightQuery);
                all = false;
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public SetQuery setQuery(SetQuery.Operation operation, boolean all, QueryCommand leftQuery, QueryCommand rightQuery) throws ParseException {
 /*@bgen(jjtree) SetQuery */
  SetQuery jjtn000 = (SetQuery)TeiidNodeFactory.jjtCreate(this, JJTSETQUERY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setOperation(operation);
        jjtn000.setAll(all);
        jjtn000.setLeftQuery(leftQuery);
        jjtn000.setRightQuery(rightQuery);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryCommand queryPrimary(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    String name = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      query = query(info);
      break;
    case TABLE:
      jj_consume_token(TABLE);
      name = id();
           MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);

           Select select = createASTNode(ASTNodes.SELECT);
           select.setSymbols(Arrays.asList(multipleElementSymbol));

           UnaryFromClause unaryFromClause = createASTNode(ASTNodes.UNARY_FROM_CLAUSE);
           unaryFromClause.setGroup(groupSymbol(name));

           From from = createASTNode(ASTNodes.FROM);
           from.setClauses(Arrays.asList(unaryFromClause));

           Query q = createASTNode(ASTNodes.QUERY);
           q.setSelect(select);
           q.setFrom(from);
           query = q;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      query = queryExpressionBody(info);
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a SELECT query
 * @return Parsed query
 * @throws ParseException if parsing failed
 */
  final public Query query(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Query */
        Query jjtn000 = (Query)TeiidNodeFactory.jjtCreate(this, JJTQUERY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Select   select         = null;
        From     from           = null;
        Into     into                   = null;
        Criteria criteria       = null;
        GroupBy  groupBy        = null;
        Criteria having         = null;
    try {
      select = select(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTO:
        into = into(info);
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        from = from(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHERE:
          criteria = where(info);
          break;
        default:
          jj_la1[83] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GROUP:
          groupBy = groupBy(info);
          break;
        default:
          jj_la1[84] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HAVING:
          having = having(info);
          break;
        default:
          jj_la1[85] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Build query from parsed pieces
                jjtn000.setSelect( select );
                jjtn000.setFrom( from );
                jjtn000.setInto( into );
                jjtn000.setCriteria(criteria);
                jjtn000.setGroupBy(groupBy);
                jjtn000.setHaving(having);

                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Into into(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Into */
        Into jjtn000 = (Into)TeiidNodeFactory.jjtCreate(this, JJTINTO);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String groupID = null;
    try {
      jj_consume_token(INTO);
      groupID = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
        jjtn000.setGroup(groupSymbol(groupID));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a SELECT clause.  The select must handle elements, aliased elements
 * (x AS y), group.*, and *.  It also must handle an optional DISTINCT at the
 * beginning of the select list.  It also must handle a scalar subquery expression
 * in parentheses.</p>
 * <p>Example:  "SELECT group.element, group2.element2 AS x, group3.*". </p>
 * <p>Example:  "SELECT *". </p>
 * <p>Example:  "SELECT DISTINCT a, b, c".</p>
 * <p>Example:  "SELECT a, (SELECT b FROM groupC)".</p>
 * <p>Example:  "SELECT a, (SELECT b FROM groupC) as d".</p>
 * @return Parsed select
 * @throws ParseException if parsing failed
 */
  final public Select select(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Select */
        Select jjtn000 = (Select)TeiidNodeFactory.jjtCreate(this, JJTSELECT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);boolean isDistinct = false;             // unless DISTINCT keyword in SELECT
        Expression symbol = null;
    try {
      jj_consume_token(SELECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                              isDistinct=true;
          break;
        default:
          jj_la1[87] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
                    MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);
            jjtn000.addSymbol(multipleElementSymbol);
        break;
      default:
        jj_la1[90] = jj_gen;
        if (jj_2_18(1)) {
          symbol = selectSymbol(info);
                                                         jjtn000.addSymbol(symbol);
          label_16:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[89] = jj_gen;
              break label_16;
            }
            jj_consume_token(COMMA);
            symbol = selectSymbol(info);
                                                             jjtn000.addSymbol(symbol);
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setDistinct(isDistinct);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression selectSymbol(ParseInfo info) throws ParseException {
        Expression symbol = null;
    if (jj_2_19(1)) {
      symbol = selectExpression(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL_IN_GROUP:
        symbol = allInGroupSymbol();
        break;
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return symbol;}
    throw new Error("Missing return statement in function");
  }

  final public SingleElementSymbol selectExpression(ParseInfo info) throws ParseException {
        Expression expression = null;
    String alias = null;
    // Expression
                    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[92] = jj_gen;
        ;
      }
      alias = id();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
                SingleElementSymbol es = null;
                if(!(expression instanceof SingleElementSymbol)) {
                        String functionName = generateFunctionName(info, null);
                        ExpressionSymbol expressionSymbol = expressionSymbol();
                        expressionSymbol.setName(functionName);
                        expressionSymbol.setExpression(expression);
                        es = expressionSymbol;
                } else {
                    es = (SingleElementSymbol)expression;
                }
                if(alias != null) {
                    try {
                            alias = validateName(alias, false);
                        } catch (Exception ex) {
                {if (true) throw new ParseException(ex.getLocalizedMessage());}
            }
                        {if (true) return aliasSymbol(alias, es);}
                }
                {if (true) return es;}
    throw new Error("Missing return statement in function");
  }

  final public DerivedColumn derivedColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DerivedColumn */
        DerivedColumn jjtn000 = (DerivedColumn)TeiidNodeFactory.jjtCreate(this, JJTDERIVEDCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expression = null;
    String alias = null;
    try {
      // Expression
                      expression = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        alias = id();
        break;
      default:
        jj_la1[94] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                if(alias != null) {
                    try {
                            alias = validateName(alias, false);
                        } catch (Exception ex) {
                {if (true) throw new ParseException(ex.getLocalizedMessage());}
            }
                }
                jjtn000.setAlias(alias);
        jjtn000.setExpression(expression);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public MultipleElementSymbol allInGroupSymbol() throws ParseException {
 /*@bgen(jjtree) MultipleElementSymbol */
        MultipleElementSymbol jjtn000 = (MultipleElementSymbol)TeiidNodeFactory.jjtCreate(this, JJTMULTIPLEELEMENTSYMBOL);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token allInGroupToken = null;
    try {
      allInGroupToken = jj_consume_token(ALL_IN_GROUP);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        String name = normalizeId(allInGroupToken.image.substring(0, allInGroupToken.image.length() - 2));
                jjtn000.setName(name);
        {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public AggregateSymbol orderedAgg(ParseInfo info) throws ParseException {
    Token t = null;
        Expression expression = null;
        OrderBy orderBy = null;
        Expression condition = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLAGG:
      t = jj_consume_token(XMLAGG);
      break;
    case ARRAY_AGG:
      t = jj_consume_token(ARRAY_AGG);
      break;
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    condition = filterClause(info);
                String aggName = t.image.toUpperCase();
                String name = generateFunctionName(info, aggName);
                AggregateSymbol agg = newAggregateSymbol(name, aggName, false, expression);
                agg.setOrderBy(orderBy);
                agg.setCondition(condition);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

  final public AggregateSymbol textAgg(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        Character delimiter = null;
        Character quote = null;
        boolean header = false;
        List<DerivedColumn> expressions = new ArrayList<DerivedColumn>();
        OrderBy orderBy = null;
        String encoding = null;
        Expression condition = null;
    nonReserved("TEXTAGG");
    jj_consume_token(LPAREN);
    jj_consume_token(FOR);
    expression = derivedColumn(info);
                expressions.add(expression);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[97] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                        expressions.add(expression);
    }
    if (jj_2_20(2147483647) && ("delimiter".equalsIgnoreCase(getToken(1).image))) {
      jj_consume_token(ID);
      delimiter = charVal(info, "DELMITER");
    } else {
      ;
    }
    if (jj_2_21(2147483647) && ("quote".equalsIgnoreCase(getToken(1).image))) {
      jj_consume_token(ID);
      quote = charVal(info, "QUOTE");
    } else {
      ;
    }
    if (jj_2_22(2147483647) && ("header".equalsIgnoreCase(getToken(1).image))) {
      jj_consume_token(ID);
            header = true;
    } else {
      ;
    }
    if (jj_2_23(2147483647) && ("encoding".equalsIgnoreCase(getToken(1).image))) {
      jj_consume_token(ID);
      encoding = id();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[98] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    condition = filterClause(info);
                TextLine tf = textLine();
                tf.setDelimiter(delimiter);
                tf.setQuote(quote);
                tf.setIncludeHeader(header);
                tf.setExpressions(expressions);
                tf.setEncoding(encoding);
        String name = generateFunctionName(info, "TEXTAGG");
                AggregateSymbol agg = newAggregateSymbol(name, "TEXTAGG", false, tf);
                agg.setOrderBy(orderBy);
                agg.setCondition(condition);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

  final public AggregateSymbol aggregateSymbol(ParseInfo info) throws ParseException {
        String func = null;
        Token starToken = null;
        AggregateSymbol agg = null;
        boolean isDistinct = false;
        Expression expression = null;
        Expression condition = null;
    if (jj_2_24(3)) {
      func = nonReserved("COUNT");
      jj_consume_token(LPAREN);
      starToken = jj_consume_token(STAR);
      jj_consume_token(RPAREN);
    } else if (jj_2_25(2147483647) && (matchesAny(getToken(1).image, "rank", "dense_rank", "row_number") != null)) {
      func = nonReserved("row_number", "rank", "dense_rank", "percent_rank", "cume_dist");
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case SOME:
      case ID:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          func = nonReserved("COUNT", "SUM", "AVG", "MIN", "MAX", "EVERY", "STDDEV_POP", "STDDEV_SAMP", "VAR_SAMP", "VAR_POP");
          break;
        case ANY:
          jj_consume_token(ANY);
                                        func = "ANY";
          break;
        case SOME:
          jj_consume_token(SOME);
                                         func = "SOME";
          break;
        default:
          jj_la1[99] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case DISTINCT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DISTINCT:
            jj_consume_token(DISTINCT);
                                      isDistinct=true;
            break;
          case ALL:
            jj_consume_token(ALL);
            break;
          default:
            jj_la1[100] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[101] = jj_gen;
          ;
        }
        expression = expression(info);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    condition = filterClause(info);
                func = func.toUpperCase();
                String name = generateFunctionName(info, func);
                if(starToken == null) {
                        // Aggregate
                        agg = newAggregateSymbol(name, func, isDistinct, expression);
                } else {
                        // COUNT(*)			
                        agg = newAggregateSymbol(name, func, false, null);
                }
                agg.setCondition(condition);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

  final public Expression filterClause(ParseInfo info) throws ParseException {
        Expression condition = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FILTER:
      jj_consume_token(FILTER);
      jj_consume_token(LPAREN);
      jj_consume_token(WHERE);
      condition = booleanPrimary(info);
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
                {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a FROM.  The from must handle groups, aliased groups or
 * joined groups. This also handles JDBC escape processinf syntax for outer joins.</p>
 * <p>Example:  "FROM a, b". </p>
 * <p>Example:  "FROM a AS x, b as Y". </p>
 * <p>Example:  "FROM a right outer join b, c, d join e".</p>
 * @param from object which is to be updated with the details in the from clause.
 * @return list containing criteria objects.
 * @throws ParseException if parsing failed
 */
  final public From from(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) From */
        From jjtn000 = (From)TeiidNodeFactory.jjtCreate(this, JJTFROM);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);FromClause clause = null;
        List clauseList = new LinkedList();
    try {
      jj_consume_token(FROM);
      clause = tableReference(info);
                        clauseList.add(clause);
                        clause = null;
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[104] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        clause = tableReference(info);
                                clauseList.add(clause);
                                clause = null;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setClauses(clauseList);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a join predicate clause, which occurs as an element in the FROM clause.  
 * The join predicate combines two from clauses with a join.</p>
 * @return Join predicate
 * @throws ParseException if parsing failed
 */
  final public FromClause tableReference(ParseInfo info) throws ParseException {
    FromClause fromClause = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      nonReserved("OJ");
      fromClause = joinedTable(info);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[105] = jj_gen;
      if (jj_2_26(1)) {
        fromClause = joinedTable(info);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return fromClause;}
    throw new Error("Missing return statement in function");
  }

  final public FromClause joinedTable(ParseInfo info) throws ParseException {
        FromClause result = null;
        JoinPredicate jp = null;
    result = tablePrimary(info);
    label_19:
    while (true) {
      if (jj_2_27(2)) {
        ;
      } else {
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
      case UNION:
        jp = crossJoin(info);
        break;
      case FULL:
      case INNER:
      case JOIN:
      case LEFT:
      case RIGHT:
        jp = qualifiedJoin(info);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        jp.setLeftClause(result);
                        result = jp;
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public JoinPredicate crossJoin(ParseInfo info) throws ParseException {
        JoinPredicate result;
        FromClause clause = null;
        result = joinPredicate();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CROSS:
      jj_consume_token(CROSS);
                          result.setJoinType(joinType(IJoinType.Types.JOIN_CROSS));
      break;
    case UNION:
      jj_consume_token(UNION);
                                                                                              result.setJoinType(joinType(IJoinType.Types.JOIN_UNION));
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(JOIN);
    clause = tablePrimary(info);
                                             result.setRightClause(clause);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public JoinPredicate qualifiedJoin(ParseInfo info) throws ParseException {
        JoinPredicate result;
        FromClause clause = null;
        Criteria onCriteria = null;
        result = joinPredicate();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL:
    case INNER:
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT:
        jj_consume_token(RIGHT);
                                  result.setJoinType(joinType(IJoinType.Types.JOIN_RIGHT_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[108] = jj_gen;
          ;
        }
        break;
      case LEFT:
        jj_consume_token(LEFT);
                           result.setJoinType(joinType(IJoinType.Types.JOIN_LEFT_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[109] = jj_gen;
          ;
        }
        break;
      case FULL:
        jj_consume_token(FULL);
                            result.setJoinType(joinType(IJoinType.Types.JOIN_FULL_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[110] = jj_gen;
          ;
        }
        break;
      case INNER:
        jj_consume_token(INNER);
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[112] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
    clause = tableReference(info);
                                               result.setRightClause(clause);
    jj_consume_token(ON);
    onCriteria = criteria(info);
                                             result.setJoinCriteria(Criteria.separateCriteriaByAnd(onCriteria));
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public JoinPredicate joinPredicate() throws ParseException {
 /*@bgen(jjtree) JoinPredicate */
  JoinPredicate jjtn000 = (JoinPredicate)TeiidNodeFactory.jjtCreate(this, JJTJOINPREDICATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public JoinType joinType(IJoinType.Types kind) throws ParseException {
 /*@bgen(jjtree) JoinType */
  JoinType jjtn000 = (JoinType)TeiidNodeFactory.jjtCreate(this, JJTJOINTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setKind(kind);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public FromClause tablePrimary(ParseInfo info) throws ParseException {
        FromClause clause = null;
        Token lparen = null;
    if (jj_2_28(2147483647) && ("texttable".equalsIgnoreCase(getToken(1).image))) {
      clause = textTable(info);
    } else if (jj_2_29(2147483647) && ("arraytable".equalsIgnoreCase(getToken(1).image))) {
      clause = arrayTable(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLTABLE:
        clause = xmlTable(info);
        break;
      case ID:
        clause = unaryFromClause(info);
        break;
      default:
        jj_la1[113] = jj_gen;
        if (jj_2_30(2147483647)) {
          clause = subqueryFromClause(info);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            lparen = jj_consume_token(LPAREN);
            clause = joinedTable(info);
                        setFromClauseOptions(lparen, clause);
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[114] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAKEDEP:
    case MAKENOTDEP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
                              clause.setMakeDep(true);
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
                                   clause.setMakeNotDep(true);
        break;
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
                {if (true) return clause;}
    throw new Error("Missing return statement in function");
  }

  final public XMLSerialize xmlSerialize(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLSerialize */
        XMLSerialize jjtn000 = (XMLSerialize)TeiidNodeFactory.jjtCreate(this, JJTXMLSERIALIZE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expr = null;
        String doc = null;
        Token t = null;
    try {
      jj_consume_token(XMLSERIALIZE);
      jj_consume_token(LPAREN);
      if (jj_2_31(2147483647) && (matchesAny(getToken(1).image, "document", "content") != null)) {
        doc = nonReserved("DOCUMENT", "CONTENT");
      } else {
        ;
      }
      expr = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING:
          t = jj_consume_token(STRING);
          break;
        case VARCHAR:
          t = jj_consume_token(VARCHAR);
          break;
        case CLOB:
          t = jj_consume_token(CLOB);
          break;
        default:
          jj_la1[117] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[118] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setExpression(expr);
                if (doc != null) {
                        jjtn000.setDocument("document".equalsIgnoreCase(doc));
                }
                if (t != null) {
                        jjtn000.setTypeString(t.image);
                }
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public String nonReserved(String... expected) throws ParseException {
        Token t = null;
    t = jj_consume_token(ID);
                String result = matchesAny(t.image, expected);
                if (result != null) {
                        {if (true) return result;}
                }
                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.expected_non_reserved, Arrays.toString(expected), t.image));}
    throw new Error("Missing return statement in function");
  }

  final public ArrayTable arrayTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ArrayTable */
        ArrayTable jjtn000 = (ArrayTable)TeiidNodeFactory.jjtCreate(this, JJTARRAYTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression array = null;
        List<ProjectedColumn> columns;
        String aliasID = null;
    try {
      jj_consume_token(ID);
      jj_consume_token(LPAREN);
      array = expression(info);
      nonReserved("COLUMNS");
      columns = createElementsWithTypes(info);
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[119] = jj_gen;
        ;
      }
      aliasID = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setArrayValue(array);
        jjtn000.setColumns(columns);
        jjtn000.setName(aliasID);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public TextTable textTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TextTable */
        TextTable jjtn000 = (TextTable)TeiidNodeFactory.jjtCreate(this, JJTTEXTTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression file = null;
        TextColumn column = null;
        List<TextColumn> columns = new ArrayList<TextColumn>();
        boolean useRowDelimiter = true;
        Character delimiter = null;
        boolean escape = false;
        Character quote = null;
        Integer header = null;
        Integer skip = null;
        String aliasID = null;
    try {
      jj_consume_token(ID);
      jj_consume_token(LPAREN);
      file = expression(info);
      nonReserved("COLUMNS");
      column = textColumn(info);
                columns.add(column);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[120] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        column = textColumn(info);
                        columns.add(column);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NO:
        jj_consume_token(NO);
        jj_consume_token(ROW);
        nonReserved("DELIMITER");
            useRowDelimiter = false;
        break;
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      if (jj_2_32(2147483647) && ("delimiter".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        delimiter = charVal(info, "DELMITER");
      } else {
        ;
      }
      if (jj_2_34(1)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ESCAPE:
          jj_consume_token(ESCAPE);
          quote = charVal(info, "ESCAPE");
                                                        escape = true;
          break;
        default:
          jj_la1[122] = jj_gen;
          if (jj_2_33(2147483647) && ("quote".equalsIgnoreCase(getToken(1).image))) {
            jj_consume_token(ID);
            quote = charVal(info, "QUOTE");
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        ;
      }
      if (jj_2_35(2147483647) && ("header".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGERVAL:
          header = intVal();
          break;
        default:
          jj_la1[123] = jj_gen;
          ;
        }
                if (header == null) {
                        header = 1;
                }
      } else {
        ;
      }
      if (jj_2_36(2147483647) && ("skip".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        skip = intVal();
      } else {
        ;
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[124] = jj_gen;
        ;
      }
      aliasID = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setFile(file);
                jjtn000.setColumns(columns);
                jjtn000.setDelimiter(delimiter);
                jjtn000.setEscape(escape);
                jjtn000.setHeader(header);
                jjtn000.setSkip(skip);
                try {
                    jjtn000.setName(validateName(aliasID, false));
                } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
                jjtn000.setQuote(quote);
                jjtn000.setUsingRowDelimiter(useRowDelimiter);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public TextColumn textColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TextColumn */
        TextColumn jjtn000 = (TextColumn)TeiidNodeFactory.jjtCreate(this, JJTTEXTCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        Constant datatype = null;
        Integer width = null;
        boolean noTrim = false;
    try {
      name = id();
      datatype = dataType();
      if (jj_2_38(2147483647) && ("width".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        width = intVal();
        if (jj_2_37(2)) {
          jj_consume_token(NO);
          nonReserved("TRIM");
                                noTrim = true;
        } else {
          ;
        }
      } else {
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            try {
               jjtn000.setName(validateName(name, true));
            } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
        jjtn000.setType((String) datatype.getValue());
        jjtn000.setWidth(width);
        jjtn000.setNoTrim(noTrim);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLQuery xmlQuery(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLQuery */
        XMLQuery jjtn000 = (XMLQuery)TeiidNodeFactory.jjtCreate(this, JJTXMLQUERY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        Boolean content = null;
        Boolean empty = null;
    try {
      jj_consume_token(XMLQUERY);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      xquery = stringVal();
      if (jj_2_39(2147483647) && ("passing".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[126] = jj_gen;
            break label_21;
          }
          jj_consume_token(COMMA);
          passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
        }
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
      case ID:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                    empty = false;
          break;
        case ID:
          nonReserved("EMPTY");
                                  empty = true;
          break;
        default:
          jj_la1[127] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(ON);
        nonReserved("EMPTY");
        break;
      default:
        jj_la1[128] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setXquery(xquery);
        jjtn000.setNamespaces(xmlNamespaces);
        jjtn000.setPassing(passingValues);
        jjtn000.setEmptyOnEmpty(empty);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLTable xmlTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLTable */
        XMLTable jjtn000 = (XMLTable)TeiidNodeFactory.jjtCreate(this, JJTXMLTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        XMLColumn column = null;
        ArrayList<XMLColumn> columns = new ArrayList<XMLColumn>();
        String aliasID = null;
    try {
      jj_consume_token(XMLTABLE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[129] = jj_gen;
        ;
      }
      xquery = stringVal();
      if (jj_2_40(2147483647) && ("passing".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[130] = jj_gen;
            break label_22;
          }
          jj_consume_token(COMMA);
          passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
        }
      } else {
        ;
      }
      if (jj_2_41(2147483647) && ("columns".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        column = xmlColumn(info);
            columns.add(column);
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[131] = jj_gen;
            break label_23;
          }
          jj_consume_token(COMMA);
          column = xmlColumn(info);
              columns.add(column);
        }
      } else {
        ;
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[132] = jj_gen;
        ;
      }
      aliasID = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setXquery(xquery);
        jjtn000.setNamespaces(xmlNamespaces);
        jjtn000.setPassing(passingValues);
        jjtn000.setColumns(columns);
        try {
            jjtn000.setName(validateName(aliasID, false));
        } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLColumn xmlColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLColumn */
        XMLColumn jjtn000 = (XMLColumn)TeiidNodeFactory.jjtCreate(this, JJTXMLCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        Constant datatype = null;
        String path = null;
        Expression defaultExpr = null;
    try {
      name = id();
       jjtn000.setName(name);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        nonReserved("ORDINALITY");
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.setOrdinal(true);
            {if (true) return jjtn000;}
        break;
      case STRING:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
        datatype = dataType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DEFAULT_KEYWORD:
          jj_consume_token(DEFAULT_KEYWORD);
          defaultExpr = expression(info);
          break;
        default:
          jj_la1[133] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          nonReserved("PATH");
          path = stringVal();
          break;
        default:
          jj_la1[134] = jj_gen;
          ;
        }
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.setType((String)datatype.getValue());
        jjtn000.setPath(path);
        jjtn000.setDefaultExpression(defaultExpr);
        {if (true) return jjtn000;}
        break;
      default:
        jj_la1[135] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public int intVal() throws ParseException {
        Token t;
    t = jj_consume_token(INTEGERVAL);
                try {
                        {if (true) return Integer.valueOf(t.image);}
                } catch(NumberFormatException e1) {
                        {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Integer_parse, t.image));}
                }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a unary from clause, which is just a single group name and an optional alias.
 * @return Unary from clause containing the group
 * @throws ParseException if parsing failed
 */
  final public SubqueryFromClause subqueryFromClause(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SubqueryFromClause */
    SubqueryFromClause jjtn000 = (SubqueryFromClause)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYFROMCLAUSE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String aliasID = null;
        Command command = null;
        Token lparen = null;
        boolean table = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
                          table = true;
        break;
      default:
        jj_la1[136] = jj_gen;
        ;
      }
      lparen = jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECT:
      case TABLE:
      case WITH:
      case LPAREN:
        command = queryExpression(info);
        break;
      case CALL:
      case EXEC:
      case EXECUTE:
        command = storedProcedure(info, newStoredProcedure());
        break;
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      aliasID = id();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            try {
               jjtn000.setName(validateName(aliasID, false));
            } catch (Exception ex) {
           {if (true) throw new ParseException(ex.getLocalizedMessage());}
        }
        jjtn000.setCommand(command);
        setFromClauseOptions(lparen, jjtn000);
        jjtn000.setTable(table);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a unary from clause, which is just a single group name and an optional alias.
 * @return Unary from clause containing the group
 * @throws ParseException if parsing failed
 */
  final public UnaryFromClause unaryFromClause(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) UnaryFromClause */
        UnaryFromClause jjtn000 = (UnaryFromClause)TeiidNodeFactory.jjtCreate(this, JJTUNARYFROMCLAUSE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);GroupSymbol group = null;
        Token groupID = null;
    String aliasID = null;
        UnaryFromClause clause = null;
    try {
      groupID = jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
      case ID:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AS:
          jj_consume_token(AS);
          break;
        default:
          jj_la1[139] = jj_gen;
          ;
        }
        aliasID = id();
        break;
      default:
        jj_la1[140] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
        if(aliasID != null) {
            try {
                group = groupSymbol(validateName(aliasID, false), normalizeId(groupID.image));
            } catch (Exception ex) {
                {if (true) throw new ParseException(ex.getLocalizedMessage());}
            }
        } else {
                        group = groupSymbol(normalizeId(groupID.image));
        }
        jjtn000.setGroup(group);
        setFromClauseOptions(groupID, jjtn000);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a WHERE clause.  The where clause holds a criteria.
 * @return Parsed where
 * @throws ParseException if parsing failed
 */
  final public Criteria where(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(WHERE);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a criteria.  This will parse any criteria expression.</p>
 * @return Parsed criteria
 * @throws ParseException if parsing failed
 */
  final public Criteria criteria(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Criteria */
  Criteria jjtn000 = (Criteria)TeiidNodeFactory.jjtCreate(this, JJTCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtn000 = compoundCritOr(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse a compound logical OR criteria.</p>
 * @return Parsed OR criteria
 * @throws ParseException if parsing failed
 */
  final public Criteria compoundCritOr(ParseInfo info) throws ParseException {
    ArrayList logicList = new ArrayList(2);
    Criteria logicPart = null;
    logicPart = compoundCritAnd(info);
                                                                          logicList.add(logicPart);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[141] = jj_gen;
        break label_24;
      }
      jj_consume_token(OR);
      logicPart = compoundCritAnd(info);
                                                                  logicList.add(logicPart);
    }
                if(logicList.size() == 1) {
                        {if (true) return (Criteria) logicList.get(0);}
                } else {
                    CompoundCriteria cc = createASTNode(ASTNodes.COMPOUND_CRITERIA);
            cc.setOperator(CompoundCriteria.OR);
            cc.setCriteria(logicList);
                {if (true) return cc;}
                }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a compound logical AND criteria.</p>
 * @return Parsed AND criteria
 * @throws ParseException if parsing failed
 */
  final public Criteria compoundCritAnd(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CompoundCriteria */
    CompoundCriteria jjtn000 = (CompoundCriteria)TeiidNodeFactory.jjtCreate(this, JJTCOMPOUNDCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);ArrayList logicList = new ArrayList(2);
    Criteria logicPart = null;
    try {
      logicPart = notCrit(info);
                                                          logicList.add(logicPart);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[142] = jj_gen;
          break label_25;
        }
        jj_consume_token(AND);
        logicPart = notCrit(info);
                                                  logicList.add(logicPart);
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                if(logicList.size() == 1) {
                        {if (true) return (Criteria) logicList.get(0);}
                } else {
                    jjtn000.setOperator(CompoundCriteria.AND);
            jjtn000.setCriteria(logicList);
            {if (true) return jjtn000;}
                }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a logical NOT criteria.</p>
 * @return Parsed NOT criteria
 * @throws ParseException if parsing failed
 */
  final public Criteria notCrit(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) NotCriteria */
    NotCriteria jjtn000 = (NotCriteria)TeiidNodeFactory.jjtCreate(this, JJTNOTCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression ex = null;
        boolean isNot = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                isNot=true;
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      ex = booleanPrimary(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            Criteria crit = null;
            if (ex instanceof Criteria) {
              crit = (Criteria)ex;
            } else {
              crit = expressionCriteria(ex);
            }
                if(isNot) {
                    jjtn000.setCriteria(crit);
                    {if (true) return jjtn000;}
                } else {
                        {if (true) return crit;}
                }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a boolean primary.</p>
 * @return criteria
 * @throws ParseException if parsing failed
 */
  final public Expression booleanPrimary(ParseInfo info) throws ParseException {
    Expression ex = null;
    if (jj_2_46(2)) {
      ex = translateCriteria(info);
    } else if (jj_2_47(1)) {
      ex = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
      case IN:
      case IS:
      case LIKE:
      case LIKE_REGEX:
      case NOT:
      case SIMILAR:
      case EQ:
      case NE:
      case NE2:
      case LT:
      case LE:
      case GT:
      case GE:
        if (jj_2_42(2)) {
          ex = betweenCrit(info, ex);
        } else if (jj_2_43(2)) {
          ex = matchCrit(info, ex);
        } else if (jj_2_44(2)) {
          ex = regexMatchCrit(info, ex);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IN:
          case NOT:
            ex = setCrit(info, ex);
            break;
          case IS:
            ex = isNullCrit(info, ex);
            break;
          default:
            jj_la1[144] = jj_gen;
            if (jj_2_45(2147483647)) {
              ex = subqueryCompareCriteria(info, ex);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case EQ:
              case NE:
              case NE2:
              case LT:
              case LE:
              case GT:
              case GE:
                ex = compareCrit(info, ex);
                break;
              default:
                jj_la1[145] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        break;
      default:
        jj_la1[146] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXISTS:
        ex = existsCriteria(info);
        break;
      case HAS:
        ex = hasCriteria();
        break;
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

  final public Token operator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      operator = jj_consume_token(EQ);
      break;
    case NE:
      operator = jj_consume_token(NE);
      break;
    case NE2:
      operator = jj_consume_token(NE2);
      break;
    case LT:
      operator = jj_consume_token(LT);
      break;
    case LE:
      operator = jj_consume_token(LE);
      break;
    case GT:
      operator = jj_consume_token(GT);
      break;
    case GE:
      operator = jj_consume_token(GE);
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return operator;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a compare criteria.</p>
 * @return Parsed compare criteria
 * @throws ParseException if parsing failed
 */
  final public CompareCriteria compareCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) CompareCriteria */
    CompareCriteria jjtn000 = (CompareCriteria)TeiidNodeFactory.jjtCreate(this, JJTCOMPARECRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression value = null;
    Token operator = null;
    try {
      operator = operator();
      value = commonValueExpression(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Set left expression
                jjtn000.setLeftExpression(expression);

                jjtn000.setOperator(Operator.getOperator(getVersion(), operator.image));

                // Set value
                jjtn000.setRightExpression(value);

            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryCommand subquery(ParseInfo info) throws ParseException {
    QueryCommand subquery = null;
    StoredProcedure proc = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case WITH:
    case LPAREN:
      subquery = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      proc = storedProcedure(info, newStoredProcedure());
        MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);

        Select select = createASTNode(ASTNodes.SELECT);
        select.setSymbols(Arrays.asList(multipleElementSymbol));

        SubqueryFromClause subqueryFromClause = createASTNode(ASTNodes.SUBQUERY_FROM_CLAUSE);
        subqueryFromClause.setName("x");
        subqueryFromClause.setCommand(proc);

        From from = createASTNode(ASTNodes.FROM);
        from.setClauses(Arrays.asList(subqueryFromClause));

        Query query = createASTNode(ASTNodes.QUERY);
        query.setSelect(select);
        query.setFrom(from);
        subquery = query;
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
                {if (true) return subquery;}
    throw new Error("Missing return statement in function");
  }

  final public Object[] subqueryAndHint(ParseInfo info) throws ParseException {
    QueryCommand subquery = null;
    Token lparen = null;
         lparen = getToken(1);
    subquery = subquery(info);
                {if (true) return new Object[] {subquery, getSubqueryHint(lparen)};}
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse a subquery compare criteria.</p>
 * @return Parsed subquery compare criteria
 * @throws ParseException if parsing failed
 */
  final public SubqueryCompareCriteria subqueryCompareCriteria(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) SubqueryCompareCriteria */
    SubqueryCompareCriteria jjtn000 = (SubqueryCompareCriteria)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYCOMPARECRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);SubqueryCompareCriteria subqueryCrit = null;
    QueryCommand subquery = null;
    Token operator = null;
    Token quantifier = null;
    try {
      operator = operator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
        quantifier = jj_consume_token(ANY);
        break;
      case SOME:
        quantifier = jj_consume_token(SOME);
        break;
      case ALL:
        quantifier = jj_consume_token(ALL);
        break;
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      subquery = subquery(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setLeftExpression(expression);
            jjtn000.setCommand(subquery);

                // Set operator
                jjtn000.setOperator(Operator.getOperator(getVersion(), operator.image));

                // Set predicate quantifier
                if(quantifier.image.equalsIgnoreCase("any")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.ANY);
                } else if(quantifier.image.equalsIgnoreCase("some")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.SOME);
                } else if(quantifier.image.equalsIgnoreCase("all")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.ALL);
                }

            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a match criteria. Also parses JDBC escape syntax for match criteria.</p>
 * @return Parsed match criteria
 * @throws ParseException if parsing failed
 */
  final public MatchCriteria matchCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) MatchCriteria */
    MatchCriteria jjtn000 = (MatchCriteria)TeiidNodeFactory.jjtCreate(this, JJTMATCHCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Character esc = null;
        Expression value = null;
        boolean negated = false;
        boolean similar = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated = true;
        break;
      default:
        jj_la1[151] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
        break;
      case SIMILAR:
        jj_consume_token(SIMILAR);
        jj_consume_token(TO);
                             similar = true;
        break;
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      value = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
      case LBRACE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ESCAPE:
          jj_consume_token(ESCAPE);
          esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
          break;
        case LBRACE:
          jj_consume_token(LBRACE);
          jj_consume_token(ESCAPE);
          esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
          jj_consume_token(RBRACE);
          break;
        default:
          jj_la1[153] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[154] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
        jjtn000.setLeftExpression(expression);
        jjtn000.setRightExpression(value);
        jjtn000.setNegated(negated);
            if(esc != null) {
                        jjtn000.setEscapeChar(esc.charValue());
                }
                jjtn000.setMode(similar?MatchMode.SIMILAR:MatchMode.LIKE);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public MatchCriteria regexMatchCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression value = null;
        boolean negated = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    jj_consume_token(LIKE_REGEX);
    value = commonValueExpression(info);
            MatchCriteria matchCriteria = createASTNode(ASTNodes.MATCH_CRITERIA);
        matchCriteria.setLeftExpression(expression);
        matchCriteria.setRightExpression(value);
        matchCriteria.setNegated(negated);
        matchCriteria.setMode(MatchMode.REGEX);
                {if (true) return matchCriteria;}
    throw new Error("Missing return statement in function");
  }

  final public Character charVal(ParseInfo info, String type) throws ParseException {
        String escStr = null;
    escStr = stringVal();
                if (escStr.length() != 1) {
                        {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.char_val));}
                }
                {if (true) return Character.valueOf(escStr.charAt(0));}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an [NOT] BETWEEN criteria.</p>
 * @return Parsed BETWEEN criteria
 * @throws ParseException if parsing failed
 */
  final public BetweenCriteria betweenCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) BetweenCriteria */
        BetweenCriteria jjtn000 = (BetweenCriteria)TeiidNodeFactory.jjtCreate(this, JJTBETWEENCRITERIA);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression lowerExpression = null, upperExpression = null;
        boolean negated = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated=true;
        break;
      default:
        jj_la1[156] = jj_gen;
        ;
      }
      jj_consume_token(BETWEEN);
      lowerExpression = commonValueExpression(info);
      jj_consume_token(AND);
      upperExpression = commonValueExpression(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setExpression(expression);
        jjtn000.setLowerExpression(lowerExpression);
        jjtn000.setUpperExpression(upperExpression);
        jjtn000.setNegated(negated);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an IS [NOT] NULL criteria.</p>
 * @return Parsed IS NULL criteria
 * @throws ParseException if parsing failed
 */
  final public IsNullCriteria isNullCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) IsNullCriteria */
        IsNullCriteria jjtn000 = (IsNullCriteria)TeiidNodeFactory.jjtCreate(this, JJTISNULLCRITERIA);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);boolean negated = false;
    try {
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated = true;
        break;
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      jj_consume_token(NULL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
           jjtn000.setExpression(expression);
       jjtn000.setNegated(negated);
       {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse a set criteria.</p>
 * @return Parsed set criteria
 * @throws ParseException if parsing failed
 */
  final public AbstractSetCriteria setCrit(ParseInfo info, Expression expression) throws ParseException {
    AbstractSetCriteria criteria = null;
        Expression value = null;
        List setList = new ArrayList();
        Object[] command = null;
        boolean negated = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    if (jj_2_48(2147483647)) {
      command = subqueryAndHint(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        value = commonValueExpression(info);
                                setList.add(value);
        label_26:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[159] = jj_gen;
            break label_26;
          }
          jj_consume_token(COMMA);
          value = commonValueExpression(info);
                                        setList.add(value);
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
            if (command != null) {
                        SubquerySetCriteria ssc = subquerySetCriteria(expression, (QueryCommand)command[0]);
                        ssc.setSubqueryHint((SubqueryHint)command[1]);
                        criteria = ssc;
                } else {
                    criteria = setCriteria(expression, setList);
                }
            criteria.setNegated(negated);
            {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

  final public SubquerySetCriteria subquerySetCriteria(Expression expression, QueryCommand command) throws ParseException {
 /*@bgen(jjtree) SubquerySetCriteria */
  SubquerySetCriteria jjtn000 = (SubquerySetCriteria)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYSETCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        jjtn000.setCommand(command);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SetCriteria setCriteria(Expression expression, List<Expression> values) throws ParseException {
 /*@bgen(jjtree) SetCriteria */
  SetCriteria jjtn000 = (SetCriteria)TeiidNodeFactory.jjtCreate(this, JJTSETCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        jjtn000.setValues(values);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse an exists criteria.</p>
 * @return Parsed exists criteria
 * @throws ParseException if parsing failed
 */
  final public ExistsCriteria existsCriteria(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ExistsCriteria */
    ExistsCriteria jjtn000 = (ExistsCriteria)TeiidNodeFactory.jjtCreate(this, JJTEXISTSCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Object[] subquery = null;
    try {
      jj_consume_token(EXISTS);
      subquery = subqueryAndHint(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setCommand((QueryCommand) subquery[0]);
        jjtn000.setSubqueryHint((SubqueryHint) subquery[1]);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a GROUP BY clause.  </p>
 * @return Parsed group by
 * @throws ParseException if parsing failed
 */
  final public GroupBy groupBy(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) GroupBy */
        GroupBy jjtn000 = (GroupBy)TeiidNodeFactory.jjtCreate(this, JJTGROUPBY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);List<Expression> expressions = null;
    try {
      jj_consume_token(GROUP);
      jj_consume_token(BY);
      expressions = expressionList(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setSymbols(expressions);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a HAVING clause.  </p>
 * @return Parsed having
 * @throws ParseException if parsing failed
 */
  final public Criteria having(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(HAVING);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse an ORDER BY clause.</p>
 * @return Parsed ORDER BY
 * @throws ParseException if parsing failed
 */
  final public OrderBy orderby(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) OrderBy */
    OrderBy jjtn000 = (OrderBy)TeiidNodeFactory.jjtCreate(this, JJTORDERBY);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);OrderByItem item = null;
    try {
      jj_consume_token(ORDER);
      jj_consume_token(BY);
      item = sortSpecification(info);
        jjtn000.getOrderByItems().add(item);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[161] = jj_gen;
          break label_27;
        }
        jj_consume_token(COMMA);
        item = sortSpecification(info);
                jjtn000.getOrderByItems().add(item);
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public OrderByItem sortSpecification(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) OrderByItem */
    OrderByItem jjtn000 = (OrderByItem)TeiidNodeFactory.jjtCreate(this, JJTORDERBYITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);SingleElementSymbol ex = null;
    boolean ascending = true;
    String nullOrdering = null;
    try {
      ex = sortKey(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
      case DESC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASC:
          jj_consume_token(ASC);
          break;
        case DESC:
          jj_consume_token(DESC);
                         ascending=false;
          break;
        default:
          jj_la1[162] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[163] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        nonReserved("NULLS");
        nullOrdering = nonReserved("FIRST", "LAST");
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setSymbol(ex);
        jjtn000.setAscending(ascending);
        if (nullOrdering != null) {
                jjtn000.setNullOrdering(NullOrdering.valueOf(nullOrdering.toUpperCase()));
        }
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SingleElementSymbol sortKey(ParseInfo info) throws ParseException {
    Expression ex = null;
    ex = expression(info);
        //legacy support check for positional constants
        if (ex instanceof Constant) {
                boolean valid = false;
            Constant c = (Constant)ex;
            if (c.getValue() instanceof Integer) {
                Integer val = (Integer)c.getValue();
                valid = val.intValue() > 0;
            }
            if (!valid) {
                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.non_position_constant, ex));}
            }
        }
        if(ex instanceof ElementSymbol) {
            {if (true) return (ElementSymbol)ex;}
        }
        String exprName = generateFunctionName(info, null);
        ExpressionSymbol es = expressionSymbol();
        es.setName(exprName);
        es.setExpression(ex);
        {if (true) return es;}
    throw new Error("Missing return statement in function");
  }

  final public ExpressionSymbol expressionSymbol() throws ParseException {
 /*@bgen(jjtree) ExpressionSymbol */
  ExpressionSymbol jjtn000 = (ExpressionSymbol)TeiidNodeFactory.jjtCreate(this, JJTEXPRESSIONSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression intParam(ParseInfo info) throws ParseException {
   Integer val = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGERVAL:
      val = intVal();
      break;
    case QMARK:
      jj_consume_token(QMARK);
      break;
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     if (val == null) {
       {if (true) return reference(info.incrementReferenceCount());}
     }
     {if (true) return constant(val, DataTypeManagerService.DefaultDataTypes.INTEGER);}
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse an LIMIT clause.</p>
 * @return Parsed LIMIT
 * @throws ParseException if parsing failed
 */
  final public Limit limit(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Limit */
        Limit jjtn000 = (Limit)TeiidNodeFactory.jjtCreate(this, JJTLIMIT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression limit = null;
        Expression offset = null;
        Token t = null;
    try {
     t = getToken(1);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
        jj_consume_token(LIMIT);
        offset = intParam(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          limit = intParam(info);
          break;
        default:
          jj_la1[166] = jj_gen;
          ;
        }
          if (limit == null) {
            limit = offset;
            offset = null;
          }
        break;
      case OFFSET:
        jj_consume_token(OFFSET);
        offset = intParam(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ROW:
          jj_consume_token(ROW);
          break;
        case ROWS:
          jj_consume_token(ROWS);
          break;
        default:
          jj_la1[167] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FETCH:
          limit = fetchLimit(info);
          break;
        default:
          jj_la1[168] = jj_gen;
          ;
        }
        break;
      case FETCH:
        limit = fetchLimit(info);
        break;
      default:
        jj_la1[169] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setOffset(offset);
        jjtn000.setRowLimit(limit);
        jjtn000.setStrict(!isNonStrictHint(t));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression fetchLimit(ParseInfo info) throws ParseException {
    Expression limit = null;
    jj_consume_token(FETCH);
    nonReserved("FIRST", "NEXT");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGERVAL:
    case QMARK:
      limit = intParam(info);
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
      break;
    case ROWS:
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
      if (limit == null) {
        {if (true) return constant(1, DataTypeManagerService.DefaultDataTypes.INTEGER);}
      }
      {if (true) return limit;}
    throw new Error("Missing return statement in function");
  }

/** 
 * <p>Parse an OPTION clause.</p>
 * @return Parsed OPTION clause
 * @throws ParseException if parsing failed
 */
  final public Option option(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Option */
        Option jjtn000 = (Option)TeiidNodeFactory.jjtCreate(this, JJTOPTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String id = null;
        Token nocache = null;
    try {
      jj_consume_token(OPTION);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MAKEDEP:
        case MAKENOTDEP:
        case NOCACHE:
          ;
          break;
        default:
          jj_la1[172] = jj_gen;
          break label_28;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MAKEDEP:
          jj_consume_token(MAKEDEP);
          id = id();
            jjtn000.addDependentGroup(id);
          label_29:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[173] = jj_gen;
              break label_29;
            }
            jj_consume_token(COMMA);
            id = id();
                jjtn000.addDependentGroup(id);
          }
          break;
        case MAKENOTDEP:
          jj_consume_token(MAKENOTDEP);
          id = id();
            jjtn000.addNotDependentGroup(id);
          label_30:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[174] = jj_gen;
              break label_30;
            }
            jj_consume_token(COMMA);
            id = id();
                jjtn000.addNotDependentGroup(id);
          }
          break;
        case NOCACHE:
          nocache = jj_consume_token(NOCACHE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
            id = id();
            jjtn000.addNoCacheGroup(id);
            label_31:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                ;
                break;
              default:
                jj_la1[175] = jj_gen;
                break label_31;
              }
              jj_consume_token(COMMA);
              id = id();
                jjtn000.addNoCacheGroup(id);
            }
            break;
          default:
            jj_la1[176] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[177] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setNoCache( (nocache != null) );
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an expression - made up of literals and functions.</p>
 * @return Expression
 * @throws ParseException if parsing failed
 */
  final public Expression expression(ParseInfo info) throws ParseException {
        Expression expression = null;
    expression = criteria(info);
                if (expression instanceof ExpressionCriteria) {
                        {if (true) return ((ExpressionCriteria)expression).getExpression();}
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public Expression commonValueExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
    leftExpression = plusExpression(info);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT_OP:
        ;
        break;
      default:
        jj_la1[178] = jj_gen;
        break label_32;
      }
      jj_consume_token(CONCAT_OP);
      rightExpression = plusExpression(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                function.setName("||"); //$NON-NLS-1$
                function.setArgs(new Expression[] {leftExpression, rightExpression});
                leftExpression = function;
                                rightExpression = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an expression - made up of literals and functions.</p>
 * @return Expression
 * @throws ParseException if parsing failed
 */
  final public Expression plusExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = timesExpression(info);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[179] = jj_gen;
        break label_33;
      }
      operator = plusOperator();
      rightExpression = timesExpression(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                function.setName(operator);
                function.setArgs(new Expression[] { leftExpression, rightExpression });
                leftExpression = function;
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse the add/subtract operators.</p>
 * @return "+" or "-"
 * @throws ParseException if parsing failed
 */
  final public String plusOperator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      operator = jj_consume_token(PLUS);
      break;
    case MINUS:
      operator = jj_consume_token(MINUS);
      break;
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return operator.image;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse an expression - made up of literals and functions.</p>
 * @return Expression
 * @throws ParseException if parsing failed
 */
  final public Expression timesExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = valueExpressionPrimary(info);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
        ;
        break;
      default:
        jj_la1[181] = jj_gen;
        break label_34;
      }
      operator = timesOperator();
      rightExpression = valueExpressionPrimary(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                function.setName(operator);
                function.setArgs(new Expression[] {leftExpression, rightExpression});
                leftExpression = function;
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse the multiply/divide operator.</p>
 * @return "*" or "/"
 * @throws ParseException if parsing failed
 */
  final public String timesOperator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      operator = jj_consume_token(STAR);
      break;
    case SLASH:
      operator = jj_consume_token(SLASH);
      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return operator.image;}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a basic expression.</p>
 * @return Expression
 * @throws ParseException if parsing failed
 */
  final public Expression valueExpressionPrimary(ParseInfo info) throws ParseException {
        Token refToken = null;
        Expression expression = null;
        Token symbol = null;
        Constant literal = null;
        QueryCommand subquery = null;
        Integer arrayIndex = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      // Reference
                      refToken = jj_consume_token(QMARK);
      break;
    case POS_REF:
      refToken = jj_consume_token(POS_REF);
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case DATETYPE:
    case TIMETYPE:
    case TIMESTAMPTYPE:
    case BOOLEANTYPE:
    case INTEGERVAL:
    case FLOATVAL:
    case STRINGVAL:
      // Literal
                      literal = literal();
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      nonReserved("FN");
      expression = function(info);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[189] = jj_gen;
      if (jj_2_49(2147483647) && (matchesAny(getToken(1).image, "textagg") != null)) {
        expression = textAgg(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OVER:
          expression = windowSpecification(expression, info);
          break;
        default:
          jj_la1[183] = jj_gen;
          ;
        }
      } else if (jj_2_50(2147483647) && (matchesAny(getToken(1).image, "count", "min", "max", "sum", "avg", "every", "STDDEV_POP", "STDDEV_SAMP", "VAR_SAMP", "VAR_POP") != null)) {
        expression = aggregateSymbol(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OVER:
          expression = windowSpecification(expression, info);
          break;
        default:
          jj_la1[184] = jj_gen;
          ;
        }
      } else if (jj_2_51(2147483647)) {
        expression = aggregateSymbol(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OVER:
          expression = windowSpecification(expression, info);
          break;
        default:
          jj_la1[185] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ARRAY_AGG:
        case XMLAGG:
          expression = orderedAgg(info);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case OVER:
            expression = windowSpecification(expression, info);
            break;
          default:
            jj_la1[186] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[190] = jj_gen;
          if (jj_2_52(2147483647) && (matchesAny(getToken(1).image, "rank", "dense_rank", "row_number") != null)) {
            expression = aggregateSymbol(info);
            expression = windowSpecification(expression, info);
          } else if (jj_2_53(2)) {
            expression = function(info);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ID:
              symbol = jj_consume_token(ID);
                                String symbolImage = symbol.image;
                                if(isStringLiteral(symbolImage, info)) {
                                    literal = constant(normalizeStringLiteral(symbolImage));
                                    symbol = null;
                                }
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LSBRACE:
                jj_consume_token(LSBRACE);
                arrayIndex = intVal();
                jj_consume_token(RSBRACE);
                break;
              default:
                jj_la1[187] = jj_gen;
                ;
              }
              break;
            default:
              jj_la1[191] = jj_gen;
              if (jj_2_54(2147483647)) {
                subquery = subquery(info);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case LPAREN:
                  jj_consume_token(LPAREN);
                  expression = expression(info);
                  jj_consume_token(RPAREN);
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case LSBRACE:
                    jj_consume_token(LSBRACE);
                    arrayIndex = intVal();
                    jj_consume_token(RSBRACE);
                    break;
                  default:
                    jj_la1[188] = jj_gen;
                    ;
                  }
                  break;
                default:
                  jj_la1[192] = jj_gen;
                  if (jj_2_55(2)) {
                    expression = searchedCaseExpression(info);
                  } else {
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case CASE:
                      // Non-searched CASE expressions
                                      expression = caseExpression(info);
                      break;
                    default:
                      jj_la1[193] = jj_gen;
                      jj_consume_token(-1);
                      throw new ParseException();
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
                if(refToken != null) {
                    if (refToken.image.charAt(0) == '$') {
                                {if (true) return reference(Integer.parseInt(refToken.image.substring(1)) -1);}
                    }
                        expression = reference(info.incrementReferenceCount());
                } else if(symbol != null) {
                        expression = elementSymbol(normalizeId(symbol.image));
                } else if(literal != null) {
                        expression = literal;           // may be null literal
                } else if (subquery != null){
                        expression = scalarSubquery(subquery);
                }
                if (arrayIndex != null) {
                    Function function = createASTNode(ASTNodes.FUNCTION);
            function.setName("array_get"); //$NON-NLS-1$
            function.setArgs(new Expression[] {expression, constant(arrayIndex)});
            expression = function;
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public Reference reference(int referenceIndex) throws ParseException {
 /*@bgen(jjtree) Reference */
  Reference jjtn000 = (Reference)TeiidNodeFactory.jjtCreate(this, JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setIndex(referenceIndex);
        jjtn000.setPositional(true);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression windowSpecification(Expression agg, ParseInfo info) throws ParseException {
        List<Expression> partitionList = null;
        OrderBy orderBy = null;
    jj_consume_token(OVER);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = expressionList(info);
      break;
    default:
      jj_la1[194] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[195] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        String aggName = "win_" + ((AggregateSymbol)agg).getName();
                String name = generateFunctionName(info, aggName);

        WindowFunction result = windowFunction();
        result.setName(aggName);
        WindowSpecification ws = newWindowSpecification();
        result.setFunction((AggregateSymbol)agg);
        ws.setPartition(partitionList);
        ws.setOrderBy(orderBy);
        result.setWindowSpecification(ws);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a non-searched CASE expression.
 * @return CaseExpression
 * @throws ParseException if parsing failed
 */
  final public CaseExpression caseExpression(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CaseExpression */
        CaseExpression jjtn000 = (CaseExpression)TeiidNodeFactory.jjtCreate(this, JJTCASEEXPRESSION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expression = null, whenExpression = null, thenExpression = null, elseExpression = null;
        ArrayList whenExpressions = new ArrayList(2);
        ArrayList thenExpressions = new ArrayList(2);
    try {
      jj_consume_token(CASE);
      expression = expression(info);
      label_35:
      while (true) {
        jj_consume_token(WHEN);
        whenExpression = expression(info);
        jj_consume_token(THEN);
        thenExpression = expression(info);
                        whenExpressions.add(whenExpression);
                        thenExpressions.add(thenExpression);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[196] = jj_gen;
          break label_35;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseExpression = expression(info);
        break;
      default:
        jj_la1[197] = jj_gen;
        ;
      }
      jj_consume_token(END);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setExpression(expression);
        jjtn000.setWhen(whenExpressions, thenExpressions);
        jjtn000.setElseExpression(elseExpression);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a searched CASE expression.
 * @return SearchedCaseExpression
 * @throws ParseException if parsing failed
 */
  final public SearchedCaseExpression searchedCaseExpression(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SearchedCaseExpression */
        SearchedCaseExpression jjtn000 = (SearchedCaseExpression)TeiidNodeFactory.jjtCreate(this, JJTSEARCHEDCASEEXPRESSION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression thenExpression = null, elseExpression = null;
        Criteria whenCriteria = null;
        List<Criteria> whenCriteriaList = new ArrayList<Criteria>(2);
        List<Expression> thenExpressions = new ArrayList<Expression>(2);
    try {
      jj_consume_token(CASE);
      label_36:
      while (true) {
        jj_consume_token(WHEN);
        whenCriteria = criteria(info);
        jj_consume_token(THEN);
        thenExpression = expression(info);
                        whenCriteriaList.add(whenCriteria);
                        thenExpressions.add(thenExpression);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[198] = jj_gen;
          break label_36;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseExpression = expression(info);
        break;
      default:
        jj_la1[199] = jj_gen;
        ;
      }
      jj_consume_token(END);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setWhen(whenCriteriaList, thenExpressions);
        jjtn000.setElseExpression(elseExpression);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a function. </p>
 * @return Parsed function
 * @throws ParseException if parsing failed
 */
  final public Expression function(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Function */
        Function jjtn000 = (Function)TeiidNodeFactory.jjtCreate(this, JJTFUNCTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String funcName = null;

        Expression expression = null;
        ArrayList args = new ArrayList(2);
        ArrayList otherArgs = null;
        Token funcToken = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONVERT:
        funcToken = jj_consume_token(CONVERT);
        jj_consume_token(LPAREN);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(COMMA);
        expression = dataType();
                        args.add(expression);
        jj_consume_token(RPAREN);
        break;
      case CAST:
        funcToken = jj_consume_token(CAST);
        jj_consume_token(LPAREN);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(AS);
        expression = dataType();
                        args.add(expression);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[209] = jj_gen;
        if (jj_2_63(2) && (getToken(1).image.equalsIgnoreCase("SUBSTRING"))) {
          funcName = nonReserved("SUBSTRING");
          jj_consume_token(LPAREN);
          expression = expression(info);
              args.add(expression);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FROM:
            jj_consume_token(FROM);
            expression = expression(info);
              args.add(expression);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case FOR:
              jj_consume_token(FOR);
              expression = expression(info);
              args.add(expression);
              break;
            default:
              jj_la1[200] = jj_gen;
              ;
            }
            break;
          case COMMA:
            jj_consume_token(COMMA);
            otherArgs = expressionList(info);
                                                          args.addAll(otherArgs);
            break;
          default:
            jj_la1[201] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(RPAREN);
        } else if (jj_2_64(2) && (getToken(1).image.equalsIgnoreCase("EXTRACT"))) {
          nonReserved("EXTRACT");
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case YEAR:
            funcToken = jj_consume_token(YEAR);
            break;
          case MONTH:
            funcToken = jj_consume_token(MONTH);
            break;
          case DAY:
            funcToken = jj_consume_token(DAY);
            break;
          case HOUR:
            funcToken = jj_consume_token(HOUR);
            break;
          case MINUTE:
            funcToken = jj_consume_token(MINUTE);
            break;
          case SECOND:
            funcToken = jj_consume_token(SECOND);
            break;
          default:
            jj_la1[202] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(FROM);
          expression = expression(info);
                  if (funcToken.image.equalsIgnoreCase("DAY")) {
                 funcName = "DAYOFMONTH";
              }
              args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_65(2) && (getToken(1).image.equalsIgnoreCase("TRIM"))) {
          funcName = nonReserved("TRIM");
          jj_consume_token(LPAREN);
             funcToken = null; expression = null;
          if (jj_2_58(2)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BOTH:
            case LEADING:
            case TRAILING:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LEADING:
                funcToken = jj_consume_token(LEADING);
                break;
              case TRAILING:
                funcToken = jj_consume_token(TRAILING);
                break;
              case BOTH:
                funcToken = jj_consume_token(BOTH);
                break;
              default:
                jj_la1[203] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              if (jj_2_56(1)) {
                expression = expression(info);
              } else {
                ;
              }
              break;
            default:
              jj_la1[204] = jj_gen;
              if (jj_2_57(1)) {
                expression = expression(info);
              } else {
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            jj_consume_token(FROM);
          } else {
            ;
          }
              if (funcToken == null) {
                  args.add(constant("BOTH"));
              } else {
                  args.add(constant(funcToken.image));
              }
              if (expression == null) {
                  args.add(constant(" "));
              } else {
                  if (expression instanceof Constant) {
                      Object value = ((Constant)expression).getValue();
                      if (value instanceof String && ((String)value).length() != 1) {
                                      {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.char_val));}
                      }
                  }
                  args.add(expression);
              }
          expression = expression(info);
              args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_66(2147483647) && (matchesAny(getToken(1).image, "to_chars", "to_bytes") != null)) {
          funcName = nonReserved("TO_CHARS", "TO_BYTES");
          jj_consume_token(LPAREN);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(COMMA);
          expression = stringConstant();
                        args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_67(2147483647) && (matchesAny(getToken(1).image, "timestampadd", "timestampdiff") != null)) {
          funcName = nonReserved("TIMESTAMPADD", "TIMESTAMPDIFF");
          jj_consume_token(LPAREN);
          expression = intervalType();
                        args.add(expression);
          jj_consume_token(COMMA);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(COMMA);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_68(2147483647) && (getToken(1).image.equalsIgnoreCase("querystring"))) {
          expression = queryString(info);
                {if (true) return expression;}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR:
          case HOUR:
          case LEFT:
          case MINUTE:
          case MONTH:
          case RIGHT:
          case SECOND:
          case USER:
          case YEAR:
          case XMLCONCAT:
          case XMLCOMMENT:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LEFT:
              funcToken = jj_consume_token(LEFT);
              break;
            case RIGHT:
              funcToken = jj_consume_token(RIGHT);
              break;
            case CHAR:
              funcToken = jj_consume_token(CHAR);
              break;
            case USER:
              funcToken = jj_consume_token(USER);
              break;
            case YEAR:
              funcToken = jj_consume_token(YEAR);
              break;
            case MONTH:
              funcToken = jj_consume_token(MONTH);
              break;
            case HOUR:
              funcToken = jj_consume_token(HOUR);
              break;
            case MINUTE:
              funcToken = jj_consume_token(MINUTE);
              break;
            case SECOND:
              funcToken = jj_consume_token(SECOND);
              break;
            case XMLCONCAT:
              funcToken = jj_consume_token(XMLCONCAT);
              break;
            case XMLCOMMENT:
              funcToken = jj_consume_token(XMLCOMMENT);
              break;
            default:
              jj_la1[205] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(LPAREN);
            if (jj_2_59(1)) {
              args = expressionList(info);
            } else {
              ;
            }
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[210] = jj_gen;
            if (jj_2_69(2147483647)) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case TRANSLATE:
                funcToken = jj_consume_token(TRANSLATE);
                break;
              case INSERT:
                funcToken = jj_consume_token(INSERT);
                break;
              default:
                jj_la1[206] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              jj_consume_token(LPAREN);
              if (jj_2_60(1)) {
                args = expressionList(info);
              } else {
                ;
              }
              jj_consume_token(RPAREN);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case XMLPARSE:
                expression = xmlParse(info);
                {if (true) return expression;}
                break;
              case XMLELEMENT:
                expression = xmlElement(info);
                {if (true) return expression;}
                break;
              case XMLPI:
                funcToken = jj_consume_token(XMLPI);
                jj_consume_token(LPAREN);
                if (jj_2_61(2147483647) && ("name".equalsIgnoreCase(getToken(1).image))) {
                  jj_consume_token(ID);
                  expression = idExpression();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case ID:
                    expression = idExpression();
                    break;
                  default:
                    jj_la1[207] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                }
                        args.add(expression);
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case COMMA:
                  jj_consume_token(COMMA);
                  expression = expression(info);
                                args.add(expression);
                  break;
                default:
                  jj_la1[208] = jj_gen;
                  ;
                }
                jj_consume_token(RPAREN);
                break;
              case XMLFOREST:
                expression = xmlForest(info);
                        {if (true) return expression;}
                break;
              case XMLSERIALIZE:
                expression = xmlSerialize(info);
                        {if (true) return expression;}
                break;
              case XMLQUERY:
                expression = xmlQuery(info);
                        {if (true) return expression;}
                break;
              case ID:
                funcName = id();
                jj_consume_token(LPAREN);
                if (jj_2_62(1)) {
                  args = expressionList(info);
                } else {
                  ;
                }
                jj_consume_token(RPAREN);
                break;
              default:
                jj_la1[211] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                if(funcName == null) {
                        funcName = funcToken.image;
                }
                jjtn000.setName(funcName);
        jjtn000.setArgs((Expression[])args.toArray(new Expression[args.size()]));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public Constant stringConstant() throws ParseException {
        String val = null;
    val = stringVal();
                {if (true) return constant(val);}
    throw new Error("Missing return statement in function");
  }

  final public XMLParse xmlParse(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLParse */
        XMLParse jjtn000 = (XMLParse)TeiidNodeFactory.jjtCreate(this, JJTXMLPARSE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expr = null;
        String doc = null;
        boolean wellformed = false;
    try {
      jj_consume_token(XMLPARSE);
      jj_consume_token(LPAREN);
      doc = nonReserved("DOCUMENT", "CONTENT");
      expr = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        nonReserved("WELLFORMED");
           wellformed = true;
        break;
      default:
        jj_la1[212] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setDocument("document".equalsIgnoreCase(doc));
                jjtn000.setExpression(expr);
                jjtn000.setWellFormed(wellformed);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryString queryString(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) QueryString */
        QueryString jjtn000 = (QueryString)TeiidNodeFactory.jjtCreate(this, JJTQUERYSTRING);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression path = null;
        DerivedColumn arg = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    try {
      nonReserved("QUERYSTRING");
      jj_consume_token(LPAREN);
      path = expression(info);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[213] = jj_gen;
          break label_37;
        }
        jj_consume_token(COMMA);
        arg = derivedColumn(info);
                args.add(arg);
                arg = null;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setPath(path);
        jjtn000.setArgs(args);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLElement xmlElement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLElement */
        XMLElement jjtn000 = (XMLElement)TeiidNodeFactory.jjtCreate(this, JJTXMLELEMENT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        ArrayList content = new ArrayList(2);
        XMLNamespaces xmlNamespaces = null;
        XMLAttributes xmlAttributes = null;
        Expression expression = null;
    try {
      jj_consume_token(XMLELEMENT);
      jj_consume_token(LPAREN);
      if (jj_2_70(2147483647) && ("name".equalsIgnoreCase(getToken(1).image))) {
        jj_consume_token(ID);
        name = id();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          name = id();
          break;
        default:
          jj_la1[214] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_71(2)) {
        jj_consume_token(COMMA);
        xmlNamespaces = xmlNamespaces(info);
      } else {
        ;
      }
      if (jj_2_72(2)) {
        jj_consume_token(COMMA);
        xmlAttributes = xmlAttributes(info);
      } else {
        ;
      }
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[215] = jj_gen;
          break label_38;
        }
        jj_consume_token(COMMA);
        expression = expression(info);
                content.add(expression);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(name);
        jjtn000.setContent(content);
        jjtn000.setNamespaces(xmlNamespaces);
        jjtn000.setAttributes(xmlAttributes);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLAttributes xmlAttributes(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLAttributes */
        XMLAttributes jjtn000 = (XMLAttributes)TeiidNodeFactory.jjtCreate(this, JJTXMLATTRIBUTES);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);DerivedColumn expression = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    try {
      jj_consume_token(XMLATTRIBUTES);
      jj_consume_token(LPAREN);
      expression = derivedColumn(info);
                args.add(expression);
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[216] = jj_gen;
          break label_39;
        }
        jj_consume_token(COMMA);
        expression = derivedColumn(info);
                args.add(expression);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setArgs(args);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLForest xmlForest(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLForest */
        XMLForest jjtn000 = (XMLForest)TeiidNodeFactory.jjtCreate(this, JJTXMLFOREST);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);DerivedColumn expression = null;
        XMLNamespaces xmlNamespaces = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    try {
      jj_consume_token(XMLFOREST);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[217] = jj_gen;
        ;
      }
      expression = derivedColumn(info);
                args.add(expression);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[218] = jj_gen;
          break label_40;
        }
        jj_consume_token(COMMA);
        expression = derivedColumn(info);
                args.add(expression);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setArguments(args);
        jjtn000.setNamespaces(xmlNamespaces);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public XMLNamespaces xmlNamespaces(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLNamespaces */
        XMLNamespaces jjtn000 = (XMLNamespaces)TeiidNodeFactory.jjtCreate(this, JJTXMLNAMESPACES);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);ArrayList namespaces = new ArrayList(2);
        NamespaceItem item = null;
    try {
      jj_consume_token(XMLNAMESPACES);
      jj_consume_token(LPAREN);
      item = namespaceItem(info);
                namespaces.add(item);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[219] = jj_gen;
          break label_41;
        }
        jj_consume_token(COMMA);
        item = namespaceItem(info);
                 namespaces.add(item);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setNamespaces(namespaces);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public NamespaceItem namespaceItem(ParseInfo info) throws ParseException {
        String uri = null;
        String prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      uri = stringVal();
      jj_consume_token(AS);
      prefix = id();
                        {if (true) return new NamespaceItem(uri, prefix);}
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(DEFAULT_KEYWORD);
                        {if (true) return new NamespaceItem();}
      break;
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      uri = stringVal();
                        {if (true) return new NamespaceItem(uri);}
      break;
    default:
      jj_la1[220] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Constant idExpression() throws ParseException {
        String id = null;
    id = id();
                {if (true) return constant(id);}
    throw new Error("Missing return statement in function");
  }

  final public String dataTypeString() throws ParseException {
        Token typeToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      typeToken = jj_consume_token(STRING);
      break;
    case VARCHAR:
      typeToken = jj_consume_token(VARCHAR);
      break;
    case BOOLEAN:
      typeToken = jj_consume_token(BOOLEAN);
      break;
    case BYTE:
      typeToken = jj_consume_token(BYTE);
      break;
    case TINYINT:
      typeToken = jj_consume_token(TINYINT);
      break;
    case SHORT:
      typeToken = jj_consume_token(SHORT);
      break;
    case SMALLINT:
      typeToken = jj_consume_token(SMALLINT);
      break;
    case CHAR:
      typeToken = jj_consume_token(CHAR);
      break;
    case INTEGER:
      typeToken = jj_consume_token(INTEGER);
      break;
    case LONG:
      typeToken = jj_consume_token(LONG);
      break;
    case BIGINT:
      typeToken = jj_consume_token(BIGINT);
      break;
    case BIGINTEGER:
      typeToken = jj_consume_token(BIGINTEGER);
      break;
    case FLOAT:
      typeToken = jj_consume_token(FLOAT);
      break;
    case REAL:
      typeToken = jj_consume_token(REAL);
      break;
    case DOUBLE:
      typeToken = jj_consume_token(DOUBLE);
      break;
    case BIGDECIMAL:
      typeToken = jj_consume_token(BIGDECIMAL);
      break;
    case DECIMAL:
      typeToken = jj_consume_token(DECIMAL);
      break;
    case DATE:
      typeToken = jj_consume_token(DATE);
      break;
    case TIME:
      typeToken = jj_consume_token(TIME);
      break;
    case TIMESTAMP:
      typeToken = jj_consume_token(TIMESTAMP);
      break;
    case OBJECT:
      typeToken = jj_consume_token(OBJECT);
      break;
    case BLOB:
      typeToken = jj_consume_token(BLOB);
      break;
    case CLOB:
      typeToken = jj_consume_token(CLOB);
      break;
    case XML:
      typeToken = jj_consume_token(XML);
      break;
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return typeToken.image;}
    throw new Error("Missing return statement in function");
  }

  final public Constant dataType() throws ParseException {
        String type = null;
    type = dataTypeString();
                {if (true) return constant(type);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse an interval type name - used only in TIMESTAMPADD and TIMESTAMPDIFF functions.
 * @return Interval type parsed into a constant string object
 * @throws ParseException if parsing failed
 */
  final public Constant intervalType() throws ParseException {
        String type = null;
    type = nonReserved("SQL_TSI_FRAC_SECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR", "SQL_TSI_DAY", "SQL_TSI_WEEK", "SQL_TSI_MONTH", "SQL_TSI_QUARTER", "SQL_TSI_YEAR");
                {if (true) return constant(type);}
    throw new Error("Missing return statement in function");
  }

/**
 * <p>Parse a literal - strings must be wrapped in either '' or "".
 * JDBC escape syntax is parsed for Date, Time and Timestamp value.</p>
 * @return Parsed literal
 * @throws ParseException if parsing failed
 */
  final public Constant literal() throws ParseException {
    Token t = null;
    String strVal = null;
    DataTypeManagerService.DefaultDataTypes escapeType = null;
    Constant constant = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      strVal = stringVal();
                        constant = constant(strVal, DataTypeManagerService.DefaultDataTypes.STRING);
      break;
    case INTEGERVAL:
      t = jj_consume_token(INTEGERVAL);
                        try {
                                // First try as integer - this should nearly always work
                                constant = constant(Integer.valueOf(t.image), DataTypeManagerService.DefaultDataTypes.INTEGER);
                        } catch(NumberFormatException e1) {
                                try {
                                        // Second try as a long
                                        constant = constant(Long.valueOf(t.image), DataTypeManagerService.DefaultDataTypes.LONG);
                                } catch(NumberFormatException e2) {
                                        try {
                                                // Third try as a biginteger
                                                constant = constant(new BigInteger(t.image), DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
                                        } catch(NumberFormatException e3) {
                                                Object[] params = new Object[] { t.image };
                                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Integer_parse, params));}
                                        }
                                }
                        }
      break;
    case FLOATVAL:
      t = jj_consume_token(FLOATVAL);
                        try {
                                constant = constant(Double.valueOf(t.image), DataTypeManagerService.DefaultDataTypes.DOUBLE);
                        } catch(NumberFormatException e) {
                                Object[] params = new Object[] { t.image };
                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Float_parse, params));}
                        }
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
                               constant = constant(Boolean.FALSE, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case TRUE:
      t = jj_consume_token(TRUE);
                               constant = constant(Boolean.TRUE, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case UNKNOWN:
      t = jj_consume_token(UNKNOWN);
                       constant = constant(null, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case NULL:
      t = jj_consume_token(NULL);
                       constant = constant(null);
      break;
    case DATETYPE:
    case TIMETYPE:
    case TIMESTAMPTYPE:
    case BOOLEANTYPE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEANTYPE:
        jj_consume_token(BOOLEANTYPE);
                             escapeType=DataTypeManagerService.DefaultDataTypes.BOOLEAN;
        break;
      case TIMESTAMPTYPE:
        jj_consume_token(TIMESTAMPTYPE);
                            escapeType=DataTypeManagerService.DefaultDataTypes.TIMESTAMP;
        break;
      case DATETYPE:
        jj_consume_token(DATETYPE);
                            escapeType=DataTypeManagerService.DefaultDataTypes.DATE;
        break;
      case TIMETYPE:
        jj_consume_token(TIMETYPE);
                            escapeType=DataTypeManagerService.DefaultDataTypes.TIME;
        break;
      default:
        jj_la1[222] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      strVal = stringVal();
                        try {
                                constant = constant(getDataTypeService().transformValue(strVal, escapeType), escapeType);
                        } catch (Exception e) {
                                {if (true) throw new ParseException(e.getMessage());}
                        }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[223] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return constant;}
    throw new Error("Missing return statement in function");
  }

  final public AssignmentStatement assignmentStatement(ElementSymbol elementSymbol, LanguageObject value) throws ParseException {
 /*@bgen(jjtree) AssignmentStatement */
  AssignmentStatement jjtn000 = (AssignmentStatement)TeiidNodeFactory.jjtCreate(this, JJTASSIGNMENTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setVariable(elementSymbol);

        if (value instanceof Expression)
            jjtn000.setExpression((Expression) value);
        else if (value instanceof QueryCommand)
            jjtn000.setExpression(scalarSubquery((QueryCommand) value));
        else
            jjtn000.setCommand((Command) value);

        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ScalarSubquery scalarSubquery(QueryCommand queryCommand) throws ParseException {
 /*@bgen(jjtree) ScalarSubquery */
  ScalarSubquery jjtn000 = (ScalarSubquery)TeiidNodeFactory.jjtCreate(this, JJTSCALARSUBQUERY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCommand(queryCommand);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public GroupSymbol groupSymbol(String... args) throws ParseException {
 /*@bgen(jjtree) GroupSymbol */
  GroupSymbol jjtn000 = (GroupSymbol)TeiidNodeFactory.jjtCreate(this, JJTGROUPSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         * Expectation is that group symbol args should be
         * name then definition (or alias).
         */
        jjtn000.setName(args[0]);
        if (args.length == 2)
            jjtn000.setDefinition(args[1]);

        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Constant constant(Object... args) throws ParseException {
 /*@bgen(jjtree) Constant */
  Constant jjtn000 = (Constant)TeiidNodeFactory.jjtCreate(this, JJTCONSTANT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        if (args == null)
            {if (true) return jjtn000;}

        /*
         * Expectation is that constant args should be
         * value of type Object and type of type Class.
         */
        for (Object arg : args) {
            if (arg instanceof Class) {
                jjtn000.setType((Class) arg);
            } else if (arg instanceof DataTypeManagerService.DefaultDataTypes) {
                DataTypeManagerService.DefaultDataTypes dataType = (DataTypeManagerService.DefaultDataTypes) arg;
                jjtn000.setType(dataType.getTypeClass());
            } else {
                jjtn000.setValue(arg);
            }
        }
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ElementSymbol elementSymbol(String name) throws ParseException {
 /*@bgen(jjtree) ElementSymbol */
  ElementSymbol jjtn000 = (ElementSymbol)TeiidNodeFactory.jjtCreate(this, JJTELEMENTSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Block block() throws ParseException {
 /*@bgen(jjtree) Block */
  Block jjtn000 = (Block)TeiidNodeFactory.jjtCreate(this, JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Block asBlock(Statement stmt) throws ParseException {
  Block b = null;
        if (stmt == null)
            {if (true) return null;}

        if (stmt instanceof Block)
            {if (true) return (Block) stmt;}

        b = block();
        b.addStatement(stmt);
        {if (true) return b;}
    throw new Error("Missing return statement in function");
  }

  final public ExpressionCriteria expressionCriteria(Expression expression) throws ParseException {
 /*@bgen(jjtree) ExpressionCriteria */
  ExpressionCriteria jjtn000 = (ExpressionCriteria)TeiidNodeFactory.jjtCreate(this, JJTEXPRESSIONCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AliasSymbol aliasSymbol(String alias, Expression expression) throws ParseException {
 /*@bgen(jjtree) AliasSymbol */
  AliasSymbol jjtn000 = (AliasSymbol)TeiidNodeFactory.jjtCreate(this, JJTALIASSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(alias);
        jjtn000.setSymbol(expression);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AggregateSymbol newAggregateSymbol(String name, String aggregateFunction, boolean isDistinct, Expression expression) throws ParseException {
 /*@bgen(jjtree) AggregateSymbol */
  AggregateSymbol jjtn000 = (AggregateSymbol)TeiidNodeFactory.jjtCreate(this, JJTAGGREGATESYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        jjtn000.setAggregateFunction(aggregateFunction);
        jjtn000.setDistinct(isDistinct);
        jjtn000.setExpression(expression);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public WindowFunction windowFunction() throws ParseException {
 /*@bgen(jjtree) WindowFunction */
  WindowFunction jjtn000 = (WindowFunction)TeiidNodeFactory.jjtCreate(this, JJTWINDOWFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public WindowSpecification newWindowSpecification() throws ParseException {
 /*@bgen(jjtree) WindowSpecification */
  WindowSpecification jjtn000 = (WindowSpecification)TeiidNodeFactory.jjtCreate(this, JJTWINDOWSPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public TextLine textLine() throws ParseException {
 /*@bgen(jjtree) TextLine */
  TextLine jjtn000 = (TextLine)TeiidNodeFactory.jjtCreate(this, JJTTEXTLINE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterTrigger alterTrigger() throws ParseException {
 /*@bgen(jjtree) AlterTrigger */
  AlterTrigger jjtn000 = (AlterTrigger)TeiidNodeFactory.jjtCreate(this, JJTALTERTRIGGER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterProcedure alterProcedure() throws ParseException {
 /*@bgen(jjtree) AlterProcedure */
  AlterProcedure jjtn000 = (AlterProcedure)TeiidNodeFactory.jjtCreate(this, JJTALTERPROCEDURE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterView alterView() throws ParseException {
 /*@bgen(jjtree) AlterView */
  AlterView jjtn000 = (AlterView)TeiidNodeFactory.jjtCreate(this, JJTALTERVIEW);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_3R_199() {
    if (jj_3R_221()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_258() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_46() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_59()) return true;
    if (jj_3R_73()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_47() {
    if (jj_3R_72()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "textagg") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_199()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "count", "min", "max", "sum", "avg", "every", "STDDEV_POP", "STDDEV_SAMP", "VAR_SAMP", "VAR_POP") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "rank", "dense_rank", "row_number") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_21() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(EACH)) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_3R_51()) return true;
    if (jj_3R_372()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_186() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) jj_scanpos = xsp;
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(TIMETYPE)) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(DATETYPE)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) return true;
    }
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(TIMESTAMPTYPE)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_scan_token(BOOLEANTYPE)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_251() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    }
    }
    if (jj_3R_274()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_345()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_346()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_351()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(FLOATVAL)) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_332()) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_186()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_187()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(INTEGERVAL)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_319()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    xsp = jj_scanpos;
    if (jj_3R_353()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_165()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_166()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_scan_token(ALL_IN_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_320() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_320()) return true;
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_368()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_156()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_305()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_403() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(CONCAT_OP)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_318() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) return true;
    }
    return false;
  }

  private boolean jj_3R_359() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_403()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_287()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(VIRTUAL)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_372() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(218)) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    }
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(STRINGVAL)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_327()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_299()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_310() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_3R_326()) return true;
    }
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(NOCACHE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_3R_274()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_404() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_412()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_272()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(INTEGERVAL)) return true;
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_404()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(MAKEDEP)) return true;
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_271()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_51()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_304()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(XMLNAMESPACES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_404()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_405()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_scan_token(INTO)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_418() {
    if (jj_3R_59()) return true;
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(TRANSLATE)) return true;
    if (jj_3R_110()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_286()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(OPTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_219()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_3R_360()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_3R_78()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_3R_51()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) return true;
    }
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_331()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_313()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_3R_329()) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(XMLFOREST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_381()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(FETCH)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    }
    if (jj_scan_token(ONLY)) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_293()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_3R_318()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(OFFSET)) return true;
    if (jj_3R_267()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_269()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_168()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(XMLATTRIBUTES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_345()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_406()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_410()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(LIMIT)) return true;
    if (jj_3R_267()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_217() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_410()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_411()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_72() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(TABLE)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3_71() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_70() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_212() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_345()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_409()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_78()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) return true;
    }
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(XMLTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    xsp = jj_scanpos;
    if (jj_3R_401()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_scan_token(XMLELEMENT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = "name".equalsIgnoreCase(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_378()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_51()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) return true;
    }
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_233() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_scan_token(INTERSECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) jj_scanpos = xsp;
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_212()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_214()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_386() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    if (jj_scan_token(ON)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(OPTION)) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_374()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_215() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind != JOIN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_215()) jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_189()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_191()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_192()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(DECLARE)) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_59()) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_345()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_390()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_3R_264()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_3R_78()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(XMLPARSE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_59()) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(XMLQUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_384()) jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    xsp = jj_scanpos;
    if (jj_3R_385()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_386()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(HAS)) return true;
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_51()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_213()) jj_scanpos = xsp;
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_136()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_235()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_236()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_62() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_scan_token(NO)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_317()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_3R_51()) return true;
    if (jj_3R_360()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_407()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3_61() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_188()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_190()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_52()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(XMLPI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = "name".equalsIgnoreCase(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_367()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3_60() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    if (jj_scan_token(CRITERIA)) return true;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_59() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_292()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = "quote".equalsIgnoreCase(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_65()) return true;
    }
    return false;
  }

  private boolean jj_3_68() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(ID)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_59()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(ROW)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3_67() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_3R_59()) return true;
    if (jj_3R_393()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_394()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_395()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_398()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_66() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(LOOP)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_363()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_72()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_335()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_3R_292()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_344()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_3R_59()) return true;
    if (jj_3R_399()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_56()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_57() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3_57()) return true;
    }
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(LEAVE)) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_scan_token(AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_65() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_285() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_382()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    xsp = jj_scanpos;
    if (jj_3R_383()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_262()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_scan_token(MAKEDEP)) return true;
    return false;
  }

  private boolean jj_3R_371() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) return true;
    }
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_64() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    if (jj_scan_token(ATOMIC)) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_60()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_72()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(BEGIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_129()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_3R_175()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_3R_173()) return true;
    return false;
  }

  private boolean jj_3_63() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = "texttable".equalsIgnoreCase(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_145()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = "arraytable".equalsIgnoreCase(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_371()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_226() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(CAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_360()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_185() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE_REGEX)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(162)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_360()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.equalsIgnoreCase("SUBSTRING");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_63()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.equalsIgnoreCase("EXTRACT");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_64()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.equalsIgnoreCase("TRIM");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_65()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "to_chars", "to_bytes") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_114()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "timestampadd", "timestampdiff") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_115()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.equalsIgnoreCase("querystring");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(162)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(162)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_51()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(318)) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) return true;
    }
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(SIMILAR)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_343()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) return true;
    }
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_3R_106()) return true;
    }
    if (jj_3R_72()) return true;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_154()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(CROSS)) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(318)) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    if (jj_3R_126()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_126()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_356()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(ERROR)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    }
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_240()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_195() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_59()) return true;
    if (jj_3R_60()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_53()) return true;
    Token xsp;
    if (jj_3R_357()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_357()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_358()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_154() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_scan_token(OVER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_354()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(PARTITION)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_154()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_328()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    }
    if (jj_3R_51()) return true;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_182()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(LOCAL)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_211()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_352() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_369()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(DROP)) return true;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_69()) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_370() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    return false;
  }

  private boolean jj_3_54() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3_55() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_3R_317()) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_3R_317()) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_53()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_3R_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    }
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_370()) jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(ID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) return true;
    }
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_53() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_222()) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_259()) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_223()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_339()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_222()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_222() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = matchesAny(getToken(1).image, "rank", "dense_rank", "row_number") != null;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    }
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_3R_222()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_337()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public Teiid7ParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[224];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x100020,0x0,0x100020,0x0,0x0,0x0,0x0,0x400,0x0,0x1000,0x144020,0x144020,0x100000,0x20,0x0,0x0,0x1,0x0,0x0,0x4000,0x140020,0x140020,0x140020,0x0,0x1000,0x144020,0x40000,0x0,0x40000,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x400,0x400,0x400,0x200,0x0,0x0,0x0,0x80,0x10,0x10,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x1,0x0,0x100000,0x400,0x400,0x400,0x0,0x40,0x0,0x0,0x0,0x8000,0x0,0x0,0x100000,0x90,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x18104040,0x0,0x18104040,0x0,0x40,0x4000,0x4000,0x0,0x0,0x0,0x19106041,0x19106041,0x18104000,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x19106041,0x19106041,0x19106041,0x0,0x0,0x19106041,0x1,0x0,0x1,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x80000,0x80000,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x18000000,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x80000000,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x1000000,0x0,0x1000000,0x0,0x4,0x1000000,0x1000000,0x0,0x0,0x0,0x1008000,0x1008000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008000,0x1008000,0x1000000,0x0,0x0,0x1008000,0x0,0x0,0x0,0x0,0x10040000,0x10040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x2000000,0x0,0x0,0x0,0x8000000,0x0,0x400,0x1000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0xc0100020,0x0,0x0,0x0,0x0,0x80100020,0x80100020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10040000,0x0,0x10040000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x10,0x4000,0x0,0x0,0x80004000,0x1000000,0x0,0x0,0x0,0x80004000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x108,0x108,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x100,0x8,0x8,0x8,0x800000,0x800000,0x108,0x0,0x0,0x8,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600,0x600,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x800030,0x0,0x0,0x0,0x0,0x800000,0x10,0x0,0x0,0x800000,0x800000,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000040,0x0,0x0,0x100600,0x0,0x0,0x0,0x0,0x100600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x24000,0x4,0x4,0x24000,0x0,0x0,0x0,0x0,0x24000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x1000000,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x20000000,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x4,0x4,0x4,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,0x0,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x10100000,0x0,0x0,0x0,0x0,0x10100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x4001000,0x0,0x4001000,0x0,0x0,0x4000000,0x4000000,0x0,0x100000,0x0,0x4001000,0x4001000,0x4001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4001000,0x4001000,0x4001000,0x0,0x0,0x4001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x1000,0x0,0x0,0x0,0x0,0x40000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x1000,0x8,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1200000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x40000,0x40000,0x2000000,0x80000,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1200000,};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x4,0x4,0x4,0x0,0x0,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180,0x0,0x0,0x0,0x0,0x180,0x79400,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {0x280000,0x0,0x80000,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x80010,0x80010,0x80000,0x0,0x20000,0x20000,0x10,0x0,0x10,0x0,0x80010,0x80010,0x80010,0x0,0x0,0x80010,0x0,0x10,0x0,0x0,0xfe000000,0xfe000000,0x20000,0x2000010,0x2000010,0x2000010,0x0,0x80000,0x2000010,0x10,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x20000,0x0,0x80000,0x0,0x0,0x0,0x20000,0x40000000,0x20000,0x40000000,0x80000,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x20000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x8,0x0,0x10,0x0,0x0,0x0,0x20000,0x0,0x10,0x0,0x0,0x10,0x0,0x20000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x80000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x1000,0x0,0x0,0x20000,0x10,0x10,0x0,0x20000,0x20000,0x0,0x0,0x10,0x0,0x0,0x80000,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0xfe000000,0xfe000000,0x0,0xfe000000,0x80000,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x20000,0x80000,0x20000,0x0,0x0,0x10,0x1000,0x20000,0x0,0x0,0x0,0x1000,0x0,0x0,0x20000,0x20000,0x20000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x207f80,0x0,0x10,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x10,0x20000,0x0,0x0,0x10,0x10,0x20000,0x10,0x20000,0x20000,0x0,0x20000,0x20000,0x4000,0x0,0x780,0x7780,};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {0x0,0x40,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0xc,0xc,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[72];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Teiid7Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Teiid7Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new Teiid7ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Teiid7Parser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new Teiid7ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Teiid7Parser(Teiid7ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(Teiid7ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 224; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[329];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 224; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 329; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 72; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
