/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */
package org.teiid.query.metadata;

import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion.Version;

public interface DDLConstants {
	public static final String JAVA_METHOD = "JAVA_METHOD";//$NON-NLS-1$
	public static final String JAVA_CLASS = "JAVA_CLASS";//$NON-NLS-1$
	public static final String DETERMINISM = "DETERMINISM";//$NON-NLS-1$
	public static final String CATEGORY = "CATEGORY";//$NON-NLS-1$
	public static final String UPDATECOUNT = "UPDATECOUNT";//$NON-NLS-1$
	public static final String DISTINCT_VALUES = "DISTINCT_VALUES";//$NON-NLS-1$
	public static final String NULL_VALUE_COUNT = "NULL_VALUE_COUNT";//$NON-NLS-1$
	public static final String RADIX = "RADIX";//$NON-NLS-1$
	public static final String NATIVE_TYPE = "NATIVE_TYPE";//$NON-NLS-1$
	public static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";//$NON-NLS-1$
	public static final String MAX_VALUE = "MAX_VALUE"; //$NON-NLS-1$
	public static final String MIN_VALUE = "MIN_VALUE";//$NON-NLS-1$
	public static final String SEARCHABLE = "SEARCHABLE";//$NON-NLS-1$
	public static final String FIXED_LENGTH = "FIXED_LENGTH";//$NON-NLS-1$
	public static final String CURRENCY = "CURRENCY";//$NON-NLS-1$
	public static final String SIGNED = "SIGNED";//$NON-NLS-1$
	public static final String SELECTABLE = "SELECTABLE";//$NON-NLS-1$
	public static final String CASE_SENSITIVE = "CASE_SENSITIVE";//$NON-NLS-1$
	@Since(Version.TEIID_8_5)
	public static final String AUTO_INCREMENT = "AUTO_INCREMENT";//$NON-NLS-1$
	public static final String NOT_NULL = "NOT NULL";//$NON-NLS-1$
	public static final String FOREIGN_KEY = "FOREIGN KEY";//$NON-NLS-1$
	public static final String PRIMARY_KEY = "PRIMARY KEY";//$NON-NLS-1$
	public static final String ACCESSPATTERN = "ACCESSPATTERN";//$NON-NLS-1$
	public static final String NAMEINSOURCE = "NAMEINSOURCE";//$NON-NLS-1$
	public static final String ANNOTATION = "ANNOTATION";//$NON-NLS-1$
	public static final String UUID = "UUID";//$NON-NLS-1$
	public static final String CARDINALITY = "CARDINALITY";//$NON-NLS-1$
	public static final String UPDATABLE = "UPDATABLE";//$NON-NLS-1$
	public static final String MATERIALIZED_TABLE = "MATERIALIZED_TABLE";//$NON-NLS-1$
	public static final String MATERIALIZED = "MATERIALIZED";//$NON-NLS-1$
	public static final String INSTEAD_OF = "INSTEAD OF";//$NON-NLS-1$
	public static final String CREATE_TRIGGER_ON = "CREATE TRIGGER ON";//$NON-NLS-1$
	public static final String FOREIGN_TABLE = "FOREIGN TABLE";//$NON-NLS-1$
	public static final String UDT = "UDT";//$NON-NLS-1$
}
