/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.mapping.ui.choice;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.query.ui.builder.util.ElementViewerFactory;


/**
 * BuilderTreeProvider is the modeler's content and label provider for the Criteria and
 * Expression builder dialogs in mapping.ui .  Creating this object will cause it to be
 * hooked up properly to the ElementViewerFactory.
 * 
 * Dan's sugg: In rewriting the transformation.ui version to work for Choice Node/Mapping classes
 *             a good start is to expect that the args to these methods will be either
 *             MappingClass or MappingClassColumn objects.
 *             Also, expet to drop the 'GroupSymbol'
 *
 * @since 8.0
 */
public class BuilderTreeProvider implements ITreeContentProvider, ILabelProvider {

    ILabelProvider emfLabelProvider;
    Object[] mappingClasses;
     
    
    /**
     * Construct an instance of BuilderTreeProvider.
     */
    public BuilderTreeProvider() {
//        System.out.println("[BuilderTreeProvider.ctor] TOP"); //$NON-NLS-1$
        ElementViewerFactory.setContentProvider(this);
        ElementViewerFactory.setLabelProvider(this);
        emfLabelProvider = ModelUtilities.getEMFLabelProvider();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
     */
    @Override
	public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[0];
        
        if ( parentElement instanceof MappingClass ) {
//            System.out.println("[BuilderTreeProvider.getChildren] About to return 'getColumns'"); //$NON-NLS-1$
            result = ((MappingClass)parentElement).getColumns().toArray();
        } else {
//            System.out.println("[BuilderTreeProvider.getChildren] parentElement NOT a MappingClass, no action"); //$NON-NLS-1$
        }
        return result;

    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
     */
    @Override
	public Object getParent( Object element ) {
        Object oResult = null;

        if ( element instanceof MappingClassColumn ) {
            oResult = ((MappingClassColumn)element).getMappingClass();
        } 
        else        
        if ( element instanceof EObject ) {
          oResult = ((EObject)element).eContainer();

          if ( oResult == null ) {
              oResult = ModelUtilities.getModelResourceForModelObject((EObject) element);
          }
      }
        
//      return result;
        
        return oResult;


    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
     */
    @Override
	public boolean hasChildren(Object element) {
//        System.out.println("[BuilderTreeProvider.hasChildren] TOP: element is: " + element ); //$NON-NLS-1$
        return getChildren(element).length > 0;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
     */
    @Override
	public Image getImage(Object obj) {

        return emfLabelProvider.getImage( obj );

    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
     */
    @Override
	public String getText(Object obj) {
//        System.out.println("[BuilderTreeProvider.getText] TOP: Arg is: " + obj ); //$NON-NLS-1$
        
//        System.out.println("[BuilderTreeProvider.getText] TOP: About to return: " + emfLabelProvider.getText( obj ) ); //$NON-NLS-1$        
        return emfLabelProvider.getText( obj );

//=============================================================
////        if ( obj instanceof IGroupSymbol ) {
////            IGroupSymbol symbol = (IGroupSymbol) obj;
////            
////            String result = null;
////            // if symbol has a non-null definition, then it is an alias:
////            if ( symbol.getDefinition() == null ) {
////                result = symbol.getName();
////            } else {
////                result = symbol.getDefinition();
////                result += " AS " + symbol.getName(); //$NON-NLS-1$  "AS" is SQL, not English - do not internationalize
////            }
////            
////            return result;
////        } else if ( obj instanceof ModelResource ) {
////            return ModelerCore.getModelEditor().getModelName((ModelResource) obj);
////        }
////        return emfLabelProvider.getText(obj);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    @Override
	public Object[] getElements( Object inputElement ) {
//        System.out.println("[BuilderTreeProvider.getElements] TOP"); //$NON-NLS-1$
//        Object[] result = new Object[] { mcCurrent };
//        System.out.println("[BuilderTreeProvider.getElements] About to return" + result[0] ); //$NON-NLS-1$

        return mappingClasses;                
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
     */
    @Override
	public void dispose() {

    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
     */
    @Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
//        System.out.println("[BuilderTreeProvider.inputChanged] TOP"); //$NON-NLS-1$
       
        if ( newInput != null  ) {
            if(newInput instanceof List) {
                mappingClasses = ((List)newInput).toArray();
            } else {
                ArrayList singleList = new ArrayList(1);
                mappingClasses = singleList.toArray();
            }
        }

    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    @Override
	public void addListener(ILabelProviderListener listener) {

    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
     */
    @Override
	public boolean isLabelProperty(Object element, String property) {
        return emfLabelProvider.isLabelProperty(element, property);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    @Override
	public void removeListener(ILabelProviderListener listener) {

    }

}
