/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.teiid.designer.diagram.ui.util.RelationalUmlEObjectHelper;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.ui.actions.TransformationSelectionHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.xsd.util.ModelerXsdUtils;



/** 
 * @since 8.0
 */
public class MappingSelectionHelper extends TransformationSelectionHelper {
    public static final int TYPE_EXTENT = 20;
    public static final int TYPE_COARSE_EXTENT = 21;
    public static final int TYPE_MAPPING_CLASS = 22;
    public static final int TYPE_MAPPING_CLASS_CHILD = 23;
    public static final int TYPE_STAGING_TABLE = 24;
    public static final int TYPE_STAGING_TABLE_CHILD = 25;
    public static final int TYPE_ENUM_TYPE = 26;
    public static final int TYPE_ENUM_VALUE = 27;
    
    /** 
     * @param tRoot
     * @param selection
     * @since 4.2
     */
    public MappingSelectionHelper(EObject tRoot, ISelection selection) {
        super(tRoot, selection);
    }
    
    public MappingSelectionHelper(ISelection selection) {
        super(null, selection);
    }
    
    /** 
     * @see org.teiid.designer.transformation.ui.actions.TransformationSelectionHelper#getEObjectType(org.eclipse.emf.ecore.EObject)
     * @since 4.2
     */
    @Override
    public int getEObjectType(EObject eObj) {
        int eObjType = TYPE_UNKNOWN;
        if( eObj instanceof StagingTable  ) {
            eObjType = TYPE_STAGING_TABLE;
        } else if( eObj instanceof MappingClass ) {
            eObjType = TYPE_MAPPING_CLASS;
        } else if( ModelMapperFactory.isXmlTreeNode(eObj)) {
            eObjType = TYPE_EXTENT;
        } else if (ModelerXsdUtils.isEnumeratedType(eObj)) {
            eObjType = TYPE_ENUM_TYPE;
        } else if (ModelerXsdUtils.isEnumeratedTypeValue(eObj)) {
            eObjType = TYPE_ENUM_VALUE;
        } else {
            // Don't know what it is, so ask someone else
            int umlType = RelationalUmlEObjectHelper.getEObjectType(eObj);
            if( umlType == RelationalUmlEObjectHelper.UML_ASSOCIATION ||
                umlType == RelationalUmlEObjectHelper.UML_GENERALIZATION ||
                umlType == RelationalUmlEObjectHelper.UML_OPERATION ||
                umlType == RelationalUmlEObjectHelper.UML_ATTRIBUTE ) {
                // Check to see whose child it is.
                EObject eContainer = eObj.eContainer();
                if( eContainer instanceof StagingTable  ) {
                    eObjType = TYPE_STAGING_TABLE_CHILD;
                } else if( eContainer instanceof MappingClass ) {
                    eObjType = TYPE_MAPPING_CLASS_CHILD;
                // defect 15883 - incorrect menu showing up in Mapping diagram:
                } else {
                    eObjType = super.getEObjectType(eObj);
                } // endif

            } else {
                eObjType = super.getEObjectType(eObj);
            }
        }
        return eObjType;
    }
    
    public boolean someExtentSelected() {
        boolean foundExtent = false;
        
        if( getCount() == 1 ) {
            EObject eObj = SelectionUtilities.getSelectedEObject(getSelection());
            if( eObj != null ) {
                int type = getEObjectType(eObj);
                if( type == TYPE_EXTENT )
                    foundExtent = true;
            }
        } else {
            Iterator iter = SelectionUtilities.getSelectedEObjects(getSelection()).iterator();
            EObject nextEObj = null;
            while( iter.hasNext() && !foundExtent) {
                nextEObj = (EObject)iter.next();
                if( getEObjectType(nextEObj) == TYPE_EXTENT )
                    foundExtent = true;
            }
        }
        
        return foundExtent;
    }
}
