/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndEditor;
import org.jboss.tools.modeshape.ui.forms.ErrorMessage;

public abstract class CndEditorPage
extends FormPage
implements IPersistableEditor {
    protected IMemento memento;

    protected CndEditorPage(CndEditor cndEditor, String id, String title) {
        super((FormEditor)cndEditor, id, title);
    }

    protected abstract void createBody(Composite var1, FormToolkit var2);

    protected final void createFormContent(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createBody(body, managedForm.getToolkit());
        this.setResourceReadOnly(this.isReadonly());
        this.updateAllMessages();
    }

    protected void ensureVisible(Control c) {
        FormToolkit.ensureVisible((Control)c);
    }

    protected CompactNodeTypeDefinition getCnd() {
        return this.getCndEditor().getCnd();
    }

    protected CndEditor getCndEditor() {
        return (CndEditor)this.getEditor();
    }

    protected IFile getFile() {
        return this.getCndEditor().getFile();
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    public abstract void handleCndReloaded();

    protected abstract void handlePropertyChanged(PropertyChangeEvent var1);

    protected boolean isReadonly() {
        return this.getCndEditor().isReadOnly();
    }

    public final void restoreState(IMemento memento) {
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
    }

    public void setFocus() {
        super.setFocus();
        if (this.getManagedForm() != null) {
            this.getManagedForm().refresh();
        }
    }

    protected abstract void setResourceReadOnly(boolean var1);

    protected abstract void updateAllMessages();

    protected void updateMessage(ErrorMessage errorMessage) {
        assert (errorMessage != null) : "errorMessage is null";
        IMessageManager msgMgr = ((CndEditor)this.getEditor()).getMessageManager();
        if (errorMessage.isOk()) {
            if (errorMessage.getControl() == null) {
                msgMgr.removeMessage(errorMessage.getKey());
            } else {
                msgMgr.removeMessage(errorMessage.getKey(), errorMessage.getControl());
            }
        } else if (errorMessage.getControl() == null) {
            msgMgr.addMessage(errorMessage.getKey(), errorMessage.getMessage(), errorMessage.getData(), errorMessage.getMessageType());
        } else {
            msgMgr.addMessage(errorMessage.getKey(), errorMessage.getMessage(), errorMessage.getData(), errorMessage.getMessageType(), errorMessage.getControl());
        }
    }
}

