/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.NotationFigureGenerator;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.SummaryExtent;
import org.teiid.designer.mapping.ui.figure.MappingDiagramFigure;
import org.teiid.designer.mapping.ui.figure.MappingExtentFigure;
import org.teiid.designer.mapping.ui.figure.SummaryExtentFigure;
import org.teiid.designer.mapping.ui.model.MappingDiagramNode;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.model.SummaryExtentNode;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.ui.figure.TransformationFigure;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;

public class MappingDiagramFigureFactory
extends AbstractDiagramFigureFactory
implements UiConstants {
    private static final int EXTENT = 1;
    private static final int DIAGRAM = 0;
    private static final int STAGING_TABLE_EXTENT = 2;
    private static final int TRANSFORM = 3;
    private static final int SUMMARY_EXTENT = 4;

    public Figure createFigure(Object modelObject, String sNotationId) {
        Figure newFigure = null;
        switch (this.getObjectType(modelObject)) {
            case 0: 
            case 1: 
            case 4: {
                newFigure = this.createFigure(modelObject);
                break;
            }
            default: {
                EObject eObj;
                NotationFigureGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getFigureGenerator(sNotationId);
                if (modelObject instanceof UmlClassifierNode && MappingDiagramUtil.isMappingSqlTable(eObj = ((DiagramModelNode)modelObject).getModelObject())) {
                    ((DiagramModelNode)modelObject).setHideLocation(true);
                }
                if (generator != null) {
                    newFigure = generator.createFigure(modelObject);
                    break;
                }
                ModelerCore.Util.log(4, Util.getString("DiagramErrors.figureGeneratorFailure", new Object[0]));
            }
        }
        return newFigure;
    }

    public Figure createFigure(Object modelObject) {
        Object newFigure = null;
        ColorPalette colorPalette = null;
        switch (this.getObjectType(modelObject)) {
            case 0: {
                Diagram diagram = (Diagram)((DiagramModelNode)modelObject).getModelObject();
                if (MappingDiagramUtil.isDetailedDiagram(diagram)) {
                    newFigure = new MappingDiagramFigure();
                    break;
                }
                newFigure = new FreeformLayer();
                newFigure.setLayoutManager((LayoutManager)new FreeformLayout());
                newFigure.setOpaque(true);
                RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.mapping.backgroundcolor");
                newFigure.setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
                break;
            }
            case 1: {
                MappingExtentNode mExtentNode = (MappingExtentNode)((Object)modelObject);
                colorPalette = this.getColorPalette(((DiagramModelNode)modelObject).getModelObject());
                if (!mExtentNode.getExtent().isCompletelyMapped()) {
                    if (mExtentNode.getExtent().isMappingRequired()) {
                        colorPalette.setColor(0, UiConstants.Colors.REQUIRES_MAPPING);
                        colorPalette.setColor(5, ColorConstants.black);
                    } else {
                        colorPalette.setColor(0, UiConstants.Colors.UNMAPPED);
                        colorPalette.setColor(5, ColorConstants.black);
                    }
                }
                newFigure = new MappingExtentFigure(null, colorPalette);
                break;
            }
            case 2: {
                MappingExtentNode mExtentNode = (MappingExtentNode)((Object)modelObject);
                EObject mappingRefEObject = mExtentNode.getExtent().getMappingReference();
                if (mappingRefEObject != null && mappingRefEObject instanceof StagingTable) {
                    colorPalette = this.getColorPalette(mappingRefEObject);
                }
                if (colorPalette == null) {
                    colorPalette = this.getColorPalette(((DiagramModelNode)modelObject).getModelObject());
                }
                newFigure = new MappingExtentFigure(null, colorPalette);
                break;
            }
            case 3: {
                colorPalette = this.getColorPalette(((DiagramModelNode)modelObject).getModelObject());
                newFigure = new TransformationFigure((TransformationNode)modelObject, "T", colorPalette);
                break;
            }
            case 4: {
                SummaryExtentNode sExtentNode = (SummaryExtentNode)modelObject;
                SummaryExtent seExtent = (SummaryExtent)sExtentNode.getExtent();
                colorPalette = this.getColorPalette(((DiagramModelNode)modelObject).getModelObject());
                Image imgImage = sExtentNode.getImage();
                int iImagePosition = sExtentNode.getImagePosition();
                newFigure = new SummaryExtentFigure(seExtent.getMappingClassColumnCount(), seExtent.getUnmappedNodeCount(), colorPalette, seExtent.getSomeMappingClassesAreVisible(), imgImage, iImagePosition);
                break;
            }
        }
        return newFigure;
    }

    protected int getObjectType(Object modelObject) {
        int objectType = -1;
        if (modelObject != null) {
            if (modelObject instanceof MappingDiagramNode) {
                objectType = 0;
            } else if (modelObject instanceof SummaryExtentNode) {
                objectType = 4;
            } else if (modelObject instanceof MappingExtentNode) {
                objectType = ((MappingExtentNode)((Object)modelObject)).getExtent().getMappingReference() instanceof StagingTable ? 2 : 1;
            } else if (modelObject instanceof TransformationNode) {
                objectType = 3;
            }
        }
        return objectType;
    }

    private ColorPalette getColorPalette(EObject eObject) {
        return DiagramUiPlugin.getDiagramTypeManager().getDiagram("mappingDiagramType").getColorPaletteManager().getColorPalette(eObject);
    }
}

