/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.figure;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierFigure;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;

public class MappingDiagramFigure
extends FreeformLayer {
    private static final String TARGET_TITLE = "VIEW";
    private static final String SOURCES_TITLE = "SOURCES";

    public MappingDiagramFigure() {
        this.init();
    }

    private void init() {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setOpaque(true);
        RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.mapping.backgroundcolor");
        this.setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
    }

    protected void paintFigure(Graphics theGraphics) {
        super.paintFigure(theGraphics);
        this.paintBkgdAndTitles(theGraphics);
    }

    private void paintBkgdAndTitles(Graphics theGraphics) {
        Font boldFont = ScaledFontManager.getFont((int)4);
        Dimension targetDim = FigureUtilities.getStringExtents((String)TARGET_TITLE, (Font)boldFont);
        int headerHeight = targetDim.height + 10;
        int targetTableWidth = this.getWidthOfTarget();
        int widthOfTargetPanel = targetTableWidth + 120 + 30;
        theGraphics.setForegroundColor(ColorConstants.black);
        theGraphics.setBackgroundColor(ColorConstants.cyan);
        theGraphics.fillRectangle(0, 0, widthOfTargetPanel, 3000);
        theGraphics.drawRectangle(0, 0, widthOfTargetPanel, 3000);
        theGraphics.drawRectangle(0, 0, 3000, headerHeight);
        theGraphics.setForegroundColor(ColorConstants.buttonDarker);
        int startingPoint = widthOfTargetPanel / 2 - targetDim.width / 2;
        theGraphics.setFont(boldFont);
        theGraphics.drawString(TARGET_TITLE, startingPoint, 8);
        startingPoint = widthOfTargetPanel + 30 + 30;
        theGraphics.drawString(SOURCES_TITLE, startingPoint, 8);
    }

    private int getWidthOfTarget() {
        int widthOfTarget = 0;
        DiagramModelNode thisDiagramNode = null;
        EObject targetOfDiagram = null;
        List childFigures = this.getChildren();
        Object nextObj2 = null;
        for (Object nextObj2 : childFigures) {
            if (nextObj2 instanceof UmlClassifierFigure) {
                thisDiagramNode = ((UmlClassifierFigure)nextObj2).getDiagramModelNode();
                if (targetOfDiagram == null) {
                    EObject modelObject;
                    Diagram diagram = thisDiagramNode.getDiagram();
                    if (diagram != null) {
                        targetOfDiagram = diagram.getTarget();
                    }
                    if ((modelObject = thisDiagramNode.getModelObject()) == targetOfDiagram) {
                        widthOfTarget = thisDiagramNode.getWidth();
                    }
                }
            }
            if (widthOfTarget > 0) break;
        }
        if (widthOfTarget < 10) {
            widthOfTarget = 10;
        }
        return widthOfTarget;
    }
}

