/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.editor.BindingAdapter;
import org.teiid.designer.mapping.ui.editor.BindingList;
import org.teiid.designer.mapping.ui.editor.InputSetAdapter;
import org.teiid.designer.mapping.ui.editor.InputSetPanel;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.transformation.ui.actions.ITransformationDiagramActionConstants;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public class InputSetObjectEditorPage
implements ModelObjectEditorPage,
INotifyChangedListener,
org.teiid.designer.transformation.ui.UiConstants,
ITransformationDiagramActionConstants {
    private static final String TITLE_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.title.text", new Object[0]);
    private static final String TITLE_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.title.toolTip", new Object[0]);
    private MappingClass currentMappingClass;
    private InputSet inputSet;
    private InputSetPanel ispInputSetPanel;
    private InputSetAdapter isoInputSetObject;
    private ModelEditor parentModelEditor;

    public boolean canClose() {
        return true;
    }

    public void createControl(Composite parent) {
        this.ispInputSetPanel = new InputSetPanel(parent);
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
    }

    public void setMappingAdapters(InputSet inputSet) {
        ModelEditorPage editorPage;
        this.inputSet = inputSet;
        IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        IEditorPart editorPart = window.getActivePage().getActiveEditor();
        if (editorPart instanceof ModelEditor && (editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage()) instanceof DiagramEditor) {
            DiagramController controller = ((DiagramEditor)editorPage).getDiagramController();
            if (controller instanceof MappingDiagramController) {
                TreeMappingAdapter mapping = ((MappingDiagramController)controller).getMappingAdapter();
                IMappableTree mappableTree = ((MappingDiagramController)controller).getMappableTree();
                this.ispInputSetPanel.setMappingAdapters(mapping, mappableTree);
            } else {
                EObject docRoot = inputSet.getMappingClass().getMappingClassSet().getTarget();
                TreeMappingAdapter mapping = new TreeMappingAdapter(docRoot);
                DefaultMappableTree mappableTree = new DefaultMappableTree(docRoot);
                this.ispInputSetPanel.setMappingAdapters(mapping, (IMappableTree)mappableTree);
            }
        }
    }

    public Control getControl() {
        return this.ispInputSetPanel;
    }

    public String getTitle() {
        return TITLE_TEXT;
    }

    public String getTitleToolTip() {
        return TITLE_TOOLTIP;
    }

    public Image getTitleImage() {
        return null;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean canEdit(Object modelObject, IEditorPart editor) {
        return modelObject instanceof InputSet || modelObject instanceof InputParameter;
    }

    public void edit(Object input) {
        InputSet parent;
        if (input instanceof InputSet) {
            this.setMappingAdapters((InputSet)input);
            this.currentMappingClass = ((InputSet)input).getMappingClass();
            this.isoInputSetObject = new InputSetAdapter(this.currentMappingClass);
            this.ispInputSetPanel.setBusinessObject(this.isoInputSetObject);
        } else if (input instanceof InputParameter && (parent = ((InputParameter)input).getInputSet()) != null) {
            this.setMappingAdapters(parent);
            this.currentMappingClass = parent.getMappingClass();
            this.isoInputSetObject = new InputSetAdapter(this.currentMappingClass);
            this.ispInputSetPanel.setBusinessObject(this.isoInputSetObject);
        }
    }

    public String getObjectText() {
        return StatusBarUpdater.formatEObjectMessage((EObject)this.currentMappingClass);
    }

    public boolean deactivate() {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this);
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void notifyChanged(Notification notification) {
        boolean doUpdate = false;
        if (notification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            Iterator iter = notifications.iterator();
            Notification nextNotification = null;
            while (iter.hasNext()) {
                nextNotification = (Notification)iter.next();
                if (!this.shouldProcessNotification(nextNotification)) continue;
                doUpdate = true;
            }
        } else if (this.shouldProcessNotification(notification)) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.update();
        }
    }

    private void update() {
        if (!this.ispInputSetPanel.isDisposed() && this.ispInputSetPanel.isVisible()) {
            this.isoInputSetObject.refreshFromMetadata();
            this.ispInputSetPanel.refreshFromBusinessObject();
        }
    }

    private boolean shouldProcessNotification(Notification notification) {
        boolean shouldProcess;
        block21: {
            EObject[] newChildren;
            EObject eObj;
            block22: {
                shouldProcess = false;
                if (notification == null || !NotificationUtilities.isEObjectNotifier((Notification)notification) || this.isoInputSetObject == null) break block21;
                eObj = NotificationUtilities.getEObject((Notification)notification);
                if (!(eObj instanceof InputParameter)) break block22;
                EObject parent = eObj.eContainer();
                InputSet iSet = this.isoInputSetObject.getInputSet();
                if (parent == null || !parent.equals(iSet)) break block21;
                shouldProcess = true;
                break block21;
            }
            if (eObj instanceof InputSet) {
                InputSet iSet = this.isoInputSetObject.getInputSet();
                if (eObj.equals(iSet)) {
                    EObject[] removedChildren;
                    if (NotificationUtilities.isAdded((Notification)notification)) {
                        EObject[] newChildren2 = NotificationUtilities.getAddedChildren((Notification)notification);
                        if (newChildren2 != null) {
                            int nChildren = newChildren2.length;
                            int i = 0;
                            while (i < nChildren) {
                                EObject child = newChildren2[i];
                                if (child != null && child instanceof InputParameter) {
                                    InputParameter iParm = (InputParameter)child;
                                    BindingList list = this.isoInputSetObject.getBindingList();
                                    if (!list.contains(iParm)) {
                                        list.add(new BindingAdapter(iParm));
                                    }
                                }
                                ++i;
                            }
                        }
                    } else if (NotificationUtilities.isRemoved((Notification)notification) && (removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification)) != null) {
                        int nChildren = removedChildren.length;
                        int i = 0;
                        while (i < nChildren) {
                            EObject child = removedChildren[i];
                            if (child != null && child instanceof InputParameter) {
                                InputParameter iParm = (InputParameter)child;
                                BindingList list = this.isoInputSetObject.getBindingList();
                                BindingAdapter adapter = list.getBindingFor(iParm);
                                if (adapter != null) {
                                    list.remove(adapter);
                                }
                            }
                            ++i;
                        }
                    }
                    shouldProcess = true;
                }
            } else if (eObj instanceof MappingClassColumn) {
                BindingList bList = this.isoInputSetObject.getBindingList();
                int nBindings = bList.size();
                int i = 0;
                while (i < nBindings) {
                    BindingAdapter adapter = bList.get(i);
                    Object mappingObj = adapter.getMapping();
                    if (mappingObj != null && mappingObj instanceof MappingClassColumn && mappingObj.equals(eObj)) {
                        shouldProcess = true;
                        break;
                    }
                    ++i;
                }
            } else if (eObj instanceof MappingClassSet && (newChildren = NotificationUtilities.getAddedChildren((Notification)notification)).length > 0) {
                int i = 0;
                while (i < newChildren.length) {
                    InputBinding binding;
                    InputParameter newInputParameter;
                    if (newChildren[i] instanceof InputBinding && (newInputParameter = (binding = (InputBinding)newChildren[i]).getInputParameter()) != null) {
                        BindingList list;
                        InputSet inputSet = newInputParameter.getInputSet();
                        InputSet iSet = this.isoInputSetObject.getInputSet();
                        if (inputSet != null && inputSet.equals(iSet) && !(list = this.isoInputSetObject.getBindingList()).contains(newInputParameter)) {
                            BindingAdapter newAdapter = new BindingAdapter(binding);
                            list.add(newAdapter);
                        }
                    }
                    ++i;
                }
            }
        }
        return shouldProcess;
    }

    public void contributeExportedActions(IMenuManager menu) {
        if (menu == null) {
            return;
        }
    }

    public List<IAction> getAdditionalModelingActions(ISelection selection) {
        return Collections.EMPTY_LIST;
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        if (toolBarMgr == null) {
            return;
        }
    }

    public void doSave(boolean isClosing) {
        this.deactivate();
    }

    public void updateReadOnlyState() {
    }

    public boolean isEditingObject(Object modelObject) {
        EObject parent;
        return this.inputSet != null && modelObject != null && modelObject instanceof InputSet ? modelObject.equals(this.inputSet) : this.inputSet != null && modelObject != null && modelObject instanceof InputParameter && (parent = ((EObject)modelObject).eContainer()) != null && parent.equals(this.inputSet);
    }

    public Object getEditableObject(Object modelObject) {
        InputSet parent;
        if (modelObject instanceof InputSet) {
            return modelObject;
        }
        if (modelObject instanceof InputParameter && (parent = ((InputParameter)modelObject).getInputSet()) != null) {
            return parent;
        }
        return null;
    }

    public boolean isResourceValid() {
        ModelResource mr;
        return this.inputSet != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)this.inputSet)) != null;
    }

    public void initialize(MultiPageModelEditor editor) {
        if (editor instanceof ModelEditor) {
            this.parentModelEditor = (ModelEditor)editor;
        }
    }

    public void setOverride(ModelObjectEditorPage editor) {
    }

    public ModelEditor getParentModelEditor() {
        return this.parentModelEditor;
    }
}

