/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class FindXsdComponentAction
extends MappingAction {
    public FindXsdComponentAction() {
        this.setUseWaitCursor(false);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_find_xsd_component.gif"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        EObject xsdComponent;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && ModelMapperFactory.isXmlTreeNode((EObject)eObject) && (xsdComponent = ModelMapperFactory.getXsdComponent((EObject)eObject)) != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        StructuredSelection selection = new StructuredSelection((Object)xsdComponent);
                        String viewId = ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId();
                        IViewPart view = UiUtil.getWorkbenchPage().showView(viewId);
                        ISelectionProvider selProvider = view.getViewSite().getSelectionProvider();
                        if (selProvider != null) {
                            if (selProvider instanceof TreeViewer) {
                                FindXsdComponentAction.this.showEObject((TreeViewer)selProvider, xsdComponent);
                            }
                            selProvider.setSelection((ISelection)selection);
                        }
                    }
                    catch (PartInitException err) {
                        UiConstants.Util.log((Throwable)err);
                        WidgetUtil.showError((String)err.getLocalizedMessage());
                    }
                }
            });
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && ModelMapperFactory.isXmlTreeNode((EObject)eObject)) {
            enable = true;
        }
        this.setEnabled(enable);
    }

    public List getModelExplorerAncestors(EObject node, boolean oldestFirst) {
        ArrayList<Object> rv = new ArrayList<Object>();
        EObject parentNode = node.eContainer();
        while (parentNode != null) {
            rv.add(parentNode);
            parentNode = parentNode.eContainer();
        }
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)node);
        IResource res = mr.getResource();
        rv.add(res);
        IContainer parentRes = res.getParent();
        while (parentRes != null) {
            rv.add(parentRes);
            parentRes = parentRes.getParent();
        }
        if (oldestFirst) {
            Collections.reverse(rv);
        }
        return rv;
    }

    public void showEObject(TreeViewer viewer, EObject nodeToShow) {
        List l = this.getModelExplorerAncestors(nodeToShow, true);
        for (Object parentNode : l) {
            viewer.setExpandedState(parentNode, true);
        }
    }
}

