/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.designer.metadata.runtime.api.MetadataSource;

public class MetadataSourceUtil {
    public static String getFileContentAsString(String path, MetadataSource iss) throws TeiidDesignerException {
        File f = iss.getFile(path);
        if (f == null) {
            return null;
        }
        try {
            return FileUtil.readSafe((File)f);
        }
        catch (IOException e) {
            throw new TeiidDesignerException((Throwable)e, "MetadataSourceUtil.ioExceptionConvertingFileToString");
        }
    }

    public static InputStream getFileContent(String path, MetadataSource iss, String[] tokens, String[] tokenReplacements) throws TeiidDesignerException {
        CoreArgCheck.isNotNull((Object)tokens);
        CoreArgCheck.isNotNull((Object)tokenReplacements);
        CoreArgCheck.isEqual((int)tokens.length, (int)tokenReplacements.length);
        String fileContents = MetadataSourceUtil.getFileContentAsString(path, iss);
        if (fileContents != null) {
            int i = 0;
            while (i < tokens.length) {
                String token = tokens[i];
                String tokenReplacement = tokenReplacements[i];
                fileContents = CoreStringUtil.replaceAll((String)fileContents, (String)token, (String)tokenReplacement);
                ++i;
            }
            return new ByteArrayInputStream(fileContents.getBytes());
        }
        return null;
    }
}

