/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class MetadataConstants {
    public static final long NOT_DEFINED_LONG = Long.MIN_VALUE;
    public static final int NOT_DEFINED_INT = Integer.MIN_VALUE;
    public static final short NOT_DEFINED_SHORT = Short.MIN_VALUE;
    public static final String BLANK = "";
    public static final String VERSION_DATE = "versionDate";
    static final String[] MATCH_TYPE_NAMES = new String[]{"Full", "Partial", "Neither", "N/A"};
    static final String[] KEY_TYPE_NAMES = new String[]{"Primary", "Foreign", "Unique", "NonUnique", "AccessPattern", "Index"};
    static final String[] PROCEDURE_TYPE_NAMES = new String[]{"Function", "StoredProc", "StoredQuery"};
    static final String[] QUERY_PLAN_TYPE_NAMES = new String[]{"MappingDefn", "QueryPlanGroup", "QueryPlanStoredQuery", "QueryPlanInsertQuery", "QueryPlanUpdateQuery", "QueryPlanDeleteQuery"};
    static final String[] PARAMETER_TYPE_NAMES = new String[]{"In", "Out", "InOut", "ReturnValue", "ResultSet"};
    static final String[] SEARCH_TYPE_NAMES = new String[]{"Searchable", "All Except Like", "Like Only", "Unsearchable"};
    static final String[] DATATYPE_TYPE_NAMES = new String[]{"Basic", "UserDefined", "ResultSet"};
    static final String[] TABLE_TYPE_NAMES = new String[]{"Table", "SystemTable", "View", "Document", "MappingClass", "XmlTempTable"};
    static final String[] NULL_TYPE_NAMES = new String[]{"Not Nullable", "Nullable", "Unknown"};
    public static final String[] VISIBILITY_TYPE_NAMES = new String[]{"Public", "Private"};

    public static final String getMatchTypeName(short type) {
        return MATCH_TYPE_NAMES[type - 1];
    }

    public static final String getKeyTypeName(short type) {
        return KEY_TYPE_NAMES[type - 1];
    }

    public static final String getProcedureTypeName(short type) {
        return PROCEDURE_TYPE_NAMES[type - 1];
    }

    public static short getProcType(String typeName) {
        if ("Function".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("StoredProc".equalsIgnoreCase(typeName) || "StoredProcedure".equalsIgnoreCase(typeName)) {
            return 2;
        }
        if ("StoredQuery".equalsIgnoreCase(typeName)) {
            return 3;
        }
        return Short.MIN_VALUE;
    }

    public static final String getQueryPlanTypeName(short type) {
        return QUERY_PLAN_TYPE_NAMES[type];
    }

    public static short getQueryPlanType(String typeName) {
        if ("MappingDefn".equalsIgnoreCase(typeName)) {
            return 0;
        }
        if ("QueryPlanGroup".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("QueryPlanStoredQuery".equalsIgnoreCase(typeName)) {
            return 2;
        }
        return Short.MIN_VALUE;
    }

    public static final String getParameterTypeName(short type) {
        return PARAMETER_TYPE_NAMES[type - 1];
    }

    public static short getParameterType(String typeName) {
        if ("In".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("Out".equalsIgnoreCase(typeName)) {
            return 2;
        }
        if ("InOut".equalsIgnoreCase(typeName)) {
            return 3;
        }
        if ("ReturnValue".equalsIgnoreCase(typeName) || "Return".equalsIgnoreCase(typeName)) {
            return 4;
        }
        if ("ResultSet".equalsIgnoreCase(typeName)) {
            return 5;
        }
        return Short.MIN_VALUE;
    }

    public static final String getSearchTypeName(short type) {
        return SEARCH_TYPE_NAMES[type - 1];
    }

    public static final short getSearchType(String typeName) {
        if ("Searchable".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("All Except Like".equalsIgnoreCase(typeName)) {
            return 2;
        }
        if ("Like Only".equalsIgnoreCase(typeName)) {
            return 3;
        }
        if ("Unsearchable".equalsIgnoreCase(typeName)) {
            return 4;
        }
        return Short.MIN_VALUE;
    }

    public static final String getDataTypeTypeName(short type) {
        return DATATYPE_TYPE_NAMES[type - 1];
    }

    public static short getDataTypeType(String typeName) {
        if ("Basic".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("UserDefined".equalsIgnoreCase(typeName)) {
            return 2;
        }
        if ("ResultSet".equalsIgnoreCase(typeName)) {
            return 3;
        }
        return Short.MIN_VALUE;
    }

    public static final String getTableTypeName(short type) {
        return TABLE_TYPE_NAMES[type - 1];
    }

    public static final String getNullTypeName(short type) {
        return NULL_TYPE_NAMES[type - 1];
    }

    public static short getNullType(String typeName) {
        if ("Not Nullable".equalsIgnoreCase(typeName)) {
            return 1;
        }
        if ("Nullable".equalsIgnoreCase(typeName)) {
            return 2;
        }
        if ("Unknown".equalsIgnoreCase(typeName)) {
            return 3;
        }
        return Short.MIN_VALUE;
    }

    public static final String getVisibilityTypeName(short type) {
        if (type == 0) {
            return VISIBILITY_TYPE_NAMES[0];
        }
        if (type == 2) {
            return VISIBILITY_TYPE_NAMES[1];
        }
        return null;
    }

    public static final short getVisibilityType(String typeName) {
        if ("Public".equalsIgnoreCase(typeName)) {
            return 0;
        }
        if ("Private".equalsIgnoreCase(typeName)) {
            return 2;
        }
        return Short.MIN_VALUE;
    }

    public static final class CAPABILITY_PROPERTY_NAMES {
        public static final String PROP_BLACK_BOX = "supportsBlackBoxJoin";
        public static final String PROP_SINGLE_GROUP_SELECT = "requiresSingleGroupSelect";
        public static final String PROP_LEAF_JOIN_SELECT = "requiresLeafJoinSelect";
    }

    public static final class DATATYPE_TYPES {
        public static final short BASIC = 1;
        public static final short USER_DEFINED = 2;
        public static final short RESULT_SET = 3;
    }

    public static final class KEY_TYPES {
        public static final short PRIMARY_KEY = 1;
        public static final short FOREIGN_KEY = 2;
        public static final short UNIQUE_KEY = 3;
        public static final short NON_UNIQUE_KEY = 4;
        public static final short ACCESS_PATTERN = 5;
        public static final short INDEX = 6;
    }

    public static final class MATCH_TYPES {
        public static final short FULL_MATCH = 1;
        public static final short PARTIAL_MATCH = 2;
        public static final short NEITHER_MATCH = 3;
        public static final short NA = 4;
    }

    public static final class NULL_TYPES {
        public static final short NOT_NULL = 1;
        public static final short NULLABLE = 2;
        public static final short UNKNOWN = 3;
    }

    public static final class PARAMETER_TYPES {
        public static final short IN_PARM = 1;
        public static final short OUT_PARM = 2;
        public static final short INOUT_PARM = 3;
        public static final short RETURN_VALUE = 4;
        public static final short RESULT_SET = 5;
    }

    public static final class PROCEDURE_TYPES {
        public static final short FUNCTION = 1;
        public static final short STORED_PROCEDURE = 2;
        public static final short STORED_QUERY = 3;
    }

    public static final class QUERY_PLAN_TYPES {
        public static final short MAPPING_DEFN = 0;
        public static final short QUERY_PLAN_GROUP = 1;
        public static final short QUERY_PLAN_STORED_QUERY = 2;
        public static final short QUERY_PLAN_INSERT_QUERY = 3;
        public static final short QUERY_PLAN_UPDATE_QUERY = 4;
        public static final short QUERY_PLAN_DELETE_QUERY = 5;
    }

    public static final class QUERY_TYPES {
        public static final int SELECT_QUERY = 0;
        public static final int UPDATE_QUERY = 1;
        public static final int INSERT_QUERY = 2;
        public static final int DELETE_QUERY = 3;
        public static final int[] TYPES;
        public static final String[] TYPE_NAMES;

        static {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            TYPES = nArray;
            TYPE_NAMES = new String[]{"SelectQuery", "UpdateQuery", "InsertQuery", "DeleteQuery"};
        }
    }

    public static final class SEARCH_TYPES {
        public static final short SEARCHABLE = 1;
        public static final short ALLEXCEPTLIKE = 2;
        public static final short LIKE_ONLY = 3;
        public static final short UNSEARCHABLE = 4;
    }

    public static final class SIMPLE_TYPES {
        public static final String[] DATA_TYPE_FACETS_NAMES = new String[]{"equal", "ordered", "bounded", "cardinality", "numeric", "length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace", "maxInclusive", "minInclusive", "maxExclusive", "minExclusive", "totalDigits", "fractionDigits"};
        public static final String[] WHITE_SPACE_TYPE_NAMES = new String[]{"preserve", "replace", "collapse"};
        public static final String[] VARIETY_TYPE_NAMES = new String[]{"atomic", "list", "union"};
        public static final String[] FINAL_TYPE_NAMES = new String[]{"restriction", "list", "union"};

        public static final String getDataTypeFacetName(short facetType) {
            if (facetType < 1 || facetType > DATA_TYPE_FACETS_NAMES.length) {
                return null;
            }
            return DATA_TYPE_FACETS_NAMES[facetType - 1];
        }

        public static final short getDataTypeFacet(String facetName) {
            if (DATA_TYPE_FACETS_NAMES[0].equalsIgnoreCase(facetName)) {
                return 1;
            }
            if (DATA_TYPE_FACETS_NAMES[1].equalsIgnoreCase(facetName)) {
                return 2;
            }
            if (DATA_TYPE_FACETS_NAMES[2].equalsIgnoreCase(facetName)) {
                return 3;
            }
            if (DATA_TYPE_FACETS_NAMES[3].equalsIgnoreCase(facetName)) {
                return 4;
            }
            if (DATA_TYPE_FACETS_NAMES[4].equalsIgnoreCase(facetName)) {
                return 5;
            }
            if (DATA_TYPE_FACETS_NAMES[5].equalsIgnoreCase(facetName)) {
                return 6;
            }
            if (DATA_TYPE_FACETS_NAMES[6].equalsIgnoreCase(facetName)) {
                return 7;
            }
            if (DATA_TYPE_FACETS_NAMES[7].equalsIgnoreCase(facetName)) {
                return 8;
            }
            if (DATA_TYPE_FACETS_NAMES[8].equalsIgnoreCase(facetName)) {
                return 9;
            }
            if (DATA_TYPE_FACETS_NAMES[9].equalsIgnoreCase(facetName)) {
                return 10;
            }
            if (DATA_TYPE_FACETS_NAMES[10].equalsIgnoreCase(facetName)) {
                return 11;
            }
            if (DATA_TYPE_FACETS_NAMES[11].equalsIgnoreCase(facetName)) {
                return 12;
            }
            if (DATA_TYPE_FACETS_NAMES[512].equalsIgnoreCase(facetName)) {
                return 13;
            }
            if (DATA_TYPE_FACETS_NAMES[13].equalsIgnoreCase(facetName)) {
                return 14;
            }
            if (DATA_TYPE_FACETS_NAMES[14].equalsIgnoreCase(facetName)) {
                return 15;
            }
            if (DATA_TYPE_FACETS_NAMES[15].equalsIgnoreCase(facetName)) {
                return 16;
            }
            if (DATA_TYPE_FACETS_NAMES[16].equalsIgnoreCase(facetName)) {
                return 17;
            }
            return Short.MIN_VALUE;
        }

        public static final String getWhiteSapceTypeName(short type) {
            if (type < 1 || type > WHITE_SPACE_TYPE_NAMES.length) {
                return null;
            }
            return WHITE_SPACE_TYPE_NAMES[type - 1];
        }

        public static final short getWhiteSapceType(String typeName) {
            if ("preserve".equalsIgnoreCase(typeName)) {
                return 1;
            }
            if ("replace".equalsIgnoreCase(typeName)) {
                return 2;
            }
            if ("collapse".equalsIgnoreCase(typeName)) {
                return 3;
            }
            return Short.MIN_VALUE;
        }

        public static final String getVarietyTypeName(short type) {
            if (type < 1 || type > VARIETY_TYPE_NAMES.length) {
                return null;
            }
            return VARIETY_TYPE_NAMES[type - 1];
        }

        public static final short getVarietyType(String typeName) {
            if ("atomic".equalsIgnoreCase(typeName)) {
                return 1;
            }
            if ("list".equalsIgnoreCase(typeName)) {
                return 2;
            }
            if ("union".equalsIgnoreCase(typeName)) {
                return 3;
            }
            return Short.MIN_VALUE;
        }

        public static final Collection getFinalTypeNames(short type) {
            if (type < 1 || type > 7) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> result = new HashSet<String>(3);
            if ((type & 1) == 1) {
                result.add(FINAL_TYPE_NAMES[0]);
            }
            if ((type & 2) == 2) {
                result.add(FINAL_TYPE_NAMES[1]);
            }
            if ((type & 4) == 4) {
                result.add(FINAL_TYPE_NAMES[2]);
            }
            return result;
        }

        public static final short getFinalType(Collection typeNames) {
            if (typeNames == null || typeNames.isEmpty()) {
                return Short.MIN_VALUE;
            }
            short result = 0;
            for (String typeName : typeNames) {
                if ("restriction".equalsIgnoreCase(typeName)) {
                    result = (short)(result | 1);
                    continue;
                }
                if ("list".equalsIgnoreCase(typeName)) {
                    result = (short)(result | 2);
                    continue;
                }
                if (!"union".equalsIgnoreCase(typeName)) continue;
                result = (short)(result | 4);
            }
            return result;
        }

        public static final class DATA_TYPE_FACETS {

            public static final class CONSTRAINING {
                public static final short LENGTH = 6;
                public static final short MIN_LENGTH = 7;
                public static final short MAX_LENGTH = 8;
                public static final short PATTERN = 9;
                public static final short ENUMERATION = 10;
                public static final short WHITE_SPACE = 11;
                public static final short MAX_INCLUSIVE = 12;
                public static final short MIN_INCLUSIVE = 13;
                public static final short MAX_EXCLUSIVE = 14;
                public static final short MIN_EXCLUSIVE = 15;
                public static final short TOTAL_DIGITS = 16;
                public static final short FRACTION_DIGITS = 17;
            }

            public static final class FUNDAMENTAL {
                public static final short EQUAL = 1;
                public static final short ORDERED = 2;
                public static final short BOUNDED = 3;
                public static final short CARDINALITY = 4;
                public static final short NUMERIC = 5;
            }
        }

        public static final class FINAL_TYPES {
            public static final short RESTRICTION = 1;
            public static final short LIST = 2;
            public static final short UNION = 4;
            public static final short RESTRICTION_AND_LIST = 3;
            public static final short RESTRICTION_AND_UNION = 5;
            public static final short LIST_AND_UNION = 6;
            public static final short RESTRICTION_AND_LISTAND_UNION = 7;
        }

        public static final class VARIETY_TYPES {
            public static final short ATOMIC = 1;
            public static final short LIST = 2;
            public static final short UNION = 3;
        }

        public static final class WHITE_SPACE_TYPES {
            public static final short PRESERVE = 1;
            public static final short REPLACE = 2;
            public static final short COLLAPSE = 3;
        }
    }

    public static final class TABLE_TYPES {
        public static final short TABLE_TYPE = 1;
        public static final short SYSTEM_TYPE = 2;
        public static final short VIEW_TYPE = 3;
        public static final short DOCUMENT_TYPE = 4;
        public static final short MAPPING_CLASS_TYPE = 5;
        public static final short XML_TEMP_TABLE_TYPE = 6;
        public static final short SYSTEM_DOCUMENT_TYPE = 7;
    }

    public static final class VISIBILITY_TYPES {
        public static final short PUBLIC_VISIBILITY = 0;
        public static final short PRIVATE_VISIBILITY = 2;
    }
}

