/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.teiid.core.designer.util.CharOperation;
import org.teiid.core.designer.util.LRUCache;
import org.teiid.designer.core.index.Block;
import org.teiid.designer.core.index.EntryResult;
import org.teiid.designer.core.index.FileListBlock;
import org.teiid.designer.core.index.GammaCompressedIndexBlock;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IQueryResult;
import org.teiid.designer.core.index.IndexBlock;
import org.teiid.designer.core.index.IndexInput;
import org.teiid.designer.core.index.IndexSummary;
import org.teiid.designer.core.index.IndexedFile;
import org.teiid.designer.core.index.SafeRandomAccessFile;
import org.teiid.designer.core.index.Util;
import org.teiid.designer.core.index.WordEntry;

public class BlocksIndexInput
extends IndexInput {
    public static final int CACHE_SIZE = 16;
    protected FileListBlock currentFileListBlock;
    protected int currentFileListBlockNum;
    protected int currentIndexBlockNum;
    protected IndexBlock currentIndexBlock;
    private RandomAccessFile raf;
    protected File indexFile;
    protected LRUCache blockCache;
    protected IndexSummary summary;

    public BlocksIndexInput(File inputFile) {
        this.indexFile = inputFile;
        this.blockCache = new LRUCache(16);
    }

    @Override
    public void clearCache() {
        this.blockCache = new LRUCache(16);
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.summary = null;
            this.setOpen(false);
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    @Override
    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        IndexedFile file = null;
        file = this.currentFileListBlock.getFile(this.filePosition);
        if (file == null) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(this.filePosition);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
            file = this.currentFileListBlock.getFile(this.filePosition);
        }
        return file;
    }

    protected WordEntry getEntry(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return null;
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        return block.findExactEntry(word);
    }

    protected FileListBlock getFileListBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get((Object)key);
        if (block != null && block instanceof FileListBlock) {
            return (FileListBlock)block;
        }
        FileListBlock fileListBlock = new FileListBlock(8192);
        fileListBlock.read(this.raf, blockNum);
        this.blockCache.put((Object)key, (Object)fileListBlock);
        return fileListBlock;
    }

    protected IndexBlock getIndexBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get((Object)key);
        if (block != null && block instanceof IndexBlock) {
            return (IndexBlock)block;
        }
        GammaCompressedIndexBlock indexBlock = new GammaCompressedIndexBlock(8192);
        indexBlock.read(this.raf, blockNum);
        this.blockCache.put((Object)key, (Object)indexBlock);
        return indexBlock;
    }

    @Override
    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        int blockNum = this.summary.getBlockNumForFileNum(fileNum);
        if (blockNum == -1) {
            return null;
        }
        FileListBlock block = this.getFileListBlock(blockNum);
        return block.getFile(fileNum);
    }

    @Override
    public IndexedFile getIndexedFile(IDocument document) throws IOException {
        this.setFirstFile();
        String name = document.getName();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            String path = file.getPath();
            if (path.equals(name)) {
                return file;
            }
            this.moveToNextFile();
        }
        return null;
    }

    protected int[] getMatchingFileNumbers(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return new int[0];
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        WordEntry entry = block.findExactEntry(word);
        return entry == null ? new int[]{} : entry.getRefs();
    }

    @Override
    public int getNumFiles() {
        return this.summary.getNumFiles();
    }

    @Override
    public int getNumWords() {
        return this.summary.getNumWords();
    }

    @Override
    public Object getSource() {
        return this.indexFile;
    }

    protected void init() throws IOException {
        this.clearCache();
        this.setFirstFile();
        this.setFirstWord();
    }

    @Override
    public void moveToNextFile() {
        ++this.filePosition;
    }

    @Override
    public void moveToNextWordEntry() throws IOException {
        boolean endOfBlock;
        ++this.wordPosition;
        if (!this.hasMoreWords()) {
            return;
        }
        boolean bl = endOfBlock = !this.currentIndexBlock.nextEntry(this.currentWordEntry);
        if (endOfBlock) {
            this.currentIndexBlock = this.getIndexBlock(++this.currentIndexBlockNum);
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    @Override
    public void open() throws IOException {
        if (!this.isOpen()) {
            this.raf = new SafeRandomAccessFile(this.indexFile, "r");
            String sig = this.raf.readUTF();
            if (!sig.equals("INDEX FILE 0.012")) {
                throw new IOException(Util.bind("exception.wrongFormat"));
            }
            int summaryBlockNum = this.raf.readInt();
            this.raf.seek((long)summaryBlockNum * 8192L);
            this.summary = new IndexSummary();
            this.summary.read(this.raf);
            this.init();
            this.setOpen(true);
        }
    }

    public IQueryResult[] query(String word) throws IOException {
        this.open();
        int[] fileNums = this.getMatchingFileNumbers(word.toCharArray());
        int size = fileNums.length;
        IQueryResult[] files = new IQueryResult[size];
        int i = 0;
        while (i < size) {
            files[i] = this.getIndexedFile(fileNums[i]);
            ++i;
        }
        return files;
    }

    public IEntryResult[] queryEntriesMatching(char[] pattern, boolean isCaseSensitive) throws IOException {
        this.open();
        if (pattern == null || pattern.length == 0) {
            return null;
        }
        int[] blockNums = null;
        int firstStar = BlocksIndexInput.indexOf('*', pattern);
        switch (firstStar) {
            case -1: {
                WordEntry entry = this.getEntry(pattern);
                if (entry == null) {
                    return null;
                }
                return new IEntryResult[]{new EntryResult(entry.getWord(), entry.getRefs())};
            }
            case 0: {
                blockNums = this.summary.getAllBlockNums();
                break;
            }
            default: {
                char[] prefix = new char[firstStar];
                System.arraycopy(pattern, 0, prefix, 0, firstStar);
                blockNums = this.summary.getBlockNumsForPrefix(prefix);
            }
        }
        if (blockNums == null || blockNums.length == 0) {
            return null;
        }
        IEntryResult[] entries = new IEntryResult[5];
        int count = 0;
        int i = 0;
        int max = blockNums.length;
        while (i < max) {
            IndexBlock block = this.getIndexBlock(blockNums[i]);
            block.reset();
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (!CharOperation.match((char[])pattern, (char[])entry.getWord(), (boolean)isCaseSensitive)) continue;
                if (count == entries.length) {
                    IEntryResult[] iEntryResultArray = entries;
                    entries = new IEntryResult[count * 2];
                    System.arraycopy(iEntryResultArray, 0, entries, 0, count);
                }
                entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
            }
            ++i;
        }
        if (count != entries.length) {
            IEntryResult[] iEntryResultArray = entries;
            entries = new IEntryResult[count];
            System.arraycopy(iEntryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        IEntryResult[] entries = new IEntryResult[5];
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals((char[])prefix, (char[])entry.getWord(), (boolean)true)) {
                    if (count == entries.length) {
                        IEntryResult[] iEntryResultArray = entries;
                        entries = new IEntryResult[count * 2];
                        System.arraycopy(iEntryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        if (count == 0) {
            return null;
        }
        if (count != entries.length) {
            IEntryResult[] iEntryResultArray = entries;
            entries = new IEntryResult[count];
            System.arraycopy(iEntryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix, boolean isCaseSensitive) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        IEntryResult[] entries = new IEntryResult[5];
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals((char[])prefix, (char[])entry.getWord(), (boolean)isCaseSensitive)) {
                    if (count == entries.length) {
                        IEntryResult[] iEntryResultArray = entries;
                        entries = new IEntryResult[count * 2];
                        System.arraycopy(iEntryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        if (count == 0) {
            return null;
        }
        if (count != entries.length) {
            IEntryResult[] iEntryResultArray = entries;
            entries = new IEntryResult[count];
            System.arraycopy(iEntryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    @Override
    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        HashMap<Integer, IndexedFile> fileMatches = new HashMap<Integer, IndexedFile>();
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals((char[])prefix, (char[])entry.getWord(), (boolean)true)) {
                    int[] refs = entry.getRefs();
                    int i = 0;
                    int max = refs.length;
                    while (i < max) {
                        int ref = refs[i];
                        Integer key = ref;
                        if (!fileMatches.containsKey(key)) {
                            ++count;
                            fileMatches.put(key, this.getIndexedFile(ref));
                        }
                        ++i;
                    }
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        IQueryResult[] files = fileMatches.values().toArray(new IQueryResult[count]);
        return files;
    }

    @Override
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        this.open();
        ArrayList<IndexedFile> matches = new ArrayList<IndexedFile>();
        this.setFirstFile();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file);
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    @Override
    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.getNumFiles() > 0) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(1);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
        }
    }

    @Override
    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.getNumWords() > 0) {
            this.currentIndexBlockNum = this.summary.getFirstWordBlockNum();
            this.currentIndexBlock = this.getIndexBlock(this.currentIndexBlockNum);
            this.currentWordEntry = new WordEntry();
            this.currentIndexBlock.reset();
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }
}

