/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xsd;

import org.teiid.designer.common.xsd.XsdHeader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminatingXsdHeaderContentHandler
extends DefaultHandler {
    public static final String SCHEMA_NOT_FOUND_EXCEPTION_MESSAGE = "SchemaNotFoundException";
    public static final String SCHEMA_FOUND_EXCEPTION_MESSAGE = "SchemaFoundException";
    private static final String SCHEMA_TAG_NAME = "schema";
    private static final String IMPORT_TAG_NAME = "import";
    private static final String INCLUDE_TAG_NAME = "include";
    private static final String TARGET_NAMESPACE_ATTRIBUTE_NAME = "targetNamespace";
    private static final String NAMESPACE_ATTRIBUTE_NAME = "namespace";
    private static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "schemaLocation";
    private static final String ELEMENT_TAG_NAME = "element";
    private static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    private static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    private static final String GROUP_TAG_NAME = "group";
    private static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    private static final String NOTATION_TAG_NAME = "notation";
    private boolean foundSchemaStartElement = false;
    private boolean foundTerminatingTag = false;
    private XsdHeader header;

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getXsdHeader().addNamespaceURI(uri);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (SCHEMA_TAG_NAME.equals(localName)) {
            this.processAttributes(atts);
            this.foundSchemaStartElement = true;
        } else if (IMPORT_TAG_NAME.equals(localName)) {
            this.processImportAttributes(atts);
        } else if (INCLUDE_TAG_NAME.equals(localName)) {
            this.processIncludeAttributes(atts);
        } else if (ELEMENT_TAG_NAME.equals(localName) || SIMPLE_TYPE_TAG_NAME.equals(localName) || COMPLEX_TYPE_TAG_NAME.equals(localName) || GROUP_TAG_NAME.equals(localName) || ATTRIBUTE_GROUP_TAG_NAME.equals(localName) || ATTRIBUTE_TAG_NAME.equals(localName) || NOTATION_TAG_NAME.equals(localName)) {
            this.foundTerminatingTag = true;
        }
        this.checkForCompletion();
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkForCompletion();
        super.endElement(namespaceURI, localName, qName);
    }

    public XsdHeader getXsdHeader() {
        if (this.header == null) {
            this.header = new XsdHeader();
        }
        return this.header;
    }

    private void checkForCompletion() throws SAXException {
        if (!this.foundSchemaStartElement) {
            throw new SAXException(SCHEMA_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundTerminatingTag) {
            throw new SAXException(SCHEMA_FOUND_EXCEPTION_MESSAGE);
        }
    }

    private void processAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (TARGET_NAMESPACE_ATTRIBUTE_NAME.equals(name)) {
                this.getXsdHeader().setTargetNamespaceURI(value);
            }
            ++i;
        }
    }

    private void processImportAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (NAMESPACE_ATTRIBUTE_NAME.equals(name)) {
                this.getXsdHeader().addImportNamespaceURI(value);
            } else if (SCHEMA_LOCATION_ATTRIBUTE_NAME.equals(name)) {
                this.getXsdHeader().addImportSchemaLocation(value);
            }
            ++i;
        }
    }

    private void processIncludeAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (SCHEMA_LOCATION_ATTRIBUTE_NAME.equals(name)) {
                this.getXsdHeader().addIncludeSchemaLocation(value);
            }
            ++i;
        }
    }
}

