/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.metamodels.diagram.AbstractDiagramEntity;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class DiagramEntityManager {
    private static HashMap diagramMap;
    private static final String MMUUID = "mmuuid";
    private static boolean clearingStaleDiagrams;
    private static EventObjectListener eventObjectListener;
    private static ITeiidServerVersionListener teiidServerVersionListener;
    private static boolean debugPrint;

    static {
        clearingStaleDiagrams = false;
        debugPrint = false;
        eventObjectListener = new EventObjectListener(){

            public void processEvent(EventObject event) {
                DiagramEntityManager.processEvent(event);
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, eventObjectListener);
        }
        catch (EventSourceException e) {
            DiagramUiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        teiidServerVersionListener = new ITeiidServerVersionListener(){

            public void serverChanged(ITeiidServer server) {
            }

            public void versionChanged(ITeiidServerVersion version) {
                if (diagramMap != null) {
                    diagramMap.clear();
                }
            }
        };
        ModelerCore.addTeiidServerVersionListener((ITeiidServerVersionListener)teiidServerVersionListener);
    }

    public static void addDiagram(Diagram diagram) {
        String diagramUuid;
        if (diagramMap == null) {
            diagramMap = new HashMap();
        }
        if ((diagramUuid = DiagramEntityManager.getDiagramURI(diagram)) != null && diagramMap.get(diagramUuid) == null) {
            HashMap<String, AbstractDiagramEntity> newMap = new HashMap<String, AbstractDiagramEntity>();
            EList diagramChildren = diagram.eContents();
            if (diagramChildren != null && !diagramChildren.isEmpty()) {
                AbstractDiagramEntity nextDE2 = null;
                String uuid = null;
                for (AbstractDiagramEntity nextDE2 : diagramChildren) {
                    EObject someDEMO = nextDE2.getModelObject();
                    if (someDEMO == null || !DiagramEntityManager.isValidURI(uuid = ModelObjectUtilities.getFullUuid((EObject)someDEMO))) continue;
                    if (debugPrint) {
                        System.out.println(" DEM.addEntity()  Adding Entity to Map.  EObject = " + nextDE2);
                    }
                    newMap.put(uuid, nextDE2);
                }
            }
            if (debugPrint) {
                System.out.println(" DEM.addDiagram()  Add Diagram To Map = " + diagram);
            }
            diagramMap.put(diagramUuid, newMap);
        }
    }

    public static void removeDiagram(Diagram diagram) {
        HashMap existingMap;
        String diagramUuid;
        if (diagramMap != null && (diagramUuid = DiagramEntityManager.getDiagramURI(diagram)) != null && (existingMap = (HashMap)diagramMap.get(diagramUuid)) != null) {
            diagramMap.remove(diagramUuid);
            if (debugPrint) {
                System.out.println(" DEM.removeDiagram()  Removing Diagram From Map = " + diagram);
            }
        }
    }

    public static void addEntity(Diagram diagram, AbstractDiagramEntity entity, EObject eObject) {
        Object existingDE;
        String uuid;
        HashMap dMap;
        String diagramUuid;
        if (diagramMap != null && (diagramUuid = DiagramEntityManager.getDiagramURI(diagram)) != null && (dMap = (HashMap)diagramMap.get(diagramUuid)) != null && DiagramEntityManager.isValidURI(uuid = ModelObjectUtilities.getFullUuid((EObject)eObject)) && (existingDE = dMap.get(uuid)) == null) {
            if (debugPrint) {
                System.out.println(" DEM.addEntity()  Adding Entity to Map.  EObject = " + eObject);
            }
            dMap.put(uuid, entity);
        }
    }

    public static void removeEntity(Diagram diagram, EObject eObject) {
        Object existingDE;
        String uuid;
        HashMap dMap;
        String diagramUuid;
        if (diagramMap != null && (diagramUuid = DiagramEntityManager.getDiagramURI(diagram)) != null && (dMap = (HashMap)diagramMap.get(diagramUuid)) != null && DiagramEntityManager.isValidURI(uuid = ModelObjectUtilities.getFullUuid((EObject)eObject)) && (existingDE = dMap.get(uuid)) != null) {
            if (debugPrint) {
                System.out.println(" DEM.removeEntity()  Removing Entity From Map.  EObject = " + eObject);
            }
            dMap.remove(uuid);
        }
    }

    public static AbstractDiagramEntity getEntity(Diagram diagram, EObject eObject) {
        String uuid;
        HashMap dMap;
        String diagramUuid;
        AbstractDiagramEntity existingDE = null;
        if (diagramMap != null && (diagramUuid = DiagramEntityManager.getDiagramURI(diagram)) != null && (dMap = (HashMap)diagramMap.get(diagramUuid)) != null && DiagramEntityManager.isValidURI(uuid = ModelObjectUtilities.getFullUuid((EObject)eObject))) {
            existingDE = (AbstractDiagramEntity)dMap.get(uuid);
        }
        return existingDE;
    }

    public static void cleanDiagramEntities(Diagram diagram) {
        String diagramUuid = DiagramEntityManager.getDiagramURI(diagram);
        if (diagramMap == null) {
            return;
        }
        HashMap dMap = (HashMap)diagramMap.get(diagramUuid);
        if (dMap != null) {
            ArrayList<AbstractDiagramEntity> deleteList = new ArrayList<AbstractDiagramEntity>();
            ArrayList keys = new ArrayList(dMap.keySet());
            Iterator iter = keys.iterator();
            AbstractDiagramEntity de = null;
            String nextKey = null;
            EObject someRef = null;
            while (iter.hasNext()) {
                nextKey = (String)iter.next();
                de = (AbstractDiagramEntity)dMap.get(nextKey);
                someRef = de.getModelObject();
                if (someRef != null && someRef instanceof EObject) {
                    EObject realEObject = ModelObjectUtilities.getRealEObject((EObject)someRef);
                    EObject resolvedEObject = DiagramEntityManager.getEObject(nextKey);
                    if (realEObject == null || resolvedEObject == null) {
                        dMap.remove(nextKey);
                        if (debugPrint) {
                            System.out.println(" DEM.cleanDiagramEntities()  Removing Stale Entity From Map.  EObject = " + someRef);
                        }
                        deleteList.add(de);
                        continue;
                    }
                    String currentUUID = ModelObjectUtilities.getFullUuid((EObject)realEObject);
                    if (currentUUID.equals(nextKey)) continue;
                    dMap.remove(nextKey);
                    if (debugPrint) {
                        System.out.println(" DEM.cleanDiagramEntities()  Removing Stale Entity From Map.  EObject = " + someRef);
                    }
                    deleteList.add(de);
                    continue;
                }
                dMap.remove(nextKey);
                deleteList.add(de);
            }
            if (!deleteList.isEmpty()) {
                ModelObjectUtilities.delete(deleteList, (boolean)false, (boolean)false, (Object)diagram);
            }
        }
    }

    public static void cleanUpDiagram(Diagram diagram) {
        if (diagram != null) {
            ArrayList<AbstractDiagramEntity> deleteList = new ArrayList<AbstractDiagramEntity>();
            Iterator iter = diagram.eContents().iterator();
            AbstractDiagramEntity de = null;
            EObject someRef = null;
            while (iter.hasNext()) {
                de = (AbstractDiagramEntity)iter.next();
                someRef = de.getModelObject();
                if (someRef != null && someRef instanceof EObject) {
                    EObject realEObject = ModelObjectUtilities.getRealEObject((EObject)someRef);
                    if (realEObject != null) continue;
                    deleteList.add(de);
                    continue;
                }
                deleteList.add(de);
            }
            if (!deleteList.isEmpty()) {
                ModelObjectUtilities.delete(deleteList, (boolean)false, (boolean)false, (Object)diagram, (boolean)false);
            }
        }
    }

    private static EObject getEObject(String uri) {
        URI theURI;
        EObject target = null;
        if (DiagramEntityManager.isValidURI(uri) && (theURI = URI.createURI((String)uri)) != null) {
            try {
                target = ModelerCore.getModelContainer().getEObject(theURI, false);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return target;
    }

    private static String getDiagramURI(Diagram diagram) {
        String diagramURI;
        if (diagram.eContainer() != null && DiagramEntityManager.isValidURI(diagramURI = ModelerCore.getModelEditor().getUri((EObject)diagram).toString())) {
            return diagramURI;
        }
        return null;
    }

    private static boolean isValidURI(String uri) {
        return uri != null && uri.length() > 6 && uri.indexOf(MMUUID) >= 0;
    }

    public static void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        int eventType = event.getType();
        IResource resource = event.getResource();
        if (resource != null) {
            switch (eventType) {
                case 3: 
                case 6: 
                case 8: 
                case 9: {
                    while (!clearingStaleDiagrams) {
                        DiagramEntityManager.clearStaleDiagrams();
                    }
                    clearingStaleDiagrams = false;
                    break;
                }
            }
        }
    }

    public static void clearStaleDiagrams() {
        clearingStaleDiagrams = true;
        if (diagramMap != null) {
            ArrayList staleKeys = new ArrayList();
            Object nextKey2 = null;
            for (Object nextKey2 : diagramMap.keySet()) {
                EObject eObj;
                if (nextKey2 == null || (eObj = DiagramEntityManager.getEObject((String)nextKey2)) != null && !eObj.eIsProxy() && eObj.eResource() != null) continue;
                if (debugPrint) {
                    System.out.println(" DEM.clearStaleDiagrams()  Removing Stale Diagram = " + nextKey2);
                }
                staleKeys.add(nextKey2);
            }
            if (!staleKeys.isEmpty()) {
                Iterator<Object> iter = staleKeys.iterator();
                while (iter.hasNext()) {
                    diagramMap.remove(iter.next());
                }
            }
        }
    }
}

