/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage.actions;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class RenameAction
extends DiagramAction
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RenameAction.class);
    private static final String RENAME_LABEL_ID = "renameLabel";
    private static final String DIALOG_TITLE = RenameAction.getString("dialogTitle");
    private DiagramEditor diagramEditor;
    String name;
    private EAttribute nameAttr;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    static String getString(String id, Object parameter) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, parameter);
    }

    @Override
    protected void doRun() {
        EditPart ep;
        List seps;
        EObject obj = (EObject)this.getSelectedObject();
        boolean wasRenamed = false;
        if (this.diagramEditor != null && (seps = this.diagramEditor.getDiagramViewer().getSelectedEditParts()) != null && !seps.isEmpty() && seps.size() == 1 && (ep = (EditPart)seps.get(0)) instanceof DirectEditPart && ((DiagramModelNode)ep.getModel()).getModelObject() == obj) {
            ((DirectEditPart)ep).performDirectEdit();
            wasRenamed = true;
        }
        if (!wasRenamed) {
            this.renameWithDialog();
        }
    }

    private void renameWithDialog() {
        EObject obj = (EObject)this.getSelectedObject();
        String existingName = ModelerCore.getModelEditor().getName(obj);
        if (existingName != null) {
            final String oldName = existingName;
            Dialog dlg = new Dialog(Display.getDefault().getActiveShell(), DIALOG_TITLE){

                protected Control createDialogArea(Composite parent) {
                    Composite dlgPanel = (Composite)super.createDialogArea(parent);
                    WidgetFactory.createLabel((Composite)dlgPanel, (String)RenameAction.getString(RenameAction.RENAME_LABEL_ID, oldName));
                    final Text nameText = WidgetFactory.createTextField((Composite)dlgPanel, (int)768, (String)oldName);
                    nameText.setSelection(0, oldName.length());
                    nameText.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent event) {
                            this.handleModifyText(nameText);
                        }
                    });
                    return dlgPanel;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    this.getButton(0).setEnabled(false);
                }

                void handleModifyText(Text nameText) {
                    String newName = nameText.getText();
                    boolean valid = newName.length() > 0 && !newName.equals(oldName);
                    this.getButton(0).setEnabled(valid);
                    if (valid) {
                        RenameAction.this.name = nameText.getText();
                    }
                }
            };
            if (dlg.open() == 0) {
                ModelObjectUtilities.rename((EObject)obj, (String)this.name, (Object)((Object)this));
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        super.selectionChanged(theEvent);
        this.determineEnablement();
    }

    protected EAttribute getNameAttribute() {
        return this.nameAttr;
    }

    protected void determineEnablement() {
        EObject eObj;
        boolean enable = false;
        if (!this.isEmptySelection() && !this.isReadOnly() && this.canLegallyEditResource() && SelectionUtilities.isSingleSelection((ISelection)this.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection())) != null) {
            enable = ModelerCore.getModelEditor().hasName(eObj) && ModelerCore.getModelEditor().getName(eObj) != null;
        }
        this.setEnabled(enable);
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.diagramEditor = editor;
    }
}

