/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage;

import java.beans.PropertyChangeListener;
import org.eclipse.gef.EditPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.BlockAnchorManager;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.DiagramUmlDependency;
import org.teiid.designer.diagram.ui.connection.DiagramUmlGeneralization;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.notation.NotationPartGenerator;
import org.teiid.designer.diagram.ui.notation.uml.part.ForeignKeyLinkEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAssociationEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAssociationLinkEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAttributeEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlDependencyLinkEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlGeneralizationLinkEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlOperationEditPart;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramEditPart;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramFigureFactory;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramNode;
import org.teiid.designer.diagram.ui.part.AbstractDefaultEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPartFactory;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.LabelEditPart;
import org.teiid.designer.diagram.ui.part.RelationalDropEditPartHelper;

public class PackageDiagramPartFactory
extends AbstractDiagramEditPartFactory
implements DiagramUiConstants {
    private DiagramFigureFactory figureFactory;
    private static final String diagramTypeId = "packageDiagramType";

    @Override
    public EditPart createEditPart(EditPart iContext, Object iModel) {
        EditPart editPart = this.createEditPart(iContext, iModel, diagramTypeId);
        return editPart;
    }

    public EditPart createEditPart(EditPart iContext, Object iModel, String diagramType) {
        PropertyChangeListener editPart = null;
        if (this.figureFactory == null) {
            this.figureFactory = new PackageDiagramFigureFactory();
        }
        if (iModel instanceof PackageDiagramNode) {
            editPart = new PackageDiagramEditPart();
            ((AbstractDiagramEditPart)editPart).setFigureFactory(this.figureFactory);
        } else if (iModel instanceof LabelModelNode) {
            editPart = new LabelEditPart();
        } else if (iModel instanceof DiagramUmlGeneralization) {
            editPart = new UmlGeneralizationLinkEditPart();
        } else if (iModel instanceof DiagramUmlDependency) {
            editPart = new UmlDependencyLinkEditPart();
        } else if (iModel instanceof DiagramUmlAssociation) {
            editPart = new UmlAssociationLinkEditPart();
        } else {
            NotationPartGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getEditPartGenerator(this.getNotationId());
            if (generator != null) {
                editPart = generator.createEditPart(iContext, iModel, diagramType);
            } else {
                ModelerCore.Util.log(4, Util.getString("DiagramErrors.partGeneratorFailure", new Object[0]));
            }
        }
        if (editPart != null) {
            if (editPart instanceof NodeConnectionEditPart) {
                editPart.setModel(iModel);
                ((NodeConnectionEditPart)editPart).setDiagramViewer((DiagramViewer)iContext.getViewer());
                ((NodeConnectionEditPart)editPart).setSourceAndTarget(iContext);
            } else if (editPart instanceof DiagramEditPart) {
                editPart.setModel(iModel);
                ((DiagramEditPart)((Object)editPart)).setNotationId(this.getNotationId());
                ((DiagramEditPart)((Object)editPart)).setSelectionHandler(this.getSelectionHandler());
                ((DiagramEditPart)((Object)editPart)).setDiagramTypeId(diagramType);
                if (editPart instanceof UmlClassifierEditPart || editPart instanceof UmlAttributeEditPart || editPart instanceof UmlAssociationEditPart || editPart instanceof UmlOperationEditPart) {
                    ((AbstractDefaultEditPart)editPart).setDropHelper(new RelationalDropEditPartHelper((DiagramEditPart)((Object)editPart)));
                }
            }
        } else if (diagramType.equals(diagramTypeId)) {
            ModelerCore.Util.log(4, Util.getString("DiagramErrors.editPartFailure", new Object[0]));
        }
        if (editPart instanceof DiagramEditPart) {
            ((DiagramEditPart)((Object)editPart)).setUnderConstruction(true);
        }
        return editPart;
    }

    @Override
    public NodeConnectionEditPart getConnectionEditPart() {
        return new ForeignKeyLinkEditPart();
    }

    @Override
    public AnchorManager getAnchorManager(DiagramEditPart editPart) {
        return new BlockAnchorManager(editPart);
    }
}

