/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;

public class UmlClassifierHeader
extends RectangleFigure {
    private Label stereotypeLabel;
    private Label nameLabel;
    private Label locationLabel;
    private Color defaultBkgdColor;
    private int nameFontStyle = 0;
    private int topInset = 4;
    private int bottomInset = 4;
    private int editIconSize = 16;
    private int leftButtonSize = 0;
    private boolean hasLeftButton = false;
    private IFigure expandcontrol;

    public UmlClassifierHeader(String stereotype, String name, String location, Image icon, Color fgdColor) {
        this.setForegroundColor(fgdColor);
        this.init(stereotype, name, location, icon);
        this.createComponent();
    }

    public void setDefaultBkgdColor(Color bkgdColor) {
        this.defaultBkgdColor = bkgdColor;
        this.setBackgroundColor(this.defaultBkgdColor);
    }

    private void init(String stereotype, String name, String location, Image icon) {
        this.setBorder((Border)new SimpleRaisedBorder());
        this.leftButtonSize = this.hasLeftButton ? this.editIconSize : 0;
        if (stereotype != null) {
            if (this.stereotypeLabel == null) {
                this.stereotypeLabel = new Label(stereotype);
                this.add((IFigure)this.stereotypeLabel);
            } else {
                this.stereotypeLabel.setText(stereotype);
            }
            this.stereotypeLabel.setForegroundColor(ColorConstants.darkGray);
        }
        if (name != null) {
            if (this.nameLabel == null) {
                if (icon != null) {
                    this.nameLabel = new Label(name);
                    this.nameLabel.setIcon(icon);
                } else {
                    this.nameLabel = new Label(name);
                }
                this.add((IFigure)this.nameLabel);
            } else {
                this.nameLabel.setText(name);
            }
            this.nameLabel.setForegroundColor(ColorConstants.black);
        }
        if (location != null) {
            if (this.locationLabel == null) {
                this.locationLabel = new Label(location);
                this.add((IFigure)this.locationLabel);
            } else {
                this.locationLabel.setText(location);
            }
            this.locationLabel.setForegroundColor(ColorConstants.darkGray);
        }
        this.refreshFont();
    }

    private void createComponent() {
        this.setSize(this.getInitialMinimumSize());
        this.layoutThisFigure();
    }

    public void layoutThisFigure() {
        int centerX = this.leftButtonSize + (this.getSize().width - this.leftButtonSize) / 2;
        int currentY = this.topInset;
        if (this.stereotypeLabel != null) {
            this.stereotypeLabel.setLocation(new Point(centerX - this.stereotypeLabel.getBounds().width / 2, currentY));
            currentY += this.stereotypeLabel.getBounds().height + this.leftButtonSize / 4;
        }
        if (this.nameLabel != null) {
            this.nameLabel.setLocation(new Point(centerX - this.nameLabel.getBounds().width / 2, currentY));
            currentY += this.nameLabel.getBounds().height;
        }
        if (this.locationLabel != null) {
            this.locationLabel.setLocation(new Point(centerX - this.locationLabel.getBounds().width / 2, currentY));
            currentY += this.nameLabel.getBounds().height;
        }
        this.setSize(this.getSize().width, currentY += this.bottomInset);
    }

    public Dimension getInitialMinimumSize() {
        int maxWidth = 10 + this.leftButtonSize;
        if (this.stereotypeLabel != null) {
            maxWidth = Math.max(maxWidth, this.stereotypeLabel.getBounds().width + this.leftButtonSize);
        }
        if (this.nameLabel != null) {
            maxWidth = Math.max(maxWidth, this.nameLabel.getBounds().width + this.leftButtonSize);
        }
        if (this.locationLabel != null) {
            maxWidth = Math.max(maxWidth, this.locationLabel.getBounds().width + this.leftButtonSize);
        }
        maxWidth += 20;
        int rectHeight = this.topInset + this.leftButtonSize / 4;
        if (this.nameLabel != null) {
            rectHeight += this.nameLabel.getBounds().height;
        }
        if (this.stereotypeLabel != null) {
            rectHeight += this.stereotypeLabel.getBounds().height;
        }
        if (this.locationLabel != null) {
            rectHeight += this.locationLabel.getBounds().height;
        }
        return new Dimension(maxWidth, rectHeight += this.bottomInset);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public IFigure getNameFigure() {
        return this.nameLabel;
    }

    public void refreshName(String newName) {
        this.init(null, newName, null, null);
        this.createComponent();
    }

    public void refreshPath(String newPath) {
        this.init(null, null, newPath, null);
        this.createComponent();
    }

    private void setLabelSize(Label label) {
        Font theFont = label.getFont();
        int hanging = FigureUtilities.getFontMetrics((Font)theFont).getDescent();
        int labelWidth = FigureUtilities.getStringExtents((String)label.getText(), (Font)theFont).width;
        if (label.getIcon() != null) {
            labelWidth += label.getIcon().getBounds().width + 30;
        }
        int labelHeight = FigureUtilities.getStringExtents((String)label.getText(), (Font)theFont).height + hanging;
        label.setSize(labelWidth, labelHeight);
        label.setPreferredSize(labelWidth, labelHeight);
    }

    public void refreshFont() {
        Font smallerFont = this.getSmallerFont();
        Font nameFont = ScaledFontManager.getFont(this.nameFontStyle);
        if (this.stereotypeLabel != null) {
            this.stereotypeLabel.setFont(smallerFont);
            this.setLabelSize(this.stereotypeLabel);
        }
        if (this.nameLabel != null) {
            this.nameLabel.setFont(nameFont);
            this.setLabelSize(this.nameLabel);
        }
        if (this.locationLabel != null) {
            this.locationLabel.setFont(smallerFont);
            this.setLabelSize(this.locationLabel);
        }
        this.createComponent();
    }

    private Font getSmallerFont() {
        return ScaledFontManager.getFont(-1);
    }

    public void hiliteBackground(Color hiliteColor) {
        if (hiliteColor == null) {
            this.setBackgroundColor(this.defaultBkgdColor);
        } else {
            this.setBackgroundColor(hiliteColor);
        }
        this.nameLabel.setForegroundColor(ColorConstants.black);
    }

    public void setNameFontStyle(int style) {
        this.nameFontStyle = style;
    }

    public void setLeftButton(boolean leftButton) {
        this.hasLeftButton = leftButton;
        if (this.expandcontrol != null) {
            this.leftButtonSize = this.expandcontrol.getSize().width;
        }
        if (this.hasLeftButton) {
            this.leftButtonSize += this.editIconSize;
        }
    }

    public void setExpandControl(IFigure expandcontrol) {
        this.expandcontrol = expandcontrol;
        this.leftButtonSize = this.hasLeftButton ? this.editIconSize + 3 + expandcontrol.getSize().width : expandcontrol.getSize().width;
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(this.getLocalBackgroundColor());
        graphics.setBackgroundColor(this.getLocalForegroundColor());
        graphics.fillGradient(this.getBounds(), true);
        this.paintChildren(graphics);
        graphics.popState();
        graphics.restoreState();
    }
}

