/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramEntityAdapter;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class AbstractDiagramModelNode
implements DiagramModelNode,
DiagramUiConstants {
    private boolean layoutState = false;
    private Vector m_sourceConnections = new Vector();
    private Vector m_targetConnections = new Vector();
    private DiagramEntity diagramEntity;
    private EObject modelObject;
    private List children = null;
    private DiagramModelNode parent;
    private Diagram diagram;
    private Dimension thisSize;
    private Point thisPosition;
    private boolean needsDiagramEntity = true;
    protected boolean errorState = false;
    protected boolean warningState = false;
    private Image firstOverlayImage;
    private String editorID = null;
    private Image secondOverlayImage;
    private boolean readOnly = false;
    private boolean hideLocationValue = false;
    private boolean heightFixed = false;
    private int fixedHeight = 200;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public AbstractDiagramModelNode(Diagram diagramModelObject, EObject modelObject) {
        this.modelObject = modelObject;
        this.diagram = diagramModelObject;
        this.thisPosition = new Point(0, 0);
        this.thisSize = new Dimension(100, 15);
        this.initialize(diagramModelObject, null);
        this.setErrorState();
    }

    public AbstractDiagramModelNode(Diagram diagramModelObject, EObject modelObject, Object secondObject) {
        this.modelObject = modelObject;
        this.diagram = diagramModelObject;
        this.thisPosition = new Point(0, 0);
        this.thisSize = new Dimension(100, 15);
        this.initialize(diagramModelObject, secondObject);
        this.setErrorState();
    }

    public AbstractDiagramModelNode(EObject modelObject) {
        this.modelObject = modelObject;
        this.needsDiagramEntity = false;
        this.thisPosition = new Point(0, 0);
        this.thisSize = new Dimension(100, 15);
        this.initialize(null, null);
        this.setErrorState();
    }

    public AbstractDiagramModelNode(Diagram diagramModelObject, EObject modelObject, boolean needsDiagramEntity) {
        this.modelObject = modelObject;
        this.diagram = diagramModelObject;
        this.needsDiagramEntity = needsDiagramEntity;
        this.thisPosition = new Point(0, 0);
        this.thisSize = new Dimension(100, 15);
        this.initialize(diagramModelObject, null);
        this.setErrorState();
    }

    public AbstractDiagramModelNode(Diagram diagramModelObject, EObject modelObject, Object secondObject, boolean needsDiagramEntity) {
        this.modelObject = modelObject;
        this.diagram = diagramModelObject;
        this.thisPosition = new Point(0, 0);
        this.thisSize = new Dimension(100, 15);
        this.initialize(diagramModelObject, secondObject);
        this.setErrorState();
    }

    protected void initialize(Diagram diagramModelObject, Object secondObject) {
        this.setReadOnly(DiagramUiUtilities.getReadOnlyState(diagramModelObject));
        if (this.needsDiagramEntity) {
            this.diagramEntity = this.findDiagramEntity(diagramModelObject, null);
            if (this.diagramEntity != null) {
                this.setLayoutState(true);
                this.thisPosition.x = DiagramEntityAdapter.getXPosition(this.diagramEntity);
                this.thisPosition.y = DiagramEntityAdapter.getYPosition(this.diagramEntity);
                this.thisSize.width = DiagramEntityAdapter.getWidth(this.diagramEntity);
                this.thisSize.height = DiagramEntityAdapter.getHeight(this.diagramEntity);
            } else if (!this.isReadOnly()) {
                this.diagramEntity = DiagramUiUtilities.getDiagramEntity(this.getModelObject(), diagramModelObject);
            }
        }
    }

    @Override
    public Diagram getDiagram() {
        return this.diagram;
    }

    protected DiagramEntity findDiagramEntity(Diagram diagram, Object secondaryObject) {
        DiagramEntity de = (DiagramEntity)DiagramEntityManager.getEntity(diagram, this.getModelObject());
        return de;
    }

    public void setErrorState() {
        int state = 0;
        this.errorState = false;
        this.warningState = false;
        if (this.getModelObject() != null) {
            state = DiagramEditorUtil.getErrorState(this.getModelObject());
            if (state == 2) {
                this.errorState = true;
            } else if (state == 1) {
                this.warningState = true;
            }
        }
    }

    @Override
    public void recoverObjectProperties() {
        this.setInitialSize();
        this.setInitialPosition();
    }

    @Override
    public void setModelObject(EObject object) {
        this.modelObject = object;
    }

    @Override
    public void setDiagramModelObject(DiagramEntity object) {
        this.diagramEntity = object;
    }

    @Override
    public EObject getModelObject() {
        return this.modelObject;
    }

    @Override
    public DiagramEntity getDiagramModelObject() {
        return this.diagramEntity;
    }

    @Override
    public void addChild(DiagramModelNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        child.setParent(this);
        this.children.add(child);
        this.fireStructureChange("children", child);
    }

    @Override
    public void addChildren(List newChildren) {
        if (newChildren != null && !newChildren.isEmpty()) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            DiagramModelNode nextChild2 = null;
            for (DiagramModelNode nextChild2 : newChildren) {
                nextChild2.setParent(this);
                this.children.add(nextChild2);
            }
            this.fireStructureChange("children", this);
        }
    }

    @Override
    public void removeChild(DiagramModelNode child, boolean deleteDiagramEntity) {
        if (this.children == null) {
            return;
        }
        this.children.remove(child);
        this.fireStructureChange("children", child);
    }

    @Override
    public void removeChildren(List oldChildren, boolean deleteDiagramEntities) {
        if (oldChildren != null && !oldChildren.isEmpty()) {
            if (this.children == null) {
                return;
            }
            DiagramModelNode nextChild2 = null;
            for (DiagramModelNode nextChild2 : oldChildren) {
                this.children.remove(nextChild2);
            }
            this.fireStructureChange("children", this);
        }
    }

    @Override
    public void updateForChild(boolean isMove) {
        this.fireStructureChange("children", "EMPTY");
    }

    @Override
    public void setChildren(List childList) {
        this.children = childList;
    }

    @Override
    public List getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public int getNumberOfChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void setParent(DiagramModelNode parent) {
        this.parent = parent;
    }

    @Override
    public DiagramModelNode getParent() {
        return this.parent;
    }

    @Override
    public void setPosition(Point position) {
        if (position.x != this.thisPosition.x || position.y != this.thisPosition.y) {
            if (this.isWritableDiagramEntity(this.diagramEntity)) {
                DiagramEntityAdapter.setPosition(this.diagramEntity, position.x, position.y);
            }
            this.thisPosition.x = position.x;
            this.thisPosition.y = position.y;
            this.firePropertyChange("location", null, position);
        }
    }

    private void setInitialPosition() {
        if (this.diagramEntity != null) {
            this.thisPosition.x = DiagramEntityAdapter.getXPosition(this.diagramEntity);
            this.thisPosition.y = DiagramEntityAdapter.getYPosition(this.diagramEntity);
        }
        this.firePropertyChange("location", null, this.getPosition());
    }

    @Override
    public void setCenterXY(int newCenterX, int newCenterY) {
        int newX = newCenterX - this.getWidth() / 2;
        int newY = newCenterY - this.getHeight() / 2;
        if (newX != this.thisPosition.x || newY != this.thisPosition.y) {
            if (this.isWritableDiagramEntity(this.diagramEntity)) {
                DiagramEntityAdapter.setXPosition(this.diagramEntity, newX);
                DiagramEntityAdapter.setYPosition(this.diagramEntity, newY);
            }
            this.thisPosition.x = newX;
            this.thisPosition.y = newY;
            this.firePropertyChange("location", null, this.thisPosition);
        }
    }

    @Override
    public void setCenterX(int newCenterX) {
        int newX = newCenterX - this.getWidth() / 2;
        if (newX != this.thisPosition.x) {
            if (this.isWritableDiagramEntity(this.diagramEntity)) {
                DiagramEntityAdapter.setXPosition(this.diagramEntity, newX);
            }
            this.thisPosition.x = newX;
            this.firePropertyChange("location", null, this.thisPosition);
        }
    }

    @Override
    public void setCenterY(int newCenterY) {
        int newY = newCenterY - this.getHeight() / 2;
        if (newY != this.thisPosition.y) {
            if (this.isWritableDiagramEntity(this.diagramEntity)) {
                DiagramEntityAdapter.setYPosition(this.diagramEntity, newY);
            }
            this.thisPosition.y = newY;
            this.firePropertyChange("location", null, this.thisPosition);
        }
    }

    @Override
    public Point getPosition() {
        return this.thisPosition;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (dimension.height != this.thisSize.height || dimension.width != this.thisSize.width) {
            this.thisSize.width = dimension.width;
            this.thisSize.height = dimension.height;
            this.firePropertyChange("size", null, dimension);
        }
    }

    public void setInitialSize() {
        this.firePropertyChange("size", null, this.thisSize);
    }

    @Override
    public Dimension getSize() {
        return this.thisSize;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public Object getEditableValue() {
        return this;
    }

    @Override
    public void update() {
        this.firePropertyChange("prop", null, null);
    }

    @Override
    public void update(String property) {
        this.firePropertyChange(property, null, null);
    }

    @Override
    public void update(String prop, String oldValue, String newValue) {
        this.firePropertyChange(prop, oldValue, newValue);
    }

    @Override
    public void setName(String name) {
        if (this.isWritableDiagramEntity(this.diagramEntity)) {
            String oldName = "xxxXxxx";
            DiagramEntityAdapter.setName(this.diagramEntity, name);
            this.firePropertyChange("name", oldName, name);
        }
    }

    @Override
    public String getName() {
        if (this.diagramEntity != null) {
            return DiagramEntityAdapter.getName(this.diagramEntity);
        }
        return null;
    }

    @Override
    public String getDisplayString() {
        return this.getName();
    }

    public String getPath() {
        return "Path";
    }

    public int getXPosition() {
        return this.thisPosition.x;
    }

    public int getYPosition() {
        return this.thisPosition.y;
    }

    @Override
    public int getX() {
        return this.thisPosition.x;
    }

    @Override
    public int getY() {
        return this.thisPosition.y;
    }

    @Override
    public int getCenterX() {
        return this.thisPosition.x + this.thisSize.width / 2;
    }

    @Override
    public int getCenterY() {
        return this.thisPosition.y + this.thisSize.height / 2;
    }

    @Override
    public int getWidth() {
        return this.thisSize.width;
    }

    @Override
    public int getHeight() {
        return this.thisSize.height;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.getName());
        result.append(", path: ");
        result.append(this.getPath());
        result.append(", xPosition: ");
        result.append(this.getXPosition());
        result.append(", yPosition: ");
        result.append(this.getYPosition());
        result.append(", height: ");
        result.append(this.getHeight());
        result.append(", width: ");
        result.append(this.getWidth());
        result.append(')');
        return result.toString();
    }

    @Override
    public Vector getSourceConnections() {
        return this.m_sourceConnections;
    }

    @Override
    public Vector getTargetConnections() {
        return this.m_targetConnections;
    }

    @Override
    public void addSourceConnection(NodeConnectionModel iConnection) {
        this.m_sourceConnections.addElement(iConnection);
    }

    @Override
    public void addTargetConnection(NodeConnectionModel iConnection) {
        this.m_targetConnections.addElement(iConnection);
    }

    @Override
    public void removeSourceConnection(NodeConnectionModel iConnection) {
        this.m_sourceConnections.removeElement(iConnection);
    }

    @Override
    public void removeTargetConnection(NodeConnectionModel iConnection) {
        this.m_targetConnections.removeElement(iConnection);
    }

    @Override
    public List getAssociations(HashMap nodeMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateAssociations() {
        this.firePropertyChange("connection", null, null);
    }

    @Override
    public boolean hasErrors() {
        return this.errorState;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningState;
    }

    @Override
    public boolean wasLayedOut() {
        return this.layoutState;
    }

    private void setLayoutState(boolean newState) {
        this.layoutState = newState;
    }

    @Override
    public List getDependencies() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Image getFirstOverlayImage() {
        return this.firstOverlayImage;
    }

    @Override
    public void setFirstOverlayImage(Image image, String editorID) {
        this.firstOverlayImage = image;
        this.editorID = editorID;
    }

    @Override
    public Image getSecondOverlayImage() {
        return this.secondOverlayImage;
    }

    @Override
    public void setSecondOverlayImage(Image image, int positionIndex) {
        this.secondOverlayImage = image;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly || ModelUtilities.isModelDiagramLocked((Object)this.getDiagram().getTarget());
    }

    @Override
    public void updateForErrorsAndWarnings() {
        this.setErrorState();
        this.firePropertyChange("errors", null, null);
    }

    private boolean isWritableDiagramEntity(DiagramEntity de) {
        boolean isOK = false;
        if (de != null && this.getModelObject() != null && !this.isReadOnly()) {
            isOK = true;
        }
        return isOK;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean hideLocation() {
        return this.hideLocationValue;
    }

    @Override
    public void setHideLocation(boolean hideLocation) {
        this.hideLocationValue = hideLocation;
    }

    @Override
    public String getEditorID() {
        return this.editorID;
    }

    public void setEditorID(String editorID) {
        this.editorID = editorID;
    }

    @Override
    public int getFixedHeight() {
        return this.fixedHeight;
    }

    @Override
    public void setFixedHeight(int theFixedHeight) {
        this.fixedHeight = theFixedHeight;
        if (this.children != null && !this.children.isEmpty()) {
            for (DiagramModelNode nextChildNode : this.children) {
                nextChildNode.setFixedHeight(theFixedHeight);
            }
        }
    }

    @Override
    public boolean isHeightFixed() {
        return this.heightFixed;
    }

    @Override
    public void setHeightFixed(boolean theHeightFixed) {
        this.heightFixed = theHeightFixed;
        if (this.children != null && !this.children.isEmpty()) {
            for (DiagramModelNode nextChildNode : this.children) {
                nextChildNode.setHeightFixed(theHeightFixed);
            }
        }
    }
}

