/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.IDiagramType;
import org.teiid.designer.diagram.ui.NotationChangeListener;
import org.teiid.designer.diagram.ui.actions.AutoLayout;
import org.teiid.designer.diagram.ui.actions.DiagramFontManager;
import org.teiid.designer.diagram.ui.actions.NotationChoiceRadioActionGroup;
import org.teiid.designer.diagram.ui.actions.ScaledFont;
import org.teiid.designer.diagram.ui.dummy.DummyDiagramNode;
import org.teiid.designer.diagram.ui.dummy.DummyDiagramPartFactory;
import org.teiid.designer.diagram.ui.editor.CustomScalableFreeformRootEditPart;
import org.teiid.designer.diagram.ui.editor.DiagramActionContributor;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramDecoratorHandler;
import org.teiid.designer.diagram.ui.editor.DiagramDropTargetAdapter;
import org.teiid.designer.diagram.ui.editor.DiagramEditorInput;
import org.teiid.designer.diagram.ui.editor.DiagramEditorSelectionProvider;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.diagram.ui.editor.DiagramViewForm;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.editor.ZoomableEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.outline.DiagramOverview;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPartFactory;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.actions.AbstractActionService;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.IInitializationCompleteListener;
import org.teiid.designer.ui.editors.IInitializationCompleteNotifier;
import org.teiid.designer.ui.editors.IInlineRenameable;
import org.teiid.designer.ui.editors.INavigationSupported;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.editors.NavigationMarker;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DiagramEditor
extends GraphicalEditor
implements ModelEditorPage,
AutoLayout,
ZoomableEditor,
INotifyChangedListener,
ISelectionChangedListener,
NotationChangeListener,
ILabelProviderListener,
IPartListener,
IInitializationCompleteNotifier,
INavigationLocationProvider,
INavigationSupported,
IGotoMarker,
IInlineRenameable,
DiagramUiConstants,
UiConstants {
    private static final String THIS_CLASS = "DiagramEditor";
    boolean initializeModelPackage = true;
    private DiagramModelNode currentModel = null;
    private DiagramModelFactory diagramModelFactory = null;
    protected DiagramViewer viewer = null;
    private KeyHandler sharedKeyHandler;
    private IDiagramSelectionHandler selectionHandler;
    private String sNotationId;
    private Image titleImage;
    private String title;
    private String tooltip;
    private DiagramEditorInput diagramInput;
    private DiagramActionContributor dacDiagramActionContributor;
    private IDiagramActionAdapter currentActionAdapter;
    private MenuManager mmNotationActionGroup;
    private ScaledFont scaledFontManager;
    private DiagramViewForm diagramViewForm;
    private ToolBar toolBar;
    private DiagramToolBarManager toolBarManager;
    private DiagramController diagramController;
    private DiagramEditorSelectionProvider selectionProvider;
    private DiagramDecoratorHandler decoratorHandler;
    private DiagramOverview overview;
    private IMarker mMostRecentlyCreatedMarker;
    boolean bOkToCreateMarkers = true;
    private IResourceChangeListener markerListener;
    private ModelEditor meParentEditor;
    private ModelResource currentModelResource;
    private IPath currentModelPath;
    private EObject revealableEObject;
    private double zoomFactor = 1.0;
    private static HashMap hmapModelTreeStates;
    private Collection completionListeners;
    private final Map adapterMap = new HashMap();

    public DiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.sNotationId = DiagramUiPlugin.getDiagramNotationManager().getCurrentExtensionId();
        this.viewer = new DiagramViewer(this);
        this.titleImage = DiagramUiPlugin.getDefault().getImage("icons/full/cview16/Diagram.gif");
    }

    public void addListener(IInitializationCompleteListener theListener) {
        if (this.completionListeners == null) {
            this.completionListeners = new ArrayList();
        }
        this.completionListeners.add(theListener);
    }

    @Override
    public void autoLayout() {
        if (this.getCurrentModel() != null && this.getGraphicalViewer().getContents() instanceof DiagramEditPart) {
            DiagramEditPart diagram = (DiagramEditPart)this.getGraphicalViewer().getContents();
            diagram.setUnderConstruction(true);
            diagram.layout();
            diagram.constructionCompleted(true);
            if (this.getDiagramController() != null) {
                this.getDiagramController().updateForAutoLayout();
            }
        }
    }

    private void autoSelect() {
        if (this.meParentEditor != null) {
            ModelEditorManager.autoSelectEditor((ModelEditor)this.meParentEditor, (ModelEditorPage)this);
        }
    }

    @Override
    public boolean canAutoLayout() {
        return true;
    }

    public boolean canDisplay(IEditorInput input) {
        boolean result = false;
        ModelResource mr = null;
        if (input instanceof EObject) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
        } else if (input instanceof ModelResource) {
            mr = (ModelResource)input;
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput ifei = (IFileEditorInput)input;
            IFile modelFile = ifei.getFile();
            if (ModelUtil.isXsdFile((IResource)modelFile)) {
                result = false;
            } else {
                try {
                    mr = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                }
                catch (ModelWorkspaceException e) {
                    String message = String.valueOf(this.getClass().getName()) + ":  canDisplay() error finding model resource for file = " + modelFile;
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        }
        if (mr != null) {
            result = ModelUtilities.supportsDiagrams((ModelResource)mr);
        }
        return result;
    }

    public boolean canOpenContext(Object input) {
        return DiagramUiPlugin.getDiagramTypeManager().canOpenContext(input);
    }

    public boolean checkValidity(String callPrefix) {
        if (this.getDiagram() == null) {
            return false;
        }
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)this.getDiagram());
        if (mr == null) {
            return false;
        }
        return !DiagramUiUtilities.isValidDiagram(this.getDiagram());
    }

    private void clearCurrentDiagram() {
        if (this.getCurrentModel() != null) {
            this.setCurrentModel(null);
            this.diagramInput = null;
        }
        if (!this.getDiagramViewer().getSelectedEditParts().isEmpty()) {
            this.getDiagramViewer().deselectAll();
        }
        this.resetRootEditPart();
    }

    private void clearDiagramToolbar() {
        this.getToolBarManager().removeAll();
        this.getToolBarManager().update(true);
        this.diagramViewForm.redraw();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.viewer = (DiagramViewer)this.getGraphicalViewer();
        this.resetRootEditPart();
        this.setInitialPartFactory();
        ((FigureCanvas)this.viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        this.selectionProvider = new DiagramEditorSelectionProvider(this.viewer);
        this.viewer.addDropTargetListener((TransferDropTargetListener)new DiagramDropTargetAdapter((EditPartViewer)this.viewer));
        this.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (e.x < 0 && DiagramEditor.this.getSelectionHandler() != null) {
                    DiagramEditor.this.getSelectionHandler().fireMouseExit();
                }
            }
        });
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.viewer.createControl((Composite)this.diagramViewForm.getSashForm());
        this.setGraphicalViewer((GraphicalViewer)this.viewer);
        this.configureGraphicalViewer();
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.viewer);
        this.initializeGraphicalViewer();
    }

    public IMarker createMarker() {
        NavigationMarker nmMarker = new NavigationMarker();
        nmMarker.setAttribute("markerType", (Object)"navigation");
        nmMarker.setAttribute("currentInput", (Object)this.getDiagram());
        this.updateSelectionsInMarker((IMarker)nmMarker);
        this.mMostRecentlyCreatedMarker = nmMarker;
        return nmMarker;
    }

    protected void createModel(Diagram diagram, IProgressMonitor monitor) {
        if (this.getModelFactory() != null) {
            this.diagramInput = new DiagramEditorInput(diagram);
            this.setCurrentModel(this.getModelFactory().createModel(diagram, this.getNotationId(), monitor));
            DiagramEditPartFactory newEditPartFactory = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getEditPartFactory();
            newEditPartFactory.setNotationId(this.getNotationId());
            this.createSelectionHandler(diagram, this.viewer);
            newEditPartFactory.setSelectionHandler(this.getSelectionHandler());
            this.viewer.setEditPartFactory(newEditPartFactory);
        }
    }

    public INavigationLocation createNavigationLocation() {
        INavigationLocation newLocation = null;
        return newLocation;
    }

    public void createPartControl(Composite parent) {
        this.diagramViewForm = new DiagramViewForm(parent, 2048);
        this.toolBar = new ToolBar((Composite)this.diagramViewForm, 8389184);
        this.diagramViewForm.setToolBar((Control)this.toolBar);
        this.toolBarManager = new DiagramToolBarManager(this.toolBar);
        super.createPartControl((Composite)this.diagramViewForm);
        this.toolBarManager.update(true);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DiagramController dController = DiagramEditor.this.getDiagramController();
                if (dController != null) {
                    dController.dispose();
                }
            }
        });
    }

    protected void createSelectionHandler(Diagram diagram, DiagramViewer theViewer) {
        this.selectionHandler = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getSelectionHandler(theViewer);
    }

    public void dispose() {
        if (!this.adapterMap.isEmpty()) {
            Iterator itr = this.adapterMap.values().iterator();
            while (itr.hasNext()) {
                ((IDiagramActionAdapter)itr.next()).disposeOfActions();
            }
        }
        DiagramUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator().removeListener((ILabelProviderListener)this);
        ModelerCore.getWorkspace().removeResourceChangeListener(this.markerListener);
        ((AbstractActionService)DiagramUiPlugin.getDefault().getActionService(this.getEditorSite().getPage())).removePartListener((IPartListener)this);
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        if (this.dacDiagramActionContributor != null) {
            this.dacDiagramActionContributor.dispose();
            this.dacDiagramActionContributor = null;
        }
        if (this.currentActionAdapter != null) {
            this.currentActionAdapter = null;
        }
    }

    public void doRefreshDiagram() {
        this.refreshDiagramSafe();
        this.autoLayout();
    }

    public void doSave(IProgressMonitor iMonitor) {
    }

    public void doSaveAs() {
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        if (this.dacDiagramActionContributor == null) {
            this.dacDiagramActionContributor = new DiagramActionContributor(this);
        }
        return this.dacDiagramActionContributor;
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class && this.getDiagramViewer().isValidViewer() && this.getDiagramViewer().getRootEditPart() != null) {
            ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
            zm.setZoomLevels(DiagramUiConstants.Zoom.zoomValues);
            zm.setZoom(this.zoomFactor);
            return zm;
        }
        if (type == ScaledFont.class) {
            return this.getFontManager();
        }
        if (type == AutoLayout.class) {
            return this;
        }
        if (type == IDiagramActionAdapter.class && this.getDiagramActionAdapter() != null) {
            return this.getDiagramActionAdapter();
        }
        return super.getAdapter(type);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public DiagramModelNode getCurrentModel() {
        return this.currentModel;
    }

    public ModelResource getCurrentModelResource() {
        return this.currentModelResource;
    }

    public double getCurrentZoomFactor() {
        return this.zoomFactor;
    }

    public DiagramDecoratorHandler getDecoratorHandler() {
        if (this.decoratorHandler == null) {
            this.decoratorHandler = new DiagramDecoratorHandler(this);
        }
        return this.decoratorHandler;
    }

    public Diagram getDiagram() {
        if (this.diagramInput != null) {
            return this.diagramInput.getDiagram();
        }
        return null;
    }

    public IDiagramActionAdapter getDiagramActionAdapter() {
        return this.currentActionAdapter;
    }

    public DiagramController getDiagramController() {
        return this.diagramController;
    }

    private DiagramController getDiagramController(Diagram diagram) {
        IDiagramType dt;
        if (diagram != null && diagram.getType() != null && (dt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType())) != null) {
            return dt.getDiagramController(this);
        }
        return null;
    }

    @Override
    public DiagramEditor getDiagramEditor() {
        return this;
    }

    public DiagramViewer getDiagramViewer() {
        return this.viewer;
    }

    public DiagramViewForm getDiagramViewForm() {
        return this.diagramViewForm;
    }

    protected ScaledFont getFontManager() {
        if (this.scaledFontManager == null) {
            this.scaledFontManager = new DiagramFontManager(this.viewer);
        }
        return this.scaledFontManager;
    }

    public IInlineRenameable getInlineRenameable(EObject theObj) {
        return this;
    }

    public ILabelProvider getLabelProvider() {
        return DiagramUiPlugin.getDiagramNotationManager().getLabelProvider();
    }

    public DiagramModelFactory getModelFactory() {
        return this.diagramModelFactory;
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return this;
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.selectionProvider;
    }

    public MenuManager getNotationActionGroup() {
        if (this.mmNotationActionGroup == null) {
            this.mmNotationActionGroup = DiagramUiPlugin.getDiagramNotationManager().getNotationActionGroup(this, this.getNotationId());
        } else {
            ((NotationChoiceRadioActionGroup)this.mmNotationActionGroup).updateNotationActions(this.getNotationId());
        }
        return this.mmNotationActionGroup;
    }

    public String getNotationId() {
        return this.sNotationId;
    }

    public INotifyChangedListener getNotifyChangedListener() {
        return this;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        if (this.overview == null) {
            this.overview = new DiagramOverview(this.getGraphicalViewer(), this.getSelectionSynchronizer(), this.getCurrentModel());
        }
        return this.overview;
    }

    public ModelEditor getParent() {
        return this.meParentEditor;
    }

    public DiagramViewForm getPrimaryControl() {
        return this.diagramViewForm;
    }

    protected IDiagramSelectionHandler getSelectionHandler() {
        return this.selectionHandler;
    }

    public String getTitle() {
        if (this.title == null) {
            return super.getTitle();
        }
        return this.title;
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public String getTitleToolTip() {
        if (this.tooltip == null) {
            return super.getTitleToolTip();
        }
        return this.tooltip;
    }

    public ToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public HashMap getTreeStatesMap() {
        if (hmapModelTreeStates == null) {
            hmapModelTreeStates = new HashMap();
        }
        return hmapModelTreeStates;
    }

    public void gotoMarker(IMarker iMarker) {
        Diagram someDiagram;
        String sMarkerType = iMarker.getAttribute("markerType", "unknown");
        if (sMarkerType.equals("navigation")) {
            this.bOkToCreateMarkers = false;
            Object oInput = MarkerUtilities.getMarkerAttribute((IMarker)iMarker, (String)"currentInput");
            if (oInput != null && this.canOpenContext(oInput)) {
                this.openContext(oInput);
                List lstSelection = (List)MarkerUtilities.getMarkerAttribute((IMarker)iMarker, (String)"currentSelection");
                if (lstSelection != null) {
                    for (EObject eoTemp : lstSelection) {
                        this.getSelectionHandler().select(eoTemp);
                    }
                }
                this.getParent().displayModelEditorPage((ModelEditorPage)this);
            }
        }
        this.bOkToCreateMarkers = true;
        if (sMarkerType.equals("navigation")) {
            return;
        }
        EObject targetEObject = ModelObjectUtilities.getMarkedEObject((IMarker)iMarker);
        if (targetEObject != null && (someDiagram = DiagramUiPlugin.getDiagramTypeManager().getDiagramForGoToMarkerEObject(targetEObject, true)) != null) {
            if (this.getDiagram() == null || !someDiagram.equals(this.getDiagram())) {
                if (this.canOpenContext(someDiagram)) {
                    this.openContext(someDiagram);
                    if (this.getDiagramController() != null) {
                        this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), (ISelection)new StructuredSelection((Object)targetEObject));
                    } else if (this.getSelectionHandler() != null) {
                        this.getSelectionHandler().select(targetEObject);
                    }
                }
            } else if (this.getDiagram() != null && someDiagram.equals(this.getDiagram())) {
                if (this.getDiagramController() != null) {
                    this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), (ISelection)new StructuredSelection((Object)targetEObject));
                } else if (this.getSelectionHandler() != null) {
                    this.getSelectionHandler().select(targetEObject);
                }
            }
        }
    }

    public void handleZoomChanged() {
        this.saveZoom();
        if (this.getDiagramViewer().getContents() != null && this.getDiagramViewer().getContents() instanceof DiagramEditPart) {
            DiagramEditPart rootEditPart = (DiagramEditPart)this.getDiagramViewer().getContents();
            if (rootEditPart != null) {
                rootEditPart.handleZoomChanged();
            }
            if (this.diagramController != null) {
                this.diagramController.handleZoomChanged();
            }
            this.getDiagramViewer().updateForPrintPreferences();
        }
    }

    public void init(IEditorSite iSite, IEditorInput iInput) {
        this.setSite((IWorkbenchPartSite)iSite);
        this.setInput(iInput);
        this.markerListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1 && DiagramEditor.this.getDiagram() != null && DiagramEditor.this.getDiagram().getTarget() != null && !ModelObjectUtilities.isStale((EObject)DiagramEditor.this.getDiagram().getTarget())) {
                    ModelResource currentMR = ModelUtilities.getModelResourceForModelObject((EObject)DiagramEditor.this.getDiagram());
                    boolean allDepExist = ModelUtilities.allDependenciesOpenInWorkspace((ModelResource)currentMR);
                    if (allDepExist) {
                        IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
                        if (deltas != null && deltas.length > 0) {
                            ArrayList<IResource> visitedResources = new ArrayList<IResource>();
                            boolean foundRefreshableResource = false;
                            IMarkerDelta[] iMarkerDeltaArray = deltas;
                            int n = deltas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMarkerDelta delta = iMarkerDeltaArray[n2];
                                IResource eventResource = delta.getResource();
                                if (!visitedResources.contains(eventResource)) {
                                    if (ModelUtilities.isModelFile((IResource)eventResource)) {
                                        boolean refreshDiagram;
                                        ModelResource mr = null;
                                        try {
                                            mr = ModelUtil.getModelResource((IFile)((IFile)eventResource), (boolean)false);
                                        }
                                        catch (ModelWorkspaceException e) {
                                            DiagramUiConstants.Util.log((Throwable)e);
                                            WidgetUtil.showError((Throwable)e);
                                        }
                                        if (mr != null && DiagramEditor.this.getDiagram() != null && currentMR != null && mr.equals(currentMR) && (refreshDiagram = DiagramEditor.this.getDecoratorHandler().handleResouceChanged())) {
                                            foundRefreshableResource = true;
                                            DiagramEditor.this.refreshDiagramSafe();
                                        }
                                    }
                                    if (!foundRefreshableResource) {
                                        visitedResources.add(eventResource);
                                    }
                                }
                                if (foundRefreshableResource) break;
                                ++n2;
                            }
                            DiagramEditor.this.updateReadOnlyState();
                        }
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DiagramEditor.this.openContext(DiagramEditor.this.getDiagram());
                                DiagramEditor.this.updateReadOnlyState();
                            }
                        });
                    }
                }
            }
        };
        ModelerCore.getWorkspace().addResourceChangeListener(this.markerListener);
        ((AbstractActionService)DiagramUiPlugin.getDefault().getActionService(iSite.getPage())).addPartListener((IPartListener)this);
    }

    protected void initializeDiagram() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        String message = String.valueOf(this.getClass().getName()) + ":  initializeDiagram() error sleeping on Thread";
                        DiagramUiConstants.Util.log(4, (Throwable)e1, message);
                    }
                    if (DiagramEditor.this.initializeModelPackage) {
                        IFileEditorInput ifei = (IFileEditorInput)DiagramEditor.this.getEditorInput();
                        IFile modelFile = ifei.getFile();
                        ModelResource mr = null;
                        try {
                            mr = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                        }
                        catch (ModelWorkspaceException e) {
                            String message = String.valueOf(this.getClass().getName()) + ":  initializeDiagram() error finding model resource for file = " + modelFile;
                            DiagramUiConstants.Util.log(4, (Throwable)e, message);
                            WidgetUtil.showError((Throwable)e);
                        }
                        if (mr != null) {
                            DiagramEditor.this.bOkToCreateMarkers = false;
                            DiagramEditor.this.openContext(mr);
                            DiagramEditor.this.bOkToCreateMarkers = true;
                        }
                    }
                }
            });
        } else {
            this.setCurrentModel(new DummyDiagramNode());
            this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
        }
    }

    public void initializeEditorPage() {
    }

    protected void initializeGraphicalViewer() {
        this.initializeDiagram();
    }

    private boolean isCurrentResource(ModelResource modelResource) {
        IPath newPath;
        CoreArgCheck.isNotNull((Object)modelResource, (String)DiagramUiConstants.Util.getString("DiagramEditor.isCurrentResourceNullCheck", new Object[0]));
        if (this.currentModelResource != null && modelResource == this.currentModelResource) {
            return true;
        }
        ModelResource editorMR = ModelUtilities.getModelResourceForModelObject((EObject)this.getDiagram());
        return editorMR != null ? modelResource == editorMR : this.currentModelPath != null && this.currentModelPath.equals((Object)(newPath = modelResource.getPath()));
    }

    public boolean isDirty() {
        return false;
    }

    private boolean isNewDiagram(Diagram newDiagram) {
        if (newDiagram == null && this.getDiagram() == null) {
            return false;
        }
        return this.getDiagram() == null || newDiagram == null || !newDiagram.getType().equals(this.getDiagram().getType());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        boolean modelChanged = false;
        Object[] elements = event.getElements();
        if (elements == null || elements.length <= 1) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object nextElement = objectArray[n2];
            if (nextElement instanceof EObject) {
                if (ModelUtilities.areModelResourcesSame((EObject)((EObject)nextElement), (EObject)this.getDiagram())) {
                    modelChanged = true;
                }
            } else if (nextElement instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)nextElement))) {
                ModelResource modelResource = null;
                ModelResource diagramModelResource = null;
                try {
                    modelResource = ModelUtil.getModelResource((IFile)((IFile)nextElement), (boolean)false);
                    if (this.getDiagram() != null) {
                        diagramModelResource = ModelUtil.getModel((Object)this.getDiagram());
                    }
                }
                catch (ModelWorkspaceException e) {
                    DiagramUiConstants.Util.log(4, (Throwable)e, "DiagramEditor.labelProviderChanged()  ERROR finding ModelResource");
                }
                if (modelResource != null && diagramModelResource != null && modelResource.equals(diagramModelResource)) {
                    modelChanged = true;
                    break;
                }
            }
            ++n2;
        }
        if (this.getModelFactory() != null && this.getCurrentModel() != null && modelChanged) {
            this.getDecoratorHandler().handleLabelProviderChanged();
        }
    }

    public void notifyChanged(Notification notification) {
        boolean diagramStillValid = true;
        if (this.getModelFactory() != null && this.getCurrentModel() != null) {
            diagramStillValid = this.getModelFactory().notifyModel(notification, this.getCurrentModel(), this.diagramInput.getDiagram().getType());
        }
        if (diagramStillValid) {
            try {
                if (this.getDiagramActionAdapter() != null) {
                    this.getDiagramActionAdapter().handleNotification(notification);
                }
                if (this.diagramController != null) {
                    this.diagramController.handleNotification(notification);
                }
            }
            catch (Exception ex) {
                DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
            }
            if (this.getDiagram() != null) {
                this.updateEditorTab(this.getDiagram());
                if (this.getModelFactory().shouldRefreshDiagram(notification, this.getCurrentModel(), this.diagramInput.getDiagram().getType())) {
                    this.refreshDiagramSafe();
                }
            }
        } else if (this.meParentEditor != null && this.meParentEditor.getModelFile() != null && this.meParentEditor.getModelFile().exists()) {
            if (this.getCurrentModel() != null && this.getCurrentModel().getDiagram() != null && !this.getCurrentModel().getDiagram().eIsProxy()) {
                this.openContext(null);
            } else {
                this.openContext(null);
            }
        }
    }

    public void notifyInitializationComplete() {
        if (this.completionListeners != null && !this.completionListeners.isEmpty()) {
            Iterator iter = this.completionListeners.iterator();
            while (iter.hasNext()) {
                ((IInitializationCompleteListener)iter.next()).processInitializationComplete();
            }
        }
    }

    public void openComplete() {
        if (this.revealableEObject != null) {
            EObject revealedObject = this.revealableEObject;
            this.getDiagramViewer().reveal(revealedObject);
            this.revealableEObject = null;
        }
    }

    public void openContext(Object input) {
        if (input instanceof ModelResource) {
            this.currentModelResource = (ModelResource)input;
        }
        this.openContext(input, false);
    }

    public void openContext(Object input, boolean forceRefresh) {
        Diagram previousDiagram = this.getDiagram();
        if (input instanceof Diagram) {
            this.autoSelect();
        }
        this.initializeModelPackage = false;
        if (input == null) {
            this.setDiagram(null, null);
            this.titleImage = null;
            this.title = null;
            this.tooltip = null;
            this.firePropertyChange(1);
            this.getDecoratorHandler().clear();
        } else {
            Diagram inputDiagram = null;
            boolean contextIsDiagram = false;
            if (input instanceof Diagram && !(input instanceof DiagramProxy)) {
                contextIsDiagram = true;
                inputDiagram = (Diagram)input;
            } else {
                inputDiagram = DiagramUiPlugin.getDiagramTypeManager().getDiagramForContext(input);
            }
            if (inputDiagram != null && !DiagramUiPlugin.getDiagramTypeManager().getDiagram(inputDiagram.getType()).isDiagramTooLarge(inputDiagram)) {
                final Diagram newDiagram = inputDiagram;
                if (this.meParentEditor != null && !forceRefresh && previousDiagram != null && inputDiagram.equals(previousDiagram)) {
                    this.meParentEditor.setIgnoreInternalFocus(true);
                    return;
                }
                this.setDiagramActionAdapter(newDiagram);
                boolean requiresProgress = false;
                requiresProgress = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).isDiagramLarge(newDiagram);
                if (requiresProgress) {
                    this.setDiagramWithProgress(newDiagram);
                } else {
                    UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DiagramEditor.this.setDiagram(newDiagram, null);
                        }
                    });
                }
                this.updateDiagramController();
                this.setDiagramToolBar();
                if (!this.diagramViewForm.isDisposed()) {
                    this.diagramViewForm.getSashForm().update();
                    this.diagramViewForm.update();
                    this.diagramViewForm.layout(false);
                    this.diagramViewForm.setInitialSashFormWeights();
                }
                this.updateEditorTab(newDiagram);
                EObject initialSelection = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).getInitialSelection(input);
                if (initialSelection != null) {
                    this.getDiagramViewer().getSelectionHandler().select(initialSelection);
                } else if (!contextIsDiagram && input instanceof EObject) {
                    this.getDiagramViewer().getSelectionHandler().select((EObject)input);
                }
                this.revealableEObject = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).getRevealedEObject(newDiagram, input);
                if (this.bOkToCreateMarkers) {
                    UiUtil.getWorkbenchPage().getNavigationHistory().markLocation((IEditorPart)this);
                }
            }
            this.getDecoratorHandler().reset();
        }
        this.updateReadOnlyState();
        this.notifyInitializationComplete();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.refreshFont();
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void preDispose() {
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        int eventType = event.getType();
        if (eventType == 2 || eventType == 3) {
            return;
        }
        boolean stillValid = this.checkValidity(String.valueOf(this.getClass().getName()) + ".processEvent()");
        final Diagram currentDiagram = this.getDiagram();
        if (eventType == 6) {
            IDiagramType idt;
            ModelResource evResource = event.getModelResource();
            boolean isSameResource = this.isCurrentResource(evResource);
            final IResource res = event.getResource();
            if (isSameResource) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EObject realDiagram = ModelObjectUtilities.getRealEObject((EObject)currentDiagram);
                        ModelEditorManager.open((EObject)realDiagram, (boolean)true);
                        if (res instanceof IFile) {
                            IFile file = (IFile)res;
                            ModelEditorManager.activate((IFile)file, (boolean)true);
                        }
                    }
                });
            } else if (currentDiagram != null && (idt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(currentDiagram.getType())).dependsOnResource(this.currentModel, evResource.getResource())) {
                this.refreshDiagramSafe();
            }
        } else if (stillValid && eventType == 4) {
            this.updateReadOnlyState();
        } else if (!(stillValid && eventType == 7 || !stillValid || eventType != 8 && eventType != 9 || currentDiagram == null)) {
            IDiagramType idt;
            ModelResource editorMR = ModelUtilities.getModelResourceForModelObject((EObject)this.getDiagram());
            if (!editorMR.isOpen()) {
                return;
            }
            if (event.getResource() instanceof IProject) {
                IProject eventProj = (IProject)event.getResource();
                IProject editorProject = ModelUtilities.getProject((Object)editorMR);
                if (editorProject == eventProj) {
                    return;
                }
            }
            if ((idt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(currentDiagram.getType())).dependsOnResource(this.currentModel, event.getResource())) {
                this.refreshDiagramSafe();
            }
        }
    }

    void refreshDiagramSafe() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DiagramUiPlugin.getDefault().getWorkbench().isClosing() && DiagramEditor.this.getDiagramViewer().isValidViewer() && DiagramEditor.this.getCurrentModel() != null && DiagramEditor.this.getCurrentModel().getModelObject() != null && DiagramUiUtilities.isValidDiagram(DiagramEditor.this.getDiagram())) {
                    DiagramEditor.this.openContext(DiagramEditor.this.getCurrentModel().getModelObject(), true);
                }
            }
        });
    }

    private void refreshFont() {
        DiagramEditPart diagramEP;
        EditPart editPart = this.getDiagramViewer().getContents();
        if (editPart != null && editPart instanceof DiagramEditPart && (diagramEP = (DiagramEditPart)editPart).getCurrentDiagramFont() != null && diagramEP.getCurrentDiagramFont().isDisposed()) {
            diagramEP.refreshFont(true);
        }
    }

    private void removeDiagramController() {
        if (this.diagramController != null) {
            if (this.diagramController instanceof ControlListener && this.getControl() != null) {
                this.getControl().removeControlListener((ControlListener)this.diagramController);
            }
            this.diagramController.deactivate();
            this.selectionProvider.removeDiagramController(this.diagramController);
            Control diagramControl = this.diagramViewForm.getControllerControl();
            if (diagramControl != null) {
                diagramControl.dispose();
            }
            this.diagramViewForm.getSashForm().update();
            this.diagramViewForm.getSashForm().pack(true);
            this.diagramViewForm.update();
            this.diagramViewForm.layout(false);
            this.diagramController = null;
        }
    }

    public void removeListener(IInitializationCompleteListener theListener) {
        if (this.completionListeners != null && !this.completionListeners.isEmpty()) {
            this.completionListeners.remove(theListener);
        }
    }

    public void renameInline(final EObject theObj, IInlineRenameable renameable) {
        if (renameable == this) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramEditor.this.getSelectionHandler().renameInline(theObj);
                }
            });
        }
    }

    private void resetRootEditPart() {
        Object root = this.viewer.getRootEditPart();
        if (root != null && this.dacDiagramActionContributor != null) {
            this.dacDiagramActionContributor.tellZoomWrappersToClose();
        }
        if (root != null) {
            if (!(root instanceof ScalableFreeformRootEditPart)) {
                root = new CustomScalableFreeformRootEditPart();
                this.viewer.setRootEditPart((RootEditPart)root);
            } else {
                root.setContents(null);
            }
            ConnectionLayer cLayer = (ConnectionLayer)((ScalableFreeformRootEditPart)root).getLayer((Object)"Connection Layer");
            if (!cLayer.getChildren().isEmpty()) {
                cLayer.removeAll();
            }
        }
    }

    public void resetZoom() {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        zm.setZoom(this.zoomFactor);
    }

    private void saveZoom() {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        this.zoomFactor = zm.getZoom();
    }

    public void selectionChanged(SelectionChangedEvent sce) {
        ISelection selection = sce.getSelection();
        if (selection instanceof IStructuredSelection) {
            if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof EObject) {
                    if (this.getSelectionHandler() != null) {
                        this.getSelectionHandler().select((EObject)obj);
                    }
                    if (this.getDiagramController() != null) {
                        this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), selection);
                    }
                    if (this.meParentEditor != null && obj instanceof Diagram && this.meParentEditor.getActiveEditor() == this) {
                        this.meParentEditor.setIgnoreInternalFocus(true);
                    }
                }
            } else if (this.getSelectionHandler() != null) {
                this.getSelectionHandler().select(selection);
            }
            this.updateSelectionsInMarker(this.mMostRecentlyCreatedMarker);
        }
    }

    protected void setCurrentModel(DiagramModelNode newDiagramModelNode) {
        this.currentModel = newDiagramModelNode;
    }

    protected void setDiagram(Diagram diagram, IProgressMonitor monitor) {
        boolean requiredStart = false;
        boolean succeeded = false;
        try {
            try {
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Display Diagram", (Object)this);
                this.saveZoom();
                this.clearCurrentDiagram();
                if (diagram != null) {
                    DiagramEntityManager.addDiagram(diagram);
                    this.currentModelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram.getTarget());
                    this.currentModelPath = ((IFileEditorInput)this.getEditorInput()).getFile().getFullPath();
                    this.setNotationId(DiagramUiUtilities.getDiagramNotation(diagram));
                    DiagramModelFactory modelFactory = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getModelFactory();
                    this.setModelFactory(modelFactory);
                    this.createModel(diagram, monitor);
                    if (this.getCurrentModel() != null) {
                        if (monitor != null) {
                            monitor.subTask("Setting Viewer Contents");
                            monitor.worked(20);
                        }
                        this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
                        if (monitor != null) {
                            monitor.subTask("Performing Layout");
                            monitor.worked(10);
                        }
                        if (this.getGraphicalViewer().getContents() instanceof DiagramEditPart) {
                            DiagramEditPart diagramEP = (DiagramEditPart)this.getGraphicalViewer().getContents();
                            diagramEP.layout(true);
                            this.resetZoom();
                            diagramEP.constructionCompleted(true);
                        }
                        if (monitor != null) {
                            monitor.worked(10);
                        }
                    }
                } else if (this.currentModelResource != null && this.currentModelResource.exists() && this.currentModelResource.isOpen()) {
                    this.openContext(this.currentModelResource);
                } else {
                    this.setModelFactory(null);
                    this.selectionHandler = null;
                    this.diagramInput = null;
                    if (this.currentActionAdapter != null) {
                        this.currentActionAdapter.disposeOfActions();
                    }
                    this.currentActionAdapter = null;
                    this.removeDiagramController();
                    this.clearDiagramToolbar();
                    this.setInitialPartFactory();
                    this.setCurrentModel(new DummyDiagramNode());
                    this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
                }
                succeeded = true;
            }
            catch (Exception ex) {
                DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".setDiagram()");
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                    if (this.overview != null) {
                        this.overview.resetContents();
                    }
                }
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
                if (this.overview != null) {
                    this.overview.resetContents();
                }
            }
        }
    }

    private void setDiagramActionAdapter(Diagram newDiagram) {
        if (newDiagram != null && (this.currentActionAdapter == null || this.isNewDiagram(newDiagram))) {
            String type;
            IDiagramActionAdapter newAdapter;
            if (this.currentActionAdapter != null) {
                this.currentActionAdapter.pageDeactivated();
            }
            if ((newAdapter = (IDiagramActionAdapter)this.adapterMap.get(type = newDiagram.getType())) == null && (newAdapter = DiagramUiPlugin.getDiagramTypeManager().getDiagram(type).getActionAdapter(this)) != null) {
                this.adapterMap.put(type, newAdapter);
            }
            if (newAdapter != null) {
                newAdapter.setDiagramEditor(this);
            }
            this.currentActionAdapter = newAdapter;
        }
    }

    private void setDiagramToolBar() {
        if (this.toolBarManager != null && this.toolBar != null) {
            if (this.getDiagramActionAdapter() != null) {
                this.getDiagramActionAdapter().contributeToDiagramToolBar();
                this.getDiagramActionAdapter().enableDiagramToolbarActions();
            }
            this.getToolBarManager().update(true);
        }
        if (!this.diagramViewForm.isDisposed() && this.diagramViewForm.isVisible()) {
            this.diagramViewForm.redraw();
        }
    }

    private boolean setDiagramWithProgress(Diagram newDiagram) {
        boolean success;
        block4: {
            success = false;
            final Diagram theDiagram = newDiagram;
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Constructing Diagram", 100);
                    DiagramEditor.this.setDiagram(theDiagram, monitor);
                }
            };
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getControl().getShell());
            dlg.run(false, true, op);
            if (!dlg.getProgressMonitor().isCanceled()) break block4;
            return true;
        }
        try {
            success = true;
        }
        catch (InterruptedException interruptedException) {
            success = true;
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    public void setFocus() {
        this.refreshFont();
        super.setFocus();
        if (this.meParentEditor != null) {
            this.meParentEditor.setIgnoreInternalFocus(true);
        }
    }

    protected void setInitialPartFactory() {
        this.viewer.setEditPartFactory(new DummyDiagramPartFactory());
    }

    public void setLabelProvider(ILabelProvider provider) {
        DiagramUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator().addListener((ILabelProviderListener)this);
        DiagramUiPlugin.getDiagramNotationManager().setLabelProvider(provider);
    }

    public void setModelFactory(DiagramModelFactory factory) {
        this.diagramModelFactory = factory;
    }

    @Override
    public void setNotationId(String sNotationId) {
        if (!this.sNotationId.equals(sNotationId)) {
            this.sNotationId = sNotationId;
            DiagramUiUtilities.setDiagramNotation(sNotationId, this.getDiagram());
            this.setDiagramWithProgress(this.diagramInput.getDiagram());
        }
    }

    public void setParent(ModelEditor meParentEditor) {
        this.meParentEditor = meParentEditor;
    }

    public void setTitleText(String newTitle) {
        this.title = newTitle;
    }

    private void updateDiagramController() {
        DiagramController newDiagramController;
        boolean useExistingController = false;
        Class<DiagramController> controllerClass = DiagramUiPlugin.getDiagramTypeManager().getDiagram(this.getDiagram().getType()).getDiagramControllerClass();
        if (this.diagramController != null) {
            if (controllerClass != null && this.diagramController.getClass().equals(controllerClass)) {
                useExistingController = this.diagramController.maintainControl(this.getDiagram());
            }
            if (!useExistingController) {
                if (this.diagramController instanceof ControlListener) {
                    this.getControl().removeControlListener((ControlListener)this.diagramController);
                }
                this.diagramController.deactivate();
                this.selectionProvider.removeDiagramController(this.diagramController);
                Control diagramControl = this.diagramViewForm.getControllerControl();
                if (diagramControl != null) {
                    diagramControl.dispose();
                }
                this.diagramController.dispose();
                this.diagramController = null;
                this.diagramViewForm.getSashForm().update();
                this.diagramViewForm.getSashForm().pack(true);
                this.diagramViewForm.update();
                this.diagramViewForm.layout(false);
            }
        }
        if (useExistingController) {
            this.diagramController.rewireDiagram(this.getDiagram());
        } else if (controllerClass != null && (newDiagramController = this.getDiagramController(this.getDiagram())) != null) {
            this.diagramController = newDiagramController;
            this.diagramController.wireDiagram(this.getDiagram());
            this.selectionProvider.setDiagramController(this.diagramController);
            if (this.diagramController instanceof ControlListener) {
                this.getControl().addControlListener((ControlListener)this.diagramController);
            }
        }
    }

    public void updateDiagramPreferences() {
        DiagramEditPart rootEditPart;
        ((DiagramFontManager)this.getFontManager()).setFontFromPreferences();
        if (this.getDiagramViewer().getContents() != null && this.getDiagramViewer().getContents() instanceof DiagramEditPart && (rootEditPart = (DiagramEditPart)this.getDiagramViewer().getContents()) != null) {
            rootEditPart.updateForPreferences();
        }
        this.getDiagramViewer().updateForPrintPreferences();
    }

    private void updateEditorTab(Diagram someDiagram) {
        ILabelProvider labelProvider = DiagramUiPlugin.getDiagramNotationManager().getLabelProvider();
        if (labelProvider != null) {
            this.titleImage = labelProvider.getImage((Object)someDiagram);
            this.setTitleText(labelProvider.getText((Object)someDiagram));
            this.tooltip = labelProvider.getText((Object)someDiagram);
        }
        if (this.meParentEditor != null) {
            this.meParentEditor.refreshEditorTabs();
        }
    }

    void updateReadOnlyState() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            boolean readOnly = ModelUtil.isIResourceReadOnly((IResource)((IFileEditorInput)this.getEditorInput()).getFile());
            this.updateReadOnlyState(readOnly);
        }
    }

    public void updateReadOnlyState(boolean isReadOnly) {
        if (this.getCurrentModel() != null && this.getCurrentModel().isReadOnly() != isReadOnly) {
            this.getCurrentModel().setReadOnly(isReadOnly);
            Iterator iter = this.getCurrentModel().getChildren().iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                ((DiagramModelNode)nextObj).setReadOnly(isReadOnly);
            }
        }
    }

    private void updateSelectionsInMarker(IMarker mMostRecentlyCreatedMarker) {
        if (mMostRecentlyCreatedMarker != null) {
            try {
                if (this.getSelectionHandler() != null) {
                    List lstEObjects = this.getSelectionHandler().getSelectedEObjects();
                    mMostRecentlyCreatedMarker.setAttribute("currentSelection", (Object)lstEObjects);
                }
            }
            catch (CoreException ce) {
                String message = String.valueOf(this.getClass().getName()) + ":  updateSelectionsInMarker() error  ";
                DiagramUiConstants.Util.log(4, (Throwable)ce, message);
            }
        }
    }
}

