/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramEditorAction;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class RefreshAction
extends DiagramEditorAction {
    public RefreshAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_refresh_diagram.gif"));
    }

    @Override
    protected void doRun() {
        DiagramModelNode diagramNode = this.editor.getCurrentModel();
        if (diagramNode != null) {
            DiagramViewer scrolledViewer = this.editor.getDiagramViewer();
            final FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
            final Point viewportPt = scrolledCanvas.getViewport().getViewLocation();
            final int vValue = scrolledCanvas.getVerticalBar().getSelection();
            final int hValue = scrolledCanvas.getHorizontalBar().getSelection();
            this.editor.openContext(diagramNode.getModelObject(), true);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    scrolledCanvas.getViewport().getContents().setVisible(false);
                    scrolledCanvas.getViewport().setViewLocation(viewportPt);
                    scrolledCanvas.getVerticalBar().setSelection(vValue);
                    scrolledCanvas.getHorizontalBar().setSelection(hValue);
                    scrolledCanvas.getViewport().getContents().setVisible(true);
                }
            });
        }
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(true);
    }
}

