/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.xmi;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.xmi.ModelImportInfo;

public final class XMIHeader {
    private final List<String> namespaceURIs = new ArrayList<String>();
    private final List<ModelImportInfo> modelImportInfos = new ArrayList<ModelImportInfo>();
    private String primaryMetamodelURI;
    private String uuid;
    private String description;
    private String modelType;
    private String modelNamespaceUri;
    private boolean visible = true;
    private String producerName;
    private String producerVersion;
    private String xmiVersion;

    public void addModelImportInfo(ModelImportInfo modelImportInfo) {
        if (modelImportInfo != null && !this.modelImportInfos.contains(modelImportInfo)) {
            this.modelImportInfos.add(modelImportInfo);
        }
    }

    public void addNamespaceURI(String uri) {
        if (!CoreStringUtil.isEmpty((String)uri) && !this.namespaceURIs.contains(uri)) {
            this.namespaceURIs.add(uri);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public ModelImportInfo[] getModelImportInfos() {
        return this.modelImportInfos.toArray(new ModelImportInfo[this.modelImportInfos.size()]);
    }

    public String[] getModelImportLocations() {
        String[] result = new String[this.modelImportInfos.size()];
        int i = 0;
        while (i < this.modelImportInfos.size()) {
            ModelImportInfo info = this.modelImportInfos.get(i);
            result[i] = info.getLocation();
            ++i;
        }
        return result;
    }

    public String[] getModelImportPaths() {
        String[] result = new String[this.modelImportInfos.size()];
        int i = 0;
        while (i < this.modelImportInfos.size()) {
            ModelImportInfo info = this.modelImportInfos.get(i);
            result[i] = info.getPath();
            ++i;
        }
        return result;
    }

    public String getModelNamespaceUri() {
        return this.modelNamespaceUri;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String[] getNamespaceURIs() {
        return this.namespaceURIs.toArray(new String[this.namespaceURIs.size()]);
    }

    public String getPrimaryMetamodelURI() {
        return this.primaryMetamodelURI;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModelNamespaceUri(String theNamespaceUri) {
        this.modelNamespaceUri = theNamespaceUri;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setPrimaryMetamodelURI(String uri) {
        this.primaryMetamodelURI = uri;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setVisible(String isVisible) {
        this.visible = true;
        if (isVisible.toUpperCase().startsWith("F")) {
            this.visible = false;
        }
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public String toString() {
        ModelImportInfo[] infos;
        String[] uris;
        StringBuffer sb = new StringBuffer(100);
        sb.append("XMI Header:");
        sb.append("\n  XMI version:           ");
        sb.append(this.getXmiVersion());
        sb.append("\n  UUID:                  ");
        sb.append(this.getUUID());
        sb.append("\n  Producer:              ");
        sb.append(this.getProducerName());
        sb.append(" ");
        sb.append(this.getProducerVersion());
        sb.append("\n  Description:           ");
        sb.append(this.getDescription());
        sb.append("\n  Model type:            ");
        sb.append(this.getModelType());
        sb.append("\n  Model namespace URI:            ");
        sb.append(this.getModelNamespaceUri());
        sb.append("\n  isVisible:             ");
        sb.append(this.isVisible());
        sb.append("\n  Primary Metamodel URI: ");
        sb.append(this.getPrimaryMetamodelURI());
        sb.append("\n  Namespace URIs:");
        String[] stringArray = uris = this.getNamespaceURIs();
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            sb.append("\n    ");
            sb.append(uri);
            ++n2;
        }
        sb.append("\n  ModelImportInfos:");
        ModelImportInfo[] modelImportInfoArray = infos = this.getModelImportInfos();
        int n3 = infos.length;
        n = 0;
        while (n < n3) {
            ModelImportInfo info = modelImportInfoArray[n];
            sb.append("\n    ");
            sb.append(info);
            ++n;
        }
        return sb.toString();
    }
}

