/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.reader.ZipReaderCallback;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ResourceFilter;
import org.teiid.designer.core.xmi.ModelImportInfo;
import org.teiid.designer.core.xmi.XMIHeader;
import org.teiid.designer.core.xmi.XMIHeaderReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WorkspaceResourceFinderUtil {
    protected static final String URI_REFERENCE_DELIMITER = "#";
    public static final ResourceFilter VDB_RESOURCE_FILTER = new VdbResourceFilter();
    private static final String SCHEME_PLATFORM = "platform:";
    private static final String SCHEME_FILE = "file:";
    private static final String PLATFORM_RESOURCE_SEGMENT = "/resource";
    private static final char DEVICE_IDENTIFIER = ':';
    private static final String AUTHORITY_SEPARATOR = "//";
    private static final char SEGMENT_SEPARATOR = '/';
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = ModelerCore.XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX;
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema.xsd";
    protected static final String XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "MagicXMLSchema.xsd";
    protected static final String XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema-instance.xsd";
    public static final String UML_PRIMITIVE_TYPES_MODEL_FILE_NAME = "primitiveTypes.xmi";
    protected static final String UML_PRIMITIVE_TYPES_INTERNAL_URI = "http://www.metamatrix.com/metamodels/UmlPrimitiveTypes-instance";
    protected static final String UML_METAMODEL_URI = "pathmap://UML2_METAMODELS/UML2.metamodel.uml2";
    public static final String RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME = "builtInRelationshipTypes.xmi";
    protected static final String RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI = "http://www.metamatrix.com/relationships/BuiltInRelationshipTypes-instance";

    public static IResource findIResource(Resource resource) {
        try {
            if (resource != null && resource.getURI() != null && WorkspaceResourceFinderUtil.getWorkspace() != null) {
                return WorkspaceResourceFinderUtil.findIResource(resource.getURI());
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }

    public static IFile findIResource(String workspaceUri) {
        if (!WorkspaceResourceFinderUtil.isValidWorkspaceUri(workspaceUri)) {
            return null;
        }
        String normalizedUriString = WorkspaceResourceFinderUtil.normalizeUriString(workspaceUri);
        Collection<IFile> fileResources = WorkspaceResourceFinderUtil.getProjectFileResources();
        IFile fileResource = WorkspaceResourceFinderUtil.getResourceStartsWithHttp(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = WorkspaceResourceFinderUtil.getResourceStartsWithPathSeparator(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = WorkspaceResourceFinderUtil.getResourceByLocation(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        return null;
    }

    public static IResource findIResource(URI resourceUri) {
        try {
            if (resourceUri != null && WorkspaceResourceFinderUtil.getWorkspace() != null) {
                String uriString = WorkspaceResourceFinderUtil.normalizeUriToString(resourceUri);
                Collection<IFile> fileResources = WorkspaceResourceFinderUtil.getProjectFileResources();
                IFile fileResource = WorkspaceResourceFinderUtil.getResourceByLocation(fileResources, uriString);
                if (fileResource != null) {
                    return fileResource;
                }
            }
        }
        catch (IllegalStateException ise) {
            ModelerCore.Util.log((Throwable)ise);
        }
        return null;
    }

    public static Collection<IFile> findIResourceByName(String name) {
        if (name == null || name.length() == 0 || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return Collections.emptyList();
        }
        FileNameResourceCollectorVisitor visitor = new FileNameResourceCollectorVisitor(name);
        WorkspaceResourceFinderUtil.getProjectFileResources(visitor);
        return visitor.getFileResources();
    }

    public static Collection<IFile> findIResourceInProjectByName(String name, IProject project) {
        if (name == null || name.length() == 0 || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return Collections.emptyList();
        }
        FileNameResourceCollectorVisitor visitor = new FileNameResourceCollectorVisitor(name);
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
        return visitor.getFileResources();
    }

    public static IFile findIResourceByPath(final IPath workspacePath) {
        if (workspacePath == null || workspacePath.isEmpty() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return null;
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor(){

            @Override
            public boolean visit(IResource resource) {
                if (!resource.exists() || resource.getType() != 1 || !this.getResourceFilter().accept(resource)) {
                    return false;
                }
                IPath path = resource.getFullPath();
                if (path.lastSegment().charAt(0) == '.') {
                    return false;
                }
                if (path.equals((Object)workspacePath)) {
                    this.addResource(resource);
                }
                return true;
            }
        };
        WorkspaceResourceFinderUtil.getProjectFileResources(visitor);
        if (visitor.getFileResources().size() == 0) {
            return null;
        }
        return visitor.getFileResources().iterator().next();
    }

    public static IFile findIResourceByUUID(final String stringifiedUuid) {
        if (CoreStringUtil.isEmpty((String)stringifiedUuid) || !stringifiedUuid.startsWith("mmuuid") || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return null;
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor(){

            @Override
            public boolean visit(IResource resource) {
                if (resource.exists() && resource.getType() == 1 && this.getResourceFilter().accept(resource)) {
                    if (ModelUtil.isXsdFile(resource)) {
                        return false;
                    }
                    if (ModelUtil.isModelFile(resource, true)) {
                        XMIHeader header = ModelUtil.getXmiHeader(resource);
                        if (header != null && stringifiedUuid.equals(header.getUUID())) {
                            this.addResource(resource);
                        }
                        return false;
                    }
                    return resource.getType() == 4 || resource.getType() == 2;
                }
                return true;
            }
        };
        WorkspaceResourceFinderUtil.getProjectFileResources(visitor);
        if (visitor.getFileResources().size() == 0) {
            return null;
        }
        return visitor.getFileResources().iterator().next();
    }

    public static String getAbsoluteLocation(File base, String relativePath) {
        URI baseLocation = URI.createFileURI((String)base.getAbsolutePath());
        URI relLocation = URI.createURI((String)relativePath, (boolean)false);
        if (baseLocation.isHierarchical() && !baseLocation.isRelative() && relLocation.isRelative()) {
            relLocation = relLocation.resolve(baseLocation);
        }
        return URI.decode((String)relLocation.toString());
    }

    public static Collection<IFile> getProjectFileResources() {
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        WorkspaceResourceFinderUtil.getProjectFileResources(visitor);
        return visitor.getFileResources();
    }

    public static void getProjectFileResources(IResourceVisitor visitor) {
        IProject[] projects;
        IWorkspace workspace = WorkspaceResourceFinderUtil.getWorkspace();
        if (workspace == null || workspace.getRoot() == null) {
            return;
        }
        IWorkspaceRoot wsRoot = workspace.getRoot();
        IProject[] iProjectArray = projects = wsRoot.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && ModelerCore.hasModelNature(project)) {
                try {
                    project.accept(visitor);
                }
                catch (CoreException e) {
                    ModelerCore.Util.log((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static Collection<IFile> getProjectFileResources(IProject project) {
        return WorkspaceResourceFinderUtil.getProjectFileResources(project, null);
    }

    public static Collection<IFile> getProjectFileResources(IProject project, ResourceFilter filter) {
        CoreArgCheck.isNotNull((Object)project);
        if (!ModelerCore.hasModelNature(project)) {
            return Collections.emptyList();
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor(filter);
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
        ArrayList<IFile> fileResources = new ArrayList<IFile>(visitor.getFileResources());
        Iterator iterator = fileResources.iterator();
        while (iterator.hasNext()) {
            IFile fileResource = (IFile)iterator.next();
            IPath path = fileResource.getFullPath();
            if (path.lastSegment().charAt(0) != '.') continue;
            iterator.remove();
        }
        return fileResources;
    }

    public static List<IFile> getDependentResources(IResource iResource) {
        if (iResource == null || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return Collections.emptyList();
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            XMIHeader header;
            File iResourceFile = ModelUtil.getLocation(iResource).toFile();
            if (!iResourceFile.exists()) {
                return Collections.emptyList();
            }
            if (ModelUtil.isXsdFile(iResource)) {
                XsdHeader header2 = XsdHeaderReader.readHeader((File)iResourceFile);
                if (header2 != null) {
                    String absolutePath;
                    IFile dependentIResource;
                    String location;
                    String[] locations = header2.getImportSchemaLocations();
                    int i = 0;
                    while (i != locations.length) {
                        location = locations[i];
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(location);
                        if (dependentIResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource != null && !result.contains(dependentIResource)) {
                            result.add(dependentIResource);
                        }
                        ++i;
                    }
                    locations = header2.getIncludeSchemaLocations();
                    i = 0;
                    while (i != locations.length) {
                        location = locations[i];
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(location);
                        if (dependentIResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource != null && !result.contains(dependentIResource)) {
                            result.add(dependentIResource);
                        }
                        ++i;
                    }
                }
            } else if (ModelUtil.isModelFile(iResource)) {
                XMIHeader header3 = XMIHeaderReader.readHeader(iResourceFile);
                if (header3 != null) {
                    ModelImportInfo[] infos;
                    ModelImportInfo[] modelImportInfoArray = infos = header3.getModelImportInfos();
                    int n = infos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String depPath;
                        ModelImportInfo info = modelImportInfoArray[n2];
                        IFile dependentIResource = null;
                        String location = info.getLocation();
                        String path = info.getPath();
                        if (!CoreStringUtil.isEmpty((String)path)) {
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(path);
                        } else if (!CoreStringUtil.isEmpty((String)location) && !WorkspaceResourceFinderUtil.isGlobalResource(depPath = iResource.getFullPath().removeLastSegments(1).append(location).toString()) && (dependentIResource = WorkspaceResourceFinderUtil.findIResource(depPath)) == null) {
                            String absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource != null && !result.contains(dependentIResource)) {
                            result.add(dependentIResource);
                        }
                        ++n2;
                    }
                }
            } else if (ModelUtil.isVdbArchiveFile(iResource) && (header = ModelUtil.getXmiHeader(iResourceFile)) != null) {
                ModelImportInfo[] infos;
                ModelImportInfo[] modelImportInfoArray = infos = header.getModelImportInfos();
                int n = infos.length;
                int n3 = 0;
                while (n3 < n) {
                    ModelImportInfo info = modelImportInfoArray[n3];
                    IFile dependentIResource = null;
                    String location = info.getLocation();
                    String path = info.getPath();
                    if (!CoreStringUtil.isEmpty((String)path)) {
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(path);
                    } else if (!CoreStringUtil.isEmpty((String)location) && !WorkspaceResourceFinderUtil.isGlobalResource(location) && (dependentIResource = WorkspaceResourceFinderUtil.findIResource(location)) == null) {
                        String absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                    }
                    if (dependentIResource != null && !result.contains(dependentIResource)) {
                        result.add(dependentIResource);
                    }
                    ++n3;
                }
            }
        }
        catch (Exception err) {
            Object[] params = new Object[]{iResource.getFullPath()};
            String msg = ModelerCore.Util.getString("WorkspaceResourceFinderUtil.Error_getting_model_imports_from_resource", params);
            ModelerCore.Util.log(4, (Throwable)err, msg);
        }
        return result;
    }

    public static String getGlobalResourceUri(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            return "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
        }
        if (uri.endsWith("builtInDataTypes.xsd")) {
            return "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
        }
        if (uri.startsWith(UML_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return UML_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.endsWith(UML_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return UML_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.startsWith(UML_METAMODEL_URI)) {
            return UML_METAMODEL_URI;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema-instance")) {
            return "http://www.w3.org/2001/XMLSchema-instance";
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema")) {
            return "http://www.w3.org/2001/XMLSchema";
        }
        if (uri.startsWith("http://www.w3.org/2001/MagicXMLSchema")) {
            return "http://www.w3.org/2001/MagicXMLSchema";
        }
        if (uri.equals("http://www.w3.org/2001/xml")) {
            return "http://www.w3.org/2001/xml";
        }
        if (uri.startsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
            if (uri.indexOf(XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/MagicXMLSchema";
            }
            if (uri.indexOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (uri.indexOf(XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
        }
        try {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            int i = 0;
            while (i != systemModels.length) {
                String systemModelUri = URI.decode((String)systemModels[i].getURI().toString());
                if (uri.equalsIgnoreCase(systemModelUri)) {
                    return systemModelUri;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            if (ModelerCore.getMetamodelRegistry().containsURI(uri)) {
                URI metamodelUri = ModelerCore.getMetamodelRegistry().getURI(uri);
                return ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(metamodelUri).getNamespaceURI();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static IFile getResourceByLocation(Collection<IFile> fileResources, String workspaceUri) {
        for (IFile fileResource : fileResources) {
            IPath location = fileResource.getLocation();
            String resourceLocation = location.toOSString();
            if (workspaceUri.endsWith(resourceLocation)) {
                return fileResource;
            }
            if (resourceLocation.endsWith(workspaceUri)) {
                return fileResource;
            }
            resourceLocation = location.toString();
            if (workspaceUri.endsWith(resourceLocation)) {
                return fileResource;
            }
            if (resourceLocation.endsWith(workspaceUri)) {
                return fileResource;
            }
            String fileNameSegment = location.lastSegment();
            if (!workspaceUri.equalsIgnoreCase(fileNameSegment)) continue;
            return fileResource;
        }
        return null;
    }

    private static IFile getResourceStartsWithHttp(Collection<IFile> fileResources, String workspaceUri) {
        if (!workspaceUri.startsWith("http")) {
            return null;
        }
        for (IFile fileResource : fileResources) {
            String targetNamespace = WorkspaceResourceFinderUtil.getXsdTargetNamespace((IResource)fileResource);
            if (!workspaceUri.equals(targetNamespace)) continue;
            return fileResource;
        }
        return null;
    }

    private static IFile getResourceStartsWithPathSeparator(Collection<IFile> fileResources, String workspaceUri) {
        if (workspaceUri.charAt(0) != '/') {
            return null;
        }
        Path pathInWorkspace = new Path(workspaceUri);
        for (IFile fileResource : fileResources) {
            if (fileResource == null || !fileResource.getFullPath().equals((Object)pathInWorkspace)) continue;
            return fileResource;
        }
        return null;
    }

    public static Collection<IFile> getResourcesThatUse(IResource resource, int depth) {
        return WorkspaceResourceFinderUtil.getResourcesThatUse(resource, null, depth);
    }

    public static Collection<IFile> getResourcesThatUse(IResource resource, ResourceFilter filter, int depth) {
        HashSet<IFile> fileResources = new HashSet<IFile>();
        WorkspaceResourceFinderUtil.getResourcesThatUse(resource, filter, depth, fileResources);
        return fileResources;
    }

    private static void getResourcesThatUse(IResource resource, ResourceFilter filter, int depth, Collection<IFile> resultDependents) {
        IProject project = resource.getProject();
        IPath targetPath = resource.getFullPath();
        Collection<IFile> projectResources = WorkspaceResourceFinderUtil.getProjectFileResources(project, filter);
        block0: for (IFile fileResource : projectResources) {
            List<IFile> dependents = WorkspaceResourceFinderUtil.getDependentResources((IResource)fileResource);
            for (IResource iResource : dependents) {
                String modelPath;
                if (!targetPath.equals((Object)iResource.getFullPath()) || WorkspaceResourceFinderUtil.isGlobalResource(modelPath = fileResource.getFullPath().toString())) continue;
                resultDependents.add(fileResource);
                if (2 != depth) continue block0;
                WorkspaceResourceFinderUtil.getResourcesThatUse((IResource)fileResource, filter, depth, resultDependents);
                continue block0;
            }
        }
    }

    public static Collection<IFile> getVdbResourcesThatContain(Collection<IResource> resources) {
        if (resources == null || resources.isEmpty() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return Collections.emptyList();
        }
        HashSet<IFile> result = new HashSet<IFile>();
        for (IResource resource : resources) {
            result.addAll(WorkspaceResourceFinderUtil.getVdbResourcesThatContain(resource));
        }
        return result;
    }

    public static Collection<IFile> getVdbResourcesThatContain(IResource resource) {
        if (resource == null || !resource.exists() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return Collections.emptyList();
        }
        HashSet<IFile> result = new HashSet<IFile>();
        Collection<IFile> vdbResources = WorkspaceResourceFinderUtil.getProjectFileResources(resource.getProject(), VDB_RESOURCE_FILTER);
        result.addAll(WorkspaceResourceFinderUtil.getVdbResourcesThatContain(resource, vdbResources));
        return result;
    }

    private static boolean vdbContainsResource(File vdbFile, final IPath targetResourcePath) {
        final Boolean[] status = new Boolean[]{false};
        try {
            ZipReaderCallback callback = new ZipReaderCallback(){

                @Override
                public void process(InputStream inputStream) throws Exception {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document xmlDocument = dBuilder.parse(inputStream);
                    NodeList modelList = xmlDocument.getElementsByTagName("model");
                    int i = 0;
                    while (i < modelList.getLength()) {
                        String path;
                        Element element;
                        Node modelNode = modelList.item(i);
                        if (modelNode.getNodeType() == 1 && (element = (Element)modelNode).hasAttribute("path") && (path = element.getAttribute("path")).equals(targetResourcePath.toOSString())) {
                            status[0] = true;
                            return;
                        }
                        ++i;
                    }
                }
            };
            ModelUtil.readVdbHeader(vdbFile, callback);
        }
        catch (Exception ex) {
            ModelerCore.Util.log((Throwable)ex);
        }
        return status[0];
    }

    private static Collection getVdbResourcesThatContain(IResource resource, Collection<IFile> workspaceResources) {
        List result = Collections.emptyList();
        if (resource == null || !resource.exists() || ModelUtil.isVdbArchiveFile(resource)) {
            return result;
        }
        if (workspaceResources == null || workspaceResources.isEmpty()) {
            return result;
        }
        result = new ArrayList();
        for (IFile fileResource : workspaceResources) {
            if (!ModelUtil.isVdbArchiveFile((IResource)fileResource)) continue;
            File vdbFile = null;
            try {
                vdbFile = ModelUtil.getLocation((IResource)fileResource).toFile();
            }
            catch (CoreException ex) {
                ModelerCore.Util.log((Throwable)ex);
            }
            if (vdbFile == null || !vdbFile.exists() || !WorkspaceResourceFinderUtil.vdbContainsResource(vdbFile, resource.getFullPath().makeAbsolute())) continue;
            result.add(fileResource);
        }
        return result;
    }

    private static IWorkspace getWorkspace() {
        return ModelerCore.getWorkspace();
    }

    public static String getWorkspaceUri(IResource resource) {
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public static String getWorkspaceUri(Resource resource) {
        if (resource == null || resource.getURI() == null || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return null;
        }
        URI resourceUri = resource.getURI();
        String resourceUriString = resourceUri.toString();
        if (WorkspaceResourceFinderUtil.isGlobalResource(resourceUriString)) {
            return WorkspaceResourceFinderUtil.getGlobalResourceUri(resourceUriString);
        }
        resourceUriString = WorkspaceResourceFinderUtil.normalizeUriToString(resourceUri);
        if (WorkspaceResourceFinderUtil.isGlobalResource(resourceUriString)) {
            return WorkspaceResourceFinderUtil.getGlobalResourceUri(resourceUriString);
        }
        IResource iResource = WorkspaceResourceFinderUtil.findIResource(resource);
        if (iResource != null) {
            return iResource.getFullPath().toString();
        }
        String path = resourceUriString;
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = WorkspaceResourceFinderUtil.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IPath iPath = project.getLocation().removeLastSegments(1);
                String projectLocation = iPath.toString();
                int beginIndex = path.indexOf(projectLocation);
                if (beginIndex >= 0) {
                    return path.substring(beginIndex += projectLocation.length());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            path = resourceUriString;
        }
        path = resourceUriString;
        String osPath = resourceUri.toFileString();
        if (osPath == null) {
            return null;
        }
        IPath wsPath = Platform.getLocation();
        String wsPathStr = wsPath.toOSString();
        if (osPath.startsWith(wsPathStr)) {
            path = osPath.substring(wsPathStr.length());
        }
        return path;
    }

    private static String getXsdTargetNamespace(IResource iResource) {
        String location;
        File resourceFile;
        if (ModelUtil.isXsdFile(iResource) && (resourceFile = new File(location = iResource.getLocation().toOSString())).exists()) {
            try {
                XsdHeader header = XsdHeaderReader.readHeader((File)resourceFile);
                if (header != null) {
                    return header.getTargetNamespaceURI();
                }
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGlobalResource(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            return true;
        }
        if (uri.endsWith("builtInDataTypes.xsd")) {
            return true;
        }
        if (uri.startsWith(UML_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return true;
        }
        if (uri.endsWith(UML_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return true;
        }
        if (uri.startsWith(UML_METAMODEL_URI)) {
            return true;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return true;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return true;
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema-instance") || uri.startsWith("http://www.w3.org/2001/MagicXMLSchema") || uri.startsWith("http://www.w3.org/2001/XMLSchema") || uri.startsWith("http://www.w3.org/2001/xml")) {
            return true;
        }
        if (uri.startsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
            if (uri.indexOf(XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
            if (uri.indexOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
            if (uri.indexOf(XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
        }
        try {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            int i = 0;
            while (i != systemModels.length) {
                String systemModelUri = URI.decode((String)systemModels[i].getURI().toString());
                if (uri.equalsIgnoreCase(systemModelUri)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            if (ModelerCore.getMetamodelRegistry().containsURI(uri)) {
                return true;
            }
        }
        catch (Exception exception) {}
        if (WorkspaceResourceFinderUtil.isLocalResource(uri)) {
            return false;
        }
        return false;
    }

    private static boolean isLocalResource(String uri) {
        boolean found = false;
        try {
            String uriName = URI.createURI((String)uri).lastSegment();
            Resource[] systemModels = ModelerCore.getModelContainer().getResourceFinder().findByName(uriName, false, false);
            int i = 0;
            while (i != systemModels.length) {
                URI resUri = systemModels[i].getURI();
                if (resUri.lastSegment().equalsIgnoreCase(uriName)) {
                    found = true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
        }
        return found;
    }

    public static boolean isValidWorkspaceUri(String workspaceUri) {
        if (workspaceUri == null || workspaceUri.length() == 0 || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return false;
        }
        return !WorkspaceResourceFinderUtil.isGlobalResource(workspaceUri);
    }

    public static String normalizeUriString(String uriString) {
        String normalizedUriString = WorkspaceResourceFinderUtil.removeSchemeAndAuthority(uriString);
        return normalizedUriString;
    }

    private static String normalizeUriToString(URI uri) {
        String uriString = new Path(URI.decode((String)uri.toString())).toString();
        return WorkspaceResourceFinderUtil.normalizeUriString(uriString);
    }

    private static String removeSchemeAndAuthority(String uri) {
        String normalizedUri = uri;
        if (normalizedUri != null) {
            int beginIndex;
            if (normalizedUri.startsWith(SCHEME_FILE)) {
                normalizedUri = normalizedUri.substring(SCHEME_FILE.length());
            } else if (normalizedUri.startsWith(SCHEME_PLATFORM) && (normalizedUri = normalizedUri.substring(SCHEME_PLATFORM.length())).startsWith(PLATFORM_RESOURCE_SEGMENT)) {
                normalizedUri = normalizedUri.substring(PLATFORM_RESOURCE_SEGMENT.length());
            }
            if (normalizedUri.startsWith(AUTHORITY_SEPARATOR) && (beginIndex = (normalizedUri = normalizedUri.substring(AUTHORITY_SEPARATOR.length())).indexOf(47)) > -1) {
                normalizedUri = normalizedUri.substring(beginIndex);
            }
            if (normalizedUri.indexOf(58) > 0 && normalizedUri.charAt(0) == '/') {
                normalizedUri = normalizedUri.substring(1);
            }
        }
        return normalizedUri;
    }

    private static class FileNameResourceCollectorVisitor
    extends FileResourceCollectorVisitor {
        private final String name;
        private final boolean removeExtension;

        public FileNameResourceCollectorVisitor(String name) {
            this.name = name;
            this.removeExtension = name.indexOf(46) == -1;
        }

        @Override
        public boolean visit(IResource resource) {
            if (!resource.exists() || resource.getType() != 1 || !this.getResourceFilter().accept(resource)) {
                return true;
            }
            IPath path = resource.getFullPath();
            if (path.lastSegment().charAt(0) == '.') {
                return true;
            }
            if (this.removeExtension) {
                path = path.removeFileExtension();
            }
            if (this.name.equalsIgnoreCase(path.lastSegment())) {
                this.addResource(resource);
            }
            return true;
        }
    }

    public static class FileResourceCollectorVisitor
    implements IResourceVisitor {
        private final List resources = new ArrayList();
        protected ResourceFilter resourceFilter;

        public FileResourceCollectorVisitor() {
            this(ResourceFilter.ACCEPT_ALL);
        }

        public FileResourceCollectorVisitor(ResourceFilter resourceFilter) {
            this.resourceFilter = resourceFilter != null ? resourceFilter : ResourceFilter.ACCEPT_ALL;
        }

        protected boolean addResource(IResource resource) {
            return this.resources.add(resource);
        }

        protected ResourceFilter getResourceFilter() {
            return this.resourceFilter;
        }

        public Collection<IFile> getFileResources() {
            return Collections.unmodifiableCollection(this.resources);
        }

        public boolean visit(IResource resource) {
            if (resource.exists() && resource.getType() == 1 && this.getResourceFilter().accept(resource)) {
                this.addResource(resource);
            }
            return true;
        }
    }

    public static class VdbResourceCollectorVisitor
    extends FileResourceCollectorVisitor {
        private final String optionalName;

        public VdbResourceCollectorVisitor() {
            this((String)null);
        }

        public VdbResourceCollectorVisitor(String vdbName) {
            this.optionalName = vdbName;
            this.resourceFilter = new VdbResourceFilter();
        }

        @Override
        public boolean visit(IResource resource) {
            if (!resource.exists() || resource.getType() != 1 || !this.getResourceFilter().accept(resource)) {
                return true;
            }
            if (this.optionalName == null) {
                this.addResource(resource);
            } else if (this.optionalName != null && this.optionalName.equalsIgnoreCase(resource.getFullPath().lastSegment())) {
                this.addResource(resource);
            }
            return true;
        }
    }

    private static class VdbResourceFilter
    implements ResourceFilter {
        private VdbResourceFilter() {
        }

        @Override
        public boolean accept(IResource res) {
            return ModelUtil.isVdbArchiveFile(res);
        }
    }
}

