/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.refactor.ModelResourceCollectorVisitor;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelProjectImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceReloadVetoListener;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceInfo;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.core.workspace.OpenableModelWorkspaceItemInfo;

public class ModelWorkspaceImpl
extends OpenableImpl
implements ModelWorkspace {
    private static final String[] MODEL_NATURES = new String[]{"org.teiid.designer.core.modelNature"};
    public static HashSet existingExternalFiles = new HashSet();

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (ModelWorkspaceManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [ModelWorkspaceImpl.getTarget(...)] Checking existence of " + path.toString());
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    ModelWorkspaceImpl() {
        super(1, null, "");
    }

    @Override
    public IPath getPath() {
        return Path.ROOT;
    }

    @Override
    public IResource getResource() {
        return this.getWorkspace().getRoot();
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    @Override
    public IWorkspace getWorkspace() {
        return ModelerCore.getWorkspace();
    }

    @Override
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
        ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
        Collection<IProject> projects = DotProjectUtils.getOpenModelProjects();
        for (IProject project : projects) {
            info.addChild(this.getModelProject((IResource)project));
        }
        return true;
    }

    @Override
    public ModelProject findModelProject(String name) {
        CoreArgCheck.isNotNull((Object)name);
        try {
            ModelProject[] projects = this.getModelProjects();
            int ndx = projects.length;
            while (--ndx >= 0) {
                ModelProject project = projects[ndx];
                if (!name.equals(project.getItemName())) continue;
                return project;
            }
        }
        catch (ModelWorkspaceException e) {
            ModelerCore.Util.log((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public ModelProject findModelProject(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        IProject rsrcProject = null;
        switch (resource.getType()) {
            case 2: {
                rsrcProject = ((IFolder)resource).getProject();
                break;
            }
            case 1: {
                rsrcProject = ((IFile)resource).getProject();
                break;
            }
            case 4: {
                rsrcProject = (IProject)resource;
            }
        }
        try {
            ModelProject[] projects = this.getModelProjects();
            int ndx = projects.length;
            while (--ndx >= 0) {
                ModelProject mdlProject = projects[ndx];
                if (rsrcProject == null || !rsrcProject.equals((Object)mdlProject.getResource())) continue;
                return mdlProject;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        return null;
    }

    @Override
    public ModelWorkspaceItem getParent(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        IProject project = resource.getProject();
        if (project.isAccessible() && !ModelerCore.hasModelNature(project)) {
            return null;
        }
        if (resource instanceof IProject) {
            return this;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IPath parentPath = path.removeLastSegments(1);
        return this.getWorkspaceItem(parentPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelWorkspaceItem getWorkspaceItem(IPath path, int resourceType) {
        CoreArgCheck.isNotNull((Object)path);
        try {
            ModelProject[] projects = this.getModelProjects();
            int i = 0;
            while (true) {
                if (i >= projects.length) {
                    return null;
                }
                ModelProject project = projects[i];
                if (resourceType == 4) {
                    if (project.getPath().equals((Object)path)) {
                        return project;
                    }
                } else if (project.isOpen()) {
                    if (path.segmentCount() < 2) {
                        return null;
                    }
                    if (path.segment(0).equals(project.getProject().getName())) {
                        ModelWorkspaceItem item = project;
                        String[] segments = path.segments();
                        int j = 1;
                        while (j < segments.length) {
                            String segment = segments[j];
                            if (!item.exists()) {
                                return null;
                            }
                            if ((item = item.getChild(segment)) == null) break;
                            if (item.getPath().makeRelative().equals((Object)path.makeRelative())) {
                                return item;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelWorkspaceItem getWorkspaceItem(IPath path) {
        CoreArgCheck.isNotNull((Object)path);
        try {
            ModelProject[] projects = this.getModelProjects();
            int i = 0;
            while (true) {
                block12: {
                    ModelProject project;
                    block13: {
                        if (i >= projects.length) {
                            return null;
                        }
                        project = projects[i];
                        if (!project.exists()) break block12;
                        if (project.isOpen()) break block13;
                        IProject iproj = (IProject)project.getResource();
                        if (!iproj.isOpen()) break block12;
                        project.open(null);
                        if (!project.isOpen()) break block12;
                    }
                    if (project.getPath().equals((Object)path)) {
                        return project;
                    }
                    ModelWorkspaceItem item = project;
                    String[] segments = path.segments();
                    int j = 1;
                    while (j < segments.length) {
                        IContainer itemContainer;
                        IResource child;
                        String segment = segments[j];
                        if (!item.exists()) {
                            return null;
                        }
                        IResource itemResource = item.getResource();
                        if ((item = item.getChild(segment)) == null && itemResource instanceof IContainer && (child = (itemContainer = (IContainer)itemResource).findMember(segment)) != null) {
                            item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(child, true);
                        }
                        if (item == null) break;
                        if (item.getPath().equals((Object)path)) {
                            return item;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        return null;
    }

    @Override
    public ModelProject createModelProject(String name, IPath path, IProgressMonitor monitor) throws CoreException {
        CoreArgCheck.isNotNull((Object)name);
        if (this.findModelProject(name) != null) {
            throw new ModelWorkspaceException(ModelerCore.Util.getString("ModelWorkspaceImpl.cannotCreateModelProject", (Object)name));
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        IStatus status = workspace.validateName(name, 4);
        if (!status.isOK()) {
            throw new ModelWorkspaceException(new ModelStatusImpl(status.getSeverity(), status.getCode(), status.getMessage()));
        }
        final IProject project = workspace.getRoot().getProject(name);
        final IProjectDescription desc = workspace.newProjectDescription(project.getName());
        desc.setLocation(path);
        desc.setNatureIds(MODEL_NATURES);
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(desc, monitor);
                project.open(monitor);
            }
        };
        workspace.run(op, monitor);
        return new ModelProjectImpl(project, this);
    }

    @Override
    public ModelProject getModelProject(IResource resource) {
        IProject project = resource.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        if (!DotProjectUtils.isModelerProject(project)) {
            return null;
        }
        ModelProject modelProject = this.findModelProject(resource);
        if (modelProject == null) {
            switch (resource.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    return new ModelProjectImpl(project, this);
                }
                case 8: {
                    return null;
                }
            }
            throw new IllegalArgumentException(ModelerCore.Util.getString("ModelWorkspaceImpl.Invalid_resource_for_ModelProject", new Object[]{resource, this}));
        }
        return modelProject;
    }

    @Override
    public ModelProject[] getModelProjects() throws ModelWorkspaceException {
        ArrayList list = this.getChildrenOfType(2);
        ModelProject[] array = new ModelProject[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public ModelResource[] getModelResources() throws CoreException {
        ArrayList<ModelResource> temp = new ArrayList<ModelResource>();
        ModelProject[] projects = this.getModelProjects();
        int i = 0;
        while (i < projects.length) {
            ModelProject mProject = projects[i];
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            if (mProject != null && mProject.isOpen() && mProject.getProject().isOpen()) {
                mProject.getProject().accept((IResourceVisitor)visitor);
                temp.addAll(visitor.getModelResources());
            }
            ++i;
        }
        ModelResource[] modelResources = new ModelResource[temp.size()];
        temp.toArray(modelResources);
        return modelResources;
    }

    @Override
    public Resource[] getEmfResources() throws CoreException {
        Resource[] result = null;
        ModelResource[] modelResources = this.getModelResources();
        if (modelResources.length == 0) {
            result = new Resource[]{};
        } else {
            ArrayList<Resource> temp = new ArrayList<Resource>(modelResources.length);
            int i = 0;
            while (i < modelResources.length) {
                try {
                    Resource resource = modelResources[i].getEmfResource();
                    if (resource != null) {
                        temp.add(resource);
                    }
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log((Throwable)((Object)theException));
                }
                ++i;
            }
            result = temp.toArray(new Resource[temp.size()]);
        }
        return result;
    }

    @Override
    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelWorkspaceInfo();
    }

    @Override
    public ModelResource findModelResource(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (!ModelUtil.isModelFile(resource)) {
            return null;
        }
        return (ModelResource)this.getWorkspaceItem(resource.getFullPath(), 1);
    }

    @Override
    public ModelResource findModelResource(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        return ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(resource);
    }

    @Override
    public ModelResource findModelResource(IPath pathInWorkspace) {
        ModelWorkspaceItem item;
        block4: {
            CoreArgCheck.isNotNull((Object)pathInWorkspace);
            try {
                item = this;
                String[] segments = pathInWorkspace.segments();
                int i = 0;
                while (i < segments.length) {
                    String segment = segments[i];
                    if (item == null) break;
                    item = item.getChild(segment);
                    ++i;
                }
                if (item != null && item.getItemType() == 5) break block4;
                return null;
            }
            catch (ModelWorkspaceException e) {
                ModelerCore.Util.log((Throwable)((Object)e));
                return null;
            }
        }
        return (ModelResource)item;
    }

    @Override
    public ModelResource findModelResource(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        try {
            Container container = ModelerCore.getModelContainer();
            Resource resource = ModelerCore.getModelEditor().findResource(container, eObject, false);
            if (resource != null) {
                return this.findModelResource(resource);
            }
        }
        catch (CoreException err) {
            ModelerCore.Util.log((Throwable)err);
        }
        return null;
    }

    @Override
    public void addNotificationListener(ModelWorkspaceNotificationListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(ModelWorkspaceNotificationListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        ModelWorkspaceManager.getModelWorkspaceManager().removeNotificationListener(listener);
    }

    @Override
    public void addModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        ModelWorkspaceManager.getModelWorkspaceManager().addModelResourceReloadVetoListener(listener);
    }

    @Override
    public void removeModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        CoreArgCheck.isNotNull((Object)listener);
        ModelWorkspaceManager.getModelWorkspaceManager().removeModelResourceReloadVetoListener(listener);
    }
}

