/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelFolder;
import org.teiid.designer.core.workspace.ModelFolderInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.core.workspace.OpenableModelWorkspaceItemInfo;

public class ModelFolderImpl
extends OpenableImpl
implements ModelFolder {
    protected IFolder ifolder;
    protected IPath path;

    public ModelFolderImpl(IFolder folder, ModelWorkspaceItem parent) {
        super(4, parent, folder.getName());
        this.ifolder = folder;
    }

    @Override
    public Object[] getNonModelingResources() throws ModelWorkspaceException {
        return ((ModelFolderInfo)this.getItemInfo()).getNonModelResources(this);
    }

    @Override
    public IPath getPath() {
        if (this.path == null) {
            return this.getFolder().getFullPath();
        }
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    @Override
    public IFolder getFolder() {
        return this.ifolder;
    }

    @Override
    public IResource getResource() {
        return this.getFolder();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getResource();
    }

    @Override
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
            this.updateFolderContents();
            validInfo = true;
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    protected ModelFolderInfo getModelFolderInfo() throws ModelWorkspaceException {
        return (ModelFolderInfo)this.getItemInfo();
    }

    public void updateFolderContents() throws ModelWorkspaceException {
        if (this.isOpen()) {
            boolean failed = false;
            try {
                try {
                    ModelFolderInfo info = this.getModelFolderInfo();
                    info.setNonModelResources(null);
                    info.setChildren(this.computeModelFolderChildren());
                }
                catch (ModelWorkspaceException e) {
                    failed = true;
                    throw e;
                }
                catch (RuntimeException e) {
                    failed = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (failed) {
                    try {
                        this.close();
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {}
                }
                throw throwable;
            }
            if (failed) {
                try {
                    this.close();
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
            }
        }
    }

    public ModelWorkspaceItem[] computeModelFolderChildren() {
        ArrayList accumulatedModelResources = new ArrayList();
        this.computeModelFolderResources((IContainer)this.getFolder(), accumulatedModelResources);
        ModelWorkspaceItem[] results = new ModelWorkspaceItem[accumulatedModelResources.size()];
        accumulatedModelResources.toArray(results);
        return results;
    }

    public void computeModelFolderResources(IContainer container, ArrayList accumulatedModelResources) {
        if (container.exists()) {
            try {
                IResource[] children = container.members();
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    if (1 == child.getType()) {
                        if (ModelUtil.isModelFile(child)) {
                            ModelResource mdlResource = this.createModelResource((IFile)child);
                            accumulatedModelResources.add(mdlResource);
                        } else if (!ModelFileUtil.isModelFileExtension((String)child.getFileExtension(), (boolean)true) && ModelFileUtil.isModelFileExtension((String)child.getFileExtension(), (boolean)false)) {
                            String actualFileName = child.getName();
                            String actualExtension = child.getFileExtension();
                            int endIndex = actualFileName.length() - actualExtension.length();
                            String expectedFileName = String.valueOf(actualFileName.substring(0, endIndex)) + actualExtension.toLowerCase();
                            Object[] params = new Object[]{actualFileName, expectedFileName};
                            String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
                            ModelerCore.Util.log(4, msg);
                        }
                    } else if (2 == child.getType()) {
                        ModelFolder mdlFolder = this.createModelFolder((IFolder)child);
                        accumulatedModelResources.add(mdlFolder);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelFolderImpl.Error_while_computing_ModelWorkspaceItem_instances_for_ModelFolder", (Object)this));
            }
        }
    }

    @Override
    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelFolderInfo();
    }

    protected ModelResource createModelResource(IFile resource) {
        return new ModelResourceImpl(this, resource.getName());
    }

    protected ModelFolder createModelFolder(IFolder folder) {
        return new ModelFolderImpl(folder, this);
    }

    @Override
    public ModelWorkspaceItem getModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        ModelWorkspaceItem[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            IResource thatResource = child.getCorrespondingResource();
            if (resource.equals((Object)thatResource)) {
                return child;
            }
            ++i;
        }
        return null;
    }
}

