/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationImpl;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;

public class DeltaProcessor
implements IResourceChangeListener {
    private final ModelWorkspaceManager manager;

    DeltaProcessor(ModelWorkspaceManager manager) {
        this.manager = manager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            ResourceChangeUtilities.debug(event);
        }
        if (ResourceChangeUtilities.isProjectClosing(event)) {
            this.fireProjectClosing(event);
            return;
        }
        if (ResourceChangeUtilities.isPreDelete(event)) {
            this.firePreDelete(event);
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        ArrayList<IResourceDelta> deltaResourceList = new ArrayList<IResourceDelta>();
        deltaResourceList.add(delta);
        this.buildDeltaResourceList(event, delta, deltaResourceList);
        for (IResourceDelta nextDelta : deltaResourceList) {
            this.debug(nextDelta, event);
            this.fireNotification(event, nextDelta);
        }
    }

    private void buildDeltaResourceList(IResourceChangeEvent event, IResourceDelta delta, List deltaResourceList) {
        if (delta == null) {
            return;
        }
        IResourceDelta[] deltas = delta.getAffectedChildren();
        if (deltas.length == 0) {
            return;
        }
        if (ResourceChangeUtilities.isRename(event, deltas)) {
            this.fireRename(deltas, event);
            return;
        }
        if (deltas.length > 1 && delta.getKind() == 4) {
            ArrayList<IResourceDelta> newDeltas = new ArrayList<IResourceDelta>();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta nextDelta = deltas[i];
                if (nextDelta.getKind() == 2) {
                    newDeltas.add(0, nextDelta);
                } else {
                    newDeltas.add(nextDelta);
                }
                ++i;
            }
            i = 0;
            while (i < newDeltas.size()) {
                deltas[i] = (IResourceDelta)newDeltas.get(i);
                ++i;
            }
        }
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta nextDelta = deltas[i];
            deltaResourceList.add(nextDelta);
            this.buildDeltaResourceList(event, nextDelta, deltaResourceList);
            ++i;
        }
    }

    private void fireNotification(IResourceChangeEvent event, IResourceDelta delta) {
        IResource rsrc = delta.getResource();
        if (rsrc.getType() == 1 && !ModelUtil.isModelFile(rsrc, false) && !ModelUtil.isVdbArchiveFile(rsrc)) {
            return;
        }
        int kind = delta.getKind();
        try {
            switch (kind) {
                case 1: {
                    ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(3, delta, event);
                    this.manager.fire(notification);
                    break;
                }
                case 4: {
                    if (!(ResourceChangeUtilities.isDescriptionChange(delta) || ResourceChangeUtilities.isMarkersChange(delta) || ResourceChangeUtilities.isTypeChange(delta))) {
                        if (ResourceChangeUtilities.isContentChanged(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(50, delta, event);
                            this.manager.fire(notification);
                        } else if (ResourceChangeUtilities.isReplaced(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(3, delta, event);
                            this.manager.fire(notification);
                            notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                            this.manager.fire(notification);
                        } else if (ResourceChangeUtilities.isMovedFrom(delta) || ResourceChangeUtilities.isMovedTo(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(7, delta, event);
                            this.manager.fire(notification);
                        } else if (rsrc instanceof IProject && ResourceChangeUtilities.isOpened(delta)) {
                            if (((IProject)rsrc).isOpen()) {
                                ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(51, delta, event);
                                this.manager.fire(notification);
                            } else {
                                ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                                this.manager.fire(notification);
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                    this.manager.fire(notification);
                    break;
                }
                case 0: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("DeltaProcessor.Unsupported_Resource_Delta_type___{0}_1", (Object)kind));
                }
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    private void fireRename(IResourceDelta[] deltas, IResourceChangeEvent event) {
        CoreArgCheck.isNotNull((Object)deltas);
        if (deltas.length != 2) {
            CoreArgCheck.isTrue((deltas.length == 2 ? 1 : 0) != 0, (String)ModelerCore.Util.getString("DeltaProcessor.Deltas_length_must_be_2_for_a_rename_1", new Object[0]));
        }
        IResourceDelta delta = null;
        if (ResourceChangeUtilities.isAdded(deltas[0])) {
            delta = deltas[0];
        } else if (ResourceChangeUtilities.isAdded(deltas[1])) {
            delta = deltas[1];
        }
        if (delta == null) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("DeltaProcessor.Unable_to_find_added_resource_for_rename_notification_2", new Object[0]));
        }
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(1, delta, event);
        notification.setIsRename(true);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    private void fireProjectClosing(IResourceChangeEvent event) {
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(52, null, event);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    private void firePreDelete(IResourceChangeEvent event) {
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, null, event);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    private void debug(IResourceDelta delta, IResourceChangeEvent event) {
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            System.out.println("--------------------START---------------------------");
            System.out.println("resource = " + delta.getResource());
            System.out.println("isPre = " + ResourceChangeUtilities.isPreEvent(event));
            System.out.println("isPostAutoBuild = " + ResourceChangeUtilities.isPostAutoBuild(event));
            System.out.println("isPostChange = " + ResourceChangeUtilities.isPostChange(event));
            System.out.println("isPreAutoBuild = " + ResourceChangeUtilities.isPreAutoBuild(event));
            System.out.println("kind=" + delta.getKind());
            System.out.println("isAdded=" + ResourceChangeUtilities.isAdded(delta));
            System.out.println("isChanged=" + ResourceChangeUtilities.isChanged(delta));
            System.out.println("isContentChanged=" + ResourceChangeUtilities.isContentChanged(delta));
            System.out.println("isDescriptionChange=" + ResourceChangeUtilities.isDescriptionChange(delta));
            System.out.println("isFile=" + ResourceChangeUtilities.isFile(delta));
            System.out.println("isFolder=" + ResourceChangeUtilities.isFolder(delta));
            System.out.println("isMovedFrom=" + ResourceChangeUtilities.isMovedFrom(delta));
            System.out.println("isMovedTo=" + ResourceChangeUtilities.isMovedTo(delta));
            System.out.println("isOpened=" + ResourceChangeUtilities.isOpened(delta));
            System.out.println("isProject=" + ResourceChangeUtilities.isProject(delta));
            System.out.println("isRemoved=" + ResourceChangeUtilities.isRemoved(delta));
            System.out.println("isReplaced=" + ResourceChangeUtilities.isReplaced(delta));
            System.out.println("isTypeChange=" + ResourceChangeUtilities.isTypeChange(delta));
            System.out.println("----------------------END-------------------------");
        }
    }
}

