/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.util.CoreArgCheck;

public final class DateUtil {
    public static final String COMPLETE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS-ZZ:zz";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.TIMESTAMP_FORMAT);
            df.setLenient(false);
            return df;
        }
    };

    public static final Date convertStringToDate(String dateString) throws ParseException {
        CoreArgCheck.isNotEmpty((String)dateString);
        int badIndex = 0;
        int millis = 0;
        try {
            int year = Integer.parseInt(dateString.substring(0, 4));
            badIndex = 5;
            int month = Integer.parseInt(dateString.substring(5, 7));
            badIndex = 8;
            int day = Integer.parseInt(dateString.substring(8, 10));
            badIndex = 11;
            int hours = Integer.parseInt(dateString.substring(11, 13));
            badIndex = 14;
            int minutes = Integer.parseInt(dateString.substring(14, 16));
            badIndex = 17;
            int seconds = Integer.parseInt(dateString.substring(17, 19));
            int len = dateString.length();
            if (len > 19) {
                badIndex = 20;
                millis = Integer.parseInt(dateString.substring(20, 23));
            }
            if (len > 23) {
                badIndex = 24;
                Integer.parseInt(dateString.substring(24, 26));
            }
            if (len > 26) {
                badIndex = 27;
                Integer.parseInt(dateString.substring(27, 29));
            }
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hours, minutes, seconds);
            calendar.add(14, millis);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Object[] params = new Object[]{dateString, COMPLETE_FORMAT};
            throw new ParseException(CoreModelerPlugin.Util.getString("DateUtil.The_string_is_not_of_the_expected_format_1", params), badIndex);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] params = new Object[]{dateString, COMPLETE_FORMAT};
            throw new ParseException(CoreModelerPlugin.Util.getString("DateUtil.The_string_is_not_of_the_expected_format_2", params), badIndex);
        }
    }

    public static final String getDateAsString(Date timestamp) {
        return DateUtil.formatString(timestamp);
    }

    public static final String getDateAsString(long timestamp) {
        return DateUtil.formatString(new Date(timestamp));
    }

    public static final Date getDate(long timestamp) {
        return new Date(timestamp);
    }

    public static final String getCurrentDateAsString() {
        return DateUtil.formatString(new Date());
    }

    public static final Date getCurrentDate() {
        return new Date();
    }

    private static final String formatString(Date timestamp) {
        StringBuffer sb = new StringBuffer(DATE_FORMATTER.get().format(timestamp));
        long offsetMillis = Calendar.getInstance().get(15);
        if (offsetMillis == 0L) {
            sb.append("+00:00");
        } else if (offsetMillis > 0L) {
            sb.append('+');
        } else {
            sb.append('-');
        }
        int seconds = (int)(Math.abs(offsetMillis) / 1000L);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        minutes %= 60;
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        return sb.toString();
    }
}

