/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EObjectHrefConverter;
import org.teiid.designer.core.util.ModelObjectCollector;

public class BuiltInTypesHrefConverter
implements EObjectHrefConverter {
    protected static final String URI_REFERENCE_DELIMITER = "#";
    protected static final String SCHEMA_FOR_SCHEMA_URI_2001_SUFFIX = "www.w3.org/2001/XMLSchema.xsd";
    protected static final String SCHEMA_INSTANCE_URI_2001_SUFFIX = "www.w3.org/2001/XMLSchema-instance.xsd";
    protected static final String MAGIC_SCHEMA_URI_2001_SUFFIX = "www.w3.org/2001/MagicXMLSchema.xsd";
    protected static final URI SCHEMA_FOR_SCHEMA_URI = URI.createURI((String)"http://www.w3.org/2001/XMLSchema");
    protected static final URI SCHEMA_INSTANCE_URI = URI.createURI((String)"http://www.w3.org/2001/XMLSchema-instance");
    protected static final URI XML_MAGIC_SCHEMA_URI = URI.createURI((String)"http://www.w3.org/2001/MagicXMLSchema");
    protected static final URI XML_SCHEMA_URI = URI.createURI((String)"http://www.w3.org/2001/xml.xsd");
    protected static final URI BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
    private static final boolean DEBUG = false;
    private Map logicalUriMap = null;
    private Map physicalUriMap = null;
    private ResourceSet eResourceSet = null;

    public BuiltInTypesHrefConverter(ResourceSet theResourceSet) {
        CoreArgCheck.isNotNull((Object)theResourceSet);
        this.eResourceSet = theResourceSet;
        this.logicalUriMap = new HashMap();
        this.physicalUriMap = new HashMap();
        this.doInit();
    }

    @Override
    public URI getLogicalURI(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        URI physicalURI = this.createPhysicalURI(eObject);
        return (URI)this.logicalUriMap.get(physicalURI);
    }

    @Override
    public URI getLogicalURI(URI physicalURI) {
        CoreArgCheck.isNotNull((Object)physicalURI);
        return (URI)this.logicalUriMap.get(physicalURI);
    }

    @Override
    public URI getPhysicalURI(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        URI logicalURI = this.createLogicalURI(eObject);
        return (URI)this.physicalUriMap.get(logicalURI);
    }

    @Override
    public URI getPhysicalURI(URI logicalURI) {
        CoreArgCheck.isNotNull((Object)logicalURI);
        return (URI)this.physicalUriMap.get(logicalURI);
    }

    protected synchronized void doInit() {
        String msg;
        XSDSchema schema;
        XSDResourceImpl xsdResource = this.getBuiltInTypesResource(BUILTIN_DATATYPES_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            CoreArgCheck.isNotNull((Object)schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", (Object)BUILTIN_DATATYPES_URI);
            ModelerCore.Util.log((Object)msg);
        }
        xsdResource = this.getBuiltInTypesResource(SCHEMA_FOR_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            CoreArgCheck.isNotNull((Object)schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", (Object)SCHEMA_FOR_SCHEMA_URI);
            ModelerCore.Util.log((Object)msg);
        }
        xsdResource = this.getBuiltInTypesResource(SCHEMA_INSTANCE_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            CoreArgCheck.isNotNull((Object)schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", (Object)SCHEMA_INSTANCE_URI);
            ModelerCore.Util.log((Object)msg);
        }
        xsdResource = this.getBuiltInTypesResource(XML_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            CoreArgCheck.isNotNull((Object)schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", (Object)XML_SCHEMA_URI);
            ModelerCore.Util.log((Object)msg);
        }
        xsdResource = this.getBuiltInTypesResource(XML_MAGIC_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            CoreArgCheck.isNotNull((Object)schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", (Object)XML_MAGIC_SCHEMA_URI);
            ModelerCore.Util.log((Object)msg);
        }
    }

    protected XSDResourceImpl getBuiltInTypesResource(URI logicalUri) {
        CoreArgCheck.isNotNull((Object)logicalUri);
        XSDResourceImpl r = (XSDResourceImpl)this.eResourceSet.getResource(logicalUri, false);
        if (r != null && !r.isLoaded()) {
            try {
                r.load(this.eResourceSet.getLoadOptions());
            }
            catch (Throwable e) {
                ModelerCore.Util.log(e);
            }
        }
        return r;
    }

    protected void addMappings(XSDComponent[] components) {
        CoreArgCheck.isNotNull((Object)components);
        int i = 0;
        while (i != components.length) {
            URI logicalURI = this.createLogicalURI((EObject)components[i]);
            URI physicalURI = this.createPhysicalURI((EObject)components[i]);
            this.physicalUriMap.put(logicalURI, physicalURI);
            this.logicalUriMap.put(physicalURI, logicalURI);
            ++i;
        }
    }

    protected XSDComponent[] getXsdComponents(XSDSchema schema) {
        CoreArgCheck.isNotNull((Object)schema);
        CoreArgCheck.isNotNull((Object)schema.eResource());
        ModelObjectCollector moc = new ModelObjectCollector(schema.eResource());
        List result = moc.getEObjects();
        Iterator i = result.iterator();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            if (eObject instanceof XSDComponent) continue;
            i.remove();
        }
        return result.toArray(new XSDComponent[result.size()]);
    }

    protected URI createLogicalURI(EObject eObject) {
        URI logicalURI = null;
        if (eObject instanceof XSDSimpleTypeDefinition) {
            logicalURI = URI.createURI((String)((XSDSimpleTypeDefinition)eObject).getURI());
        } else {
            URI uri = EcoreUtil.getURI((EObject)eObject);
            String uriString = uri.trimFragment().toString();
            if (uriString.endsWith(MAGIC_SCHEMA_URI_2001_SUFFIX)) {
                logicalURI = XML_MAGIC_SCHEMA_URI.appendFragment(uri.fragment());
            } else if (uriString.endsWith(SCHEMA_FOR_SCHEMA_URI_2001_SUFFIX)) {
                logicalURI = SCHEMA_FOR_SCHEMA_URI.appendFragment(uri.fragment());
            } else if (uriString.endsWith(SCHEMA_INSTANCE_URI_2001_SUFFIX)) {
                logicalURI = SCHEMA_INSTANCE_URI.appendFragment(uri.fragment());
            }
        }
        return logicalURI;
    }

    protected URI createPhysicalURI(EObject eObject) {
        return EcoreUtil.getURI((EObject)eObject);
    }
}

