/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.resource.EmfResource;

public class SqlStringConverter {
    public static final int UUID_STRING_LENGTH = 43;
    private static final List SYSTEM_RESOURCES = Arrays.asList(ModelerCore.getSystemVdbResources());

    public static String convertUUIDsToFullNames(String uuidString, Collection eResources) {
        if (CoreStringUtil.isEmpty((String)uuidString)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int index = uuidString.indexOf("mmuuid");
        if (index == -1) {
            return uuidString;
        }
        sb.append(uuidString.substring(0, index));
        while (index != -1) {
            String id = null;
            try {
                int nextIndex;
                id = uuidString.substring(index, index + 43);
                ObjectID uuid = IDGenerator.getInstance().stringToObject(id, "mmuuid");
                EObject obj = SqlStringConverter.findEObjectInResourceSet(uuid.toString(), eResources);
                if (obj != null) {
                    SqlAspect aspect = AspectManager.getSqlAspect(obj);
                    String name = null;
                    if (aspect != null && !CoreStringUtil.isEmpty((String)(name = index > 0 && uuidString.charAt(index - 1) == '.' ? aspect.getName(obj) : aspect.getFullName(obj)))) {
                        sb.append(name);
                    }
                } else {
                    sb.append(id);
                    String msg = ModelerCore.Util.getString("SqlStringConverter.unable_to_find_eobject_with_uuid", (Object)id);
                    ModelerCore.Util.log(4, msg);
                }
                if ((nextIndex = uuidString.indexOf("mmuuid", index + 43)) == -1) {
                    sb.append(uuidString.substring(index + 43));
                    break;
                }
                sb.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
            catch (InvalidIDException e) {
                ModelerCore.Util.log((Throwable)e);
                sb.append(id);
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                sb.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
        }
        return sb.toString();
    }

    private static EObject findEObjectInResourceSet(String uuid, Collection eResources) {
        for (Resource resource : eResources) {
            EObject eObj;
            if (!(resource instanceof EmfResource)) continue;
            if (!resource.isLoaded()) {
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    ModelerCore.Util.log(4, e.getLocalizedMessage());
                }
            }
            if ((eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return SqlStringConverter.findEobjectInSystemResources(uuid);
    }

    private static EObject findEobjectInSystemResources(String uuid) {
        for (Resource resource : SYSTEM_RESOURCES) {
            EObject eObj;
            if (!(resource instanceof EmfResource) || (eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return null;
    }
}

