/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.notification.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.teiid.designer.core.notification.util.DefaultNotificationHelper;
import org.teiid.designer.core.notification.util.INotificationHelper;
import org.teiid.designer.metamodels.core.Annotation;

public class NotificationUtilities {
    private static INotificationHelper notificationHelper = new DefaultNotificationHelper();

    private NotificationUtilities() {
    }

    public static EObject[] getAddedChildren(Notification theNotification) {
        EObject[] result = new EObject[]{};
        if (NotificationUtilities.isAdded(theNotification)) {
            Object added = theNotification.getNewValue();
            ArrayList<Object> temp = new ArrayList<Object>();
            if (added instanceof List) {
                List newKids = (List)added;
                int size = newKids.size();
                int i = 0;
                while (i < size) {
                    Object kid = newKids.get(i);
                    if (kid instanceof EObject) {
                        temp.add(kid);
                    }
                    ++i;
                }
            } else if (added instanceof EObject) {
                temp.add(added);
            }
            if (!temp.isEmpty()) {
                int size = temp.size();
                result = new EObject[size];
                int i = 0;
                while (i < size) {
                    result[i] = (EObject)temp.get(i);
                    ++i;
                }
            }
        }
        return result;
    }

    public static EObject[] getRemovedChildren(Notification theNotification) {
        EObject[] result = new EObject[]{};
        if (NotificationUtilities.isRemoved(theNotification)) {
            Object removed = theNotification.getOldValue();
            if (removed instanceof List) {
                List oldKids = (List)removed;
                int size = oldKids.size();
                result = new EObject[size];
                int i = 0;
                while (i < size) {
                    result[i] = (EObject)oldKids.get(i);
                    ++i;
                }
            } else if (removed instanceof EObject) {
                result = new EObject[]{(EObject)removed};
            }
        }
        return result;
    }

    public static EObject getEObject(Notification theNotification) {
        Object obj = NotificationUtilities.getNotificationHelper().getNotifier(theNotification);
        return obj instanceof EObject ? (EObject)obj : null;
    }

    public static Resource getResource(Notification theNotification) {
        Object obj = NotificationUtilities.getNotificationHelper().getNotifier(theNotification);
        return obj instanceof Resource ? (Resource)obj : null;
    }

    public static int getFeatureChanged(Notification theNotification) {
        int result = -1;
        Object obj = theNotification.getFeature();
        if (obj instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)obj;
            result = feature.getFeatureID();
        }
        return result;
    }

    public static boolean isAdded(Notification notification) {
        int eventType = notification.getEventType();
        boolean isValidSet = eventType == 1 && NotificationUtilities.isSetAdd(notification);
        Object feature = notification.getFeature();
        if (feature instanceof EReference) {
            XSDAttributeGroupDefinition attrGrp;
            EReference ref = (EReference)feature;
            if (!ref.isContainment()) {
                return false;
            }
            Object newVal = notification.getNewValue();
            if (newVal instanceof XSDAttributeGroupDefinition && (attrGrp = (XSDAttributeGroupDefinition)newVal) != attrGrp.getResolvedAttributeGroupDefinition()) {
                return false;
            }
        }
        return eventType == 3 || eventType == 5 || isValidSet;
    }

    private static boolean isSetAdd(Notification notification) {
        Object feature = notification.getFeature();
        Object oldVal = notification.getOldValue();
        Object newVal = notification.getNewValue();
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            return ref.isContainment() && newVal != null && oldVal == null;
        }
        if (feature instanceof List) {
            return newVal != null && oldVal == null;
        }
        return false;
    }

    public static boolean isChanged(Notification theNotification) {
        return !theNotification.isTouch();
    }

    public static boolean isEObjectNotifier(Notification theNotification) {
        return NotificationUtilities.getEObject(theNotification) != null;
    }

    public static boolean isResourceNotifier(Notification theNotification) {
        Object obj = NotificationUtilities.getNotificationHelper().getNotifier(theNotification);
        return obj instanceof Resource;
    }

    public static boolean isFeatureChanged(Notification theNotification, int theFeatureId) {
        return NotificationUtilities.isFeatureChanged(theNotification, new int[]{theFeatureId});
    }

    public static boolean isFeatureChanged(Notification theNotification, int[] theFeatureIds) {
        boolean result = false;
        Object obj = theNotification.getFeature();
        if (obj instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)obj;
            int i = 0;
            while (i < theFeatureIds.length) {
                if (feature.eClass().getClassifierID() == theFeatureIds[i] && NotificationUtilities.isChanged(theNotification)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isMoved(Notification theNotification) {
        return theNotification.getEventType() == 7;
    }

    public static boolean isMultipleChanges(Notification theNotification) {
        return theNotification.getEventType() == 5 || theNotification.getEventType() == 6;
    }

    public static boolean isRemoved(Notification theNotification) {
        int eventType = theNotification.getEventType();
        if (eventType == 4 || eventType == 6 || NotificationUtilities.isSetRemove(theNotification)) {
            Object feature = theNotification.getFeature();
            if (feature instanceof EReference && !((EReference)feature).isContainment()) {
                return false;
            }
            Object removed = theNotification.getOldValue();
            Object parent = theNotification.getNotifier();
            if (parent instanceof EObject) {
                Resource resource = null;
                resource = parent instanceof Annotation ? ((Annotation)parent).getAnnotatedObject().eResource() : ((EObject)parent).eResource();
                if (resource == null) {
                    return false;
                }
            }
            boolean isRemoved = true;
            if (removed instanceof EObject) {
                isRemoved = NotificationUtilities.isRemoved(parent, (EObject)removed);
            } else if (removed instanceof List) {
                for (Object removedObj : (List)removed) {
                    if (removedObj instanceof EObject) {
                        if (NotificationUtilities.isRemoved(parent, (EObject)removedObj)) continue;
                        isRemoved = false;
                    } else {
                        isRemoved = false;
                    }
                    break;
                }
            } else {
                isRemoved = false;
            }
            return isRemoved;
        }
        return false;
    }

    private static boolean isRemoved(Object parent, EObject removedObj) {
        boolean isRemoved = true;
        if (parent instanceof EObject) {
            isRemoved = !((EObject)parent).eContents().contains((Object)removedObj);
        } else if (parent instanceof Resource) {
            isRemoved = !((Resource)parent).getContents().contains((Object)removedObj);
        }
        return isRemoved;
    }

    private static boolean isSetRemove(Notification notification) {
        Object feature = notification.getFeature();
        Object oldVal = notification.getOldValue();
        Object newVal = notification.getNewValue();
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            return ref.isContainment() && newVal == null && oldVal != null;
        }
        if (feature instanceof List) {
            return newVal == null && oldVal != null;
        }
        return false;
    }

    public static String paramString(Notification theNotification) {
        String notifierClass = NotificationUtilities.getNotificationHelper().getNotifier(theNotification) == null ? "null" : NotificationUtilities.getNotificationHelper().getNotifier(theNotification).getClass().getName();
        return new StringBuffer().append("Notification:\n  event type=").append(theNotification.getEventType()).append("\n  feature=").append(theNotification.getFeature()).append("\n  notifier=").append(NotificationUtilities.getNotificationHelper().getNotifier(theNotification)).append("\n  notifier class=").append(notifierClass).append("\n  position=").append(theNotification.getPosition()).append("\n  reset=").append(theNotification.isReset()).append("\n  touch=").append(theNotification.isTouch()).append("\n  isAdded=" + NotificationUtilities.isAdded(theNotification)).append("\n  isChanged=").append(NotificationUtilities.isChanged(theNotification)).append("\n  isEObjectNotifier=").append(NotificationUtilities.isEObjectNotifier(theNotification)).append("\n  isMoved=").append(NotificationUtilities.isMoved(theNotification)).append("\n  isMultipleChanges=").append(NotificationUtilities.isMultipleChanges(theNotification)).append("\n  isRemoved=").append(NotificationUtilities.isRemoved(theNotification)).append("\n  getAddedChildren=").append(NotificationUtilities.getAddedChildrenPrintString(theNotification)).append("\n  getRemovedChildren=").append(NotificationUtilities.getRemovedChildrenPrintString(theNotification)).toString();
    }

    private static String getAddedChildrenPrintString(Notification notification) {
        if (NotificationUtilities.getAddedChildren(notification) == null || NotificationUtilities.getAddedChildren(notification).length == 0) {
            return "EMPTY";
        }
        StringBuffer returnString = new StringBuffer().append(" ");
        int i = 0;
        while (i < NotificationUtilities.getAddedChildren(notification).length) {
            returnString.append("\n     child =").append(NotificationUtilities.getAddedChildren(notification)[i]);
            ++i;
        }
        return returnString.toString();
    }

    private static String getRemovedChildrenPrintString(Notification notification) {
        if (NotificationUtilities.getRemovedChildren(notification) == null || NotificationUtilities.getRemovedChildren(notification).length == 0) {
            return "EMPTY";
        }
        StringBuffer returnString = new StringBuffer().append(" ");
        int i = 0;
        while (i < NotificationUtilities.getRemovedChildren(notification).length) {
            returnString.append("\n     child =").append(NotificationUtilities.getRemovedChildren(notification)[i]);
            ++i;
        }
        return returnString.toString();
    }

    public static boolean addedChildrenParentIsNotifier(Notification notification) {
        EObject[] addedChildren = NotificationUtilities.getAddedChildren(notification);
        if (addedChildren == null || addedChildren.length == 0) {
            return false;
        }
        boolean notifierIsParent = true;
        Object notifier = NotificationUtilities.getNotificationHelper().getNotifier(notification);
        int nObjects = addedChildren.length;
        int i = 0;
        while (i < nObjects) {
            EObject childsParent = addedChildren[i].eContainer();
            if (childsParent == null || !childsParent.equals(notifier)) {
                notifierIsParent = false;
                break;
            }
            ++i;
        }
        return notifierIsParent;
    }

    public static INotificationHelper getNotificationHelper() {
        return notificationHelper;
    }

    public static void setNotificationHelper(INotificationHelper helper) {
        notificationHelper = helper;
    }
}

