/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;

public class MissingModelImportRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ModelAnnotation.class, (Object)eObject);
        ModelAnnotation modelAnnot = (ModelAnnotation)eObject;
        Resource resource = modelAnnot.eResource();
        if (resource == null) {
            return;
        }
        Container container = context.getResourceContainer();
        CoreArgCheck.isNotNull((Object)container);
        ResourceFinder finder = container.getResourceFinder();
        String[] unresolvedLocations = finder.findMissingImportLocations(resource);
        int i = 0;
        while (i != unresolvedLocations.length) {
            String pathToExternalResource = unresolvedLocations[i];
            Object[] params = new Object[]{pathToExternalResource};
            ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
            String msg = ModelerCore.Util.getString("MissingModelImportRule.Missing_model_import_to_resource_0_4", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            result.setFatalResource(true);
            context.addResult(result);
            ++i;
        }
        List<Resource> refs = Arrays.asList(finder.findReferencesFrom(resource, false, true));
        ArrayList imports = new ArrayList(modelAnnot.getModelImports());
        for (ModelImport modelImport : imports) {
            ValidationProblemImpl problem;
            String msg;
            ValidationResultImpl result;
            Object[] params;
            URI uri;
            String location = modelImport.getModelLocation();
            if (!CoreStringUtil.isEmpty((String)location) && finder.isBuiltInResource(uri = URI.createURI((String)location))) continue;
            Resource importResource = finder.findByImport(modelImport, true);
            if (importResource == null) {
                params = new Object[]{location};
                result = new ValidationResultImpl(eObject, eObject.eResource());
                msg = ModelerCore.Util.getString("MissingModelImportRule.Bad_model_import_to_resource_0_4", params);
                problem = new ValidationProblemImpl(0, 4, msg, MissingModelImportRule.getLocationPath((EObject)modelImport), MissingModelImportRule.getURIString((EObject)modelImport));
                result.addProblem(problem);
                result.setFatalResource(true);
                context.addResult(result);
                continue;
            }
            if (importResource == resource || refs.contains(importResource)) continue;
            params = new Object[]{location};
            result = new ValidationResultImpl(eObject, modelImport);
            msg = ModelerCore.Util.getString("MissingModelImportRule.Model_import_0_is_no_longer_needed._3", params);
            problem = new ValidationProblemImpl(0, 2, msg, MissingModelImportRule.getLocationPath((EObject)modelImport), MissingModelImportRule.getURIString((EObject)modelImport));
            result.addProblem(problem);
            context.addResult(result);
        }
    }

    private static String getURIString(EObject eoj) {
        return ModelerCore.getModelEditor().getUri(eoj).toString();
    }

    private static String getLocationPath(EObject eoj) {
        return ModelerCore.getModelEditor().getModelRelativePath(eoj).toString();
    }
}

