/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelImport;

public class InvalidModelImportRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ModelImport.class, (Object)eObject);
        ModelImport modelImport = (ModelImport)eObject;
        String location = modelImport.getModelLocation();
        Resource resource = eObject.eResource();
        CoreArgCheck.isNotNull((Object)resource, (String)"resource");
        if (location == null) {
            ValidationResultImpl result = new ValidationResultImpl(eObject, resource);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("InvalidModelImportRule.0", new Object[0]), InvalidModelImportRule.getLocationPath((EObject)modelImport), InvalidModelImportRule.getURIString((EObject)modelImport));
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        String resourceUUID = ModelerCore.getObjectIdString((EObject)modelImport.getModel());
        String importResourceUUID = modelImport.getUuid();
        if (resourceUUID != null && resourceUUID.equals(importResourceUUID)) {
            ValidationResultImpl result = new ValidationResultImpl(eObject, modelImport);
            Object[] params = new Object[]{location};
            String msg = ModelerCore.Util.getString("InvalidModelImportRule.The_model_import_is_invalid", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg, InvalidModelImportRule.getLocationPath((EObject)modelImport), InvalidModelImportRule.getURIString((EObject)modelImport));
            result.addProblem(problem);
            context.addResult(result);
        }
    }

    private static String getURIString(EObject eoj) {
        return ModelerCore.getModelEditor().getUri(eoj).toString();
    }

    private static String getLocationPath(EObject eoj) {
        return ModelerCore.getModelEditor().getModelRelativePath(eoj).toString();
    }
}

