/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.IndexingContext;
import org.teiid.designer.core.index.ModelDocument;
import org.teiid.designer.core.index.ModelIndexer;
import org.teiid.designer.core.index.ResourceDocument;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.xmi.XMIHeader;
import org.teiid.designer.metamodels.core.ModelType;

public class ModelSearchIndexer
extends ModelIndexer {
    private static String INDEX_TYPES = ModelerCore.Util.getString("ModelSearchIndexer.Search_Indexes_1", new Object[0]);

    @Override
    protected void addIndexWord(EObject eObject, IndexingContext context, String modelPath, List wordEntries) {
        this.addIndexWord(eObject, modelPath, wordEntries);
    }

    protected void addIndexWord(EObject eObject, String modelPath, List wordEntries) {
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isNotNull((Object)wordEntries);
        SearchRuntimeAdapter.addObjectSearchWords(eObject, modelPath, wordEntries);
    }

    @Override
    protected void addResourceWordEntries(IDocument document, List wordEntries) {
        ResourceDocument resourceDocument;
        IResource resourceFile;
        XMIHeader header;
        if (document instanceof ModelDocument) {
            ModelDocument modelDocument = (ModelDocument)document;
            Resource resource = modelDocument.getResource();
            try {
                MetamodelDescriptor descriptor;
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(resource);
                String primaryMetamodelURI = null;
                if (modelResource != null && (descriptor = modelResource.getPrimaryMetamodelDescriptor()) != null) {
                    primaryMetamodelURI = descriptor.getNamespaceURI();
                }
                SearchRuntimeAdapter.addResourceSearchWords(modelResource.getUuid(), modelDocument.getIResource().getFullPath(), resource.getURI().toString(), primaryMetamodelURI, modelResource.getModelType().getName(), wordEntries);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                return;
            }
        } else if (document instanceof ResourceDocument && (header = ModelUtil.getXmiHeader(resourceFile = (resourceDocument = (ResourceDocument)document).getIResource())) != null) {
            SearchRuntimeAdapter.addResourceSearchWords(header.getUUID(), resourceDocument.getIResource().getFullPath(), URI.createFileURI((String)resourceFile.getLocation().toString()), header.getPrimaryMetamodelURI(), ModelType.VDB_ARCHIVE_LITERAL.getName(), wordEntries);
        }
    }

    @Override
    protected String getIndexFileName(IPath path) {
        return IndexUtil.getIndexFileName(path.toString(), "SEARCH_INDEX");
    }

    @Override
    public String getIndexType() {
        return INDEX_TYPES;
    }

    @Override
    protected void setIndexType(ModelResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (resource.getIndexType() == 0) {
            resource.setIndexType(2);
        } else if (resource.getIndexType() == 1) {
            resource.setIndexType(3);
        }
    }

    @Override
    public boolean shouldIndex(IDocument document) {
        return document instanceof ResourceDocument;
    }
}

