/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.id.UUID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.RunnableState;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerEditingDomain;
import org.teiid.designer.core.container.DefaultEObjectFinder;
import org.teiid.designer.core.container.DefaultResourceFinder;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.container.EObjectFinder;
import org.teiid.designer.core.container.ObjectManager;
import org.teiid.designer.core.container.ObjectManagerImpl;
import org.teiid.designer.core.container.ResourceAction;
import org.teiid.designer.core.container.ResourceDescriptor;
import org.teiid.designer.core.container.ResourceDescriptorImpl;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.resource.EmfResourceSetImpl;
import org.teiid.designer.core.resource.XResource;
import org.teiid.designer.core.transaction.UndoableListener;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.transaction.UnitOfWorkProvider;
import org.teiid.designer.core.transaction.UnitOfWorkProviderImpl;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ExternalResourceImportsHelper;
import org.teiid.designer.core.util.ProcessedNotificationResult;

public class ContainerImpl
implements Container,
IEditingDomainProvider {
    private static final ResourceSet[] EMPTY_RESOURCE_SET_ARRAY = new ResourceSet[0];
    public static final int UNSTARTED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 3;
    public static final int STOPPED = 4;
    public static final int FAILED = 5;
    private UnitOfWorkProvider emfTransactionProvider;
    private ResourceSet resourceSet;
    private MetamodelRegistry metamodelRegistry;
    private MultiStatus status;
    private final ObjectManager objectManager;
    private DatatypeManager datatypeManager;
    private Map options;
    private RunnableState state;
    private String name;
    private ChangeNotifier changeNotifier;
    private EObjectFinder finder;
    private ResourceFinder resourceFinder;
    private EditingDomain editingDomain;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ContainerImpl() {
        this.objectManager = new ObjectManagerImpl(this);
        this.initializeDefaults();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static ResourceAction getOrCreateResource(ResourceSet resourceSet, URI uri) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)uri);
        Resource existingResource = resourceSet.getResource(uri, false);
        if (existingResource != null) {
            return new ResourceAction(existingResource, false);
        }
        if (!uri.isFile()) {
            Object[] params = new Object[]{URI.decode((String)uri.toString())};
            String msg = ModelerCore.Util.getString("ContainerImpl.URI_is_not_a_file_and_cannot_be_openned_as_a_resource", params);
            throw new ModelerCoreException(msg);
        }
        File file = new File(uri.toFileString());
        if (file.canRead() && file.exists() && file.length() != 0L) {
            try {
                return new ResourceAction(resourceSet.getResource(uri, true), false);
            }
            catch (DuplicateResourceException dre) {
                throw dre;
            }
            catch (Throwable t) {
                Object[] params = new Object[]{URI.decode((String)uri.toString())};
                String msg = ModelerCore.Util.getString("ContainerImpl.Unable_to_open_the_resource", params);
                throw new ModelerCoreException(t, msg);
            }
        }
        try {
            Resource newResource = resourceSet.createResource(uri);
            return new ResourceAction(newResource, true);
        }
        catch (DuplicateResourceException dre) {
            throw dre;
        }
        catch (Throwable t) {
            Object[] params = new Object[]{URI.decode((String)uri.toString())};
            String msg = ModelerCore.Util.getString("ContainerImpl.Unable_to_create_the_resource", params);
            throw new ModelerCoreException(t, msg);
        }
    }

    @Override
    public Resource getOrCreateResource(URI uri) throws ModelerCoreException {
        ResourceAction action = ContainerImpl.getOrCreateResource(this, uri);
        return action.getResource();
    }

    public boolean isStarted() {
        return this.state.isState(2);
    }

    public boolean isStopped() {
        return this.state.isState(4);
    }

    @Override
    public void addUndoableEditListener(UndoableListener listener) {
        this.emfTransactionProvider.addUndoableEditListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableListener listener) {
        this.emfTransactionProvider.removeUndoableEditListener(listener);
    }

    protected boolean isValidName(String potentialName) {
        return true;
    }

    protected void performShutdown() {
    }

    public void setChangeNotifier(ChangeNotifier notifier) {
        CoreArgCheck.isNotNull((Object)notifier);
        this.verifySetIsAllowed(this.changeNotifier);
        this.changeNotifier = notifier;
    }

    @Override
    public void setName(String newName) {
        this.verifySetIsAllowed(this.name);
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException(String.valueOf(ModelerCore.Util.getString("ContainerImpl.The_name___2", new Object[0])) + newName + ModelerCore.Util.getString("ContainerImpl.__is_not_valid_3", new Object[0]));
        }
        String oldName = this.name;
        this.name = newName;
        this.propertyChangeSupport.firePropertyChange("container name property", oldName, newName);
    }

    protected void setState(int state) {
        this.state.setState(state);
    }

    @Override
    public final void shutdown() {
        if (this.state.isState(4)) {
            return;
        }
        this.state.setState(3);
        this.performShutdown();
        this.state.setState(4);
    }

    @Override
    public final void start() {
        if (this.state.isState(2)) {
            return;
        }
        this.state.setState(1);
        this.performStart();
        this.state.setState(2);
    }

    public String toString() {
        return this.getName();
    }

    protected void verifySetIsAllowed(Object property) {
        if (property != null) {
            if (this.state.isInTransition()) {
                throw new IllegalStateException(ModelerCore.Util.getString("ContainerImpl.Unable_to_set_the_name_while_the_container_is_in_transition_4", new Object[0]));
            }
            if (this.state.isRunning()) {
                throw new IllegalStateException(ModelerCore.Util.getString("ContainerImpl.Unable_to_set_the_name_on_a_running_container_5", new Object[0]));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected int getState() {
        return this.state.getState();
    }

    protected void initializeDefaults() {
        this.state = new RunnableState();
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    protected EObjectFinder createDefaultEObjectFinder() {
        return new DefaultEObjectFinder(this);
    }

    protected ResourceFinder createDefaultResourceFinder() {
        return new DefaultResourceFinder(this);
    }

    protected EditingDomain createDefaultEditingDomain() {
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)ModelerCore.getMetamodelRegistry().getAdapterFactory();
        CoreArgCheck.isNotNull((Object)this.getEmfTransactionProvider());
        BasicCommandStack commandStack = new BasicCommandStack();
        return new ContainerEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, this);
    }

    protected ChangeNotifier createDefaultChangeNotifier() {
        return new ChangeNotifier();
    }

    @Override
    public ChangeNotifier getChangeNotifier() {
        if (this.changeNotifier == null) {
            this.setChangeNotifier(this.createDefaultChangeNotifier());
        }
        return this.changeNotifier;
    }

    @Override
    public EObjectFinder getEObjectFinder() {
        if (this.finder == null) {
            this.setEObjectFinder(this.createDefaultEObjectFinder());
        }
        return this.finder;
    }

    @Override
    public ResourceFinder getResourceFinder() {
        if (this.resourceFinder == null) {
            this.setResourceFinder(this.createDefaultResourceFinder());
        }
        return this.resourceFinder;
    }

    @Override
    public void setEObjectFinder(EObjectFinder finder) {
        CoreArgCheck.isNotNull((Object)finder);
        this.verifySetIsAllowed(this.finder);
        this.finder = finder;
    }

    @Override
    public void setResourceFinder(ResourceFinder finder) {
        CoreArgCheck.isNotNull((Object)finder);
        this.verifySetIsAllowed(this.resourceFinder);
        this.resourceFinder = finder;
    }

    @Override
    public UnitOfWorkProvider getEmfTransactionProvider() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_7", new Object[0]));
        }
        return this.emfTransactionProvider;
    }

    protected void setEmfTransactionProvider(UnitOfWorkProvider emfTransactionProvider) {
        if (emfTransactionProvider == null) {
            CoreArgCheck.isNotNull((Object)emfTransactionProvider, (String)ModelerCore.Util.getString("ContainerImpl.The_UnitOfWorkProvider_may_not_be_null_8", new Object[0]));
        }
        this.emfTransactionProvider = emfTransactionProvider;
    }

    protected void setEditingDomain(EditingDomain editingDomain) {
        if (editingDomain == null) {
            CoreArgCheck.isNotNull((Object)editingDomain, (String)ModelerCore.Util.getString("ContainerImpl.The_EditingDomain_reference_may_not_be_null_1", new Object[0]));
        }
        this.editingDomain = editingDomain;
    }

    public final ResourceSet getResourceSet() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_9", new Object[0]));
        }
        return this.resourceSet;
    }

    @Override
    public MetamodelRegistry getMetamodelRegistry() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_10", new Object[0]));
        }
        return this.metamodelRegistry;
    }

    @Override
    public void setMetamodelRegistry(MetamodelRegistry metamodelRegistry) {
        if (metamodelRegistry == null) {
            CoreArgCheck.isNotNull((Object)metamodelRegistry, (String)ModelerCore.Util.getString("ContainerImpl.The_reference_to_the_MetamodelRegistry_may_not_be_null_11", new Object[0]));
        }
        this.metamodelRegistry = metamodelRegistry;
    }

    @Override
    public DatatypeManager getDatatypeManager() {
        if (this.datatypeManager == null) {
            this.datatypeManager = ModelerCore.getBuiltInTypesManager();
        }
        return this.datatypeManager;
    }

    public void setDatatypeManager(DatatypeManager datatypeManager) {
        CoreArgCheck.isNotNull((Object)datatypeManager);
        this.datatypeManager = datatypeManager;
    }

    public Resource createResource(URI uri) {
        return this.resourceSet.createResource(uri);
    }

    public EList<AdapterFactory> getAdapterFactories() {
        return this.resourceSet.getAdapterFactories();
    }

    public TreeIterator<Notifier> getAllContents() {
        return this.resourceSet.getAllContents();
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject result = null;
        if (uri != null && uri.fragment() != null) {
            String uriFragment = uri.fragment();
            URI resourceUri = uri.trimFragment();
            int beginIndex = uriFragment.indexOf("mmuuid");
            if (beginIndex != -1 && (beginIndex = beginIndex + "mmuuid".length() + 1) < uriFragment.length()) {
                String uuidStringWithoutProtocol = uriFragment.substring(beginIndex);
                try {
                    ObjectID uuid = UUID.stringToObject((String)uuidStringWithoutProtocol);
                    result = (EObject)this.getEObjectFinder().find((Object)uuid);
                    if (result == null) {
                        result = this.getEObjectFromExternalResourceSets(uri, false);
                    }
                    if (result != null) {
                        Resource resource = this.resourceSet.getResource(resourceUri, false);
                        Resource resultantResource = result.eResource();
                        if (resource != null && !resource.equals(resultantResource)) {
                            result = null;
                        }
                    }
                }
                catch (InvalidIDException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
        }
        if (result != null) {
            return result;
        }
        return this.resourceSet.getEObject(uri, loadOnDemand);
    }

    private EObject getEObjectFromExternalResourceSets(URI uri, boolean loadOnDemand) {
        EObject result = null;
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            ResourceSet[] externalResourceSets = ((EmfResourceSetImpl)this.resourceSet).getExternalResourceSets();
            int i = 0;
            while (i != externalResourceSets.length) {
                ResourceSet rsrcSet = externalResourceSets[i];
                result = rsrcSet.getEObject(uri, loadOnDemand);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public Map<Object, Object> getLoadOptions() {
        return this.resourceSet.getLoadOptions();
    }

    public EPackage.Registry getPackageRegistry() {
        return this.resourceSet.getPackageRegistry();
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.resourceSet.setPackageRegistry(packageRegistry);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (uri == null) {
            CoreArgCheck.isNotNull((Object)uri, (String)ModelerCore.Util.getString("ContainerImpl.The_URI_to_load_may_not_be_null_12", new Object[0]));
        }
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_13", new Object[0]));
        }
        UnitOfWork txn = this.getEmfTransactionProvider().getCurrent();
        boolean startedTxn = false;
        if (!txn.isStarted()) {
            try {
                txn.begin();
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
            startedTxn = true;
        }
        Resource resource = null;
        boolean created = false;
        try {
            this.log(String.valueOf(ModelerCore.Util.getString("ContainerImpl.>>_ContainerImpl.delegatedGetResource__URI___14", new Object[0])) + uri + ", loadOnDemand= " + loadOnDemand);
            if (this.metamodelRegistry != null && this.metamodelRegistry.containsURI(uri)) {
                resource = this.metamodelRegistry.getResource(uri);
                this.log(String.valueOf(ModelerCore.Util.getString("ContainerImpl.>>_Returning_Resource_in_the_MetamodelRegistry_with_URI___16", new Object[0])) + uri + "\"");
            }
            created = this.resourceSet.getResource(uri, false) == null;
            resource = this.resourceSet.getResource(uri, loadOnDemand);
        }
        finally {
            if (startedTxn) {
                try {
                    if (resource != null) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (ModelerCoreException e) {
                    throw new ModelerCoreRuntimeException((Throwable)e);
                }
            }
            if (resource != null && created) {
                resource.setModified(false);
            }
        }
        return resource;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        return this.resourceSet.getResourceFactoryRegistry();
    }

    public EList<Resource> getResources() {
        return this.resourceSet.getResources();
    }

    public URIConverter getURIConverter() {
        return this.resourceSet.getURIConverter();
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        this.resourceSet.setResourceFactoryRegistry(resourceFactoryRegistry);
    }

    public void setURIConverter(URIConverter converter) {
        this.resourceSet.setURIConverter(converter);
    }

    public EList<Adapter> eAdapters() {
        return this.resourceSet.eAdapters();
    }

    public boolean eDeliver() {
        return this.resourceSet.eDeliver();
    }

    public void eNotify(Notification notification) {
        this.resourceSet.eNotify(notification);
    }

    public void eSetDeliver(boolean deliver) {
        this.resourceSet.eSetDeliver(deliver);
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.setEditingDomain(this.createDefaultEditingDomain());
        }
        return this.editingDomain;
    }

    private boolean shouldProcess(Notification notification) {
        Object val;
        if (notification.getNotifier() != null && notification.getFeatureID(notification.getNotifier().getClass()) == 23) {
            return false;
        }
        switch (notification.getEventType()) {
            case 3: 
            case 5: {
                val = notification.getNewValue();
                break;
            }
            case 4: 
            case 6: {
                val = notification.getOldValue();
                break;
            }
            case 9: {
                return false;
            }
            case 1: 
            case 2: {
                boolean result = true;
                Object oldValue = notification.getOldValue();
                Object newValue = notification.getNewValue();
                if (oldValue == null) {
                    result = newValue != null;
                } else if (newValue != null) {
                    result = !oldValue.equals(newValue);
                }
                return result;
            }
            default: {
                return true;
            }
        }
        return val != null && (!(val instanceof Collection) || !((Collection)val).isEmpty()) && (!(val instanceof Object[]) || ((Object[])val).length != 0);
    }

    private boolean isExternalResourceSetMember(Resource theResource) {
        return ModelerCore.isResourceInExternalResourceSet(theResource);
    }

    protected void processNotification(Notification notification) {
        if (!this.shouldProcess(notification)) {
            return;
        }
        Resource resource = null;
        Object notifier = notification.getNotifier();
        int eventType = notification.getEventType();
        boolean doit = false;
        if (notifier instanceof Resource) {
            resource = (Resource)notifier;
            int featureId = notification.getFeatureID(resource.getClass());
            if (eventType != 8 && featureId != 4 && featureId != 3 && featureId != 0 && !this.isExternalResourceSetMember(resource)) {
                doit = true;
            }
        } else if (notifier instanceof EObject) {
            resource = ((EObject)notifier).eResource();
            doit = true;
        }
        Object feature = notification.getFeature();
        Object newVal = notification.getNewValue();
        String desc = feature == null ? null : ModelerCore.Util.getString("ContainerImpl.setFeatureDescription", new Object[]{feature, newVal});
        boolean xActionStarted = ModelerCore.startTxn(desc, this);
        boolean xActionSucceeded = false;
        try {
            ProcessedNotificationResult result;
            XResource xRes;
            try {
                Container ctnr = ModelerCore.getModelContainer();
                if (xActionStarted && CoreModelerPlugin.getTransactionManager() != null && feature != null && eventType == 1 && ctnr != null && notifier instanceof EObject && (!(resource instanceof XResource) || !((XResource)resource).isLoading())) {
                    CommandParameter prm = new CommandParameter(notifier, feature, newVal);
                    Command cmd = ((ContainerImpl)ctnr).getEditingDomain().createCommand(SetCommand.class, prm);
                    ((ModelEditorImpl)ModelerCore.getModelEditor()).postExecuteCommand((EObject)notifier, cmd);
                }
            }
            catch (CoreException err) {
                ModelerCore.Util.log((Throwable)err);
            }
            UnitOfWorkImpl txn = (UnitOfWorkImpl)this.getEmfTransactionProvider().getCurrent();
            boolean shouldCheckImports = false;
            if (resource != null && (shouldCheckImports = resource instanceof XResource ? !(xRes = (XResource)resource).isLoading() && !xRes.isUnloading() : true) && (result = ExternalResourceImportsHelper.processNotification(notification)) != null && !result.getDereferencedResources().isEmpty()) {
                txn.addProcessedNotificationResult(result);
            }
            if (doit && resource != null && !resource.isModified() && !txn.isRollingBack()) {
                resource.setModified(true);
            }
            try {
                if (txn.isStarted() || txn.isRollingBack()) {
                    txn.processNotification(notification);
                } else {
                    this.notifyForClosedUoW(txn, notification);
                }
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            xActionSucceeded = true;
        }
        finally {
            if (xActionStarted) {
                if (xActionSucceeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void debug(String heading, Notification notification) {
        System.out.println("\n" + heading + ":");
        Resource resource = null;
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource) {
            resource = (Resource)notifier;
        } else if (notifier instanceof EObject) {
            resource = ((EObject)notifier).eResource();
        }
        System.out.println("\tResource=" + resource);
        System.out.println("\tNotifier=" + notifier);
        System.out.print("\tType=");
        switch (notification.getEventType()) {
            case 3: {
                System.out.println("ADD");
                break;
            }
            case 5: {
                System.out.println("ADD_MANY");
                break;
            }
            case 7: {
                System.out.println("MOVE");
                break;
            }
            case 4: {
                System.out.println("REMOVE");
                break;
            }
            case 6: {
                System.out.println("REMOVE_MANY");
                break;
            }
            case 8: {
                System.out.println("REMOVING_ADAPTER");
                break;
            }
            case 9: {
                System.out.println("RESOLVE");
                break;
            }
            case 1: {
                System.out.println("SET");
                break;
            }
            case 2: {
                System.out.println("UNSET");
            }
        }
        int featureId = notification.getFeatureID(notification.getNotifier().getClass());
        System.out.println("\tFeature ID=" + featureId);
        if (notifier instanceof ResourceSet) {
            System.out.println("\tFeature=RESOURCES");
        } else if (notifier instanceof Resource) {
            System.out.print("\tFeature=");
            switch (featureId) {
                case 2: {
                    System.out.println("CONTENTS");
                    break;
                }
                case 6: {
                    System.out.println("ERRORS");
                    break;
                }
                case 4: {
                    System.out.println("IS_LOADED");
                    break;
                }
                case 3: {
                    System.out.println("IS_MODIFIED");
                    break;
                }
                case 5: {
                    System.out.println("IS_TRACKING_MODIFICATION");
                    break;
                }
                case 0: {
                    System.out.println("RESOURCE_SET");
                    break;
                }
                case 1: {
                    System.out.println("URI");
                    break;
                }
                case 7: {
                    System.out.println("WARNINGS");
                }
            }
        } else {
            System.out.println("\tFeature=" + notification.getFeature());
        }
        System.out.println("\tNew Value=" + notification.getNewValue());
        System.out.println("\tOld Value=" + notification.getOldValue());
    }

    private void notifyForClosedUoW(UnitOfWorkImpl txn, Notification msg) {
        MetamodelDescriptor descriptor;
        String nsUriString;
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject && !CoreStringUtil.isEmpty((String)(nsUriString = ((EObject)notifier).eClass().getEPackage().getNsURI())) && (descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUriString)) != null) {
            try {
                txn.begin();
                txn.setSource(this);
                txn.processNotification(msg);
                return;
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
            finally {
                if (txn.isStarted()) {
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e1) {
                        ModelerCore.Util.log(4, (Throwable)e1, e1.getMessage());
                    }
                }
            }
        }
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ContainerImpl.Could_not_process_notification_for_closed_txn_1", new Object[0]));
        }
    }

    protected void performStart() {
        MetamodelRegistry registry;
        this.setState(1);
        this.resourceSet = new EmfResourceSetImpl(this);
        this.resourceSet.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                ContainerImpl.this.processNotification(msg);
            }
        });
        this.resourceSet.setURIConverter((URIConverter)new ExtensibleURIConverterImpl());
        this.emfTransactionProvider = new UnitOfWorkProviderImpl(this.resourceSet);
        this.metamodelRegistry = registry = ModelerCore.getMetamodelRegistry();
        this.setState(2);
    }

    protected boolean isReadOnly(Resource resource) {
        File f;
        return resource != null && resource.getURI().isFile() && (f = new File(resource.getURI().toFileString())).exists() && !f.canWrite();
    }

    private void log(String msg) {
        if (ModelerCore.DEBUG) {
            ModelerCore.Util.log((Object)msg);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void addResourceDescriptor(ResourceDescriptor resourceDescriptor) throws ModelerCoreException {
        ResourceDescriptorImpl.register(resourceDescriptor, this.resourceSet);
    }

    @Override
    public void addExternalResourceSet(ResourceSet rsrcSet) {
        CoreArgCheck.isNotNull((Object)rsrcSet);
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            ((EmfResourceSetImpl)this.resourceSet).addExternalResourceSet(rsrcSet);
        }
    }

    @Override
    public ResourceSet[] getExternalResourceSets() {
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            return ((EmfResourceSetImpl)this.resourceSet).getExternalResourceSets();
        }
        return EMPTY_RESOURCE_SET_ARRAY;
    }

    @Override
    public Map getOptions() {
        return this.options == null ? Collections.EMPTY_MAP : this.options;
    }

    @Override
    public void setOptions(Map options) {
        this.verifySetIsAllowed(this.options);
        this.options = options;
    }

    public Resource createResource(URI uri, String contentType) {
        return this.resourceSet.createResource(uri, contentType);
    }
}

