/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.builder.AbstractTeiidProjectBuilder;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.notification.util.IgnorableNotificationSource;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.SearchIndexResourceVisitor;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class ModelBuilder
extends AbstractTeiidProjectBuilder
implements IgnorableNotificationSource {
    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject proj = this.getProject();
        proj.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
        ModelWorkspaceManager.getModelWorkspaceManager().notifyClean(proj);
        ModelWorkspaceManager.getModelWorkspaceManager().deleteIndexes((IResource)proj, visitor);
        for (IResource model : visitor.getResources()) {
            ModelResource resrc = ModelerCore.getModelWorkspace().findModelResource(model);
            if (resrc == null) continue;
            model.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            resrc.setIndexType(0);
        }
    }

    protected IProject[] buildInternal(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        switch (kind) {
            case 6: {
                this.performFullBuild(monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta delta = this.getDelta(project);
                if (delta == null) {
                    this.performFullBuild(monitor);
                    break;
                }
                this.performIncrementaBuild(monitor, delta);
            }
        }
        return null;
    }

    private void performFullBuild(final IProgressMonitor monitor) throws CoreException {
        final SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
        this.getProject().accept((IResourceVisitor)visitor);
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                Container container = ModelBuilder.this.doGetContainer();
                List resources = visitor.getResources();
                for (Object resource : resources) {
                    try {
                        ((IResource)resource).deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                    }
                    catch (CoreException e) {
                        ModelerCore.Util.log((Throwable)e);
                    }
                }
                ModelBuildUtil.buildResources(monitor, visitor.getResources(), container, false);
                ArrayList<IProject> projectResources = new ArrayList<IProject>(1);
                projectResources.add(ModelBuilder.this.getProject());
                ModelBuildUtil.buildResources(monitor, projectResources, container, false);
                return null;
            }
        };
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        ModelerCore.getModelEditor().executeAsTransaction(runnable, "Full Build", false, false, (Object)this);
        ModelBuildUtil.setModifiedResources(modifiedResources);
        this.cleanOrphanedIndexes();
    }

    private void performIncrementaBuild(final IProgressMonitor monitor, IResourceDelta delta) throws CoreException {
        class ResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            List resources = new ArrayList();

            ResourceDeltaVisitor() {
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (this.isIncludedResource(resource)) {
                    this.resources.add(resource);
                    resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                }
                return true;
            }

            public List getResources() {
                return this.resources;
            }

            private boolean isIncludedResource(IResource resource) {
                if (resource == null || !resource.exists()) {
                    return false;
                }
                return ModelUtil.isModelFile(resource) || ModelUtil.isXsdFile(resource) || ModelUtil.isVdbArchiveFile(resource);
            }
        }
        final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)visitor);
        TransactionRunnable runnable = new TransactionRunnable(){
            {
            }

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                List iResources = visitor.getResources();
                Collection<IFile> vdbResources = WorkspaceResourceFinderUtil.getVdbResourcesThatContain(iResources);
                for (IFile vdbResource : vdbResources) {
                    if (iResources.contains(vdbResource)) continue;
                    iResources.add(vdbResource);
                }
                Container container = ModelBuilder.this.doGetContainer();
                if (!iResources.contains(ModelBuilder.this.getProject())) {
                    iResources.add(ModelBuilder.this.getProject());
                }
                ModelBuildUtil.buildResources(monitor, iResources, container, false);
                return null;
            }
        };
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        ModelerCore.getModelEditor().executeAsTransaction(runnable, "Incremental Build", false, false, (Object)this);
        ModelBuildUtil.setModifiedResources(modifiedResources);
    }

    protected Container doGetContainer() throws ModelerCoreException {
        try {
            return ModelerCore.getModelContainer();
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    protected void cleanOrphanedIndexes() throws CoreException {
        IWorkspace workspace;
        IWorkspaceRoot root;
        IProject currentProj = this.getProject();
        LinkedList<IProject> builtProjects = new LinkedList<IProject>();
        if (currentProj != null && (root = (workspace = currentProj.getWorkspace()).getRoot()) != null) {
            IProject[] projects = root.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project != null && project.isAccessible()) {
                    if (!super.hasBeenBuilt(project) && !currentProj.equals((Object)project)) {
                        return;
                    }
                    builtProjects.add(project);
                }
                ++i;
            }
        }
        if (!builtProjects.isEmpty()) {
            SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
            for (IProject proj : builtProjects) {
                proj.accept((IResourceVisitor)visitor);
            }
            File[] indexFiles = new File(IndexUtil.INDEX_PATH).listFiles();
            int i = 0;
            while (i < indexFiles.length) {
                File indexFile = indexFiles[i];
                if (IndexUtil.isIndexFile(indexFile)) {
                    String fileName = indexFile.getName();
                    if (!visitor.getIndexNames().contains(fileName)) {
                        indexFile.delete();
                    }
                }
                ++i;
            }
        }
    }
}

