/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.association;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.association.AssociationDescriptor;

public abstract class AbstractAssociationDescriptor
implements AssociationDescriptor {
    protected static final AssociationDescriptor[] EMPTY_ARRAY = new AssociationDescriptor[0];
    private static final String PLUGIN_ID = "org.teiid.designer.core";
    private EObject newAssociation;
    private List eObjects;
    private IStatus status;
    private ArrayList children;
    private boolean ambiguous;
    private boolean creationComplete;

    protected AbstractAssociationDescriptor(List eObjects) {
        CoreArgCheck.isNotNull((Object)eObjects);
        this.eObjects = eObjects;
        this.status = new Status(0, PLUGIN_ID, -1, "", null);
        this.children = null;
        this.ambiguous = false;
    }

    @Override
    public abstract Object getImage();

    @Override
    public abstract String getText();

    @Override
    public abstract boolean isComplete();

    @Override
    public boolean creationComplete() {
        return this.creationComplete;
    }

    @Override
    public void setCreationComplete(boolean complete) {
        this.creationComplete = complete;
    }

    @Override
    public abstract String getType();

    @Override
    public AssociationDescriptor[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return EMPTY_ARRAY;
        }
        AssociationDescriptor[] result = new AssociationDescriptor[this.children.size()];
        this.children.toArray(result);
        return result;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public abstract EObject create() throws ModelerCoreException;

    public abstract boolean canCreate();

    public List getEObjects() {
        return this.eObjects;
    }

    public void setAmbiguous(boolean b) {
        this.ambiguous = b;
    }

    public void updateStatus(IStatus s) {
        if (s != null) {
            if (this.status.isMultiStatus()) {
                MultiStatus multiStatus = (MultiStatus)this.status;
                if (s.isMultiStatus()) {
                    multiStatus.addAll(s);
                } else {
                    multiStatus.add(s);
                }
            } else {
                this.status = s;
            }
        }
    }

    public void updateStatus(int severity, int code, String msg, Throwable e) {
        CoreArgCheck.isNotNull((Object)msg);
        this.updateStatus((IStatus)new Status(severity, PLUGIN_ID, code, msg, e));
    }

    public void addDescriptor(AssociationDescriptor descriptor) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (!this.children.contains(descriptor)) {
            this.children.add(descriptor);
        }
    }

    @Override
    public EObject getNewAssociation() {
        return this.newAssociation;
    }

    public void setAssociation(EObject association) {
        this.newAssociation = association;
    }
}

