/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.id.ObjectIDFactory;
import org.teiid.core.designer.id.UUID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.DebuggingStopwatch;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.common.xmi.XMIHeaderReader;
import org.teiid.designer.core.ClearReferencesUponDelete;
import org.teiid.designer.core.Configuration;
import org.teiid.designer.core.ExtensionDescriptor;
import org.teiid.designer.core.FindReferencesToDeletedObjects;
import org.teiid.designer.core.FindRelatedObjectsToBeCopied;
import org.teiid.designer.core.FindRelatedObjectsToDeleted;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ObjectExtension;
import org.teiid.designer.core.SafeRemoveCompoundCommand;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.XsdConcreteComponentAddCommand;
import org.teiid.designer.core.XsdObjectExtension;
import org.teiid.designer.core.association.AbstractAssociationDescriptor;
import org.teiid.designer.core.association.AssociationProvider;
import org.teiid.designer.core.container.CloneCommand;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerEditingDomain;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.container.EObjectFinder;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelRootClass;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAnnotationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeCheckerAspect;
import org.teiid.designer.core.resource.MMXmiResource;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;
import org.teiid.designer.core.search.DeleteRelatedWorkspaceSearch;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.core.util.DisabledCommand;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.custom.impl.XsdModelAnnotationImpl;
import org.teiid.designer.metamodels.core.extension.ExtensionFactory;
import org.teiid.designer.metamodels.core.extension.XClass;
import org.teiid.designer.metamodels.core.extension.XPackage;
import org.teiid.designer.metamodels.core.extension.impl.ExtensionFactoryImpl;
import org.teiid.designer.metamodels.diagram.Diagram;

public class ModelEditorImpl
implements ModelEditor {
    public static final String XML_SCHEMA_METAMODEL_URI = "http://www.eclipse.org/xsd/2002/XSD";
    private static final String NAME_FEATURE_NAME = "name";
    private static final String ESTRING_MAP_NAME = "EStringToStringMapEntry";
    protected static final String NEW = ModelerCore.Util.getString("ModelEditorImpl.New_1", new Object[0]);
    private static final ObjectIDFactory OBJECT_ID_FACTORY = IDGenerator.getInstance().getFactory("mmuuid");
    static final int BUFFER_LENGTH = 8192;
    private static final int UUID_PROTOCOL_LENGTH = "mmuuid".length();
    private static final int UUID_PREFIX_LENGTH = UUID_PROTOCOL_LENGTH + 1;
    private static ContainerImpl ctnr;

    public static ContainerImpl getContainer() {
        if (ctnr != null) {
            return ctnr;
        }
        try {
            return (ContainerImpl)ModelerCore.getModelContainer();
        }
        catch (CoreException err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
            return null;
        }
    }

    public static void setContainer(ContainerImpl container) {
        ctnr = container;
    }

    @Override
    public boolean isDatatypeFeature(EObject object, EStructuralFeature feature) {
        if (object == null || feature == null) {
            return false;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(object);
        if (aspect instanceof SqlDatatypeCheckerAspect) {
            return ((SqlDatatypeCheckerAspect)((Object)aspect)).isDatatypeFeature(object, feature);
        }
        return false;
    }

    @Override
    public Collection getTags(EObject obj) {
        Annotation annotation = this.getAnnotation(obj, false);
        if (annotation == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> tags = new ArrayList<Object>();
        for (EReference ref : annotation.eClass().getEReferences()) {
            Object val;
            if (ref.getEType() == null || ref.getEType().getName() == null || !ref.getEType().getName().equals(ESTRING_MAP_NAME) || (val = annotation.eGet((EStructuralFeature)ref)) == null) continue;
            tags.add(val);
        }
        return tags;
    }

    @Override
    public boolean equals(EObject eObject1, EObject eObject2) {
        String msg;
        if (eObject1 == null || eObject2 == null) {
            return false;
        }
        if (eObject1 == eObject2) {
            return true;
        }
        EObject eObj1 = eObject1;
        EObject eObj2 = eObject2;
        boolean eObjIsProxy1 = eObj1.eIsProxy();
        boolean eObjIsProxy2 = eObj2.eIsProxy();
        if (eObjIsProxy1 && eObjIsProxy2) {
            URI eProxyUri1 = EcoreUtil.getURI((EObject)eObj1);
            URI eProxyUri2 = EcoreUtil.getURI((EObject)eObj2);
            return eProxyUri1.equals(eProxyUri2);
        }
        if (eObjIsProxy1) {
            try {
                eObj1 = EcoreUtil.resolve((EObject)eObj1, (ResourceSet)ModelEditorImpl.getContainer());
            }
            catch (Exception e) {
                msg = ModelerCore.Util.getString("ModelEditorImpl.Error_getting_model_container._1", new Object[0]);
                ModelerCore.Util.log(4, (Throwable)e, msg);
            }
        }
        if (eObjIsProxy2) {
            try {
                eObj2 = EcoreUtil.resolve((EObject)eObj2, (ResourceSet)ModelEditorImpl.getContainer());
            }
            catch (Exception e) {
                msg = ModelerCore.Util.getString("ModelEditorImpl.Error_getting_model_container._2", new Object[0]);
                ModelerCore.Util.log(4, (Throwable)e, msg);
            }
        }
        return eObj1.equals(eObj2);
    }

    @Override
    public EObject createInitialModel(Resource resource, EClass eClass) throws ModelerCoreException {
        if (!ModelEditorImpl.isRootObject(eClass)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.{0}_is_not_a_valid_root_object_1", (Object)eClass.getName()));
        }
        EObject rootObject = this.create(eClass);
        if (rootObject != null) {
            resource.getContents().add((Object)rootObject);
        }
        return rootObject;
    }

    @Override
    public MetamodelDescriptor getMetamodelDescriptor(EObject object) {
        CoreArgCheck.isNotNull((Object)object);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        String uri = object.eClass().getEPackage().getNsURI();
        if (uri != null && cntr != null) {
            return cntr.getMetamodelRegistry().getMetamodelDescriptor(URI.createURI((String)uri));
        }
        if (uri != null && cntr == null) {
            return ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(URI.createURI((String)uri));
        }
        return null;
    }

    @Override
    public MetamodelDescriptor getPrimaryMetamodelDescriptor(ModelResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        return resource.getPrimaryMetamodelDescriptor();
    }

    @Override
    public MetamodelDescriptor getPrimaryMetamodelDescriptor(Resource resource) throws ModelWorkspaceException {
        MMXmiResource emfResource;
        String primaryMetamodelUri;
        CoreArgCheck.isNotNull((Object)resource);
        if (resource instanceof MMXmiResource && (primaryMetamodelUri = ModelEditorImpl.getPrimaryMetamodelURI((Resource)(emfResource = (MMXmiResource)resource))) != null && primaryMetamodelUri.length() != 0) {
            URI nsUri = ModelerCore.getMetamodelRegistry().getURI(primaryMetamodelUri);
            MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUri);
            if (descriptor == null) {
                StringBuffer sb = new StringBuffer();
                MetamodelDescriptor[] descriptors = ModelerCore.getMetamodelRegistry().getMetamodelDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    MetamodelDescriptor mmd = descriptors[i];
                    if (mmd.isPrimary() && !CoreStringUtil.isEmpty((String)mmd.getNamespaceURI())) {
                        sb.append(mmd.getNamespaceURI());
                        sb.append(CoreStringUtil.Constants.SPACE);
                    }
                    ++i;
                }
                Object[] params = new Object[]{primaryMetamodelUri, sb.toString()};
                String msg = ModelerCore.Util.getString("ModelResourceImpl.no_metamodel_found_for_primary_metamodel_URI", params);
                ModelerCore.Util.log(4, msg);
            }
            return descriptor;
        }
        ModelResource modelResource = this.findModelResource(resource);
        return this.getPrimaryMetamodelDescriptor(modelResource);
    }

    @Override
    public Collection getNewChildCommands(final EObject eObject) throws ModelerCoreException {
        final ContainerImpl container = ModelEditorImpl.getContainer();
        if (container != null) {
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) {
                    EditingDomain domain = container.getEditingDomain();
                    Collection result = domain.getNewChildDescriptors((Object)eObject, null);
                    ModelEditorImpl.setDescriptorOwner(result, eObject);
                    result = ModelEditorImpl.this.createCommands(result, domain);
                    return result != null ? result : Collections.EMPTY_LIST;
                }
            };
            Object result = this.executeAsTransaction(runnable, container, "Getting Child Commands", false, false, eObject);
            return result instanceof Collection ? (Collection)result : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean shouldBeDisabled(Object owner, CommandParameter commandParam) {
        if (owner instanceof EObject) {
            EObject parent = (EObject)owner;
            EStructuralFeature feature = commandParam.getEStructuralFeature();
            int maxMultiplicity = feature.getUpperBound();
            if (maxMultiplicity == -1) {
                return false;
            }
            if (maxMultiplicity > 1) {
                Object currentValue = parent.eGet(feature);
                int currentSize = ((List)currentValue).size();
                if (currentSize >= maxMultiplicity) {
                    return true;
                }
            } else {
                boolean isSet;
                try {
                    isSet = parent.eIsSet(feature);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return true;
                }
                if (isSet) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Collection getNewRootObjectCommands(Resource resource) {
        ContainerImpl container = ModelEditorImpl.getContainer();
        EditingDomain domain = container.getEditingDomain();
        Collection descriptors = this.getRootDescriptors(resource);
        return this.createCommands(descriptors, domain);
    }

    @Override
    public Collection getNewSiblingCommands(final EObject eObject) throws ModelerCoreException {
        final ContainerImpl container = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) {
                Collection descriptors = null;
                EditingDomain domain = container.getEditingDomain();
                if (eObject.eContainer() == null) {
                    URI nsUri = eObject.eClass().eResource().getURI();
                    List<MetamodelRootClass> rootClasses = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelRootClasses(nsUri));
                    ArrayList<MetamodelRootClass> filteredClasses = new ArrayList<MetamodelRootClass>(rootClasses.size());
                    for (MetamodelRootClass obj : rootClasses) {
                        boolean ignore;
                        String className = obj.getEClass().getName();
                        boolean bl = ignore = className.equalsIgnoreCase("BaseTable") || className.equalsIgnoreCase("Procedure") || className.equalsIgnoreCase("Index") || className.equalsIgnoreCase("View");
                        if (ignore) continue;
                        filteredClasses.add(obj);
                    }
                    EPackage ePackage = ModelerCore.getMetamodelRegistry().getEPackage(nsUri);
                    EFactory eFactory = ePackage.getEFactoryInstance();
                    descriptors = ModelEditorImpl.createSiblingDescriptors(filteredClasses, eFactory, eObject);
                    descriptors = ModelEditorImpl.this.createCommands(descriptors, domain);
                } else {
                    descriptors = domain.getNewChildDescriptors(null, (Object)eObject);
                    ModelEditorImpl.setDescriptorOwner(descriptors, eObject.eContainer());
                    descriptors = ModelEditorImpl.this.createCommands(descriptors, domain);
                }
                if (descriptors == null) {
                    return Collections.EMPTY_LIST;
                }
                return descriptors;
            }
        };
        Object result = this.executeAsTransaction(runnable, container, "Getting Sibling Commands", false, false, eObject);
        return result instanceof Collection ? (Collection)result : Collections.EMPTY_LIST;
    }

    @Override
    public Object executeAsTransaction(TransactionRunnable runnable, String description, boolean significant, Object source) throws ModelerCoreException {
        try {
            return this.executeAsTransaction(runnable, null, description, significant, source);
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    @Override
    public Object executeAsTransaction(TransactionRunnable runnable, String description, boolean significant, boolean undoable, Object source) throws ModelerCoreException {
        try {
            return this.executeAsTransaction(runnable, null, description, significant, undoable, source);
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    protected Object executeAsTransaction(TransactionRunnable runnable, Container container, String operationDescription, boolean isSignificant, boolean undoable, Object source) throws ModelerCoreException {
        if (container == null) {
            container = ModelEditorImpl.getContainer();
        }
        UnitOfWork uow = container.getEmfTransactionProvider().getCurrent();
        boolean startedTxn = false;
        if (uow.requiresStart()) {
            uow.begin();
            startedTxn = true;
            uow.setSignificant(isSignificant);
            uow.setSource(source);
            uow.setUndoable(undoable);
            if (operationDescription != null) {
                uow.setDescription(operationDescription);
            }
        }
        boolean failed = false;
        Object result = null;
        try {
            try {
                result = runnable.run(uow);
            }
            catch (ModelerCoreException t) {
                failed = true;
                throw t;
            }
            catch (RuntimeException t) {
                failed = true;
                throw new ModelerCoreRuntimeException((Throwable)t);
            }
        }
        finally {
            if (startedTxn) {
                if (!failed) {
                    try {
                        uow.commit();
                    }
                    catch (Throwable e) {
                        ModelerCore.Util.log(e);
                        failed = true;
                    }
                }
                if (failed) {
                    try {
                        uow.rollback();
                    }
                    catch (ModelerCoreException e1) {
                        ModelerCore.Util.log((Throwable)e1);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Object executeAsTransaction(TransactionRunnable runnable, Container container, String operationDescription, boolean isSignificant, Object source) throws ModelerCoreException {
        return this.executeAsTransaction(runnable, container, operationDescription, isSignificant, true, source);
    }

    @Override
    public EObject createNewChildFromCommand(final EObject parent, final Command cmd) throws ModelerCoreException {
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Child_for_{0}_1", (Object)this.getPresentationValue(parent));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, parent, cmd);
                EObject child = null;
                if (cmd.getResult() != null) {
                    child = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(child, String.valueOf(NEW) + child.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(child);
                }
                return child;
            }
        };
        EObject child = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return child;
    }

    protected void setUuidFeatureValue(EObject eObj) {
    }

    @Override
    public EObject createNewRootObjectFromCommand(final Resource parent, final Command cmd) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)cmd);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Child_for_{0}_1", (Object)this.getPresentationValue(parent));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, parent, cmd);
                EObject child = null;
                if (cmd.getResult() != null) {
                    child = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(child, String.valueOf(NEW) + child.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(child);
                }
                return child;
            }
        };
        EObject child = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return child;
    }

    @Override
    public EObject createNewSiblingFromCommand(final EObject sibling, final Command cmd) throws ModelerCoreException {
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Sibling_for_{0}_2", (Object)this.getPresentationValue(sibling));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, sibling, cmd);
                EObject newSibling = null;
                if (cmd.getResult() != null) {
                    newSibling = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(newSibling, String.valueOf(NEW) + newSibling.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(newSibling);
                }
                return newSibling;
            }
        };
        EObject newSibling = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return newSibling;
    }

    @Override
    public EObject createNewAssociationFromDescriptor(Object descriptor) throws ModelerCoreException {
        AbstractAssociationDescriptor assocDescr;
        if (descriptor != null && descriptor instanceof AbstractAssociationDescriptor && (assocDescr = (AbstractAssociationDescriptor)descriptor).isComplete()) {
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_new_Association_3", new Object[0]);
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EObject result = null;
                    result = assocDescr.isAmbiguous() ? ((AbstractAssociationDescriptor)assocDescr.getChildren()[0]).create() : assocDescr.create();
                    ModelEditorImpl.this.renameInternal(result, String.valueOf(NEW) + result.eClass().getName());
                    return result;
                }
            };
            EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
            return result;
        }
        return null;
    }

    @Override
    public Collection getNewAssociationDescriptors(List eObjects) throws ModelerCoreException {
        Configuration config = ModelerCore.getConfiguration();
        List descriptors = config.getAssociationProviderDescriptors();
        HashSet result = new HashSet(descriptors.size());
        for (ExtensionDescriptor descriptor : descriptors) {
            AssociationProvider provider = (AssociationProvider)descriptor.getExtensionClassInstance();
            if (provider == null) continue;
            result.addAll(provider.getNewAssociationDescriptors(eObjects));
        }
        return result;
    }

    @Override
    public EObject copy(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        return this.copy(eObject, null);
    }

    @Override
    public EObject copy(final EObject eObject, final Map originalsToCopies) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_4", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CopyCommand.Helper helper = new CopyCommand.Helper();
                if (originalsToCopies != null && !originalsToCopies.isEmpty()) {
                    helper.putAll(originalsToCopies);
                }
                Command command = ModelEditorImpl.createCopyCommand(ed, eObject, helper);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                EObject result = null;
                if (command.getResult() != null) {
                    result = (EObject)command.getResult().iterator().next();
                    ModelEditorImpl.this.setUuidFeatureValue(result);
                }
                if (originalsToCopies != null) {
                    originalsToCopies.putAll(helper);
                }
                return result;
            }
        };
        EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    @Override
    public Collection copyMultiple(final EObject eObject, final int numCopies) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isPositive((int)numCopies);
        final ArrayList copies = new ArrayList(numCopies);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_4", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                while (copies.size() < numCopies) {
                    Command command = CopyCommand.create((EditingDomain)ed, (Object)eObject);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                    if (command.getResult() != null) {
                        EObject copy = (EObject)command.getResult().iterator().next();
                        ModelEditorImpl.this.setUuidFeatureValue(copy);
                        copies.add(copy);
                        continue;
                    }
                    throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Error_creating_copies_1", new Object[0]));
                }
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return copies;
    }

    @Override
    public boolean delete(Collection eObjects) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObjects);
        if (eObjects.isEmpty()) {
            return false;
        }
        boolean result = this.delete(eObjects, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    @Override
    public boolean delete(final Collection eObjects, final IProgressMonitor monitor) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObjects);
        if (eObjects.isEmpty()) {
            return false;
        }
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Delete_multiple_objects_1", new Object[0]);
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = ModelEditorImpl.this.createDeleteManyCommand(ed, eObjects, monitor);
                monitor.subTask(ModelerCore.Util.getString("ModelEditorImpl.executingDeleteMsg", new Object[0]));
                monitor.worked(5);
                if (!monitor.isCanceled()) {
                    ModelEditorImpl.this.executeCommandInTransaction(uow, null, command);
                }
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public Command createDeleteManyCommand(EditingDomain ed, Collection eObjects, IProgressMonitor monitor) throws ModelerCoreException {
        HashMap objectsByContainment = new HashMap();
        boolean ignoreXsdResources = !this.includesXsdObject(eObjects);
        DebuggingStopwatch watch = new DebuggingStopwatch("ModelEditorImpl.createDeleteManyCommand(EObject) Ignore XSD's = " + ignoreXsdResources, 10, false);
        watch.start();
        watch.startStats();
        LinkedList<Command> commands = new LinkedList<Command>();
        for (EObject eObject : eObjects) {
            Resource owner = eObject.eContainer() == null ? eObject.eResource() : eObject.eContainer();
            EReference feature = eObject.eContainmentFeature();
            Object existing = objectsByContainment.get(owner);
            if (existing == null) {
                existing = feature == null ? new HashSet() : new HashMap();
                objectsByContainment.put(owner, existing);
            }
            if (existing instanceof Collection) {
                ((Collection)existing).add(eObject);
                continue;
            }
            if (!(existing instanceof Map)) continue;
            HashSet<EObject> objectsByFeature = (HashSet<EObject>)((Map)existing).get(feature);
            if (objectsByFeature == null) {
                objectsByFeature = new HashSet<EObject>();
            }
            objectsByFeature.add(eObject);
            ((Map)existing).put(feature, objectsByFeature);
        }
        monitor.worked(5);
        DeleteRelatedWorkspaceSearch workspaceSearch = new DeleteRelatedWorkspaceSearch(ignoreXsdResources);
        Collection allDeleted = this.findOtherObjectsToBeDeleted(eObjects, ed, commands, workspaceSearch, monitor);
        monitor.worked(10);
        this.findReferencesToObjectsBeingDeleted(allDeleted, ed, commands, workspaceSearch, monitor);
        monitor.subTask(ModelerCore.Util.getString("ModelEditorImpl.preparingCommandMsg", new Object[0]));
        monitor.worked(10);
        Iterator iter1 = objectsByContainment.entrySet().iterator();
        while (iter1.hasNext()) {
            if (monitor.isCanceled()) break;
            Map.Entry entry1 = iter1.next();
            Object key = entry1.getKey();
            if (key instanceof EObject) {
                EObject parent = (EObject)key;
                Map objectsByFeature = (Map)entry1.getValue();
                for (Map.Entry entry2 : objectsByFeature.entrySet()) {
                    Command command;
                    CommandParameter param;
                    EReference ref = (EReference)entry2.getKey();
                    Collection objects = (Collection)entry2.getValue();
                    if (ref.isMany()) {
                        param = new CommandParameter((Object)parent, (Object)ref, objects);
                        command = ed.createCommand(RemoveCommand.class, param);
                        commands.addFirst(command);
                        continue;
                    }
                    param = new CommandParameter((Object)parent, (Object)ref, null);
                    command = ed.createCommand(SetCommand.class, param);
                    commands.addFirst(command);
                }
                continue;
            }
            Collection values = (Collection)entry1.getValue();
            Resource parent = (Resource)key;
            EList contents = parent.getContents();
            CommandParameter param = new CommandParameter((Object)parent, (Object)contents, values);
            Command command = ed.createCommand(RemoveCommand.class, param);
            commands.addFirst(command);
        }
        Collection finalEObjects = Collections.EMPTY_LIST;
        LinkedList<Command> finalCommands = Collections.EMPTY_LIST;
        if (!monitor.isCanceled()) {
            finalEObjects = eObjects;
            finalCommands = commands;
        }
        CompoundCommand cCommand = CompoundCommandFactory.create(finalEObjects, finalCommands);
        watch.stop();
        watch.stopStats();
        return cCommand;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean includesXsdObject(Object obj) {
        try {
            ModelResource mr;
            Object nextObj;
            if (obj instanceof EObject) {
                ModelResource mr2 = this.findModelResource((EObject)obj);
                if (mr2 == null) return false;
                if (mr2.getEmfResource() == null) return false;
                if (!ModelUtil.isXsdFile(mr2.getEmfResource())) return false;
                return true;
            }
            if (!(obj instanceof Collection)) return false;
            Collection theObjs = (Collection)obj;
            Iterator iter = theObjs.iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!((nextObj = iter.next()) instanceof EObject) || (mr = this.findModelResource((EObject)nextObj)) == null || mr.getEmfResource() == null || !ModelUtil.isXsdFile(mr.getEmfResource()));
            return true;
        }
        catch (ModelWorkspaceException theException) {
            ModelerCore.Util.log((Throwable)((Object)theException));
        }
        return false;
    }

    @Override
    public boolean delete(final EObject eObject, boolean performResourceCheck, final boolean performRelatedObjectCheck) throws ModelerCoreException {
        Resource resource;
        CoreArgCheck.isNotNull((Object)eObject);
        if (performResourceCheck && (resource = eObject.eResource()) == null) {
            return false;
        }
        final boolean ignoreXsdResources = !this.includesXsdObject(eObject);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Delete_{0}_5", (Object)this.getPresentationValue(eObject));
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                DebuggingStopwatch watch = new DebuggingStopwatch("ModelEditorImpl.delete(EObject)  Ignore XSD's = " + ignoreXsdResources, 10, false);
                watch.start();
                watch.startStats();
                EditingDomain ed = cntr.getEditingDomain();
                Command command = ModelEditorImpl.createDeleteCommand(ed, eObject);
                if (command == null) {
                    return null;
                }
                if (performRelatedObjectCheck) {
                    LinkedList<Command> additionalCommands = new LinkedList<Command>();
                    Resource emfResource = eObject.eResource();
                    if (emfResource != null) {
                        DeleteRelatedWorkspaceSearch workspaceSearch = new DeleteRelatedWorkspaceSearch(ignoreXsdResources);
                        Collection allDeleted = ModelEditorImpl.this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, workspaceSearch);
                        ModelEditorImpl.this.findReferencesToObjectsBeingDeleted(allDeleted, ed, additionalCommands, workspaceSearch);
                        if (!additionalCommands.isEmpty()) {
                            additionalCommands.addFirst(command);
                            command = CompoundCommandFactory.create(eObject, additionalCommands);
                        }
                    }
                }
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                watch.stop();
                watch.stopStats();
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    @Override
    public boolean delete(EObject eObject, boolean performResourceCheck) throws ModelerCoreException {
        return this.delete(eObject, performResourceCheck, true);
    }

    @Override
    public boolean delete(EObject eObject) throws ModelerCoreException {
        return this.delete(eObject, true);
    }

    protected static Command createDeleteCommand(EditingDomain editingDomain, EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        RemoveCommand command = null;
        if (eObject.eContainer() == null) {
            EList contents;
            Resource rsrc = eObject.eResource();
            if (rsrc != null && (contents = rsrc.getContents()).contains((Object)eObject)) {
                command = new RemoveCommand(editingDomain, contents, (Object)eObject);
            }
        } else {
            EReference sf = eObject.eContainmentFeature();
            if (sf.isMany()) {
                HashSet<EObject> collection = new HashSet<EObject>(1);
                collection.add(eObject);
                CommandParameter param = new CommandParameter((Object)eObject.eContainer(), (Object)sf, collection);
                command = editingDomain.createCommand(RemoveCommand.class, param);
            } else {
                CommandParameter param = new CommandParameter((Object)eObject.eContainer(), (Object)sf, null);
                command = editingDomain.createCommand(SetCommand.class, param);
            }
        }
        return command;
    }

    @Override
    public void findReferencesToObjectsBeingDeleted(Collection allDeleted, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        this.findReferencesToObjectsBeingDeleted(allDeleted, editingDomain, additionalCommands, workspaceSearch, (IProgressMonitor)new NullProgressMonitor());
    }

    public void findReferencesToObjectsBeingDeleted(Collection allDeleted, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch, IProgressMonitor monitor) throws ModelerCoreException {
        List removeAndSetCommands;
        int iObj = 1;
        int nObj = allDeleted.size();
        int iInc = 1;
        int halfWay = nObj / 2;
        boolean pastHalfWay = false;
        iInc = nObj < 20 ? 1 : (nObj < 100 ? 10 : (nObj < 500 ? 25 : 100));
        String startMessage = String.valueOf(ModelerCore.Util.getString("ModelEditorImpl.searchingReferencesMsg", new Object[0])) + CoreStringUtil.Constants.SPACE;
        String ofText = "  " + ModelerCore.Util.getString("ModelEditorImpl.ofText", new Object[0]) + CoreStringUtil.Constants.SPACE;
        ClearReferencesUponDelete visitor = new ClearReferencesUponDelete(allDeleted, editingDomain, workspaceSearch);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        Iterator iter = allDeleted.iterator();
        while (iter.hasNext()) {
            EObject eObject;
            if (iObj % iInc == 0) {
                String message = String.valueOf(startMessage) + iObj + ofText + nObj;
                monitor.subTask(message);
            }
            if ((eObject = (EObject)iter.next()).eResource() == null) continue;
            processor.walk(eObject, 2);
            ++iObj;
            if (monitor.isCanceled()) break;
            if (pastHalfWay || iObj <= halfWay) continue;
            monitor.worked(10);
            pastHalfWay = true;
        }
        monitor.worked(10);
        if (!monitor.isCanceled() && (removeAndSetCommands = visitor.getAdditionalCommands()) != null && !removeAndSetCommands.isEmpty()) {
            this.addCommands(removeAndSetCommands, additionalCommands);
        }
    }

    private void addCommands(List removeAndSetCommands, List additionalCommands) {
        Object command2 = null;
        boolean addCommand = true;
        for (Object command2 : removeAndSetCommands) {
            if (command2 instanceof RemoveCommand) {
                addCommand = true;
                for (Object additionalCommand : additionalCommands) {
                    if (!(additionalCommand instanceof RemoveCommand) || !((RemoveCommand)additionalCommand).getOwner().equals(((RemoveCommand)command2).getOwner()) || ((RemoveCommand)additionalCommand).getCollection().size() != ((RemoveCommand)command2).getCollection().size() || !((RemoveCommand)additionalCommand).getCollection().containsAll(((RemoveCommand)command2).getCollection())) continue;
                    addCommand = false;
                    break;
                }
                if (!addCommand) continue;
                additionalCommands.add(command2);
                continue;
            }
            additionalCommands.add(command2);
        }
    }

    @Override
    public List findRelatedObjects(Collection objects, EditingDomain domain) {
        if (domain instanceof ContainerEditingDomain) {
            FindRelatedObjectsToBeCopied visitor = new FindRelatedObjectsToBeCopied();
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            try {
                processor.walk(objects, 2);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            return new ArrayList(visitor.getAdditionalObjects());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection findExternalReferencesToObjectsBeingDeleted(EObject eObject, Collection allDeleted) {
        HashSet<EObject> allDeletedObjects;
        CoreArgCheck.isNotNull((Object)eObject);
        Resource resource = eObject.eResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Object> hashSet = allDeletedObjects = allDeleted == null ? new HashSet<EObject>() : new HashSet(allDeleted);
        if (!allDeletedObjects.contains(eObject)) {
            allDeletedObjects.add(eObject);
        }
        FindReferencesToDeletedObjects visitor = new FindReferencesToDeletedObjects(allDeleted);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            processor.walk(resource, 2);
        }
        catch (Throwable t) {
            ModelerCore.Util.log(4, t, t.getMessage());
        }
        return visitor.getReferencesToDeletedObjects();
    }

    protected Collection findOtherObjectsToBeDeleted(EObject eObject, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        EditingDomain ed = cntr.getEditingDomain();
        LinkedList additionalCommands = new LinkedList();
        return this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, workspaceSearch);
    }

    @Override
    public Collection findOtherObjectsToBeDeleted(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        EditingDomain ed = cntr.getEditingDomain();
        LinkedList additionalCommands = new LinkedList();
        boolean ignoreXsdResources = !this.includesXsdObject(eObject);
        DeleteRelatedWorkspaceSearch search = new DeleteRelatedWorkspaceSearch(ignoreXsdResources);
        return this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, search);
    }

    @Override
    public Collection findOtherObjectsToBeDeleted(Collection eObjects, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        return this.findOtherObjectsToBeDeleted(eObjects, editingDomain, additionalCommands, workspaceSearch, (IProgressMonitor)new NullProgressMonitor());
    }

    public Collection findOtherObjectsToBeDeleted(Collection eObjects, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch, IProgressMonitor monitor) throws ModelerCoreException {
        HashSet rv = new HashSet();
        int iObj = 1;
        int nObj = eObjects.size();
        int halfWay = nObj / 2;
        boolean pastHalfWay = false;
        String startMessage = String.valueOf(ModelerCore.Util.getString("ModelEditorImpl.searchingRelatedMsg", new Object[0])) + CoreStringUtil.Constants.SPACE;
        String ofText = "  " + ModelerCore.Util.getString("ModelEditorImpl.ofText", new Object[0]) + CoreStringUtil.Constants.SPACE;
        Iterator itor = eObjects.iterator();
        while (itor.hasNext()) {
            String message = String.valueOf(startMessage) + "  " + iObj + ofText + nObj;
            ++iObj;
            monitor.subTask(message);
            EObject eObject = (EObject)itor.next();
            Resource resource = eObject.eResource();
            if (resource == null) continue;
            LinkedList<EObject> objectsToDelete = new LinkedList<EObject>();
            objectsToDelete.addFirst(eObject);
            FindRelatedObjectsToDeleted visitor = new FindRelatedObjectsToDeleted(eObject, editingDomain, objectsToDelete, this.getRemovedObjectsForCurrentTxn(), workspaceSearch);
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            while (!objectsToDelete.isEmpty() && !monitor.isCanceled()) {
                processor.walk((EObject)objectsToDelete.getFirst(), 2);
            }
            if (!monitor.isCanceled()) {
                if (visitor.getAdditionalDeleteCommands() != null && !visitor.getAdditionalDeleteCommands().isEmpty()) {
                    additionalCommands.addAll(visitor.getAdditionalDeleteCommands());
                }
                rv.addAll(visitor.getAllDeletedObjects());
            }
            if (pastHalfWay || iObj <= halfWay) continue;
            monitor.worked(10);
            pastHalfWay = true;
        }
        monitor.worked(10);
        if (monitor.isCanceled()) {
            rv.clear();
        }
        return rv;
    }

    private Collection getRemovedObjectsForCurrentTxn() {
        try {
            ContainerImpl container = ModelEditorImpl.getContainer();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)container.getEmfTransactionProvider().getCurrent();
            return uow.getRemovedEObjects();
        }
        catch (Exception exception) {
            return new HashSet();
        }
    }

    @Override
    public boolean rename(final EObject eObject, final String newName) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        final EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature == null) {
            return false;
        }
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Rename_{0}_6", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = SetCommand.create((EditingDomain)ed, (Object)eObject, (Object)nameFeature, (Object)newName);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    @Override
    public EStructuralFeature getNameFeature(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EClass eClass = eObject.eClass();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!NAME_FEATURE_NAME.equalsIgnoreCase(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public String getName(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature == null) {
            return null;
        }
        Object value = eObject.eGet(nameFeature);
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean hasName(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        return nameFeature != null;
    }

    protected boolean renameInternal(EObject eObject, String newName) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature != null) {
            this.generateUniqueInternalName(eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents(), eObject, nameFeature, newName);
            return true;
        }
        return false;
    }

    private void generateUniqueInternalName(EList siblings, EObject eObject, EStructuralFeature nameFeature, String name) {
        String newName = name;
        if (siblings != null && eObject.eGet(nameFeature) == null) {
            HashSet<Object> siblingNames = new HashSet<Object>();
            for (EObject child : siblings) {
                if (!eObject.getClass().equals(child.getClass())) continue;
                siblingNames.add(child.eGet(nameFeature));
            }
            boolean foundUniqueName = false;
            int index = 1;
            while (!foundUniqueName) {
                if (siblingNames.contains(newName)) {
                    newName = String.valueOf(name) + String.valueOf(index++);
                    continue;
                }
                foundUniqueName = true;
            }
        }
        eObject.eSet(nameFeature, (Object)newName);
    }

    @Override
    public void executeCommand(final EObject owner, final Command cmd) throws ModelerCoreException {
        String operationDescription = null;
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, owner, cmd);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    public void postExecuteCommand(final EObject owner, final Command cmd) throws ModelerCoreException {
        this.executeAsTransaction(new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ((UnitOfWorkImpl)uow).setAlreadyExecuted(true);
                ModelEditorImpl.this.executeCommandInTransaction(uow, owner, cmd);
                return null;
            }
        }, ModelEditorImpl.getContainer(), null, true, (Object)this);
    }

    protected void executeCommandInTransaction(UnitOfWork uow, Object owner, Command cmd) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)uow);
        if (cmd == null || !cmd.canExecute()) {
            String nullMsg = ModelerCore.Util.getString("ModelEditorImpl.Can_not_execute_a_null_command_1", new Object[0]);
            String reason = cmd == null ? nullMsg : this.getCmdFailureReason(cmd);
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Unable_to_execute_Command_1", (Object)reason));
        }
        uow.executeCommand(cmd);
    }

    protected String getCmdFailureReason(Command cmd) {
        StringBuffer failures;
        block50: {
            failures = new StringBuffer();
            failures.append(cmd.toString());
            try {
                EReference eReference;
                if (cmd instanceof CompoundCommand && !cmd.canExecute()) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl.Compound_Command_with_unexecutable_children_1", new Object[0]));
                    break block50;
                }
                if (cmd instanceof AddCommand && !cmd.canExecute()) {
                    AddCommand add = (AddCommand)cmd;
                    if (add.getOwnerList() == null || add.getCollection() == null || add.getCollection().size() == 0 || add.getIndex() != -1 && (add.getIndex() < 0 || add.getIndex() > add.getOwnerList().size())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl.Invalid_index_for_Add_operation_2", new Object[0]));
                        return failures.toString();
                    }
                    for (Object object : add.getCollection()) {
                        if (add.getFeature() == null || add.getFeature().getEType().isInstance(object)) continue;
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_item_of_type_{0}_to_feature_{1}_3", new Object[]{object.getClass().getName(), add.getFeature().getName()}));
                    }
                    if (add.getFeature() instanceof EReference && ((EReference)add.getFeature()).isContainment()) {
                        EObject container = add.getOwner();
                        while (container != null) {
                            if (add.getCollection().contains(container)) {
                                failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_to_a_contained_object_4", new Object[0]));
                                return failures.toString();
                            }
                            container = container.eContainer();
                        }
                    }
                    break block50;
                }
                if (cmd instanceof CopyToClipboardCommand && !cmd.canExecute()) {
                    if (((CopyToClipboardCommand)cmd).getSourceObjects() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nSource_Objects_collection_may_not_be_null_for_Copy_operation_5", new Object[0]));
                    } else if (((CopyToClipboardCommand)cmd).getSourceObjects().isEmpty()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nSource_Objects_collection_may_not_be_empty_for_Copy_operation_6", new Object[0]));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnable_to_execute_copy_to_clipboard_command_7", new Object[0]));
                    }
                    break block50;
                }
                if (cmd instanceof CommandWrapper && !cmd.canExecute()) {
                    Command tmp = ((CommandWrapper)cmd).getCommand();
                    if (tmp != null && tmp != UnexecutableCommand.INSTANCE) {
                        return this.getCmdFailureReason(tmp);
                    }
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nWrapped_command_may_not_be_null_or_Unexecutable_8", new Object[0]));
                    break block50;
                }
                if (cmd instanceof CreateCopyCommand && !cmd.canExecute()) {
                    if (((CreateCopyCommand)cmd).getOwner() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_create_copy_of_NULL_object_9", new Object[0]));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Create_Copy_command_10", new Object[0]));
                    }
                    break block50;
                }
                if (cmd instanceof MoveCommand && !cmd.canExecute()) {
                    MoveCommand tmp = (MoveCommand)cmd;
                    if (tmp.getOwnerList() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_may_not_be_null_for_a_Move_Command_11", new Object[0]));
                    } else if (!tmp.getOwnerList().contains(tmp.getValue())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_must_contain_value_for_a_Move_Command_12", new Object[0]));
                    } else if (tmp.getIndex() < tmp.getOwnerList().size()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nInvalid_index_for_Move_Command_13", new Object[0]));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_for_Move_Command_14", new Object[0]));
                    }
                    break block50;
                }
                if (cmd instanceof PasteFromClipboardCommand && !cmd.canExecute()) {
                    PasteFromClipboardCommand tmp = (PasteFromClipboardCommand)cmd;
                    Collection copies = tmp.getChildrenToCopy();
                    if (copies == null || copies.isEmpty()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nNo_objects_found_to_paste_15", new Object[0]));
                        return failures.toString();
                    }
                    if (tmp.getFeature() != null && tmp.getFeature() instanceof EStructuralFeature) {
                        EStructuralFeature feature = (EStructuralFeature)tmp.getFeature();
                        for (Object object : copies) {
                            if (feature.getEType().isInstance(object)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_paste_item_of_type_{0}_to_feature_{1}_16", new Object[]{object.getClass().getName(), feature.getName()}));
                        }
                    }
                    if (tmp.getOwner() instanceof EObject && tmp.getFeature() instanceof EReference && ((EReference)tmp.getFeature()).isContainment()) {
                        EObject container = (EObject)tmp.getOwner();
                        while (container != null) {
                            if (copies.contains(container)) {
                                failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_to_a_contained_object_17", new Object[0]));
                                return failures.toString();
                            }
                            container = container.eContainer();
                        }
                    }
                    if (failures.length() == 0) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Paste_From_Clipboard_command_18", new Object[0]));
                    }
                    break block50;
                }
                if (cmd instanceof RemoveCommand && !cmd.canExecute()) {
                    RemoveCommand removeCmd = (RemoveCommand)cmd;
                    if (removeCmd.getOwnerList() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_may_not_be_null_19", new Object[0]));
                    } else if (!removeCmd.getOwnerList().containsAll(removeCmd.getCollection())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_must_contain_all_values_to_be_removed_20", new Object[0]));
                    }
                    if (failures.length() == 0) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Remove_command_21", new Object[0]));
                    }
                    break block50;
                }
                if (!(cmd instanceof SetCommand) || cmd.canExecute()) break block50;
                SetCommand tmp = (SetCommand)cmd;
                EObject owner = tmp.getOwner();
                EStructuralFeature feature = tmp.getFeature();
                Object value = tmp.getValue();
                if (feature == null) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_set_value_on_null_feature_22", new Object[0]));
                    return failures.toString();
                }
                if (owner == null) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_set_value_on_null_owner_23", new Object[0]));
                    return failures.toString();
                }
                EClass eMetaObject = owner.eClass();
                if (eMetaObject.getEAllAttributes().contains((Object)feature)) {
                    EAttribute eAttribute = (EAttribute)feature;
                    EClassifier eType = eAttribute.getEType();
                    if (eAttribute.isMany() && value instanceof EList) {
                        EList list = (EList)value;
                        for (Object next : list) {
                            if (eType.isInstance(next)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_of_type_{0}_to_feature_{1}_24", new Object[]{next.getClass().getName(), tmp.getFeature().getName()}));
                        }
                    }
                } else if (eMetaObject.getEAllReferences().contains((Object)feature) && !(eReference = (EReference)feature).isMany() && (value == null || eReference.getEType().isInstance(value)) && eReference.isContainment()) {
                    EObject container = owner;
                    while (container != null) {
                        if (value == container) {
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nMay_not_add_value_to_contained_object_25", new Object[0]));
                            break;
                        }
                        container = container.eContainer();
                    }
                }
                if (failures.length() == 0) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_executing_Set_command_26", new Object[0]));
                }
            }
            catch (Exception exception) {}
        }
        if (failures.length() == 0) {
            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_executing_command___Command_not_executable_27", new Object[0]));
        }
        return failures.toString();
    }

    @Override
    public boolean move(Object newParent, EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)newParent);
        CoreArgCheck.isNotNull((Object)eObject);
        if (!this.isValidParent(newParent, eObject)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Invalid_parent_for_child_encountered_1", new Object[0]));
        }
        int index = 0;
        if (newParent instanceof EObject) {
            EObject eParent = (EObject)newParent;
            EReference ref = this.getChildReference(eParent, eObject);
            if (ref != null && ref.isMany() && eParent.eGet((EStructuralFeature)ref) instanceof EList) {
                index = ((EList)eParent.eGet((EStructuralFeature)ref)).size();
            }
        } else if (newParent instanceof Resource) {
            index = ((Resource)newParent).getContents().size();
        }
        return this.move(newParent, eObject, index);
    }

    @Override
    public boolean move(final Object newParent, final EObject eObject, final int index) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)newParent);
        CoreArgCheck.isNotNull((Object)eObject);
        if (!this.isValidParent(newParent, eObject)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Invalid_parent_for_child_encountered_1", new Object[0]));
        }
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Move_{0}_7", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = null;
                if (eObject.eContainer() != null && eObject.eContainer() == newParent) {
                    command = MoveCommand.create((EditingDomain)ed, (Object)newParent, null, (Object)eObject, (int)index);
                } else {
                    if (eObject.eContainer() != null) {
                        command = RemoveCommand.create((EditingDomain)ed, (Object)eObject.eContainer(), (Object)eObject.eContainmentFeature(), (Object)eObject);
                        ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                    }
                    command = AddCommand.create((EditingDomain)ed, (Object)newParent, null, (Object)eObject, (int)index);
                }
                ModelEditorImpl.this.executeCommandInTransaction(uow, newParent, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    @Override
    public void copyToClipboard(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        ArrayList<EObject> objects = new ArrayList<EObject>(1);
        objects.add(eObject);
        this.copyAllToClipboard(objects);
    }

    @Override
    public void copyAllToClipboard(final Collection eObjects) throws ModelerCoreException {
        CoreArgCheck.isNotEmpty((Collection)eObjects);
        final EObject eObject = (EObject)eObjects.iterator().next();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_8", (Object)this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = CopyToClipboardCommand.create((EditingDomain)ed, (Collection)eObjects);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
    }

    @Override
    public void cutToClipboard(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        ArrayList<EObject> objects = new ArrayList<EObject>(1);
        objects.add(eObject);
        this.cutAllToClipboard(objects);
    }

    @Override
    public void cutAllToClipboard(final Collection eObjects) throws ModelerCoreException {
        CoreArgCheck.isNotEmpty((Collection)eObjects);
        final EObject eObject = (EObject)eObjects.iterator().next();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Cut_{0}_9", (Object)this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CompoundCommand command = CompoundCommandFactory.create(eObjects, new ArrayList(1));
                command.append(CutToClipboardCommand.create((EditingDomain)ed, (Collection)eObjects));
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, (Command)command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    @Override
    public boolean pasteFromClipboard(final Object owner) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)owner);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Paste_{0}_10", (Object)this.getPresentationValue(owner));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Object realOwner = owner instanceof ModelResource ? ((ModelResource)owner).getEmfResource() : owner;
                Command command = PasteFromClipboardCommand.create((EditingDomain)ed, (Object)realOwner, null);
                ModelEditorImpl.this.executeCommandInTransaction(uow, realOwner, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    @Override
    public Collection getClipboardContents(Object target) {
        try {
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            EditingDomain ed = cntr.getEditingDomain();
            Collection content = ed.getClipboard();
            if (content != null) {
                return Collections.unmodifiableCollection(ed.getClipboard());
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public Map getClipboardContentsOriginalToCopyMapping(Object target) {
        try {
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            EditingDomain ed = cntr.getEditingDomain();
            if (ed instanceof ContainerEditingDomain) {
                ContainerEditingDomain ced = (ContainerEditingDomain)ed;
                return ced.getClipboardContentsOriginalToCopyMapping();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @Override
    public Map getClipboardContentsCopyToOriginalMapping(Object target) {
        Map originalToCopy = this.getClipboardContentsOriginalToCopyMapping(target);
        if (originalToCopy != null) {
            HashMap copyToOriginal = new HashMap();
            for (Map.Entry entry : originalToCopy.entrySet()) {
                Object copy = entry.getValue();
                Object orig = entry.getKey();
                copyToOriginal.put(copy, orig);
            }
            return copyToOriginal;
        }
        return null;
    }

    @Override
    public Collection copyAll(Collection eObjects) throws ModelerCoreException {
        if (eObjects == null || eObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.copyAll(eObjects, null);
    }

    @Override
    public Collection copyAll(final Collection eObjects, final Map originalsToCopies) throws ModelerCoreException {
        if (eObjects == null || eObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        final EObject eObject = (EObject)eObjects.iterator().next();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_11", (Object)this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CopyCommand.Helper helper = new CopyCommand.Helper();
                if (originalsToCopies != null && !originalsToCopies.isEmpty()) {
                    for (Map.Entry entry : originalsToCopies.entrySet()) {
                        helper.put((EObject)entry.getKey(), (EObject)entry.getValue());
                    }
                    helper.putAll(originalsToCopies);
                }
                Command command = ModelEditorImpl.createCopyCommand(ed, eObjects, helper);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                for (Object next : command.getResult()) {
                    if (!(next instanceof EObject)) continue;
                    ModelEditorImpl.this.setUuidFeatureValue((EObject)next);
                }
                if (originalsToCopies != null) {
                    originalsToCopies.putAll(helper);
                }
                return command.getResult();
            }
        };
        Collection result = (Collection)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    @Override
    public void addValue(Object owner, Object value, EList feature) throws ModelerCoreException {
        this.addValue(owner, value, feature, -1);
    }

    @Override
    public void addValue(final Object owner, Object value, final EList feature, final int index) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)owner);
        CoreArgCheck.isNotNull((Object)value);
        CoreArgCheck.isNotNull((Object)feature);
        final ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            feature.add(index, values);
        } else {
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Add_values_to_{0}_1", (Object)this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    AddCommand command = AddCommandFactory.create(owner, ed, feature, values, index);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
    }

    @Override
    public void addMapValue(final Object owner, final Map map, final Object key, final Object value) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)owner);
        CoreArgCheck.isNotNull((Object)map);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            map.put(key, value);
        } else {
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Add_value_to_map_for_{0}", (Object)this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    AddValueToMapCommand command = new AddValueToMapCommand(ed, owner, map, key, value);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
        }
    }

    @Override
    public void removeValue(final Object owner, Object value, final EList feature) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)owner);
        CoreArgCheck.isNotNull((Object)value);
        CoreArgCheck.isNotNull((Object)feature);
        final ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            feature.remove(values);
        } else {
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Remove_values_from_{0}_1", (Object)this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    RemoveCommand command = new RemoveCommand(ed, feature, values);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
    }

    @Override
    public void removeMapValue(final Object owner, final Map map, final Object key) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)owner);
        CoreArgCheck.isNotNull((Object)map);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            map.remove(key);
        } else {
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Remove_value_from_map_for_{0}", (Object)this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                @Override
                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    RemoveValueFromMapCommand command = new RemoveValueFromMapCommand(ed, owner, map, key);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
        }
    }

    @Override
    public boolean setPropertyValue(EObject eObject, Object value, ItemPropertyDescriptor descriptor) {
        if (eObject == null || descriptor == null) {
            return false;
        }
        return this.setPropertyValue(eObject, value, descriptor.getFeature((Object)eObject));
    }

    @Override
    public boolean setEnterpriseDatatypePropertyValue(EObject owner, final Object object) {
        if (owner == null || object == null || !(owner instanceof XSDSimpleTypeDefinition) || !(object instanceof EnterpriseDatatypeInfo)) {
            return false;
        }
        final EnterpriseDatatypeInfo newEdtInfo = (EnterpriseDatatypeInfo)object;
        final XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)owner;
        final EnterpriseDatatypeInfo oldEdtInfo = ModelerCore.getDatatypeManager((EObject)simpleType).getEnterpriseDatatypeInfo(simpleType);
        if (newEdtInfo.equals((Object)oldEdtInfo)) {
            return false;
        }
        ModelEditorImpl.fillWithDefaultValues(newEdtInfo, simpleType);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", (Object)object.toString());
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                EnterpriseDatatypeInfoSetCommand cmd = new EnterpriseDatatypeInfoSetCommand(ed, simpleType, newEdtInfo, oldEdtInfo);
                ModelEditorImpl.this.executeCommandInTransaction(uow, object, (Command)cmd);
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            return false;
        }
        return true;
    }

    public static void fillWithDefaultValues(EnterpriseDatatypeInfo newEdtInfo, XSDSimpleTypeDefinition simpleType) {
        String objectID;
        if ((newEdtInfo.getUuid() == null || newEdtInfo.getUuid().length() == 0) && (objectID = ModelerCore.getObjectIdString((EObject)simpleType)) != null) {
            newEdtInfo.setUuid(objectID);
        }
        if (newEdtInfo.getRuntimeType() == null || newEdtInfo.getRuntimeType().length() == 0) {
            newEdtInfo.setRuntimeType("string");
        }
        if (newEdtInfo.getRuntimeTypeFixed() == null) {
            newEdtInfo.setRuntimeTypeFixed(EnterpriseDatatypeInfo.DEFAULT_RUNTIME_TYPE_FIXED_VALUE);
        }
    }

    @Override
    public boolean unsetEnterpriseDatatypePropertyValue(final EObject owner) {
        if (owner == null || !(owner instanceof XSDSimpleTypeDefinition)) {
            return false;
        }
        final XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)owner;
        final EnterpriseDatatypeInfo oldEdtInfo = ModelerCore.getDatatypeManager((EObject)simpleType).getEnterpriseDatatypeInfo(simpleType);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", (Object)owner.toString());
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                EnterpriseDatatypeInfoUnsetCommand cmd = new EnterpriseDatatypeInfoUnsetCommand(ed, simpleType, oldEdtInfo);
                ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)cmd);
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean setPropertyValue(final EObject eObject, final Object value, Object feature) {
        if (eObject == null || feature == null || !(feature instanceof EStructuralFeature)) {
            return false;
        }
        final EStructuralFeature sf = (EStructuralFeature)feature;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", (Object)sf.getName());
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                if (sf.isMany()) {
                    EList currentValues = (EList)eObject.eGet(sf);
                    ArrayList addedValues = new ArrayList(currentValues.size());
                    ArrayList removedValues = new ArrayList(currentValues.size());
                    Collection<Object> newValues = new ArrayList<Object>();
                    if (value instanceof Collection) {
                        newValues = (Collection)value;
                    } else {
                        newValues.add(value);
                    }
                    removedValues.addAll(currentValues);
                    addedValues.addAll(newValues);
                    if (!currentValues.isEmpty()) {
                        ModelEditorImpl.this.removeValue(eObject, removedValues, currentValues);
                    }
                    if (!addedValues.isEmpty()) {
                        ModelEditorImpl.this.addValue(eObject, addedValues, currentValues);
                    }
                } else {
                    XSDParticleContent particleContent;
                    EObject owner;
                    Object newValue = value;
                    if (value != null && value instanceof String) {
                        EDataType dt = (EDataType)sf.getEType();
                        EPackage ePackage = dt.getEPackage();
                        EFactory fac = ePackage.getEFactoryInstance();
                        newValue = fac.createFromString(dt, (String)value);
                    }
                    if ((owner = eObject) instanceof XSDParticle && !owner.eClass().getEAllStructuralFeatures().contains((Object)sf) && (particleContent = ((XSDParticle)owner).getContent()) != null && particleContent.eClass().getEAllStructuralFeatures().contains((Object)sf)) {
                        owner = particleContent;
                    }
                    SetCommand command = new SetCommand(ed, owner, sf, newValue);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, (Command)command);
                }
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public EObject clone(final EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Clone_{0}_12", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CloneCommand command = new CloneCommand(ed, eObject);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, (Command)command);
                command.getAffectedObjects();
                return command.getHelper().getCopy(eObject);
            }
        };
        EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    @Override
    public void cloneProject(String originalProjectPath, String clonedProjectPath) throws IOException {
        this.cloneProject(originalProjectPath, clonedProjectPath, null);
    }

    void cloneProject(String originalProjectPath, String clonedProjectPath, Tester tester) throws IOException {
        HashMap model2RefMap = new HashMap();
        HashMap genRefMap = new HashMap();
        File originalProject = new File(originalProjectPath);
        this.cloneFolder(originalProject, originalProject, model2RefMap, genRefMap, tester);
        this.cloneFolder2(originalProject, originalProject, model2RefMap, genRefMap, new File(clonedProjectPath), tester);
    }

    private void cloneFolder(File originalProject, File originalFolder, Map modelToReferenceMap, Map genRefMap, Tester tester) throws IOException {
        File[] origFiles = originalFolder.listFiles();
        if (origFiles != null) {
            int ndx = origFiles.length;
            while (--ndx >= 0) {
                File origFile = origFiles[ndx];
                String name = origFile.getName();
                if (origFile.isDirectory()) {
                    if (name.charAt(0) == '.') continue;
                    this.cloneFolder(originalProject, origFile, modelToReferenceMap, genRefMap, tester);
                    continue;
                }
                if (!name.endsWith(".xmi")) continue;
                this.cloneFile(originalProject, origFile, modelToReferenceMap, genRefMap, tester);
            }
        }
    }

    private void cloneFolder2(File originalProject, File originalFolder, Map modelToReferenceMap, Map genRefMap, File clonedFolder, Tester tester) throws IOException {
        File[] origFiles = originalFolder.listFiles();
        if (origFiles != null) {
            int ndx = origFiles.length;
            while (--ndx >= 0) {
                File origFile = origFiles[ndx];
                File clonedFile = new File(clonedFolder, origFile.getName());
                String name = origFile.getName();
                if (origFile.isDirectory()) {
                    if (name.charAt(0) == '.') continue;
                    this.cloneFolder2(originalProject, origFile, modelToReferenceMap, genRefMap, clonedFile, tester);
                    continue;
                }
                if (!name.endsWith(".xmi") && !name.endsWith(".xsd")) continue;
                clonedFolder.mkdirs();
                this.cloneFile2(originalProject, origFile, modelToReferenceMap, genRefMap, clonedFile, tester);
            }
        }
    }

    void cloneFile(File originalProject, File originalFile, Map modelToReferenceMap, Map genRefMap, Tester tester) throws IOException {
        FileReader in = new FileReader(originalFile);
        char[] buf = new char[8192];
        int state = 0;
        StringBuffer elemNameBuilder = null;
        StringBuffer attrNameBuilder = null;
        StringBuffer attrValBuilder = null;
        String attrName = null;
        boolean href = false;
        boolean choiceCriteria = false;
        boolean sqlUuid = false;
        int skipState = 0;
        int xmiUuidCounter = 0;
        int newUuidCounter = 0;
        int xProjectHRefCounter = 0;
        try {
            int bufLen = in.read(buf);
            while (bufLen > 0) {
                int bufNdx = 0;
                while (bufNdx < bufLen) {
                    block74: {
                        int chr;
                        block66: {
                            block71: {
                                block72: {
                                    String attrVal;
                                    block77: {
                                        int ndx;
                                        block76: {
                                            block73: {
                                                String referencedPath;
                                                block75: {
                                                    block70: {
                                                        block69: {
                                                            block68: {
                                                                block67: {
                                                                    block65: {
                                                                        chr = buf[bufNdx];
                                                                        if (state != 0) break block65;
                                                                        if (chr == 60) {
                                                                            state = 60;
                                                                        }
                                                                        break block66;
                                                                    }
                                                                    if (state != 60) break block67;
                                                                    if (chr == 63) {
                                                                        state = 63;
                                                                    } else if (chr == 33) {
                                                                        state = 33;
                                                                    } else if (chr == 47) {
                                                                        state = 0;
                                                                    } else if (!Character.isWhitespace((char)chr)) {
                                                                        state = 69;
                                                                        elemNameBuilder = new StringBuffer();
                                                                        elemNameBuilder.append((char)chr);
                                                                    }
                                                                    break block66;
                                                                }
                                                                if (state != 69) break block68;
                                                                if (chr == 47 || chr == 62) {
                                                                    state = 0;
                                                                    if (chr == 47 || skipState == 72) {
                                                                        skipState = this.updateSkipMode((char)skipState, (char)chr, elemNameBuilder);
                                                                    }
                                                                } else if (Character.isWhitespace((char)chr)) {
                                                                    state = 64;
                                                                    attrNameBuilder = new StringBuffer();
                                                                    if (skipState == 0) {
                                                                        if ((elemNameBuilder.charAt(0) == 't' || elemNameBuilder.charAt(0) == 'T') && "transformation:TransformationContainer".equalsIgnoreCase(elemNameBuilder.toString())) {
                                                                            skipState = 67;
                                                                        }
                                                                    } else if (skipState == 67) {
                                                                        if ("transformationMappings".equals(elemNameBuilder.toString())) {
                                                                            skipState = 77;
                                                                        }
                                                                    } else if (skipState == 77 && "helper".equals(elemNameBuilder.toString())) {
                                                                        skipState = 72;
                                                                    }
                                                                } else {
                                                                    elemNameBuilder.append((char)chr);
                                                                }
                                                                break block66;
                                                            }
                                                            if (state != 101) break block69;
                                                            if (chr == 62 || Character.isWhitespace((char)chr)) {
                                                                state = 0;
                                                                skipState = this.updateSkipMode((char)skipState, (char)chr, elemNameBuilder);
                                                            } else {
                                                                elemNameBuilder.append((char)chr);
                                                            }
                                                            break block66;
                                                        }
                                                        if (state != 64) break block70;
                                                        if (chr == 47 || chr == 62) {
                                                            state = 0;
                                                            if (chr == 47 || skipState == 72) {
                                                                skipState = this.updateSkipMode((char)skipState, (char)chr, elemNameBuilder);
                                                            }
                                                        } else if (chr == 39 || chr == 34) {
                                                            state = chr;
                                                            attrName = attrNameBuilder.toString();
                                                            if ("xmi:uuid".equals(attrName) || "mmedt:UUID".equals(attrName)) {
                                                                attrValBuilder = null;
                                                                ++xmiUuidCounter;
                                                            } else if (skipState == 72 && attrName.endsWith("Sql") && (attrName.startsWith("select") || attrName.startsWith("insert") || attrName.startsWith("update") || attrName.startsWith("delete"))) {
                                                                attrValBuilder = new StringBuffer();
                                                                sqlUuid = true;
                                                            } else {
                                                                attrValBuilder = new StringBuffer();
                                                                if ("href".equals(attrName)) {
                                                                    href = true;
                                                                } else if ("choiceCriteria".equals(attrName)) {
                                                                    choiceCriteria = true;
                                                                }
                                                            }
                                                        } else if (chr != 61 && !Character.isWhitespace((char)chr)) {
                                                            attrNameBuilder.append((char)chr);
                                                        }
                                                        break block66;
                                                    }
                                                    if (state != 39 && state != 34) break block71;
                                                    if (chr != state) break block72;
                                                    state = 69;
                                                    if (attrValBuilder == null) break block66;
                                                    attrVal = attrValBuilder.toString();
                                                    if (!href) break block73;
                                                    href = false;
                                                    if (attrVal.startsWith("http:") || attrVal.indexOf("mmuuid") < 0) break block74;
                                                    ndx = attrVal.indexOf(35);
                                                    String ref = attrVal.substring(0, ndx);
                                                    File referencedFile = new File(originalFile.getParentFile().getPath(), ref);
                                                    referencedPath = referencedFile.getCanonicalPath();
                                                    if (referencedPath.startsWith(originalProject.getCanonicalPath())) break block75;
                                                    ++xProjectHRefCounter;
                                                    break block74;
                                                }
                                                boolean didCreate = this.mapOriginalUuidToNewUuidForReferencedPath(attrVal.substring(ndx + 1 + UUID_PREFIX_LENGTH), this.getOriginalReferenceToNewReferenceMap(referencedPath, modelToReferenceMap), genRefMap);
                                                if (didCreate) {
                                                    ++newUuidCounter;
                                                }
                                                break block66;
                                            }
                                            if (!choiceCriteria) break block76;
                                            choiceCriteria = false;
                                            Map origRef2NewRefMap = this.getOriginalReferenceToNewReferenceMap(originalFile.getCanonicalPath(), modelToReferenceMap);
                                            int ndx2 = attrVal.indexOf("mmuuid");
                                            while (ndx2 >= 0) {
                                                boolean didCreate;
                                                if (didCreate = this.mapOriginalUuidToNewUuidForReferencedPath(attrVal.substring(ndx2 += UUID_PREFIX_LENGTH, ndx2 + UUID.FQ_LENGTH - UUID_PREFIX_LENGTH), origRef2NewRefMap, genRefMap)) {
                                                    ++newUuidCounter;
                                                }
                                                ndx2 = attrVal.indexOf("mmuuid", ndx2);
                                            }
                                            break block66;
                                        }
                                        if (!sqlUuid) break block77;
                                        sqlUuid = false;
                                        ndx = attrVal.indexOf("mmuuid");
                                        while (ndx >= 0) {
                                            String originalUuid;
                                            boolean didCreate;
                                            if (didCreate = this.mapOriginalUuidToNewUuidForReferencedPath(originalUuid = attrVal.substring(ndx += UUID_PREFIX_LENGTH, ndx + UUID.FQ_LENGTH - UUID_PREFIX_LENGTH), genRefMap, genRefMap)) {
                                                ++newUuidCounter;
                                            }
                                            ndx = attrVal.indexOf("mmuuid", ndx);
                                        }
                                        break block66;
                                    }
                                    if (attrValBuilder.length() >= UUID_PROTOCOL_LENGTH) {
                                        Map origRef2NewRefMap = this.getOriginalReferenceToNewReferenceMap(originalFile.getCanonicalPath(), modelToReferenceMap);
                                        String[] origUuids = attrVal.split(" +");
                                        int ndx = origUuids.length;
                                        while (--ndx >= 0) {
                                            boolean didCreate = this.mapOriginalUuidToNewUuidForReferencedPath(origUuids[ndx].substring(UUID_PREFIX_LENGTH), origRef2NewRefMap, genRefMap);
                                            if (!didCreate) continue;
                                            ++newUuidCounter;
                                        }
                                    }
                                    break block74;
                                    break block66;
                                }
                                if (attrValBuilder != null) {
                                    attrValBuilder.append((char)chr);
                                    if (!(href || choiceCriteria || sqlUuid || attrValBuilder.length() != UUID_PROTOCOL_LENGTH || "mmuuid".equals(attrValBuilder.toString()))) {
                                        attrValBuilder = null;
                                    }
                                }
                                break block66;
                            }
                            if (state == 63) {
                                if (chr == 63) {
                                    state = 62;
                                }
                            } else if (state == 62) {
                                state = chr == 62 ? 0 : 63;
                            } else if (state == 33) {
                                if (chr == 45) {
                                    state = 126;
                                }
                            } else if (state == 126) {
                                state = chr == 45 ? 45 : 33;
                            } else if (state == 45) {
                                state = chr == 62 ? 0 : 33;
                            }
                        }
                        if (tester != null) {
                            tester.cloneFile1(originalProject, originalFile, modelToReferenceMap, buf, bufLen, bufNdx, (char)chr, (char)state, elemNameBuilder, attrNameBuilder, attrValBuilder, href, choiceCriteria);
                        }
                    }
                    ++bufNdx;
                }
                bufLen = in.read(buf);
            }
            if (tester != null) {
                tester.cloneFilePassOneSummary(originalProject, originalFile, this.getOriginalReferenceToNewReferenceMap(originalFile.getCanonicalPath(), modelToReferenceMap), xmiUuidCounter, newUuidCounter, xProjectHRefCounter);
            }
        }
        catch (Throwable throwable) {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)in).close();
        }
        catch (IOException iOException) {}
    }

    void cloneFile2(File originalProject, File originalFile, Map modelToReferenceMap, Map genRefMap, File clonedFile, Tester tester) throws IOException {
        FileReader in = new FileReader(originalFile);
        int replacedUuidCounter = 0;
        try {
            BufferedWriter out;
            CharArrayWriter testWriter = null;
            if (tester == null) {
                out = new BufferedWriter(new FileWriter(clonedFile));
            } else {
                tester.cloningFile(originalFile);
                testWriter = new CharArrayWriter();
                out = new BufferedWriter(testWriter);
            }
            char[] buf = new char[8192];
            int state = 0;
            StringBuffer elemNameBuilder = null;
            StringBuffer attrNameBuilder = null;
            StringBuffer attrValBuilder = null;
            String attrName = null;
            boolean href = false;
            boolean choiceCriteria = false;
            boolean sqlUuid = false;
            boolean uuid = false;
            int prevBufLen = 0;
            int outBufNdx = 0;
            boolean xsd = originalFile.getName().endsWith(".xsd");
            try {
                int bufLen = ((Reader)in).read(buf, 0, 8192);
                while (bufLen > prevBufLen) {
                    int inBufNdx = prevBufLen;
                    while (inBufNdx < bufLen) {
                        int chr = buf[inBufNdx];
                        if (state == 0) {
                            if (chr == 60) {
                                state = 60;
                            }
                        } else if (state == 60) {
                            if (chr == 63) {
                                state = 63;
                            } else if (chr == 33) {
                                state = 33;
                            } else if (chr == 47) {
                                state = 101;
                                elemNameBuilder = new StringBuffer();
                            } else if (!Character.isWhitespace((char)chr)) {
                                state = 69;
                                elemNameBuilder = new StringBuffer();
                                elemNameBuilder.append((char)chr);
                            }
                        } else if (state == 69) {
                            if (chr == 47 || chr == 62) {
                                state = 0;
                            } else if (Character.isWhitespace((char)chr)) {
                                state = 64;
                                attrNameBuilder = new StringBuffer();
                            } else {
                                elemNameBuilder.append((char)chr);
                            }
                        } else if (state == 101) {
                            if (chr == 62 || Character.isWhitespace((char)chr)) {
                                state = 0;
                            } else {
                                elemNameBuilder.append((char)chr);
                            }
                        } else if (state == 64) {
                            if (chr == 47 || chr == 62) {
                                state = 0;
                            } else if (chr == 39 || chr == 34) {
                                state = chr;
                                attrName = attrNameBuilder.toString();
                                if (tester != null) {
                                    tester.writeToOut(buf, outBufNdx, inBufNdx + 1 - outBufNdx);
                                }
                                out.write(buf, outBufNdx, inBufNdx + 1 - outBufNdx);
                                outBufNdx = inBufNdx + 1;
                                if (xsd) {
                                    if ("mmedt:UUID".equals(attrName)) {
                                        uuid = true;
                                        attrValBuilder = new StringBuffer();
                                    } else {
                                        attrValBuilder = null;
                                    }
                                } else {
                                    attrValBuilder = new StringBuffer();
                                    if ("xmi:uuid".equals(attrName)) {
                                        uuid = true;
                                    } else if ("href".equals(attrName)) {
                                        href = true;
                                    } else if ("choiceCriteria".equals(attrName)) {
                                        choiceCriteria = true;
                                    } else if (attrName.endsWith("Sql") && (attrName.startsWith("select") || attrName.startsWith("insert") || attrName.startsWith("update") || attrName.startsWith("delete"))) {
                                        sqlUuid = true;
                                    }
                                }
                            } else if (chr != 61 && !Character.isWhitespace((char)chr)) {
                                if (attrNameBuilder.length() == 0) {
                                    if (tester != null) {
                                        tester.writeToOut(buf, outBufNdx, inBufNdx - outBufNdx);
                                    }
                                    out.write(buf, outBufNdx, inBufNdx - outBufNdx);
                                    outBufNdx = inBufNdx;
                                }
                                attrNameBuilder.append((char)chr);
                            }
                        } else if (state == 39 || state == 34) {
                            if (chr == state) {
                                state = 69;
                                if (attrValBuilder != null) {
                                    String newUuid;
                                    String attrVal = attrValBuilder.toString();
                                    if (uuid) {
                                        uuid = false;
                                        boolean emptyUuid = false;
                                        String referencedPath = originalFile.getCanonicalPath();
                                        String originalUuid = "";
                                        if (attrVal.length() >= UUID_PREFIX_LENGTH) {
                                            originalUuid = attrVal.substring(UUID_PREFIX_LENGTH);
                                        } else if (attrVal.trim().length() == 0) {
                                            emptyUuid = true;
                                        }
                                        String newUuid2 = (String)genRefMap.get(originalUuid);
                                        if (newUuid2 == null) {
                                            Map origRef2NewRefMap = (Map)modelToReferenceMap.get(referencedPath);
                                            if (origRef2NewRefMap != null) {
                                                newUuid2 = (String)origRef2NewRefMap.get(originalUuid);
                                            }
                                            if (newUuid2 == null) {
                                                newUuid2 = ((UUID)OBJECT_ID_FACTORY.create()).exportableForm();
                                            }
                                        }
                                        ++replacedUuidCounter;
                                        if (xsd && emptyUuid) {
                                            if (tester != null) {
                                                tester.writeToOut("mmuuid:");
                                            }
                                            out.write("mmuuid:");
                                        } else {
                                            if (tester != null) {
                                                tester.writeToOut(buf, outBufNdx, UUID_PREFIX_LENGTH);
                                            }
                                            out.write(buf, outBufNdx, UUID_PREFIX_LENGTH);
                                        }
                                        if (tester != null) {
                                            tester.writeToOut(newUuid2);
                                        }
                                        out.write(newUuid2);
                                        outBufNdx = inBufNdx;
                                    } else if (href) {
                                        String referencedPath;
                                        int ndx;
                                        href = false;
                                        if (!attrVal.startsWith("http:") && attrVal.regionMatches((ndx = attrVal.indexOf(35)) + 1, "mmuuid", 0, UUID_PROTOCOL_LENGTH) && (referencedPath = new File(originalFile.getParentFile().getPath(), attrVal.substring(0, ndx)).getCanonicalPath()).startsWith(originalProject.getCanonicalPath())) {
                                            Map origRef2NewRefMap = (Map)modelToReferenceMap.get(referencedPath);
                                            String originalUuid = attrVal.substring(ndx + 1 + UUID_PREFIX_LENGTH);
                                            newUuid = (String)genRefMap.get(originalUuid);
                                            if (newUuid == null) {
                                                newUuid = (String)origRef2NewRefMap.get(originalUuid);
                                            }
                                            ++replacedUuidCounter;
                                            if (tester != null) {
                                                tester.writeToOut(buf, outBufNdx, UUID_PREFIX_LENGTH);
                                            }
                                            out.write(buf, outBufNdx, ndx + 1 + UUID_PREFIX_LENGTH);
                                            if (tester != null) {
                                                tester.writeToOut(newUuid);
                                            }
                                            out.write(newUuid);
                                            outBufNdx = inBufNdx;
                                        }
                                    } else if (sqlUuid) {
                                        sqlUuid = false;
                                        int startNdx = 0;
                                        int ndx = attrVal.indexOf("mmuuid");
                                        while (ndx >= 0) {
                                            int endNdx;
                                            String origUuid;
                                            if ((newUuid = (String)genRefMap.get(origUuid = attrVal.substring(ndx += UUID_PREFIX_LENGTH, endNdx = ndx + UUID.FQ_LENGTH - UUID_PREFIX_LENGTH))) == null) {
                                                newUuid = this.getNewUuidForOriginalUuid(origUuid, modelToReferenceMap);
                                            }
                                            ++replacedUuidCounter;
                                            if (tester != null) {
                                                tester.writeToOut(buf, outBufNdx, ndx - startNdx);
                                            }
                                            out.write(buf, outBufNdx, ndx - startNdx);
                                            if (tester != null) {
                                                tester.writeToOut(newUuid);
                                            }
                                            out.write(newUuid);
                                            outBufNdx += endNdx - startNdx;
                                            startNdx = endNdx;
                                            ndx = attrVal.indexOf("mmuuid", startNdx);
                                        }
                                    } else {
                                        if (choiceCriteria) {
                                            choiceCriteria = false;
                                        }
                                        Map origRef2NewRefMap = (Map)modelToReferenceMap.get(originalFile.getCanonicalPath());
                                        int startNdx = 0;
                                        int ndx = attrVal.indexOf("mmuuid");
                                        while (ndx >= 0) {
                                            int endNdx;
                                            String origUuid;
                                            String newUuid3;
                                            if ((newUuid3 = (String)genRefMap.get(origUuid = attrVal.substring(ndx += UUID_PREFIX_LENGTH, endNdx = ndx + UUID.FQ_LENGTH - UUID_PREFIX_LENGTH))) == null) {
                                                newUuid3 = (String)origRef2NewRefMap.get(origUuid);
                                            }
                                            ++replacedUuidCounter;
                                            if (tester != null) {
                                                tester.writeToOut(buf, outBufNdx, ndx - startNdx);
                                            }
                                            out.write(buf, outBufNdx, ndx - startNdx);
                                            if (tester != null) {
                                                tester.writeToOut(newUuid3);
                                            }
                                            out.write(newUuid3);
                                            outBufNdx += endNdx - startNdx;
                                            startNdx = endNdx;
                                            ndx = attrVal.indexOf("mmuuid", startNdx);
                                        }
                                    }
                                }
                            } else if (attrValBuilder != null) {
                                attrValBuilder.append((char)chr);
                                if (!(uuid || href || sqlUuid || choiceCriteria || attrValBuilder.length() != "mmuuid".length() || "mmuuid".equals(attrValBuilder.toString()))) {
                                    attrValBuilder = null;
                                }
                            }
                        } else if (state == 63) {
                            if (chr == 63) {
                                state = 62;
                            }
                        } else if (state == 62) {
                            state = chr == 62 ? 0 : 63;
                        } else if (state == 33) {
                            if (chr == 45) {
                                state = 126;
                            }
                        } else if (state == 126) {
                            state = chr == 45 ? 45 : 33;
                        } else if (state == 45) {
                            state = chr == 62 ? 0 : 33;
                        }
                        if (tester != null) {
                            out.flush();
                            tester.cloneFile2(originalProject, originalFile, modelToReferenceMap, buf, bufLen, inBufNdx, (char)chr, (char)state, elemNameBuilder, attrNameBuilder, attrValBuilder, href, choiceCriteria, clonedFile, testWriter, uuid, outBufNdx);
                        }
                        ++inBufNdx;
                    }
                    if (outBufNdx < bufLen) {
                        prevBufLen = bufLen - outBufNdx;
                        char[] newBuf = new char[prevBufLen + 8192];
                        System.arraycopy(buf, outBufNdx, newBuf, 0, prevBufLen);
                        buf = newBuf;
                    } else if (prevBufLen > 0) {
                        prevBufLen = 0;
                        buf = new char[8192];
                    }
                    outBufNdx = 0;
                    bufLen = prevBufLen + ((Reader)in).read(buf, prevBufLen, 8192);
                }
                if (prevBufLen > 0) {
                    if (tester != null) {
                        tester.writeToOut(buf, outBufNdx, prevBufLen);
                    }
                    out.write(buf, outBufNdx, prevBufLen);
                    if (tester != null) {
                        out.flush();
                        tester.cloneFile2(originalProject, originalFile, modelToReferenceMap, buf, prevBufLen, 0, '\u0000', '\u0000', null, null, null, false, false, clonedFile, testWriter, false, 0);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
            if (tester != null) {
                tester.cloneFilePassTwoSummary(originalProject, originalFile, replacedUuidCounter);
            }
        }
        catch (Throwable throwable) {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)in).close();
        }
        catch (IOException iOException) {}
    }

    private Map getOriginalReferenceToNewReferenceMap(String referencedPath, Map modelToReferenceMap) {
        HashMap origRef2NewRefMap = (HashMap)modelToReferenceMap.get(referencedPath);
        if (origRef2NewRefMap == null) {
            origRef2NewRefMap = new HashMap();
            modelToReferenceMap.put(referencedPath, origRef2NewRefMap);
        }
        return origRef2NewRefMap;
    }

    private boolean mapOriginalUuidToNewUuidForReferencedPath(String originalUuid, Map origRef2NewRefMap, Map genRefMap) {
        boolean createdNew = false;
        String newUuid = (String)origRef2NewRefMap.get(originalUuid);
        if (newUuid == null && (newUuid = (String)genRefMap.get(originalUuid)) == null) {
            createdNew = true;
            newUuid = ((UUID)OBJECT_ID_FACTORY.create()).exportableForm();
            origRef2NewRefMap.put(originalUuid, newUuid);
        }
        return createdNew;
    }

    private String getNewUuidForOriginalUuid(String originalUuid, Map modelToReferenceMap) {
        for (String nextKey : modelToReferenceMap.keySet()) {
            Map origRef2NewRefMap;
            String newUuid;
            if (nextKey == null || (newUuid = (String)(origRef2NewRefMap = (Map)modelToReferenceMap.get(nextKey)).get(originalUuid)) == null) continue;
            return newUuid;
        }
        return null;
    }

    private char updateSkipMode(char skipMode, char chr, StringBuffer elementName) {
        if (skipMode == 'H' && "helper".equals(elementName.toString())) {
            return 'M';
        }
        if (skipMode == 'M' && "transformationMappings".equals(elementName.toString())) {
            return 'C';
        }
        if (skipMode == 'C' && "Transformation:TransformationContainer".equals(elementName.toString())) {
            return '$';
        }
        return skipMode;
    }

    @Override
    public Collection cloneMultiple(final EObject eObject, final int numClones) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isPositive((int)numClones);
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Clone_{0}_12", (Object)this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                ArrayList resultsList = new ArrayList();
                int i = 0;
                while (i != numClones) {
                    CloneCommand command = new CloneCommand(ed, eObject);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, (Command)command);
                    command.getAffectedObjects();
                    Collection commandResults = command.getResult();
                    for (Object nextObj : commandResults) {
                        if (resultsList.contains(nextObj)) continue;
                        resultsList.add(nextObj);
                    }
                    ++i;
                }
                return resultsList;
            }
        };
        Collection result = (Collection)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    @Override
    public boolean isValidParent(Object parent, EObject child) {
        block17: {
            if (parent instanceof EObject) {
                EObject eParent = (EObject)parent;
                EReference ref = this.getChildReference(eParent, child);
                if (ref == null) {
                    return false;
                }
                if (!ref.isContainment()) {
                    return false;
                }
                EClass eParentClass = eParent.eClass();
                EClass eChildClass = child.eClass();
                if (eParentClass != null && eChildClass != null) {
                    URI eParentMetamodelURI = eParentClass.eResource().getURI();
                    URI eChildMetamodelURI = eChildClass.eResource().getURI();
                    if (eParentMetamodelURI != null && !eParentMetamodelURI.equals(eChildMetamodelURI)) {
                        return false;
                    }
                }
                if (ref.isMany()) {
                    return true;
                }
                Object value = eParent.eGet((EStructuralFeature)ref);
                if (value == null) {
                    return true;
                }
            } else {
                if (parent instanceof Resource) {
                    return ModelEditorImpl.isValidRootObject((Resource)parent, child.eClass());
                }
                if (parent instanceof IFile) {
                    try {
                        Resource rsrc;
                        ModelResource mr = this.findModelResource((IResource)((IFile)parent));
                        if (mr != null && (rsrc = mr.getEmfResource()) != null) {
                            return ModelEditorImpl.isValidRootObject(rsrc, child.eClass());
                        }
                        break block17;
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {
                        return false;
                    }
                }
                if (parent instanceof ModelResource) {
                    try {
                        Resource rsrc = ((ModelResource)parent).getEmfResource();
                        if (rsrc != null) {
                            return ModelEditorImpl.isValidRootObject(rsrc, child.eClass());
                        }
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {}
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValidPasteParent(Object potentialParent) {
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            return false;
        }
        EditingDomain ed = cntr.getEditingDomain();
        if (ed.getClipboard() == null || ed.getClipboard().isEmpty()) {
            return false;
        }
        for (EObject next : ed.getClipboard()) {
            if (this.isValidParent(potentialParent, next)) continue;
            return false;
        }
        return true;
    }

    public EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    Collection createCommands(Collection commandParams, EditingDomain ed) {
        if (commandParams == null) {
            return commandParams;
        }
        ArrayList<Command> commands = new ArrayList<Command>(commandParams.size());
        for (CommandParameter param : commandParams) {
            EObject eOwner = param.getEOwner();
            Object owner = param.getOwner();
            Command command = null;
            if (eOwner == null && owner instanceof Resource) {
                EObject value = param.getEValue();
                command = new AddCommand(ed, ((Resource)owner).getContents(), (Object)value);
            } else {
                CommandParameter newChildParam = new CommandParameter(param.getOwner(), param.getFeature(), (Object)param);
                command = ed.createCommand(CreateChildCommand.class, newChildParam);
            }
            if (param.getFeature() == null) {
                command = new DisabledCommand(command);
            } else {
                boolean disable = this.shouldBeDisabled(owner, param);
                if (disable && command != null) {
                    command = new DisabledCommand(command);
                }
            }
            if (command == null || command instanceof DisabledCommand) continue;
            commands.add(command);
        }
        return commands;
    }

    private Collection getRootDescriptors(Resource rsrc) {
        CoreArgCheck.isNotNull((Object)rsrc);
        String primaryMetamodelURI = ModelEditorImpl.getPrimaryMetamodelURI(rsrc);
        if (primaryMetamodelURI == null) {
            return Collections.EMPTY_LIST;
        }
        URI nsUri = ModelerCore.getMetamodelRegistry().getURI(primaryMetamodelURI);
        if (ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUri) == null) {
            StringBuffer sb = new StringBuffer();
            MetamodelDescriptor[] descriptors = ModelerCore.getMetamodelRegistry().getMetamodelDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                MetamodelDescriptor mmd = descriptors[i];
                if (mmd.isPrimary() && !CoreStringUtil.isEmpty((String)mmd.getNamespaceURI())) {
                    sb.append(mmd.getNamespaceURI());
                    sb.append(CoreStringUtil.Constants.SPACE);
                }
                ++i;
            }
            Object[] params = new Object[]{primaryMetamodelURI, sb.toString()};
            String msg = ModelerCore.Util.getString("ModelEditorImpl.No_root_classes_found_for_metamodel_URI", params);
            ModelerCore.Util.log(4, msg);
        }
        EPackage ePackage = ModelerCore.getMetamodelRegistry().getEPackage(nsUri);
        EFactory eFactory = ePackage.getEFactoryInstance();
        List<MetamodelRootClass> rootClasses = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelRootClasses(nsUri));
        ArrayList filteredClasses = new ArrayList(rootClasses.size());
        for (Object e : rootClasses) {
            boolean ignore;
            String className = ((MetamodelRootClass)e).getEClass().getName();
            boolean bl = ignore = className.equalsIgnoreCase("BaseTable") || className.equalsIgnoreCase("Procedure") || className.equalsIgnoreCase("Index") || className.equalsIgnoreCase("View");
            if (ignore) continue;
            filteredClasses.add(e);
        }
        Collection collection = ModelEditorImpl.createSiblingDescriptors(filteredClasses, eFactory, rsrc);
        return collection;
    }

    private String getPresentationValue(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof EObject) {
            for (EStructuralFeature feature : ((EObject)obj).eClass().getEAllStructuralFeatures()) {
                if (!NAME_FEATURE_NAME.equalsIgnoreCase(feature.getName())) continue;
                Object val = ((EObject)obj).eGet(feature);
                if (val == null) {
                    return ((EObject)obj).eClass().getName();
                }
                return val.toString();
            }
            return ((EObject)obj).eClass().getName();
        }
        if (obj instanceof Resource) {
            return URI.decode((String)((Resource)obj).getURI().toString());
        }
        if (obj instanceof Collection) {
            if (((Collection)obj).size() > 1) {
                return ModelerCore.Util.getString("ModelEditorImpl.many_1", new Object[0]);
            }
            if (((Collection)obj).size() == 0) {
                return ModelerCore.Util.getString("ModelEditorImpl.empty_list_2", new Object[0]);
            }
            Object first = ((Collection)obj).iterator().next();
            return this.getPresentationValue(first);
        }
        return obj.toString();
    }

    static void setDescriptorOwner(Collection descriptors, Object owner) {
        CoreArgCheck.isNotNull((Object)descriptors);
        for (Object descriptor : descriptors) {
            if (!(descriptor instanceof CommandParameter)) continue;
            if (owner instanceof XSDParticle) {
                ((CommandParameter)descriptor).setOwner((Object)((XSDParticle)owner).getContent());
                continue;
            }
            if (owner instanceof XSDAttributeUse) {
                ((CommandParameter)descriptor).setOwner((Object)((XSDAttributeUse)owner).getContent());
                continue;
            }
            ((CommandParameter)descriptor).setOwner(owner);
        }
    }

    private EReference getChildReference(EObject object, Object child) {
        if (child instanceof EObject) {
            EObject eChild = (EObject)child;
            EObject eParent = object;
            EList refs = eParent.eClass().getEAllReferences();
            for (EReference eReference : refs) {
                EClassifier eType = eReference.getEType();
                if (!eType.isInstance((Object)eChild) || !eReference.isContainment()) continue;
                return eReference;
            }
        }
        return null;
    }

    private ModelAnnotation getModelAnnotation(Resource rsrc) {
        if (rsrc instanceof MMXmiResource) {
            ModelAnnotation model = ((MMXmiResource)rsrc).getModelAnnotation();
            return model;
        }
        ModelResource mr = this.findModelResource(rsrc);
        if (mr != null) {
            try {
                ModelAnnotation ma = mr.getModelAnnotation();
                if (ma != null) {
                    return ma;
                }
            }
            catch (ModelWorkspaceException e) {
                ModelerCore.Util.log((Throwable)((Object)e));
            }
        }
        for (EObject next : rsrc.getContents()) {
            if (!(next instanceof ModelAnnotation)) continue;
            return (ModelAnnotation)next;
        }
        return null;
    }

    private static String getPrimaryMetamodelURI(Resource rsrc) {
        String primaryMetamodelUri = null;
        if (ModelUtil.isXsdFile(rsrc)) {
            primaryMetamodelUri = XML_SCHEMA_METAMODEL_URI;
        } else if (ModelUtil.isModelFile(rsrc) && rsrc instanceof MMXmiResource) {
            MMXmiResource eRsrc = (MMXmiResource)rsrc;
            if (eRsrc.isLoaded()) {
                ModelAnnotation annotation = eRsrc.getModelAnnotation();
                if (annotation != null) {
                    primaryMetamodelUri = annotation.getPrimaryMetamodelUri();
                }
            } else {
                XMIHeader header = ModelEditorImpl.getXmiHeader((Resource)eRsrc);
                if (header != null) {
                    primaryMetamodelUri = header.getPrimaryMetamodelURI();
                }
            }
        } else if (ModelUtil.isVdbArchiveFile(rsrc)) {
            primaryMetamodelUri = "http://www.metamatrix.com/metamodels/VirtualDatabase";
        }
        return primaryMetamodelUri;
    }

    static Collection createSiblingDescriptors(Collection rootClasses, EFactory factory, Object owner) {
        if (factory == null) {
            return Collections.EMPTY_LIST;
        }
        boolean ownerIsRoot = owner instanceof Resource || owner instanceof EObject && ((EObject)owner).eContainer() == null;
        HashSet<CommandParameter> result = new HashSet<CommandParameter>(rootClasses.size());
        Iterator iter = rootClasses.iterator();
        while (iter.hasNext()) {
            Resource rsrc = null;
            if (owner instanceof Resource) {
                rsrc = (Resource)owner;
            } else if (owner instanceof EObject) {
                rsrc = ((EObject)owner).eResource();
            }
            if (rsrc != null) {
                Object next = iter.next();
                EClass eClass = null;
                int maxOccurs = -1;
                if (next instanceof MetamodelRootClass) {
                    MetamodelRootClass mmrc = (MetamodelRootClass)next;
                    eClass = mmrc.getEClass();
                    maxOccurs = mmrc.getMaxOccurs();
                } else {
                    eClass = (EClass)next;
                }
                EObject child = factory.create(eClass);
                boolean disable = false;
                if (ownerIsRoot && maxOccurs == 0) {
                    disable = true;
                } else if (ownerIsRoot && maxOccurs > 0) {
                    int count = 0;
                    for (EObject root : rsrc.getContents()) {
                        if (!root.eClass().equals(eClass)) continue;
                        ++count;
                    }
                    if (count >= maxOccurs) {
                        disable = true;
                    }
                }
                if (disable) {
                    result.add(new CommandParameter((Object)rsrc, null, (Object)child));
                    continue;
                }
                result.add(new CommandParameter((Object)rsrc, (Object)rsrc.getContents(), (Object)child));
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    private static boolean isRootObject(EClass eclass) {
        URI uri = eclass.eResource().getURI();
        List<EClass> eclasses = Arrays.asList(ModelerCore.getMetamodelRegistry().getRootMetaClasses(uri));
        if (eclasses == null || eclasses.isEmpty()) {
            return false;
        }
        return eclasses.contains(eclass);
    }

    private static boolean isValidRootObject(Resource rsrc, EClass eclass) {
        String primaryMetamodelUri;
        block4: {
            if (rsrc == null || eclass == null || !ModelEditorImpl.isRootObject(eclass)) {
                return false;
            }
            try {
                primaryMetamodelUri = ModelEditorImpl.getPrimaryMetamodelURI(rsrc);
                if (primaryMetamodelUri != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        URI nsUri = ModelerCore.getMetamodelRegistry().getURI(primaryMetamodelUri);
        List<EClass> validRoots = Arrays.asList(ModelerCore.getMetamodelRegistry().getRootMetaClasses(nsUri));
        return validRoots.contains(eclass);
    }

    public static XMIHeader getXmiHeader(Resource resource) {
        File resourceFile;
        XMIHeader header = null;
        if (resource != null && resource.getURI().isFile() && (resourceFile = new File(resource.getURI().toFileString())).exists()) {
            try {
                header = XMIHeaderReader.readHeader((File)resourceFile);
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
        return header;
    }

    @Override
    public String getDescription(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        Annotation annotation = this.getAnnotation(eObject, false);
        if (annotation != null) {
            return annotation.getDescription();
        }
        return null;
    }

    @Override
    public void setDescription(final EObject eObject, final String desc) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        if (eObject.eIsProxy()) {
            return;
        }
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_Description_on_{0}_14", (Object)eObject.toString());
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public Object run(UnitOfWork uow) {
                if (desc == null || desc.trim().length() == 0) {
                    Annotation annotation = ModelEditorImpl.this.getAnnotation(eObject, false);
                    if (annotation != null) {
                        annotation.setDescription(null);
                        if (annotation.getKeywords().isEmpty() && annotation.getTags().isEmpty()) {
                            annotation.setAnnotationContainer(null);
                        }
                    }
                } else {
                    Annotation annotation = ModelEditorImpl.this.getAnnotation(eObject, true);
                    annotation.setDescription(desc);
                }
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    @Override
    public ModelResource findModelResource(Resource resource) {
        return ModelerCore.getModelWorkspace().findModelResource(resource);
    }

    @Override
    public ModelResource findModelResource(EObject eObject) {
        EObject target;
        ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(eObject);
        if (modelResource == null && eObject instanceof Diagram && (target = ((Diagram)eObject).getTarget()) != null) {
            modelResource = this.findModelResource(target);
        }
        return modelResource;
    }

    @Override
    public Resource findResource(Container container, EObject eObject) {
        CoreArgCheck.isNotNull((Object)container);
        CoreArgCheck.isNotNull((Object)eObject);
        return this.findResource(container, eObject, true);
    }

    @Override
    public Resource findResource(Container container, EObject eObject, boolean resolve) {
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isNotNull((Object)container);
        Resource resource = eObject.eResource();
        if (resolve && resource == null && eObject.eIsProxy()) {
            try {
                URI uri = ((InternalEObject)eObject).eProxyURI();
                resource = container.getResource(uri.trimFragment(), resolve);
            }
            catch (Exception exception) {}
        } else if (eObject instanceof XsdModelAnnotationImpl) {
            resource = ((XsdModelAnnotationImpl)eObject).getResource();
        }
        return resource;
    }

    @Override
    public ModelResource findModelResource(IResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        return (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(resource);
    }

    @Override
    public boolean addModelImport(MMXmiResource resource, Resource importedResource) throws ModelerCoreException {
        if (resource != null && importedResource != null && resource != importedResource) {
            ModelImport newModelImport;
            URI importedUri = importedResource.getURI();
            URI resourceUri = resource.getURI();
            if (resourceUri.isRelative() || resourceUri.equals(importedUri)) {
                return false;
            }
            ModelImport existingImport = this.findModelImport(resource, importedResource);
            if (existingImport != null) {
                return false;
            }
            ModelAnnotation modelAnnotation = resource.getModelAnnotation();
            if (modelAnnotation != null && (newModelImport = this.createModelImport(resource, importedResource)) != null) {
                this.addValue(modelAnnotation, newModelImport, modelAnnotation.getModelImports());
                return true;
            }
        }
        return false;
    }

    @Override
    public ModelImport getExistingModelImportForLocation(MMXmiResource resource, String someModelLocation) {
        ModelAnnotation modelAnnot;
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)someModelLocation);
        Container cntr = ModelerCore.getContainer((Resource)resource);
        if (cntr != null && (modelAnnot = resource.getModelAnnotation()) != null && modelAnnot.getModelImports() != null) {
            for (ModelImport modelImport : modelAnnot.getModelImports()) {
                String existingModelImportLocation = modelImport.getModelLocation();
                if (existingModelImportLocation == null || !existingModelImportLocation.equalsIgnoreCase(someModelLocation)) continue;
                return modelImport;
            }
        }
        return null;
    }

    @Override
    public String createModelLocation(MMXmiResource resource, Resource importedResource) {
        CoreArgCheck.isNotNull((Object)importedResource);
        if (!this.isValidImportResource(importedResource)) {
            return null;
        }
        String newModelLocation = null;
        URI resourceURI = resource.getURI();
        URI importURI = importedResource.getURI();
        String uriString = URI.decode((String)importURI.toString());
        boolean isVdbResource = false;
        if (resourceURI.toString().indexOf(".metadata/.plugins/org.teiid.designer.vdb.edit/vdbWorkingFolder") > -1) {
            isVdbResource = true;
        }
        if (uriString.startsWith("http") || uriString.startsWith("mtkplugin://") || uriString.startsWith("pathmap://UML2_METAMODELS/")) {
            IPath vdbProjectPath;
            newModelLocation = uriString;
            if (isVdbResource && newModelLocation.equalsIgnoreCase("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance") && (vdbProjectPath = ModelUtil.getVdbProjectPathURI(resource)) != null && !vdbProjectPath.isEmpty()) {
                String builtInDatatypesName = "builtInDataTypes.xsd";
                IPath builtInDatatypesPath = vdbProjectPath.append(builtInDatatypesName);
                URI builtInDTypeURI = URI.createFileURI((String)builtInDatatypesPath.toString());
                URI relURI = ModelUtil.getRelativeLocation(resourceURI, builtInDTypeURI);
                newModelLocation = relURI.toString();
            }
        } else if (importURI.isFile()) {
            URI deresolvedURI;
            boolean deresolve;
            boolean bl = deresolve = !resourceURI.isRelative() && resourceURI.isHierarchical();
            if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                importURI = deresolvedURI;
            }
            newModelLocation = URI.decode((String)importURI.toString());
        } else {
            ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
            if (globalResourceSet.getResources().contains((Object)importedResource)) {
                if (importedResource == XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").eResource()) {
                    newModelLocation = "http://www.w3.org/2001/XMLSchema";
                } else if (importedResource == XSDSchemaImpl.getSchemaInstance((String)"http://www.w3.org/2001/XMLSchema-instance").eResource()) {
                    newModelLocation = "http://www.w3.org/2001/XMLSchema-instance";
                } else if (importedResource == XSDSchemaImpl.getMagicSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").eResource()) {
                    newModelLocation = ResourceFinder.MAGIC_SCHEMA_URI.toString();
                }
            } else {
                newModelLocation = URI.decode((String)importURI.toString());
            }
        }
        return newModelLocation;
    }

    @Override
    public ModelImport createModelImport(MMXmiResource resource, Resource importedResource) {
        CoreArgCheck.isNotNull((Object)importedResource);
        if (!this.isValidImportResource(importedResource)) {
            return null;
        }
        ModelImport modelImport = null;
        String newModelLocation = this.createModelLocation(resource, importedResource);
        if (newModelLocation != null) {
            modelImport = CoreFactory.eINSTANCE.createModelImport();
            modelImport.setName(this.getResourceName(importedResource));
            modelImport.setModelLocation(newModelLocation);
            if (importedResource instanceof MMXmiResource) {
                MMXmiResource emfResource = (MMXmiResource)importedResource;
                modelImport.setModelType(emfResource.getModelType());
                modelImport.setPrimaryMetamodelUri(emfResource.getPrimaryMetamodelUri().toString());
                modelImport.setUuid(emfResource.getUuid().toString());
            } else if (importedResource instanceof XSDResourceImpl) {
                modelImport.setModelType(ModelType.TYPE_LITERAL);
                modelImport.setPrimaryMetamodelUri(XML_SCHEMA_METAMODEL_URI);
            }
        } else {
            String msg = ModelerCore.Util.getString("ModelEditorImpl.could_not_create_model_import_for_resource_0", (Object)importedResource.getURI());
            ModelerCore.Util.log(4, msg);
        }
        return modelImport;
    }

    protected boolean isValidImportResource(Resource importedResource) {
        if (importedResource instanceof MMXmiResource) {
            MMXmiResource emfResource = (MMXmiResource)importedResource;
            if (emfResource.getModelType() == null) {
                return false;
            }
            if (emfResource.getPrimaryMetamodelUri() == null) {
                return false;
            }
            return emfResource.getUuid() != null;
        }
        return importedResource instanceof XSDResourceImpl;
    }

    @Override
    public void updateModelImport(ModelImport modelImport, Resource importedResource) {
        CoreArgCheck.isNotNull((Object)modelImport);
        CoreArgCheck.isNotNull((Object)importedResource);
        Resource resource = modelImport.eResource();
        if (resource != null) {
            URI resourceURI = resource.getURI();
            URI importURI = importedResource.getURI();
            Container cntr = ModelerCore.getContainer(resource);
            if (cntr != null && cntr.getResourceFinder().isBuiltInResource(importedResource)) {
                return;
            }
            if (importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setName(importURI.trimFileExtension().lastSegment());
                modelImport.setModelLocation(URI.decode((String)importURI.toString()));
            }
        }
    }

    @Override
    public void removeModelImport(MMXmiResource resource, Resource importedResource) throws ModelerCoreException {
        if (resource != null && importedResource != null && resource != importedResource) {
            ModelAnnotation modelWithImports;
            ModelImport importToRemove = this.findModelImport(resource, importedResource);
            if (importToRemove == null) {
                return;
            }
            Container cntr = ModelerCore.getContainer((Resource)resource);
            if (cntr != null) {
                ResourceFinder finder = cntr.getResourceFinder();
                Resource[] refs = finder.findReferencesFrom((Resource)resource, true, true);
                int i = 0;
                while (i != refs.length) {
                    if (importedResource == refs[i]) {
                        return;
                    }
                    ++i;
                }
            }
            if ((modelWithImports = resource.getModelAnnotation()) != null) {
                this.removeValue(modelWithImports, importToRemove, modelWithImports.getModelImports());
            }
        }
    }

    @Override
    public ModelImport findModelImport(MMXmiResource resource, Resource importedResource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (importedResource == null || resource.getURI().isRelative() || importedResource.getURI().isRelative()) {
            return null;
        }
        ModelImport theModelImport = null;
        Container cntr = ModelerCore.getContainer((Resource)resource);
        if (cntr != null) {
            String importedModelLocation = this.createModelLocation(resource, importedResource);
            if (importedModelLocation != null) {
                theModelImport = this.getExistingModelImportForLocation(resource, importedModelLocation);
            }
        } else {
            EList modelImports;
            String importedResourceUuid = null;
            String importedResourceLocation = null;
            if (importedResource instanceof MMXmiResource) {
                importedResourceUuid = ((MMXmiResource)importedResource).getUuid().toString();
            }
            URI resourceURI = resource.getURI();
            URI importURI = importedResource.getURI();
            if (XSDSchemaImpl.getGlobalResourceSet().getResources().contains((Object)importedResource)) {
                if (importedResource == XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").eResource()) {
                    importURI = ResourceFinder.SCHEMA_FOR_SCHEMA_URI;
                } else if (importedResource == XSDSchemaImpl.getSchemaInstance((String)"http://www.w3.org/2001/XMLSchema-instance").eResource()) {
                    importURI = ResourceFinder.SCHEMA_INSTANCE_URI;
                } else if (importedResource == XSDSchemaImpl.getMagicSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").eResource()) {
                    importURI = ResourceFinder.MAGIC_SCHEMA_URI;
                }
            } else if (resourceURI.isFile() && importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
            }
            importedResourceLocation = URI.decode((String)importURI.toString());
            ModelAnnotation modelAnnot = resource.getModelAnnotation();
            if (modelAnnot != null && !(modelImports = modelAnnot.getModelImports()).isEmpty()) {
                for (ModelImport modelImport : modelImports) {
                    String modelLocation;
                    String modelImportUuid = modelImport.getUuid();
                    if (modelImportUuid != null && modelImportUuid.equalsIgnoreCase(importedResourceUuid)) {
                        theModelImport = modelImport;
                    }
                    if (theModelImport == null && (modelLocation = modelImport.getModelLocation()) != null && modelLocation.equalsIgnoreCase(importedResourceLocation)) {
                        theModelImport = modelImport;
                    }
                    if (theModelImport != null) break;
                }
            }
        }
        return theModelImport;
    }

    @Override
    public Annotation getAnnotation(EObject eObject, boolean forceCreate) {
        Resource eObjectResource = eObject.eResource();
        if (eObjectResource instanceof MMXmiResource) {
            MMXmiResource emfResource = (MMXmiResource)eObjectResource;
            Annotation annotation = emfResource.getAnnotation(eObject);
            if (annotation == null && forceCreate) {
                annotation = ModelResourceContainerFactory.createNewAnnotation(eObject, emfResource.getAnnotationContainer(true));
            }
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation getAnnotation(ModelResource modelResource, EObject eObject, boolean forceCreate) {
        return this.getAnnotation(eObject, forceCreate);
    }

    @Override
    public EObject getExtension(EObject eObject) throws ModelerCoreException {
        XClass xclass;
        XPackage extPackage;
        XSDResourceImpl xsdResource;
        XSDSchema xsdSchema;
        CoreArgCheck.isNotNull((Object)eObject);
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (EcorePackage.eINSTANCE.equals(ePackage)) {
            return null;
        }
        Resource emfResource = eObject.eResource();
        if (emfResource == null) {
            return null;
        }
        if (emfResource instanceof MMXmiResource) {
            XClass xclass2;
            XPackage extPackage2;
            ModelAnnotation model = this.getModelAnnotation(emfResource);
            if (model != null && (extPackage2 = model.getExtensionPackage()) != null && (xclass2 = extPackage2.findXClass(eClass)) != null) {
                ObjectExtension result = null;
                try {
                    XPackage pkg = extPackage2;
                    ExtensionFactoryImpl factory = null;
                    EFactory existingFactory = pkg.getEFactoryInstance();
                    if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                        factory = new ExtensionFactoryImpl();
                        factory.setEPackage((EPackage)extPackage2);
                    }
                    result = new ObjectExtension(eObject, xclass2, this);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return result;
            }
        } else if (emfResource instanceof XSDResourceImpl && (xsdSchema = (xsdResource = (XSDResourceImpl)emfResource).getSchema()) != null && (extPackage = XsdObjectExtension.getExtensionPackage(xsdSchema)) != null && (xclass = extPackage.findXClass(eClass)) != null) {
            XsdObjectExtension result = null;
            try {
                XPackage pkg = extPackage;
                ExtensionFactoryImpl factory = null;
                EFactory existingFactory = pkg.getEFactoryInstance();
                if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                    factory = new ExtensionFactoryImpl();
                    factory.setEPackage((EPackage)extPackage);
                }
                result = new XsdObjectExtension(eObject, xclass, this);
            }
            catch (Throwable throwable) {
                String msg = ModelerCore.Util.getString("ModelEditorImpl.getExtension_0", (Object)xsdSchema);
                throw new ModelerCoreException(msg);
            }
            return result;
        }
        return null;
    }

    @Override
    public ModelResource findModelResource(ModelImport modelImport) {
        CoreArgCheck.isNotNull((Object)modelImport);
        String thePath = modelImport.getPath();
        if (thePath != null) {
            Path pathInWorkspace = new Path(modelImport.getPath());
            return ModelerCore.getModelWorkspace().findModelResource((IPath)pathInWorkspace);
        }
        return null;
    }

    @Override
    public URI getUri(EObject object) {
        Resource eResource;
        CoreArgCheck.isNotNull((Object)object);
        if (object instanceof EClass && (eResource = object.eResource()) != null && ModelerCore.getPlugin() != null) {
            URI eResourceUri = eResource.getURI();
            MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(eResourceUri);
            if (descriptor != null) {
                String logicalUri = URI.decode((String)descriptor.getNamespaceURI());
                return URI.createURI((String)logicalUri).appendFragment(eResource.getURIFragment(object));
            }
        }
        return EcoreUtil.getURI((EObject)object);
    }

    @Override
    public ObjectID getObjectID(EObject object) {
        CoreArgCheck.isNotNull((Object)object);
        try {
            String uuid = ModelEditorImpl.getContainer().getObjectManager().getObjectId(object);
            if (uuid != null) {
                return this.stringToUuid(uuid);
            }
        }
        catch (Exception err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
        }
        return null;
    }

    private ObjectID stringToUuid(String uuidString) throws InvalidIDException {
        return UUID.stringToObject((String)(uuidString.startsWith("mmuuid") ? uuidString.substring("mmuuid".length() + 1) : uuidString));
    }

    @Override
    public String getObjectIdString(EObject object) {
        CoreArgCheck.isNotNull((Object)object);
        return ModelEditorImpl.getContainer().getObjectManager().getObjectId(object);
    }

    @Override
    public void setObjectID(EObject object, ObjectID objectId) {
        this.setObjectID(object, objectId.toString());
    }

    @Override
    public void setObjectID(EObject object, String objectId) {
        CoreArgCheck.isNotNull((Object)object);
        try {
            ModelEditorImpl.getContainer().getObjectManager().setObjectId(object, objectId);
        }
        catch (Exception err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
        }
    }

    public String getSearchIndexObjectID(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        Object objId = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        if (sqlAspect != null) {
            objId = sqlAspect instanceof SqlAnnotationAspect ? this.getObjectIdString(eObject) : sqlAspect.getObjectID(eObject);
        } else if (eObject instanceof XSDConcreteComponent) {
            if (eObject.eIsProxy()) {
                URI proxyURI = EcoreUtil.getURI((EObject)eObject);
                if (proxyURI != null) {
                    objId = proxyURI.fragment();
                }
            } else if (eObject.eResource() != null) {
                objId = eObject.eResource().getURIFragment(eObject);
            }
        } else {
            objId = this.getObjectIdString(eObject);
        }
        if (objId != null) {
            return objId.toString();
        }
        return null;
    }

    @Override
    public EObject findObject(Object objectId) {
        CoreArgCheck.isNotNull((Object)objectId);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        return this.findObject(objectId, cntr);
    }

    protected EObject findObject(Object objectId, Container container) {
        if (container == null) {
            return null;
        }
        EObject result = null;
        Object resolvedObjectId = null;
        if (objectId instanceof String) {
            String stringId = (String)objectId;
            try {
                resolvedObjectId = IDGenerator.getInstance().stringToObject(stringId);
            }
            catch (InvalidIDException invalidIDException) {}
            if (resolvedObjectId == null) {
                try {
                    resolvedObjectId = URI.createURI((String)stringId);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (objectId instanceof URI) {
            resolvedObjectId = objectId;
        } else if (objectId instanceof ObjectID) {
            resolvedObjectId = objectId;
        }
        if (resolvedObjectId != null) {
            EObjectFinder finder = container.getEObjectFinder();
            result = (EObject)finder.find(resolvedObjectId);
        }
        return result;
    }

    @Override
    public EObject findObject(Object objectId, ModelResource resource, IProgressMonitor monitor) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)objectId);
        CoreArgCheck.isNotNull((Object)resource);
        if (!resource.isLoaded() || !resource.isOpen()) {
            resource.open(monitor);
            resource.getEmfResource();
        }
        return this.findObject(objectId);
    }

    @Override
    public Object getChangedObject(Notification notification) {
        CoreArgCheck.isNotNull((Object)notification);
        return notification.getNotifier();
    }

    @Override
    public EObject findObjectByPath(Resource resource, IPath modelRelativePath) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)modelRelativePath);
        EObject object = null;
        EList children = resource.getContents();
        String[] segments = modelRelativePath.segments();
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            object = this.findChildByLabel((Collection)children, segment);
            if (object == null) {
                return null;
            }
            children = object.eContents();
            ++i;
        }
        return object;
    }

    protected EObject findChildByLabel(Collection children, String label) {
        for (EObject child : children) {
            AdapterFactory adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            IItemLabelProvider provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)child, IItemLabelProvider.class);
            String objName = this.formatLabel(provider.getText((Object)child));
            if (!objName.equals(label)) continue;
            return child;
        }
        return null;
    }

    @Override
    public EObject findObjectByPath(ModelResource resource, IPath modelRelativePath) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)modelRelativePath);
        Resource emfResource = resource.getEmfResource();
        return this.findObjectByPath(emfResource, modelRelativePath);
    }

    @Override
    public IPath getModelRelativePath(EObject object) {
        return this.getModelRelativePath(object, true);
    }

    @Override
    public IPath getModelRelativePath(EObject object, boolean includeUnnamedObjects) {
        CoreArgCheck.isNotNull((Object)object);
        return this.computeModelRelativePath(object, false, includeUnnamedObjects);
    }

    @Override
    public IPath getModelRelativePathIncludingModel(EObject object) {
        return this.getModelRelativePathIncludingModel(object, true);
    }

    @Override
    public IPath getModelRelativePathIncludingModel(EObject object, boolean includeUnnamedObjects) {
        CoreArgCheck.isNotNull((Object)object);
        return this.computeModelRelativePath(object, true, includeUnnamedObjects);
    }

    @Override
    public IPath getFullPathToParent(EObject object) {
        CoreArgCheck.isNotNull((Object)object);
        Resource resource = object.eResource();
        if (resource == null) {
            return Path.ROOT;
        }
        String resourcePathStr = this.getResourcePath(resource);
        if (resourcePathStr == null) {
            return Path.ROOT;
        }
        Path resourcePath = new Path(resourcePathStr);
        EObject container = object.eContainer();
        if (container != null) {
            IPath relPathWithoutModel = this.computeModelRelativePath(container, false);
            return resourcePath.append(relPathWithoutModel);
        }
        return resourcePath;
    }

    protected IPath computeModelRelativePath(EObject object, boolean includeModelInPath) {
        return this.computeModelRelativePath(object, includeModelInPath, true);
    }

    protected IPath computeModelRelativePath(EObject object, boolean includeModelInPath, boolean includeUnnamedObjects) {
        String modelName;
        AdapterFactory adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
        Path path = new Path("");
        EObject tmp = object;
        if (tmp instanceof XSDParticle) {
            path = this.updatePath((IPath)path, (EObject)((XSDParticle)tmp).getTerm(), adapterFactory, includeUnnamedObjects);
            tmp = tmp.eContainer();
        }
        while (tmp != null) {
            if (!(tmp instanceof XSDParticle)) {
                path = this.updatePath((IPath)path, tmp, adapterFactory, includeUnnamedObjects);
            }
            tmp = tmp.eContainer();
        }
        if (includeModelInPath && (modelName = this.getModelName(object)) != null) {
            path = new Path(modelName).append((IPath)path);
        }
        return path;
    }

    private IPath updatePath(IPath path, EObject eObject, AdapterFactory factory, boolean includeUnnamedObjects) {
        if (!includeUnnamedObjects && !this.hasName(eObject)) {
            return path;
        }
        IItemLabelProvider provider = (IItemLabelProvider)factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        String objName = this.formatLabel(provider.getText((Object)eObject));
        return new Path(objName).append(path);
    }

    private String formatLabel(String name) {
        int ndx = name.indexOf(58);
        if (ndx >= 0) {
            return name.substring(0, ndx).trim();
        }
        return name;
    }

    @Override
    public String getModelName(EObject object) {
        CoreArgCheck.isNotNull((Object)object);
        if (object.eIsProxy()) {
            URI proxyUri = ((InternalEObject)object).eProxyURI();
            URI resourceUri = proxyUri.trimFragment();
            return this.getModelName(resourceUri);
        }
        if (object.eResource() != null) {
            return this.getModelName(object.eResource().getURI());
        }
        return "";
    }

    @Override
    public String getModelName(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        return this.getModelName(resource.getURI());
    }

    public String getModelName(URI resourceUri) {
        CoreArgCheck.isNotNull((Object)resourceUri);
        return resourceUri.trimFileExtension().lastSegment();
    }

    @Override
    public String getModelName(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource);
        IResource modelFile = modelResource.getResource();
        String modelName = null;
        if (modelFile instanceof IFile) {
            IFile theFile = (IFile)modelFile;
            String extension = theFile.getFileExtension();
            modelName = theFile.getName();
            if (extension != null) {
                int indexOfExtension = modelName.lastIndexOf(extension);
                modelName = indexOfExtension == 0 ? "" : modelName.substring(0, indexOfExtension - 1);
            }
        } else {
            modelName = modelResource.getItemName();
        }
        return modelName;
    }

    @Override
    public Collection getAllContainers(Resource resource) {
        if (resource == null || !(resource instanceof MMXmiResource)) {
            return Collections.EMPTY_LIST;
        }
        return ModelResourceContainerFactory.getAllContainers(resource, true);
    }

    public String getResourcePath(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        return WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
    }

    private String getResourceName(Resource resource) {
        int index;
        CoreArgCheck.isNotNull((Object)resource);
        URI resourceUri = resource.getURI();
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }

    public static Command createCopyCommand(EditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return domain.createCommand(CopyCommand.class, new CommandParameter(owner, null, (Object)helper));
    }

    public static Command createCopyCommand(EditingDomain domain, Collection collection, CopyCommand.Helper helper) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CopyCommand.Helper copyHelper = helper;
        CompoundCommand copyCommand = CompoundCommandFactory.create(Integer.MAX_VALUE);
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            copyCommand.append(domain.createCommand(CopyCommand.class, new CommandParameter(objects.next(), null, (Object)copyHelper)));
        }
        return copyCommand.unwrap();
    }

    @Override
    public ModelContents getModelContents(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        Resource resource = eObject.eResource();
        return this.getModelContents(resource);
    }

    @Override
    public ModelContents getModelContents(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (resource instanceof MtkXmiResourceImpl) {
            return ((MtkXmiResourceImpl)resource).getModelContents();
        }
        ModelResource modelResource = this.findModelResource(resource);
        return this.getModelContents(modelResource);
    }

    @Override
    public ModelContents getModelContents(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource);
        try {
            return ModelContents.getModelContents(modelResource);
        }
        catch (ModelWorkspaceException e) {
            ModelerCore.Util.log((Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public ModelAnnotation getModelAnnotation(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        Resource resource = eObject.eResource();
        if (resource instanceof MMXmiResource) {
            return ((MMXmiResource)resource).getModelAnnotation();
        }
        ModelResource modelResource = resource == null ? null : this.findModelResource(resource);
        return modelResource == null ? null : modelResource.getModelAnnotation();
    }

    protected static SqlDatatypeAspect getSqlAspect(EObject obj) {
        if (obj != null && obj instanceof XSDSimpleTypeDefinition) {
            return (SqlDatatypeAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(obj, SqlAspect.class);
        }
        return null;
    }

    static EObject resolveWhenProxy(EObject e) {
        EObject resolvedEObject = e;
        if (e.eIsProxy() && (resolvedEObject = EcoreUtil.resolve((EObject)e, (ResourceSet)ModelEditorImpl.getContainer())).eIsProxy()) {
            throw new TeiidDesignerRuntimeException(ModelerCore.Util.getString("ModelEditorImpl.Error_EObject_can_not_be_a_proxy", (Object)resolvedEObject.toString()));
        }
        return resolvedEObject;
    }

    public static class AddCommandFactory {
        public static AddCommand create(Object owner, EditingDomain domain, EList list, Collection collection, int index) {
            if (owner instanceof XSDConcreteComponent) {
                return new XsdConcreteComponentAddCommand(domain, list, collection, index);
            }
            return new AddCommand(domain, list, collection, index);
        }
    }

    public class AddValueToMapCommand
    extends AbstractOverrideableCommand {
        private Object owner;
        private Map map;
        private Object key;
        private Object oldValue;
        private Object newValue;

        public AddValueToMapCommand(EditingDomain ed, Object owner, Map map, Object key, Object newValue) {
            super(ed);
            this.owner = owner;
            this.map = map;
            this.key = key;
            this.newValue = newValue;
            if (map != null) {
                this.oldValue = map.get(key);
            }
        }

        public void doExecute() {
            this.map.put(this.key, this.newValue);
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 3, null, this.oldValue, this.newValue));
            }
        }

        public void doRedo() {
            this.map.put(this.key, this.newValue);
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 3, null, this.oldValue, this.newValue));
            }
        }

        public void doUndo() {
            if (this.oldValue != null) {
                this.map.put(this.key, this.oldValue);
            } else {
                this.map.remove(this.key);
                if (this.key == null && this.owner instanceof XSDSchema) {
                    ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
                }
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 4, null, this.newValue, this.oldValue != null ? this.oldValue : null));
            }
        }

        protected boolean prepare() {
            if (this.map == null || this.newValue == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public static class CompoundCommandFactory {
        public static CompoundCommand create(int index) {
            return new CompoundCommand(index);
        }

        public static CompoundCommand create(Object owner, List commands) {
            if (owner instanceof XSDConcreteComponent) {
                return new SafeRemoveCompoundCommand(commands);
            }
            if (owner instanceof Collection) {
                Collection col = (Collection)owner;
                for (Object element : col) {
                    if (!(element instanceof XSDConcreteComponent)) continue;
                    return new SafeRemoveCompoundCommand(commands);
                }
            }
            return new CompoundCommand(commands);
        }
    }

    public class EnterpriseDatatypeInfoSetCommand
    extends AbstractOverrideableCommand {
        private EnterpriseDatatypeInfo oldEdtInfo;
        private final EnterpriseDatatypeInfo newEdtInfo;
        private final XSDSimpleTypeDefinition simpleType;

        public EnterpriseDatatypeInfoSetCommand(EditingDomain ed, XSDSimpleTypeDefinition simpleType, EnterpriseDatatypeInfo newEdtInfo, EnterpriseDatatypeInfo oldEdtInfo) {
            super(ed);
            this.simpleType = simpleType;
            this.newEdtInfo = newEdtInfo;
            this.oldEdtInfo = oldEdtInfo;
        }

        protected void invokeSetOperation(EnterpriseDatatypeInfo edtInfo) {
            ModelEditorImpl.getSqlAspect((EObject)this.simpleType).setEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy((EObject)this.simpleType), edtInfo);
        }

        public void doExecute() {
            this.invokeSetOperation(this.newEdtInfo);
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 1, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, (Object)this.newEdtInfo));
        }

        public void doRedo() {
            this.invokeSetOperation(this.newEdtInfo);
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 1, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, (Object)this.newEdtInfo));
        }

        public void doUndo() {
            this.invokeSetOperation(this.oldEdtInfo);
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.newEdtInfo, (Object)this.oldEdtInfo));
        }

        protected boolean prepare() {
            if (this.simpleType == null || this.newEdtInfo == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public class EnterpriseDatatypeInfoUnsetCommand
    extends AbstractOverrideableCommand {
        private EnterpriseDatatypeInfo oldEdtInfo;
        private final XSDSimpleTypeDefinition simpleType;

        public EnterpriseDatatypeInfoUnsetCommand(EditingDomain ed, XSDSimpleTypeDefinition simpleType, EnterpriseDatatypeInfo oldEdtInfo) {
            super(ed);
            this.simpleType = simpleType;
            this.oldEdtInfo = oldEdtInfo;
        }

        protected void invokeUnsetOperation() {
            ModelEditorImpl.getSqlAspect((EObject)this.simpleType).unSetEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy((EObject)this.simpleType));
        }

        protected void invokeSetOperation(EnterpriseDatatypeInfo edtInfo) {
            ModelEditorImpl.getSqlAspect((EObject)this.simpleType).setEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy((EObject)this.simpleType), edtInfo);
        }

        public void doExecute() {
            this.invokeUnsetOperation();
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, null));
        }

        public void doRedo() {
            this.invokeUnsetOperation();
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, null));
        }

        public void doUndo() {
            this.invokeSetOperation(this.oldEdtInfo);
            this.simpleType.eNotify((Notification)new ENotificationImpl((InternalEObject)this.simpleType, 1, this.simpleType.eClass().getEStructuralFeature(5), null, (Object)this.oldEdtInfo));
        }

        protected boolean prepare() {
            if (this.simpleType == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public class RemoveValueFromMapCommand
    extends AbstractOverrideableCommand {
        private Object owner;
        private Map map;
        private Object key;
        private Object oldValue;

        public RemoveValueFromMapCommand(EditingDomain ed, Object owner, Map map, Object key) {
            super(ed);
            this.owner = owner;
            this.map = map;
            this.key = key;
            if (map != null) {
                this.oldValue = map.get(key);
            }
        }

        public void doExecute() {
            this.map.remove(this.key);
            if (this.key == null && this.owner instanceof XSDSchema) {
                ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 4, null, this.oldValue, null));
            }
        }

        public void doRedo() {
            this.map.remove(this.key);
            if (this.key == null && this.owner instanceof XSDSchema) {
                ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 4, null, this.oldValue, null));
            }
        }

        public void doUndo() {
            if (this.oldValue != null) {
                this.map.put(this.key, this.oldValue);
                if (this.owner instanceof EObject) {
                    ((EObject)this.owner).eNotify((Notification)new ENotificationImpl((InternalEObject)this.owner, 3, null, null, this.oldValue));
                }
            }
        }

        protected boolean prepare() {
            if (this.map == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    static class Tester {
        Tester() {
        }

        protected void cloneFilePassOneSummary(File originalProject, File originalFile, Map modelToReferenceMap, int xmiUuidCount, int newUuidCount, int xProjectHRefCounter) {
        }

        protected void cloneFile1(File originalProject, File originalFile, Map modelToReferenceMap, char[] buf, int bufLen, int bufNdx, char chr, char state, StringBuffer elemNameBuilder, StringBuffer attrNameBuilder, StringBuffer attrValBuilder, boolean href, boolean choiceCriteria) {
        }

        protected void cloneFilePassTwoSummary(File originalProject, File originalFile, int replacedUuidCount) {
        }

        protected void cloneFile2(File originalProject, File originalFile, Map modelToReferenceMap, char[] buf, int bufLen, int inBufNdx, char chr, char state, StringBuffer elemNameBuilder, StringBuffer attrNameBuilder, StringBuffer attrValBuilder, boolean href, boolean choiceCriteria, File clonedFile, CharArrayWriter testWriter, boolean uuid, int outBufNdx) {
        }

        protected void cloningFile(File file) {
        }

        protected void writeToOut(char[] charBuff, int startIndex, int length) {
        }

        protected void writeToOut(String str) {
        }
    }
}

