/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import org.osgi.framework.Bundle;
import org.teiid.designer.core.ExtensionDescriptor;
import org.teiid.designer.core.ModelerCore;

public class ExtensionDescriptorImpl
implements ExtensionDescriptor {
    protected static final ExtensionDescriptor[] EMPTY_ARRAY = new ExtensionDescriptor[0];
    protected Object id;
    protected DescriptorClassLoader extensionClassLoader;

    public ExtensionDescriptorImpl(Object id, String className, Bundle bundle) {
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_ID_reference_may_not_be_null_1", new Object[0]));
        }
        this.id = id;
        if (className != null && bundle != null) {
            this.extensionClassLoader = new DescriptorClassLoader(className, bundle);
        }
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public String getClassName() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getClassName() : null;
    }

    @Override
    public Class getExtensionClass() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getLoadedClass() : null;
    }

    @Override
    public Object getExtensionClassInstance() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getClassInstance() : null;
    }

    @Override
    public Object getNewExtensionClassInstance() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getNewClassInstance() : null;
    }

    @Override
    public ExtensionDescriptor[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public boolean isMultiDescriptor() {
        return false;
    }

    @Override
    public ExtensionDescriptor getChildDescriptor(Object id) {
        return null;
    }

    private class DescriptorClassLoader {
        private final String className;
        private final Bundle bundle;
        private boolean loadClassFailure;
        private boolean newInstanceFailure;
        private Class loadedClass;
        private Object classInstance;

        public DescriptorClassLoader(String className, Bundle bundle) {
            if (className == null) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_class_name_string_may_not_be_null_1", new Object[0]));
            }
            if (className.length() == 0) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_class_name_string_may_not_be_zero_length_3", new Object[0]));
            }
            if (bundle == null) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_bundle_reference_may_not_be_null_2", new Object[0]));
            }
            this.className = className;
            this.bundle = bundle;
            this.loadClassFailure = false;
            this.newInstanceFailure = false;
            this.loadedClass = null;
            this.classInstance = null;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescriptorClassLoader)) {
                return false;
            }
            DescriptorClassLoader that = (DescriptorClassLoader)obj;
            if (this.className.equals(that.className) && this.bundle.equals(that.bundle)) {
                return true;
            }
            return super.equals(obj);
        }

        public Class getLoadedClass() {
            if (!this.loadClassFailure && this.loadedClass == null) {
                try {
                    this.loadedClass = this.bundle.loadClass(this.className);
                    this.loadClassFailure = false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ModelerCore.Util.log(4, ModelerCore.Util.getString("ExtensionDescriptorImpl.Unable_to_load_class_using_bundle_4", new Object[]{this.className, this.bundle}));
                    this.loadedClass = null;
                    this.loadClassFailure = true;
                }
            }
            return this.loadedClass;
        }

        public Object getClassInstance() {
            if (!this.newInstanceFailure && this.classInstance == null && this.getLoadedClass() != null) {
                try {
                    this.classInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e) {
                    ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_5", new Object[]{this.loadedClass, e.getMessage()}));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e) {
                    ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_6", new Object[]{this.loadedClass, e.getMessage()}));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
            }
            return this.classInstance;
        }

        public Object getNewClassInstance() {
            Object newClassInstance = null;
            if (!this.newInstanceFailure && this.getLoadedClass() != null) {
                try {
                    newClassInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e) {
                    ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_5", new Object[]{this.loadedClass, e.getMessage()}));
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e) {
                    ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_6", new Object[]{this.loadedClass, e.getMessage()}));
                    this.newInstanceFailure = true;
                }
            }
            return newClassInstance;
        }

        public String toString() {
            Object[] params = new Object[]{this.className, this.bundle, new Boolean(this.loadedClass != null)};
            return ModelerCore.Util.getString(ModelerCore.Util.getString("ExtensionDescriptorImpl.ExtensionDescriptor___className,_bundle,_isLoaded_7", params), new Object[0]);
        }
    }
}

