/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.search.runtime.ReferencesRecord;
import org.teiid.designer.core.util.ModelVisitor;

public class ClearReferencesUponDelete
implements ModelVisitor {
    private final EditingDomain editingDomain;
    private final List additionalCommands;
    private final Collection allDeletedObjects;
    private final HashMap featureValueRemoves;
    private final ModelWorkspaceSearch workspaceSearch;
    private Map objectFeatureUnsetMap = new HashMap();

    public ClearReferencesUponDelete(Collection allDeletedObjects, EditingDomain editingDomain) {
        this(allDeletedObjects, editingDomain, new ModelWorkspaceSearch());
    }

    public ClearReferencesUponDelete(Collection allDeletedObjects, EditingDomain editingDomain, ModelWorkspaceSearch workspaceSearch) {
        CoreArgCheck.isNotNull((Object)editingDomain);
        CoreArgCheck.isNotNull((Object)allDeletedObjects);
        CoreArgCheck.isNotNull((Object)workspaceSearch);
        this.additionalCommands = new LinkedList();
        this.editingDomain = editingDomain;
        this.allDeletedObjects = allDeletedObjects;
        this.featureValueRemoves = new HashMap();
        this.workspaceSearch = workspaceSearch;
    }

    private boolean isRemoveCommandNeeded(EObject theReferencingObject, EStructuralFeature theFeature, Object theValue) {
        boolean result = false;
        HashMap featureMap = (HashMap)this.featureValueRemoves.get(theReferencingObject);
        ArrayList<Object> values = null;
        if (featureMap == null) {
            featureMap = new HashMap();
            this.featureValueRemoves.put(theReferencingObject, featureMap);
        }
        if (featureMap.containsKey(theFeature)) {
            values = (ArrayList<Object>)featureMap.get(theFeature);
        } else {
            values = new ArrayList<Object>(1);
            featureMap.put(theFeature, values);
        }
        if (!values.contains(theValue)) {
            values.add(theValue);
            result = true;
        }
        return result;
    }

    private void removeReference(Object theReferencingObject, EReference theFeatureReference, EObject theDeletedObject) {
        if (theReferencingObject instanceof EObject && !this.allDeletedObjects.contains(theReferencingObject)) {
            if (theFeatureReference.isMany() && !theFeatureReference.isVolatile()) {
                this.remove((EObject)theReferencingObject, theFeatureReference, theDeletedObject);
            } else {
                this.unset((EObject)theReferencingObject, (EStructuralFeature)theFeatureReference);
            }
        }
    }

    @Override
    public boolean visit(EObject object) {
        Collection refRecords;
        EClass eclass = object.eClass();
        EList allRefs = eclass.getEAllReferences();
        for (EReference reference : allRefs) {
            EReference opposite = reference.getEOpposite();
            if (reference.isContainment() || opposite == null || opposite.isContainment()) continue;
            if (reference.isMany()) {
                Collection values = (Collection)object.eGet((EStructuralFeature)reference);
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    this.removeReference(valueIter.next(), opposite, object);
                }
                continue;
            }
            if (!opposite.isChangeable()) continue;
            this.removeReference(object.eGet((EStructuralFeature)reference), opposite, object);
        }
        ModelEditorImpl modelEditor = (ModelEditorImpl)ModelerCore.getModelEditor();
        String objID = modelEditor.getSearchIndexObjectID(object);
        if (objID != null && (refRecords = this.workspaceSearch.getUniDirectionalReferencesTo(objID)) != null && !refRecords.isEmpty()) {
            for (ReferencesRecord refRecord : refRecords) {
                String refUUID = refRecord.getUUID();
                EObject refrencingObj = modelEditor.findObject(refUUID);
                if (refrencingObj == null) continue;
                this.cleanupUniDirectionalReferences(refrencingObj, object);
            }
        }
        return true;
    }

    @Override
    public boolean visit(Resource resource) {
        return resource != null;
    }

    private void cleanupUniDirectionalReferences(EObject referencingObj, EObject referencedObj) {
        if (this.allDeletedObjects.contains(referencingObj)) {
            return;
        }
        EClass eclass = referencingObj.eClass();
        EList allRefs = eclass.getEAllReferences();
        for (EReference reference : allRefs) {
            if (reference.getEOpposite() != null || reference.isVolatile() || !reference.isChangeable() || reference.isContainment()) continue;
            ModelEditor modelEditor = ModelerCore.getModelEditor();
            if (reference.isMany()) {
                Collection values = (Collection)referencingObj.eGet((EStructuralFeature)reference);
                for (Object value : values) {
                    if (!(value instanceof EObject) || !modelEditor.equals((EObject)value, referencedObj)) continue;
                    this.remove(referencingObj, reference, value);
                }
                continue;
            }
            Object value = referencingObj.eGet((EStructuralFeature)reference);
            if (!(value instanceof EObject) || !modelEditor.equals((EObject)value, referencedObj)) continue;
            this.unset(referencingObj, (EStructuralFeature)reference);
        }
    }

    protected void remove(EObject theReferencingObject, EReference theFeature, Object theValue) {
        boolean doDelete = true;
        EObject parent = theReferencingObject.eContainer();
        while (parent != null && doDelete) {
            if (this.allDeletedObjects.contains(parent)) {
                doDelete = false;
                continue;
            }
            parent = parent.eContainer();
        }
        if (doDelete && !theFeature.isVolatile() && this.isRemoveCommandNeeded(theReferencingObject, (EStructuralFeature)theFeature, theValue)) {
            Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)theReferencingObject, (Object)theFeature, (Object)theValue);
            this.additionalCommands.add(removeCommand);
        }
    }

    protected void unset(EObject owner, EStructuralFeature feature) {
        if (!this.allDeletedObjects.contains(owner) && !feature.isVolatile() && this.isUnsetCommandNeeded(owner, feature)) {
            Command setCommand = SetCommand.create((EditingDomain)this.editingDomain, (Object)owner, (Object)feature, null);
            this.additionalCommands.add(setCommand);
        }
    }

    private boolean isUnsetCommandNeeded(EObject theOwner, EStructuralFeature theFeature) {
        boolean result = false;
        HashSet<EStructuralFeature> features = (HashSet<EStructuralFeature>)this.objectFeatureUnsetMap.get(theOwner);
        if (features == null) {
            features = new HashSet<EStructuralFeature>();
            this.objectFeatureUnsetMap.put(theOwner, features);
        }
        if (!features.contains(theFeature)) {
            features.add(theFeature);
            result = true;
        }
        return result;
    }

    public List getAdditionalCommands() {
        return this.additionalCommands;
    }
}

