/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.registry.ExtensionDefinitionsManager;
import org.teiid.designer.extension.registry.RegistryEvent;
import org.teiid.designer.extension.registry.RegistryListener;

public final class ModelExtensionRegistry {
    private Set<String> extendableMetamodelUris;
    private final Map<String, ModelExtensionDefinition> definitions = new HashMap<String, ModelExtensionDefinition>();
    private final CopyOnWriteArrayList<RegistryListener> listeners = new CopyOnWriteArrayList();
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private ModelExtensionDefinitionParser parser;

    public ModelExtensionRegistry(File medSchema) throws IllegalStateException {
        try {
            this.parser = new ModelExtensionDefinitionParser(medSchema);
        }
        catch (Exception e) {
            IllegalStateException error = e instanceof IllegalStateException ? (IllegalStateException)e : new IllegalStateException(e);
            throw error;
        }
    }

    public ModelExtensionDefinition addDefinition(InputStream definitionStream, ModelExtensionAssistant assistant) throws Exception {
        ModelExtensionDefinition definition = this.parser.parse(definitionStream, assistant);
        assert (definition != null) : "parser should not return a null model extension definition";
        Collection<String> errors = this.parser.getErrors();
        if (!errors.isEmpty()) {
            throw new Exception(NLS.bind((String)Messages.modelExtensionDefinitionHasParseErrors, (Object)errors.size(), (Object)errors.iterator().next()));
        }
        String namespacePrefix = definition.getNamespacePrefix();
        if (!definition.isBuiltIn() && this.definitions.containsKey(namespacePrefix)) {
            throw new Exception(NLS.bind((String)Messages.namespacePrefixAlreadyRegistered, (Object)namespacePrefix));
        }
        String namespaceUri = definition.getNamespaceUri();
        if (!definition.isBuiltIn() && this.namespaces.containsKey(namespaceUri)) {
            throw new Exception(NLS.bind((String)Messages.namespaceUriAlreadyRegistered, (Object)namespaceUri));
        }
        String metamodelUri = definition.getMetamodelUri();
        if (this.extendableMetamodelUris == null || !this.extendableMetamodelUris.contains(metamodelUri)) {
            throw new Exception(NLS.bind((String)Messages.invalidMetamodelUriExtension, (Object)metamodelUri));
        }
        this.definitions.put(namespacePrefix, definition);
        this.namespaces.put(namespaceUri, namespacePrefix);
        this.fireEvent(RegistryEvent.createAddDefinitionEvent(definition));
        return definition;
    }

    public void removeDefinition(String namespacePrefix) {
        ModelExtensionDefinition removedMed;
        CoreArgCheck.isNotEmpty((String)namespacePrefix, (String)"namespacePrefix is empty");
        if (this.isNamespacePrefixRegistered(namespacePrefix) && (removedMed = this.definitions.remove(namespacePrefix)) != null) {
            this.namespaces.remove(removedMed.getNamespaceUri());
            this.fireEvent(RegistryEvent.createRemoveDefinitionEvent(removedMed));
        }
    }

    public boolean addListener(RegistryListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        if (this.listeners.contains(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    private void fireEvent(RegistryEvent event) {
        assert (event != null) : "event is null";
        for (RegistryListener listener : this.listeners) {
            try {
                listener.process(event);
            }
            catch (Exception e) {
                ExtensionPlugin.Util.log((Throwable)e);
                this.removeListener(listener);
            }
        }
    }

    public Collection<ModelExtensionDefinition> getAllDefinitions() {
        return Collections.unmodifiableCollection(this.definitions.values());
    }

    public Collection<ModelExtensionDefinition> getBuiltInDefinitions() {
        ArrayList<ModelExtensionDefinition> builtInDefns = new ArrayList<ModelExtensionDefinition>();
        for (ModelExtensionDefinition med : this.definitions.values()) {
            if (!med.isBuiltIn()) continue;
            builtInDefns.add(med);
        }
        return builtInDefns;
    }

    public Collection<ModelExtensionDefinition> getUserDefinedDefinitions() {
        ArrayList<ModelExtensionDefinition> userDefns = new ArrayList<ModelExtensionDefinition>();
        for (ModelExtensionDefinition med : this.definitions.values()) {
            if (med.isBuiltIn() || med.isImported()) continue;
            userDefns.add(med);
        }
        return userDefns;
    }

    public Collection<ModelExtensionDefinition> getImportedDefinitions() {
        ArrayList<ModelExtensionDefinition> importedDefns = new ArrayList<ModelExtensionDefinition>();
        for (ModelExtensionDefinition med : this.definitions.values()) {
            if (!med.isImported()) continue;
            importedDefns.add(med);
        }
        return importedDefns;
    }

    private IStatus addDefinitions(Collection<File> definedMedFiles, ExtensionConstants.MxdType mxdType) {
        boolean allSuccess = true;
        for (File medFile : definedMedFiles) {
            try {
                ModelObjectExtensionAssistant assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant();
                ModelExtensionDefinition definition = this.addDefinition(new FileInputStream(medFile), assistant);
                if (!ExtensionConstants.MxdType.IMPORTED.equals((Object)mxdType)) continue;
                definition.markAsImported();
            }
            catch (Exception e) {
                allSuccess = false;
                String errMessage = NLS.bind((String)Messages.errorAddingUserDefinition, (Object)medFile.getAbsolutePath());
                ExtensionPlugin.Util.log(4, (Throwable)e, errMessage);
            }
        }
        if (allSuccess) {
            return new Status(0, ExtensionConstants.PLUGIN_ID, 0, "", null);
        }
        return new Status(2, ExtensionConstants.PLUGIN_ID, 0, Messages.errorRestoringUserDefinitions, null);
    }

    public IStatus restoreDefinedDefinitions(String userDefinitionsPath) {
        MultiStatus status = new MultiStatus(ExtensionConstants.PLUGIN_ID, 0, "", null);
        ExtensionDefinitionsManager mgr = new ExtensionDefinitionsManager(userDefinitionsPath);
        Collection<File> definedMedFiles = mgr.retrieveDefinitionFiles(ExtensionConstants.MxdType.USER);
        status.add(this.addDefinitions(definedMedFiles, ExtensionConstants.MxdType.USER));
        definedMedFiles = mgr.retrieveDefinitionFiles(ExtensionConstants.MxdType.IMPORTED);
        status.add(this.addDefinitions(definedMedFiles, ExtensionConstants.MxdType.IMPORTED));
        return status;
    }

    public void saveDefinedDefinitions(String definedDefinitionsPath) {
        ExtensionDefinitionsManager mgr = new ExtensionDefinitionsManager(definedDefinitionsPath);
        mgr.saveDefinitions(this.getUserDefinedDefinitions());
        mgr.saveDefinitions(this.getImportedDefinitions());
    }

    public Set<String> getAllNamespacePrefixes() {
        return new HashSet<String>(this.namespaces.values());
    }

    public Set<String> getAllNamespaceUris() {
        return this.namespaces.keySet();
    }

    public ModelExtensionDefinition getDefinition(String namespacePrefix) {
        CoreArgCheck.isNotEmpty((String)namespacePrefix, (String)"namespacePrefix is empty");
        return this.definitions.get(namespacePrefix);
    }

    public ModelExtensionDefinition getDefinitionWithNSUri(String namespaceUri) {
        CoreArgCheck.isNotEmpty((String)namespaceUri, (String)"namespacePrefix is empty");
        ModelExtensionDefinition resultMed = null;
        Collection<ModelExtensionDefinition> allMeds = this.getAllDefinitions();
        for (ModelExtensionDefinition med : allMeds) {
            if (!namespaceUri.equals(med.getNamespaceUri())) continue;
            resultMed = med;
            break;
        }
        return resultMed;
    }

    public Set<String> getExtendableMetamodelUris() {
        if (this.extendableMetamodelUris == null) {
            return Collections.emptySet();
        }
        return this.extendableMetamodelUris;
    }

    public ModelExtensionAssistant getModelExtensionAssistant(String namespacePrefix) {
        ModelExtensionDefinition definition = this.getDefinition(namespacePrefix);
        if (definition != null) {
            return definition.getModelExtensionAssistant();
        }
        return null;
    }

    public Collection<ModelExtensionAssistant> getModelExtensionAssistants(String metaclassName) {
        ArrayList<ModelExtensionAssistant> assistants = new ArrayList<ModelExtensionAssistant>();
        for (ModelExtensionDefinition definition : this.getAllDefinitions()) {
            if (!definition.extendsMetaclass(metaclassName)) continue;
            assistants.add(definition.getModelExtensionAssistant());
        }
        return assistants;
    }

    public ModelExtensionPropertyDefinition getPropertyDefinition(String metaclassName, String propId) {
        CoreArgCheck.isNotEmpty((String)propId, (String)"propId is empty");
        for (ModelExtensionDefinition definition : this.getAllDefinitions()) {
            ModelExtensionPropertyDefinition propDefn = definition.getPropertyDefinition(metaclassName, propId);
            if (propDefn == null) continue;
            return propDefn;
        }
        return null;
    }

    public boolean isNamespacePrefixRegistered(String namespacePrefix) {
        CoreArgCheck.isNotEmpty((String)namespacePrefix, (String)"namespacePrefix is empty");
        return this.definitions.containsKey(namespacePrefix);
    }

    public boolean isNamespaceUriRegistered(String namespaceUri) {
        CoreArgCheck.isNotEmpty((String)namespaceUri, (String)"namespaceUri is empty");
        return this.namespaces.containsKey(namespaceUri);
    }

    public boolean isExtendable(String metamodelUri) {
        CoreArgCheck.isNotEmpty((String)metamodelUri, (String)"metamodelUri is empty");
        return this.extendableMetamodelUris.contains(metamodelUri);
    }

    public boolean removeListener(RegistryListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.remove(listener);
    }

    public void setMetamodelUris(Set<String> extendableMetamodelUris) throws Exception {
        CoreArgCheck.isNotNull(extendableMetamodelUris, (String)"extendableMetamodelUris");
        assert (this.extendableMetamodelUris == null) : "Extendable metamodel URIs being set for second time";
        this.extendableMetamodelUris = Collections.unmodifiableSet(extendableMetamodelUris);
    }
}

