/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teiid.core.designer.properties.Property;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;

public class ModelExtensionProperty
implements Property {
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private String overriddenValue;
    private final ModelExtensionPropertyDefinition propDefn;

    public ModelExtensionProperty(ModelExtensionPropertyDefinition propDefn) {
        CoreArgCheck.isNotNull((Object)propDefn, (String)"propDef is null");
        this.propDefn = propDefn;
        this.listeners = new CopyOnWriteArrayList();
    }

    public ModelExtensionProperty(ModelExtensionPropertyDefinition propDefn, String initialValue) {
        this(propDefn);
        this.setValue(initialValue);
    }

    public boolean addListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.addIfAbsent(listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.propDefn.getId().equals(((ModelExtensionProperty)obj).getPropertyDefinition().getId());
    }

    public String getId() {
        return this.propDefn.getId();
    }

    public ModelExtensionPropertyDefinition getModelExtensionPropertyDefinition() {
        return this.propDefn;
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.propDefn;
    }

    public String getValue() {
        return CoreStringUtil.isEmpty((String)this.overriddenValue) ? this.getPropertyDefinition().getDefaultValue() : this.overriddenValue;
    }

    public int hashCode() {
        return this.getPropertyDefinition().getId().hashCode();
    }

    public boolean hasOverridenValue() {
        return this.overriddenValue != null;
    }

    private void notifyChangeListeners(Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, this.propDefn.getId(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                ExtensionPlugin.Util.log((Throwable)e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.remove(listener);
    }

    public void setValue(String newValue) {
        String oldValue = this.getValue();
        if (CoreStringUtil.equals((String)oldValue, (String)newValue)) {
            return;
        }
        this.overriddenValue = CoreStringUtil.equals((String)newValue, (String)this.getPropertyDefinition().getDefaultValue()) ? null : newValue;
        this.notifyChangeListeners(oldValue, this.getValue());
    }

    public static enum PropertyName {
        PROPERTY_DEFINITION,
        VALUE;

    }
}

