/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.util.Collections;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.MedStatus;

public class ValidationStatus
implements MedStatus {
    private static final List<MedStatus> NO_CHILDREN = Collections.emptyList();
    public static final ValidationStatus OK_STATUS = ValidationStatus.createOkMessage(Messages.okValidationMsg);
    private String message;
    private MedStatus.Severity severity;

    public static ValidationStatus createErrorMessage(String message) {
        return new ValidationStatus(MedStatus.Severity.ERROR, message);
    }

    public static ValidationStatus createInfoMessage(String message) {
        return new ValidationStatus(MedStatus.Severity.INFO, message);
    }

    public static ValidationStatus createOkMessage(String message) {
        return new ValidationStatus(MedStatus.Severity.OK, message);
    }

    public static ValidationStatus createWarningMessage(String message) {
        return new ValidationStatus(MedStatus.Severity.WARNING, message);
    }

    protected ValidationStatus(MedStatus.Severity type, String message) {
        assert (type != null) : "severity is null";
        CoreArgCheck.isNotEmpty((String)message, (String)"message is empty");
        this.severity = type;
        this.message = message;
    }

    @Override
    public int compareTo(MedStatus that) {
        if (this == that || this.getSeverity() == that.getSeverity()) {
            return this.getMessage().compareTo(that.getMessage());
        }
        if (this.isError()) {
            if (that.isWarning()) {
                return -10;
            }
            if (that.isInfo()) {
                return -100;
            }
            return -1000;
        }
        if (this.isWarning()) {
            if (that.isError()) {
                return 10;
            }
            if (that.isInfo()) {
                return -10;
            }
            return -100;
        }
        if (this.isInfo()) {
            if (that.isError()) {
                return 100;
            }
            if (that.isWarning()) {
                return 10;
            }
            return -10;
        }
        if (that.isError()) {
            return 1000;
        }
        if (that.isWarning()) {
            return 100;
        }
        return 10;
    }

    @Override
    public List<MedStatus> getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public MedStatus.Severity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isError() {
        return MedStatus.Severity.ERROR == this.severity;
    }

    @Override
    public boolean isInfo() {
        return MedStatus.Severity.INFO == this.severity;
    }

    @Override
    public boolean isMulti() {
        return false;
    }

    @Override
    public boolean isOk() {
        return MedStatus.Severity.OK == this.severity;
    }

    @Override
    public boolean isWarning() {
        return MedStatus.Severity.WARNING == this.severity;
    }
}

