/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.definition.MedStatus;

public class MultiValidationStatus
implements MedStatus {
    private MedStatus status;
    private final List<MedStatus> children = new ArrayList<MedStatus>();

    public static final MultiValidationStatus create(MedStatus status) {
        CoreArgCheck.isNotNull((Object)status);
        MultiValidationStatus multiStatus = new MultiValidationStatus();
        multiStatus.add(status);
        return multiStatus;
    }

    private MultiValidationStatus() {
    }

    public void add(MedStatus childStatus) {
        CoreArgCheck.isNotNull((Object)childStatus);
        if (childStatus.isMulti()) {
            for (MedStatus kid : childStatus.getChildren()) {
                this.add(kid);
            }
        } else if (childStatus.isOk()) {
            if (this.status == null) {
                this.status = childStatus;
            }
        } else {
            this.children.add(childStatus);
            if (this.status == null || this.status.compareTo(childStatus) > 0) {
                this.status = childStatus;
            }
        }
    }

    @Override
    public int compareTo(MedStatus that) {
        return this.status.compareTo(that);
    }

    @Override
    public List<MedStatus> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getMessage() {
        return this.status.getMessage();
    }

    @Override
    public MedStatus.Severity getSeverity() {
        return this.status.getSeverity();
    }

    @Override
    public boolean isError() {
        return this.status.isError();
    }

    @Override
    public boolean isInfo() {
        return this.status.isInfo();
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public boolean isOk() {
        return this.status.isOk();
    }

    @Override
    public boolean isWarning() {
        return this.status.isWarning();
    }
}

